/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.PayAddPlatfUseFeeService;
import com.tydic.pfscext.api.busi.bo.PayAddPlatfUseFeeReqBO;
import com.tydic.pfscext.base.BasePayService;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.po.InquiryPayOrder;
import com.tydic.pfscext.enums.InquiryApprovalStatus;
import com.tydic.pfscext.enums.InquiryMailStatus;
import com.tydic.pfscext.enums.InquiryPayFeeType;
import com.tydic.pfscext.enums.InquiryPaymentStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddPlatfUseFeePayServiceImpl
extends BasePayService<PfscExtRspBaseBO>
implements PayAddPlatfUseFeeService {
    private static final Logger logger = LoggerFactory.getLogger(AddPlatfUseFeePayServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public PfscExtRspBaseBO addPlatfUseFee(PayAddPlatfUseFeeReqBO reqBO) {
        PfscExtRspBaseBO rspBO = (PfscExtRspBaseBO)this.queryRspOrSaveLog((PfscExtReqBaseBO)reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        try {
            rspBO = this.addPlatfUseFee2(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((PfscExtReqBaseBO)reqBO, e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        this.updateLog((PfscExtReqBaseBO)reqBO, rspBO);
        return rspBO;
    }

    private PfscExtRspBaseBO addPlatfUseFee2(PayAddPlatfUseFeeReqBO reqBO) {
        logger.debug("\u65b0\u589e\u5e73\u53f0\u4f7f\u7528\u8d39\u7f34\u8d39\u5355\u529f\u80fdStart......");
        if (null == reqBO.getPayOrderNo()) {
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderDate()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u65e5\u671f[orderDate]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMaterialsClass()) {
            throw new PfscExtBusinessException("0001", "\u7269\u8d44\u5206\u7c7b[materialsClass]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u5355\u4f4d\u7f16\u53f7[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyType()) {
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u5355\u4f4d\u7c7b\u578b[companyType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayMoney()) {
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u91d1\u989d[payMoney]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperUnitNo()) {
            throw new PfscExtBusinessException("0001", "\u6536\u6b3e\u5355\u4f4d\u673a\u6784\u53f7[operUnitNo]\u4e3a\u7a7a");
        }
        InquiryPayOrder payOrderInfo = new InquiryPayOrder();
        payOrderInfo.setPayOrderNo(reqBO.getPayOrderNo());
        payOrderInfo.setInquiryNo(reqBO.getPayOrderNo());
        payOrderInfo.setOrderTime(reqBO.getOrderDate());
        String materialsClass = reqBO.getMaterialsClass();
        if (materialsClass.length() > 200) {
            materialsClass = materialsClass.substring(0, 196) + "...";
        }
        payOrderInfo.setMaterialsClass(materialsClass);
        payOrderInfo.setCompanyType(reqBO.getCompanyType().getCode());
        payOrderInfo.setOperUnitNo(reqBO.getOperUnitNo());
        payOrderInfo.setPayMoney(reqBO.getPayMoney());
        payOrderInfo.setSupplierId(reqBO.getSupplierId());
        payOrderInfo.setMark(reqBO.getMark());
        payOrderInfo.setPaymentStatus(InquiryPaymentStatus.NO_PAYMENT.getCode());
        payOrderInfo.setMailStatus(InquiryMailStatus.NOT_MAILING.getCode());
        payOrderInfo.setPayFeeType(InquiryPayFeeType.PLAT_USE_FEE.getCode());
        payOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payOrderInfo.setApprovalStatus(InquiryApprovalStatus.UNSUBMITTED.getCode());
        logger.debug("\u6570\u636e\u5e93\u65b0\u589e\u7f34\u8d39\u8ba2\u5355\u53c2\u6570\uff1a" + payOrderInfo);
        this.inquiryPayOrderMapper.insert(payOrderInfo);
        logger.debug("\u65b0\u589e\u5e73\u53f0\u4f7f\u7528\u8d39\u7f34\u8d39\u5355\u529f\u80fdEnd......");
        return new PfscExtRspBaseBO();
    }

    @Override
    protected PfscExtRspBaseBO fillRspBO(String respPackage) {
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.containsKey((Object)"respCode") ? jsonObject.getString("respCode") : null);
        rspBO.setRespDesc(jsonObject.containsKey((Object)"respDesc") ? jsonObject.getString("respDesc") : null);
        return rspBO;
    }
}

