/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiGetBillingRecordService;
import com.tydic.pfscext.api.busi.bo.BillingRecordRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBillingRecordReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBillingRecordRspBO;
import com.tydic.pfscext.api.busi.vo.BillMergeInfoVO;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetBillingRecordService.class)
public class BusiGetBillingRecordServiceImpl
implements BusiGetBillingRecordService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetBillingRecordServiceImpl.class);
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;

    public BusiGetBillingRecordRspBO getBillingRecord(BusiGetBillingRecordReqBO reqBO) {
        log.info("\u67e5\u8be2\u5f00\u7968\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)reqBO);
        if ("".equals(reqBO.getType()) || null == reqBO.getType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getPurDeptId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getSupplierId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String type = reqBO.getType();
        if (CtrantType.RAW_COAL.getCode().equals(type) || CtrantType.CHEMICAL.getCode().equals(type)) {
            reqBO.setType("1");
        } else if (CtrantType.CHEMICAL_STORE.getCode().equals(type) || CtrantType.NON_HOSTED.getCode().equals(type)) {
            reqBO.setType("2");
        } else {
            reqBO.setType("3");
        }
        if (!"".equals(reqBO.getDocumentNo()) && null != reqBO.getDocumentNo() || !"".equals(reqBO.getSettlementSupplier()) && null != reqBO.getSettlementSupplier() || !"".equals(reqBO.getPayType()) && null != reqBO.getPayType() || !"".equals(reqBO.getCoalSupplierId()) && null != reqBO.getCoalSupplierId() || !"".equals(reqBO.getWarehouseId()) && null != reqBO.getWarehouseId() || !"".equals(reqBO.getCtrantTypeId()) && null != reqBO.getCtrantTypeId() || !"".equals(reqBO.getSumStartDate()) && null != reqBO.getSumStartDate()) {
            return this.getPageByCondition(reqBO);
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        BusiGetBillingRecordRspBO rspBO = new BusiGetBillingRecordRspBO();
        rspBO.setRecordsTotal(Integer.valueOf(0));
        rspBO.setTotal(Integer.valueOf(1));
        rspBO.setPageNo(Integer.valueOf(1));
        List<BillMergeInfo> billMergeInfos = this.billMergeInfoMapper.selectPage(reqBO, (Page<Map<String, Object>>)page, reqBO.getType());
        ArrayList billingRecordRspBOS = new ArrayList();
        if (billMergeInfos.size() != 0) {
            billingRecordRspBOS.addAll(JSON.parseArray((String)JSON.toJSONString(billMergeInfos), BillingRecordRspBO.class));
            List<String> mergeNoList = billMergeInfos.stream().map(BillMergeInfo::getMergeSetNo).collect(Collectors.toList());
            List<String> statementNos = this.billSummaryInfoMapper.selectDocNoByMergeNo(mergeNoList);
            if (statementNos.size() != 0) {
                List<GetOriginalDocumentsInfoVO> documentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByStatementNos(statementNos);
                Map<String, GetOriginalDocumentsInfoVO> documentsInfoVOMap = documentsInfoVOS.stream().collect(Collectors.toMap(GetOriginalDocumentsInfoVO::getDocumentNo, documentsInfoVO -> documentsInfoVO));
                for (BillingRecordRspBO billMergeInfo : billingRecordRspBOS) {
                    List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.selectByMergeNo(billMergeInfo.getMergeSetNo());
                    HashSet documentsNOs = new HashSet();
                    billSummaryInfos.forEach(billSummaryInfo -> documentsNOs.add(billSummaryInfo.getStatementNo()));
                    ArrayList<GetOriginalDocumentsInfoVO> documentsInfoVOList = new ArrayList<GetOriginalDocumentsInfoVO>();
                    for (String documentsNO : documentsNOs) {
                        GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO = documentsInfoVOMap.get(documentsNO);
                        documentsInfoVOList.add(getOriginalDocumentsInfoVO);
                    }
                    String jsonString = JSON.toJSONString(documentsInfoVOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    List billMergeInfoVOS = JSON.parseArray((String)jsonString, BillMergeInfoVO.class);
                    billMergeInfo.setMergeInfoList(billMergeInfoVOS);
                    billMergeInfo.setInvoiceStatusDesc(FscBillStatus.getInstance(billMergeInfo.getInvoiceStatus()).getDescr());
                }
                rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
                rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
                rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            }
        }
        rspBO.setRows(billingRecordRspBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BusiGetBillingRecordRspBO getPageByCondition(BusiGetBillingRecordReqBO reqBO) {
        List<String> documentsNoList;
        List<BillSummaryInfo> billSummaryInfos;
        BusiGetBillingRecordRspBO rspBO = new BusiGetBillingRecordRspBO();
        List<GetOriginalDocumentsInfoVO> documentsInfoVOS = this.originalDocumentsInfoMapper.selectByBillingRecordReqBO(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        rspBO.setRecordsTotal(Integer.valueOf(0));
        rspBO.setPageNo(Integer.valueOf(1));
        rspBO.setTotal(Integer.valueOf(1));
        ArrayList billingRecordRspBOS = new ArrayList();
        if (documentsInfoVOS.size() != 0 && (billSummaryInfos = this.billSummaryInfoMapper.selectByDocumentNos(documentsNoList = documentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getDocumentNo).collect(Collectors.toList()))).size() != 0) {
            List<String> mergeNoList = billSummaryInfos.stream().filter(billSummaryInfo -> !FscBillStatus.NOT_INVOICED.getCode().equals(billSummaryInfo.getInvoiceStatus())).map(BillSummaryInfo::getMergeSetNo).distinct().collect(Collectors.toList());
            List<BillMergeInfo> billMergeInfos = this.billMergeInfoMapper.selectPageByMergeNo(mergeNoList, (Page<Map<String, Object>>)page);
            billingRecordRspBOS.addAll(JSON.parseArray((String)JSON.toJSONString(billMergeInfos), BillingRecordRspBO.class));
            for (BillingRecordRspBO billingRecordRspBO : billingRecordRspBOS) {
                String mergeSetNo = billingRecordRspBO.getMergeSetNo();
                List documentsNos = billSummaryInfos.stream().filter(billSummaryInfo -> mergeSetNo.equals(billSummaryInfo.getMergeSetNo())).map(BillSummaryInfo::getStatementNo).distinct().collect(Collectors.toList());
                List documentsInfoVOList = documentsInfoVOS.stream().filter(documentsInfo -> documentsNos.contains(documentsInfo.getDocumentNo())).collect(Collectors.toList());
                String jsonString = JSON.toJSONString(documentsInfoVOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                List billMergeInfoVOS = JSON.parseArray((String)jsonString, BillMergeInfoVO.class);
                billingRecordRspBO.setMergeInfoList(billMergeInfoVOS);
            }
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        rspBO.setRows(billingRecordRspBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

