/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pfscext.api.busi.BusiGetInspectionReportService;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetInspectionReportErpService;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpInfoRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetInspectionReportService.class)
public class BusiGetInspectionReportServiceImpl
implements BusiGetInspectionReportService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetInspectionReportServiceImpl.class);
    @Autowired
    private BusiGetInspectionReportErpService busiGetInspectionReportErpService;
    @Autowired
    private CacheClient cacheClient;
    private static final String INSPECTION_REPORT_KEY_PREFIX = "INSPECTION_REPORT_KEY";

    public BusiGetInspectionReportRspBO getInspectionReport(BusiGetInspectionReportReqBO reqBO) {
        log.info("\u67e5\u8be2\u8d28\u68c0\u62a5\u544a\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        if (null == reqBO.getPkOrg() || "".equals(reqBO.getPkOrg())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss");
        StringBuilder key = new StringBuilder();
        key.append(INSPECTION_REPORT_KEY_PREFIX).append(reqBO.getPkOrg());
        if (null != reqBO.getPkSupplier() && !"".equals(reqBO.getPkSupplier())) {
            key.append(reqBO.getPkSupplier());
        }
        if (null != reqBO.getStartDate()) {
            key.append(format.format(reqBO.getStartDate()));
        }
        if (null != reqBO.getEndDate()) {
            key.append(format.format(reqBO.getEndDate()));
        }
        if (null != reqBO.getVlimsbillcode()) {
            key.append(reqBO.getVlimsbillcode());
        }
        if (null != reqBO.getPkMaterial()) {
            key.append(reqBO.getPkMaterial());
        }
        if (null != reqBO.getVdef4()) {
            key.append(reqBO.getVdef4());
        }
        log.info("\u7f13\u5b58key:{}", (Object)key.toString());
        BusiGetInspectionReportRspBO rspBO = new BusiGetInspectionReportRspBO();
        int pageNo = reqBO.getPageNo();
        int startIndex = pageNo == 1 ? 0 : (pageNo - 1) * reqBO.getPageSize();
        int endIndex = startIndex + reqBO.getPageSize();
        String jsonString = (String)this.cacheClient.get(key.toString(), String.class);
        if (null != jsonString) {
            log.info("===========\u4ece\u7f13\u5b58\u83b7\u53d6============");
            List rspRows = JSON.parseArray((String)jsonString, BusiGetInspectionReportInfoRspBO.class);
            log.info("\u7f13\u5b58\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)rspRows));
            List receiptPageRspBos = rspRows.subList(startIndex, endIndex);
            int total = 0 == rspRows.size() % reqBO.getPageSize() ? rspRows.size() / reqBO.getPageSize() : rspRows.size() / reqBO.getPageSize() + 1;
            rspBO.setRows(receiptPageRspBos);
            rspBO.setTotal(Integer.valueOf(total));
            rspBO.setPageNo(Integer.valueOf(pageNo));
            rspBO.setRecordsTotal(Integer.valueOf(rspRows.size()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        BusiGetInspectionReportErpReqBO erpReqBO = new BusiGetInspectionReportErpReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)erpReqBO);
        BusiGetInspectionReportErpRspBO inspectionReport = this.busiGetInspectionReportErpService.getInspectionReport(erpReqBO);
        List dataList = inspectionReport.getDataList();
        ArrayList<BusiGetInspectionReportInfoRspBO> rows = new ArrayList<BusiGetInspectionReportInfoRspBO>();
        for (BusiGetInspectionReportErpInfoRspBO erpInfoRspBO : dataList) {
            BusiGetInspectionReportInfoRspBO receiptPageRspBO = new BusiGetInspectionReportInfoRspBO();
            BeanUtils.copyProperties((Object)erpInfoRspBO, (Object)receiptPageRspBO);
            rows.add(receiptPageRspBO);
        }
        int size = dataList.size();
        rspBO.setRecordsTotal(Integer.valueOf(size));
        if (size < reqBO.getPageSize()) {
            rspBO.setRows(rows);
            rspBO.setPageNo(Integer.valueOf(1));
            rspBO.setTotal(Integer.valueOf(1));
        } else {
            this.cacheClient.set(key.toString(), (Object)JSON.toJSONString(rows), 300000);
            int total = 0 == size % reqBO.getPageSize() ? size / reqBO.getPageSize() : size / reqBO.getPageSize() + 1;
            List receiptPageRsps = rows.subList(startIndex, endIndex);
            rspBO.setTotal(Integer.valueOf(total));
            rspBO.setPageNo(Integer.valueOf(pageNo));
            rspBO.setRows(receiptPageRsps);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

