/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryPayableDetailItemListPageService;
import com.tydic.pfscext.api.busi.bo.BusiQryPayableDetailItemListPageReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryPayableDetailItemListPageRspBO;
import com.tydic.pfscext.api.busi.bo.PayableDetailItemBO;
import com.tydic.pfscext.dao.DicDictionaryMapper;
import com.tydic.pfscext.dao.PayableDetailItemMapper;
import com.tydic.pfscext.dao.bo.DicDictionaryPO;
import com.tydic.pfscext.dao.po.PayableDetailItemPO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.DateUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiQryPayableDetailItemListPageService.class)
public class BusiQryPayableDetailItemListPageServiceImpl
implements BusiQryPayableDetailItemListPageService {
    @Autowired
    private PayableDetailItemMapper payableDetailItemMapper;
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;

    public BusiQryPayableDetailItemListPageRspBO qryPayableDetailItemList(BusiQryPayableDetailItemListPageReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getPayableNo())) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        PayableDetailItemPO payableDetailItemPO = new PayableDetailItemPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)payableDetailItemPO);
        List<PayableDetailItemBO> payableDetailItemBOS = this.payableDetailItemMapper.getListPage((Page<PayableDetailItemPO>)page, payableDetailItemPO);
        if (!CollectionUtils.isEmpty(payableDetailItemBOS)) {
            HashMap applyAgreePayTypeMap = new HashMap();
            DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
            dicDictionaryPO.setPCode("APPLY_ARGEE_PAY_TYPE");
            List<DicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(dicDictionaryPO);
            if (!CollectionUtils.isEmpty(dicDictionaryPOS)) {
                dicDictionaryPOS.forEach(dicDictionaryPO1 -> applyAgreePayTypeMap.put(dicDictionaryPO1.getCode(), dicDictionaryPO1.getDescrip()));
            }
            payableDetailItemBOS.forEach(payableDetailItemBO -> {
                if (!StringUtils.isBlank((CharSequence)payableDetailItemBO.getPayableStatus())) {
                    payableDetailItemBO.setPayableStatusStr(PayableStatus.getInstance(payableDetailItemBO.getPayableStatus()).getDescr());
                }
                if (!StringUtils.isBlank((CharSequence)payableDetailItemBO.getAgreePayType())) {
                    payableDetailItemBO.setAgreePayTypeStr((String)applyAgreePayTypeMap.get(payableDetailItemBO.getAgreePayType()));
                }
                if (null != payableDetailItemBO.getApplyDate()) {
                    payableDetailItemBO.setApplyDateStr(DateUtil.dateToStr(payableDetailItemBO.getApplyDate()));
                }
            });
        }
        BusiQryPayableDetailItemListPageRspBO rspBO = new BusiQryPayableDetailItemListPageRspBO();
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(payableDetailItemBOS);
        return rspBO;
    }
}

