/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SftpClient {
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String keyFile;
    private Session session;
    private String currPath = "/";
    private int timeout = 30000;
    private ChannelSftp sftp;
    private static final char CURR_PATH_CHAR = '/';
    private static final char TRANS_PATH_CHAR = '\\';

    public SftpClient() {
    }

    public SftpClient(String keyFileName) {
        this.keyFile = keyFileName;
    }

    public boolean connect(String host, int port, String username, String password, String rootPath) {
        JSch jsch = new JSch();
        try {
            this.logger.info("--SFTP Client,try to connnect server {} {},userName:{}", new Object[]{host, port, username});
            if (this.keyFile != null) {
                File f = new File(this.keyFile);
                if (!f.exists()) {
                    this.logger.error("--SFTP Client,Key file [" + this.keyFile + "]not found");
                    return false;
                }
                jsch.addIdentity(this.keyFile);
            }
            this.session = jsch.getSession(username, host, port);
            if (password != null) {
                this.session.setPassword(password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect(this.timeout);
            this.logger.info("--SFTP Client,Session is connected!");
            Channel channel = this.session.openChannel("sftp");
            channel.connect(this.timeout);
            this.logger.info("--SFTP Client,channel is connected successful,sftp is ready!");
            this.sftp = (ChannelSftp)channel;
            if (StringUtils.hasText((String)rootPath)) {
                this.changeDir(rootPath);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("--SFTP Client, access sftp server error," + e.getMessage(), (Throwable)e);
            this.disconnect();
            return false;
        }
    }

    private void disconnect() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.logger.info("--SFTP Client,sftp closed!");
    }

    private boolean changeDir(String path) {
        if (this.sftp == null) {
            this.logger.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!StringUtils.hasText((String)path)) {
            return true;
        }
        try {
            this.sftp.cd(path);
            if (path.charAt(path.length() - 1) != '/') {
                path = path + "/";
            }
            this.currPath = path;
            return true;
        }
        catch (SftpException e) {
            this.logger.error("--SFTP Client,CD " + path + " commond failed," + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<String> list(String path, String pattern) {
        return this.list(path, pattern, false, true, false);
    }

    public List<String> list(String path, String pattern, boolean includeDirectory, boolean includeFile, boolean withFullPath) {
        ArrayList<String> files = new ArrayList<String>();
        if (this.sftp == null) {
            this.logger.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return files;
        }
        StringBuilder cmd = new StringBuilder();
        if (!StringUtils.hasText((String)path)) {
            path = this.currPath;
        } else if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        cmd.append(path);
        if (StringUtils.hasText((String)pattern)) {
            cmd.append(pattern);
        }
        Vector ls = null;
        try {
            String cmdText = cmd.toString();
            this.logger.info("--SFTP Client,ls cmd [" + cmdText + "]");
            ls = this.sftp.ls(cmdText);
            for (Object l : ls) {
                ChannelSftp.LsEntry e = (ChannelSftp.LsEntry)l;
                if (includeFile && e.getAttrs().isDir() || includeDirectory && !e.getAttrs().isDir()) continue;
                String fileName = e.getFilename();
                if (withFullPath) {
                    fileName = path + fileName;
                }
                files.add(fileName);
            }
            this.logger.info("--SFTP Client,ls get files count=" + ls.size());
        }
        catch (Exception e) {
            this.logger.error("--SFTP Client,ls [" + cmd + "] cmd failed," + e.getMessage(), (Throwable)e);
        }
        return files;
    }

    public boolean download(String servFileName, String saveLocalPath, String saveToLocalName, boolean autoOverwrite) {
        if (this.sftp == null) {
            this.logger.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!StringUtils.hasText((String)saveToLocalName)) {
            int idx = servFileName.lastIndexOf(47);
            saveToLocalName = idx == -1 ? servFileName : servFileName.substring(idx + 1);
        }
        if (StringUtils.hasText((String)saveLocalPath)) {
            File file = new File(saveLocalPath);
            if (!file.exists()) {
                this.logger.error("--SFTP Client,download file [" + servFileName + "] failed,localPath" + saveLocalPath + " not exist");
                return false;
            }
            char sign = saveLocalPath.charAt(saveLocalPath.length() - 1);
            if (sign != '/' || sign != '\\') {
                saveLocalPath = saveLocalPath + "/";
            }
        }
        String fullName = saveLocalPath + saveToLocalName;
        File file = new File(fullName);
        if (!autoOverwrite && file.exists()) {
            this.logger.info("--SFTP Client,download file skip,target file " + fullName + " exists.");
            return true;
        }
        try {
            long tick = System.currentTimeMillis();
            this.sftp.get(servFileName, (OutputStream)new FileOutputStream(file));
            this.logger.info("--SFTP Client,download file [" + servFileName + "] to " + fullName + " successfully,timeCost=" + (System.currentTimeMillis() - tick));
            return true;
        }
        catch (Exception e) {
            this.logger.error("--SFTP Client,download file [" + servFileName + "] to [" + saveLocalPath + saveToLocalName + "] failed," + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public byte[] download(String servFileName) {
        if (this.sftp == null) {
            this.logger.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return null;
        }
        InputStream is = null;
        try {
            long tick = System.currentTimeMillis();
            is = this.sftp.get(servFileName);
            byte[] fileData = IOUtils.toByteArray((InputStream)is);
            this.logger.info("--SFTP Client,download file [{}] to buffer successfully,fileSize={},timeCost={}", new Object[]{servFileName, fileData.length, System.currentTimeMillis() - tick});
            return fileData;
        }
        catch (Exception e) {
            this.logger.error("--SFTP Client,download file [{}] failed,{}", (Object)servFileName, (Object)e.getMessage());
            return null;
        }
    }

    private boolean upload(String servPath, String servFileName, InputStream input) {
        if (this.sftp == null) {
            this.logger.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!this.changeDir(servPath)) {
            return false;
        }
        if (servPath.charAt(servPath.length() - 1) != '/') {
            servPath = servPath + "/";
        }
        String fullName = servPath + servFileName;
        try {
            this.sftp.put(input, fullName);
            this.logger.info("--SFTP Client,upload to servfile [{}] successfully", (Object)fullName);
            return true;
        }
        catch (SftpException e) {
            this.logger.error("--SFTP Client,upload to servfile [{}] failed,{}", (Object)fullName, (Object)e.getMessage());
            return false;
        }
    }

    public boolean upload(String localFileName, String servPath, String servFileName) {
        if (this.sftp == null) {
            this.logger.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!StringUtils.hasText((String)localFileName)) {
            this.logger.error("--SFTP Client,not found upload file name.");
            return false;
        }
        File file = new File(localFileName);
        if (!file.exists()) {
            this.logger.error("--SFTP Client,upload file [{}] failed,local file not found.", (Object)localFileName);
            return false;
        }
        if (file.isDirectory()) {
            this.logger.error("--SFTP Client,upload file name is a directory");
            return false;
        }
        if (!StringUtils.hasText((String)servFileName)) {
            int idx = localFileName.lastIndexOf(92);
            if (idx == -1) {
                idx = localFileName.lastIndexOf(47);
            }
            idx = idx == -1 ? 0 : ++idx;
            servFileName = localFileName.substring(idx);
        }
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            this.upload(servPath, servFileName, fs);
            return true;
        }
        catch (Exception e) {
            this.logger.error("--SFTP Client,upload file Exception,", (Throwable)e);
            return false;
        }
    }

    public boolean deleteFile(String servFileName) {
        if (this.sftp == null) {
            this.logger.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        try {
            this.sftp.rm(servFileName);
            return true;
        }
        catch (SftpException e) {
            this.logger.error("--SFTP Client,delete remote file " + servFileName + " failed," + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean isReady() {
        return this.sftp != null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static void main(String[] args) {
        SftpClient ftp = new SftpClient();
        ftp.connect("60.205.183.130", 22, "tomcat", "flzx3qC", "/var/ftp/ftptest/downLoad");
        if (ftp.isReady()) {
            List<String> fs = ftp.list("", "pab_505036_20170810_*.txt");
            System.out.println(fs.size() + "===" + fs);
        }
        ftp.disconnect();
    }
}

