/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.BusiFscReceiveOrderInfoService;
import com.tydic.pfscext.api.busi.bo.BusiFscReceiveOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiFscReceiveOrderInfoRspBO;
import com.tydic.pfscext.dao.OriginalOrderInfoMapper;
import com.tydic.pfscext.dao.po.OriginalOrderInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiFscReceiveOrderInfoService.class)
public class BusiFscReceiveOrderInfoServiceImpl
implements BusiFscReceiveOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiFscReceiveOrderInfoServiceImpl.class);
    private static final String UN_PUSH = "2";
    private static final String EFFECTIVE = "1";
    @Autowired
    private OriginalOrderInfoMapper originalOrderInfoMapper;

    public BusiFscReceiveOrderInfoRspBO receiveOrderInfo(BusiFscReceiveOrderInfoReqBO reqBO) {
        log.info("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u7684\u539f\u6599\u7164\u7b49\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        List orderList = reqBO.getOrderList();
        String jsonString = JSON.toJSONString((Object)orderList);
        List originalOrderInfos = JSON.parseArray((String)jsonString, OriginalOrderInfo.class);
        originalOrderInfos.forEach(originalOrderInfo -> {
            originalOrderInfo.setEffectiveState(EFFECTIVE);
            originalOrderInfo.setPushErpType(UN_PUSH);
        });
        log.info("\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)originalOrderInfos));
        try {
            this.originalOrderInfoMapper.insertBatch(originalOrderInfos);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8ba2\u5355\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u8ba2\u5355\u6570\u636e\u5931\u8d25");
        }
        BusiFscReceiveOrderInfoRspBO rspBO = new BusiFscReceiveOrderInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

