/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.BusiGetOriginalDocumentsFromErpService;
import com.tydic.pfscext.api.busi.bo.BusiDocumentSummaryInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetConsumptionSummaryErpReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetDOcumentsInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetDetailErpReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetDocumentDetailErpRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentErpRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetSummeryErpReqBO;
import com.tydic.pfscext.api.busi.vo.DocumentSummary;
import com.tydic.pfscext.api.busi.vo.OriginalDocumentDetailInfoVO;
import com.tydic.pfscext.api.busi.vo.OriginalDocumentSummaryInfoVO;
import com.tydic.pfscext.dao.BillDetailInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillDetailInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetOriginalDocumentsFromErpService.class)
public class BusiGetOriginalDocumentsFromErpServiceImpl
implements BusiGetOriginalDocumentsFromErpService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetOriginalDocumentsFromErpServiceImpl.class);
    @Value(value="${ESB_GET_ORDER_INFO_SYNC_ERP_URL:http://10.18.0.39:8001/OSN/api/purchaseInOrder/v1}")
    private String ESB_GET_ORDER_INFO_SYNC_ERP_URL;
    @Value(value="${ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL:http://10.18.0.39:8001/OSN/api/settleSummary/v1}")
    private String ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL;
    @Value(value="${ESB_GET_ORDER_DETAIL_SYNC_ERP_URL:http://10.18.0.39:8001/OSN/api/settleSummaryDetails/v1}")
    private String ESB_GET_ORDER_DETAIL_SYNC_ERP_URL;
    @Value(value="${ESB_GET_CONSUMPTION_SUMMARY_SYNC_ERP_URL:http://10.18.0.39:8001/OSN/api/vmisum/v1}")
    private String ESB_GET_CONSUMPTION_SUMMARY_SYNC_ERP_URL;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;
    public static final String ORG_CODE = "0105";

    public BusiGetDOcumentsInfoRspBO getOriginalDocuments() {
        log.info("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2erp\u91c7\u8d2d\u5165\u5e93\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        Date now = new Date();
        Date before10Min = new Date(now.getTime() - 600000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDate = simpleDateFormat.format(before10Min);
        String endDate = simpleDateFormat.format(now);
        try {
            this.getDocumentsInfo(ORG_CODE, startDate, endDate);
            List<OriginalDocumentsInfo> summeryInfos = this.getSummeryInfo(ORG_CODE, startDate, endDate);
            this.getDetail(summeryInfos);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            e.printStackTrace();
        }
        BusiGetDOcumentsInfoRspBO rspBO = new BusiGetDOcumentsInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5931\u8d25");
        return rspBO;
    }

    private void getDetail(List<OriginalDocumentsInfo> summeryInfos) {
        log.info("=================\u67e5\u8be2\u660e\u7ec6================");
        for (OriginalDocumentsInfo summeryInfo : summeryInfos) {
            if (summeryInfo.getSummeryHeadId() == null || "".equals(summeryInfo.getSummeryHeadId())) continue;
            BusiGetDetailErpReqBO detailErpReqBO = new BusiGetDetailErpReqBO();
            detailErpReqBO.setCgeneralhId(summeryInfo.getSummeryHeadId());
            OriginalDocumentDetailInfoVO originalDocumentDetailErp = this.getOriginalDocumentDetailErp(detailErpReqBO);
            if ("0".equals(originalDocumentDetailErp.getCode())) {
                if (null == originalDocumentDetailErp.getData() && originalDocumentDetailErp.getDataList().size() == 0) {
                    log.error("\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u660e\u7ec6\u5355erp\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)originalDocumentDetailErp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u660e\u7ec6\u5355erp\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
                }
                List dataList = originalDocumentDetailErp.getDataList();
                for (BusiGetDocumentDetailErpRspBO busiGetDocumentDetailErpRspBO : dataList) {
                    List documentDetails = busiGetDocumentDetailErpRspBO.getBvos();
                    String documentDetailsJsonString = JSON.toJSONString((Object)documentDetails, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    List billDetailInfos = JSON.parseArray((String)documentDetailsJsonString, BillDetailInfo.class);
                    for (BillDetailInfo billDetailInfo : billDetailInfos) {
                        long nextId = Sequence.getInstance().nextId();
                        billDetailInfo.setId(String.valueOf(nextId));
                        billDetailInfo.setEffectiveState("1");
                        billDetailInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                        billDetailInfo.setStatementNo(summeryInfo.getDocumentNo());
                    }
                    log.info("\u5f85\u63d2\u5165\u660e\u7ec6\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)billDetailInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    int n = this.billDetailInfoMapper.insertBatch(billDetailInfos);
                }
                continue;
            }
            log.error("\u8c03\u7528erp\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u660e\u7ec6\u5355\u51fa\u9519:{}", (Object)originalDocumentDetailErp.getMsg());
            throw new PfscExtBusinessException("\u5931\u8d25", originalDocumentDetailErp.getMsg());
        }
    }

    private List<OriginalDocumentsInfo> getSummeryInfo(String orgCode, String startTime, String endTime) {
        log.info("=================\u67e5\u8be2\u7ed3\u7b97\u5355================");
        BusiGetSummeryErpReqBO summeryErpReqBO = new BusiGetSummeryErpReqBO();
        summeryErpReqBO.setPkOrg(orgCode);
        summeryErpReqBO.setInvoiceStatus(Integer.valueOf(2));
        summeryErpReqBO.setStartDate(startTime);
        summeryErpReqBO.setEndDate(endTime);
        OriginalDocumentSummaryInfoVO originalDocumentSummeryErp = this.getOriginalDocumentSummeryErp(summeryErpReqBO);
        ArrayList<OriginalDocumentsInfo> originalDocumentsInfos = new ArrayList<OriginalDocumentsInfo>();
        if ("0".equals(originalDocumentSummeryErp.getCode())) {
            if (null == originalDocumentSummeryErp.getData() && originalDocumentSummeryErp.getDataList().size() == 0) {
                log.error("\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u6c47\u603b\u5355erp\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)originalDocumentSummeryErp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u6c47\u603b\u5355erp\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            }
            List dataList = originalDocumentSummeryErp.getDataList();
            for (BusiDocumentSummaryInfoRspBO busiDocumentSummaryInfoRspBO : dataList) {
                OriginalDocumentsInfo originalDocumentsInfo = new OriginalDocumentsInfo();
                BeanUtils.copyProperties((Object)busiDocumentSummaryInfoRspBO, (Object)originalDocumentsInfo);
                originalDocumentsInfo.setEffectiveState("1");
                originalDocumentsInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                originalDocumentsInfo.setBillType("1");
                log.info("\u7ed3\u7b97\u5355:{}", (Object)originalDocumentsInfo);
                int insert = this.originalDocumentsInfoMapper.insert(originalDocumentsInfo);
                originalDocumentsInfos.add(originalDocumentsInfo);
                List documentSummaries = busiDocumentSummaryInfoRspBO.getBvos();
                ArrayList<BillSummaryInfo> billSummaryInfos = new ArrayList<BillSummaryInfo>();
                for (DocumentSummary documentSummary : documentSummaries) {
                    BillSummaryInfo billSummaryInfo = new BillSummaryInfo();
                    BeanUtils.copyProperties((Object)documentSummary, (Object)billSummaryInfo);
                    billSummaryInfo.setEffectiveState("1");
                    long nextId = Sequence.getInstance().nextId();
                    billSummaryInfo.setId(String.valueOf(nextId));
                    billSummaryInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                    billSummaryInfo.setStatementNo(busiDocumentSummaryInfoRspBO.getDocumentNo());
                    billSummaryInfos.add(billSummaryInfo);
                    billSummaryInfo.setBillType("1");
                }
                log.info("\u5f85\u63d2\u5165\u6c47\u603b\u5355\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(billSummaryInfos));
                int n = this.billSummaryInfoMapper.insertBatch(billSummaryInfos);
            }
        } else {
            log.error("\u8c03\u7528erp\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u6c47\u603b\u5355\u51fa\u9519:{}", (Object)originalDocumentSummeryErp.getMsg());
            throw new PfscExtBusinessException("\u5931\u8d25", originalDocumentSummeryErp.getMsg());
        }
        return originalDocumentsInfos;
    }

    private List<BusiGetOriginalDocumentErpRspBO> getDocumentsInfo(String orgCode, String startTime, String endTime) {
        log.info("=================\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f================");
        BusiGetOriginalDocumentsReqBO reqBO = new BusiGetOriginalDocumentsReqBO();
        reqBO.setPkOrg(orgCode);
        reqBO.setInvoiceStatus(Integer.valueOf(2));
        reqBO.setStartDate(startTime);
        reqBO.setEndDate(endTime);
        BusiGetOriginalDocumentsRspBO originalDocumentFromErp = this.getOriginalDocumentFromErp(reqBO);
        ArrayList<BusiGetOriginalDocumentErpRspBO> dataList = new ArrayList<BusiGetOriginalDocumentErpRspBO>();
        if ("0".equals(originalDocumentFromErp.getCode())) {
            if (null == originalDocumentFromErp.getData() && originalDocumentFromErp.getDataList().size() == 0) {
                log.error("\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93erp\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)originalDocumentFromErp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93erp\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            }
            dataList.addAll(originalDocumentFromErp.getDataList());
            for (BusiGetOriginalDocumentErpRspBO busiGetOriginalDocumentErpRspBO : dataList) {
                OriginalDocumentsInfo originalDocumentsInfo = new OriginalDocumentsInfo();
                BeanUtils.copyProperties((Object)busiGetOriginalDocumentErpRspBO, (Object)originalDocumentsInfo);
                originalDocumentsInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                originalDocumentsInfo.setEffectiveState("1");
                originalDocumentsInfo.setBillType("2");
                log.info("\u539f\u59cb\u5355\u636e:{}", (Object)originalDocumentsInfo);
                int insert = this.originalDocumentsInfoMapper.insert(originalDocumentsInfo);
                List documentsItemRspBOS = busiGetOriginalDocumentErpRspBO.getBvos();
                ArrayList<BillSummaryInfo> billSummaryInfos = new ArrayList<BillSummaryInfo>();
                for (BusiGetOriginalDocumentsItemRspBO documentsItemRspBO : documentsItemRspBOS) {
                    BillSummaryInfo billSummaryInfo = new BillSummaryInfo();
                    BeanUtils.copyProperties((Object)documentsItemRspBO, (Object)billSummaryInfo);
                    long nextId = Sequence.getInstance().nextId();
                    billSummaryInfo.setId(String.valueOf(nextId));
                    billSummaryInfo.setStatementNo(busiGetOriginalDocumentErpRspBO.getDocumentNo());
                    billSummaryInfo.setEffectiveState("1");
                    billSummaryInfo.setBillType("2");
                    billSummaryInfos.add(billSummaryInfo);
                }
                log.info("\u5f85\u63d2\u5165\u91c7\u8d2d\u5165\u5e93\u6c47\u603b\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString(billSummaryInfos));
                int n = this.billSummaryInfoMapper.insertBatch(billSummaryInfos);
            }
        } else {
            log.error("\u8c03\u7528erp\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u51fa\u9519:{}", (Object)originalDocumentFromErp.getMsg());
            throw new PfscExtBusinessException("\u5931\u8d25", originalDocumentFromErp.getMsg());
        }
        return dataList;
    }

    private BusiGetOriginalDocumentsRspBO getOriginalDocumentFromErp(BusiGetOriginalDocumentsReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_GET_ORDER_INFO_SYNC_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_GET_ORDER_INFO_SYNC_ERP_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.ESB_GET_ORDER_INFO_SYNC_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        String replaced = returnString.replaceAll("~", "");
        log.info("\u66ff\u6362\u540e\uff1a{}", (Object)replaced);
        BusiGetOriginalDocumentsRspBO erpRsp = (BusiGetOriginalDocumentsRspBO)JSON.parseObject((String)replaced, BusiGetOriginalDocumentsRspBO.class);
        return erpRsp;
    }

    private OriginalDocumentSummaryInfoVO getOriginalDocumentSummeryErp(BusiGetSummeryErpReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5f02\u5e38");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        String replaced = returnString.replaceAll("~", "");
        log.info("\u66ff\u6362\u540e\uff1a{}", (Object)replaced);
        OriginalDocumentSummaryInfoVO erpRsp = (OriginalDocumentSummaryInfoVO)JSON.parseObject((String)returnString, OriginalDocumentSummaryInfoVO.class);
        return erpRsp;
    }

    private OriginalDocumentDetailInfoVO getOriginalDocumentDetailErp(BusiGetDetailErpReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_GET_ORDER_DETAIL_SYNC_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_GET_ORDER_DETAIL_SYNC_ERP_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5f02\u5e38");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.ESB_GET_ORDER_DETAIL_SYNC_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        String replaced = returnString.replaceAll("~", "");
        log.info("\u66ff\u6362\u540e\uff1a{}", (Object)replaced);
        OriginalDocumentDetailInfoVO erpRsp = (OriginalDocumentDetailInfoVO)JSON.parseObject((String)returnString, OriginalDocumentDetailInfoVO.class);
        return erpRsp;
    }

    private OriginalDocumentDetailInfoVO getConsumptionSummaryErp(BusiGetConsumptionSummaryErpReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_GET_CONSUMPTION_SUMMARY_SYNC_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_GET_CONSUMPTION_SUMMARY_SYNC_ERP_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.ESB_GET_CONSUMPTION_SUMMARY_SYNC_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u6d88\u8017\u6c47\u603b\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        String replaced = returnString.replaceAll("~", "");
        log.info("\u66ff\u6362\u540e\uff1a{}", (Object)replaced);
        OriginalDocumentDetailInfoVO erpRsp = (OriginalDocumentDetailInfoVO)JSON.parseObject((String)returnString, OriginalDocumentDetailInfoVO.class);
        return erpRsp;
    }
}

