/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pfscext.api.busi.BusiInvoiceBaiwangCheckErpService;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceBaiwangCheckErpReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceBaiwangCheckErpRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiInvoiceBaiwangCheckService;
import com.tydic.pfscext.external.api.bo.BusiInvoiceBaiwangCheckReqBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceBaiwangCheckRspBO;
import com.tydic.pfscext.external.utils.JsonUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiInvoiceBaiwangCheckErpService.class)
public class BusiInvoiceBaiwangCheckErpServiceImpl
implements BusiInvoiceBaiwangCheckErpService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceBaiwangCheckErpServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private BusiInvoiceBaiwangCheckService baiwangCheckService;

    public BusiInvoiceBaiwangCheckErpRspBO invoiceBaiwangCheck(BusiInvoiceBaiwangCheckErpReqBO busiInvoiceBaiwangCheckErpReqBO) {
        log.info("\u767e\u65fa\u67e5\u9a8c\u53d1\u7968\u5165\u53c2\uff1a{}", (Object)busiInvoiceBaiwangCheckErpReqBO.toString());
        this.checkParams(busiInvoiceBaiwangCheckErpReqBO);
        String jsonStr = JSON.toJSONString((Object)busiInvoiceBaiwangCheckErpReqBO);
        BusiInvoiceBaiwangCheckReqBO busiInvoiceBaiwangCheckReqBO = (BusiInvoiceBaiwangCheckReqBO)JSON.parseObject((String)jsonStr, BusiInvoiceBaiwangCheckReqBO.class);
        BusiInvoiceBaiwangCheckRspBO busiInvoiceBaiwangCheckRspBO = this.baiwangCheckService.invoiceBaiwangCheck(busiInvoiceBaiwangCheckReqBO);
        String code = "0000";
        String codeFalse = "CY0018";
        String codeTimesOut = "CY0011";
        BusiInvoiceBaiwangCheckErpRspBO resultRspBO = new BusiInvoiceBaiwangCheckErpRspBO();
        String resCode = busiInvoiceBaiwangCheckRspBO.getCode();
        if (resCode.equals("CY0018")) {
            resultRspBO.setCode(code);
            resultRspBO.setMessage("\u67e5\u8be2\u6210\u529f");
            resultRspBO.setData((Object)"\u53d1\u7968\u4e3a\u5047\u53d1\u7968");
            log.info("fsc-\u67e5\u9a8c\u53d1\u7968--\u767e\u65fa\u67e5\u9a8c\uff1a\u67e5\u8be2\u6210\u529f\uff0c\u4e3a\u5047\u53d1\u7968\uff01");
            return resultRspBO;
        }
        if (resCode.equals("CY0011")) {
            resultRspBO.setCode(code);
            resultRspBO.setMessage("\u8be5\u5f20\u53d1\u7968\u8d85\u51fa\u5f53\u5929\u67e5\u9a8c\u6b21\u6570\uff01");
            resultRspBO.setData((Object)"\u8be5\u5f20\u53d1\u7968\u8d85\u51fa\u5f53\u5929\u67e5\u9a8c\u6b21\u6570\uff01");
        }
        if (code.equals(resCode)) {
            resultRspBO.setCode(code);
            resultRspBO.setMessage(busiInvoiceBaiwangCheckRspBO.getMsg());
            String dataJson = JSON.toJSONString((Object)busiInvoiceBaiwangCheckRspBO.getData());
            BusiInvoiceBaiwangCheckErpRspBO.Data dataBean = (BusiInvoiceBaiwangCheckErpRspBO.Data)JsonUtils.jsonStringToJavaBean((String)dataJson, BusiInvoiceBaiwangCheckErpRspBO.Data.class);
            resultRspBO.setData((Object)dataBean);
            log.info("fsc-\u67e5\u9a8c\u53d1\u7968--\u767e\u65fa\u67e5\u9a8c\uff1a\u67e5\u8be2\u6210\u529f\uff0c\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)busiInvoiceBaiwangCheckRspBO.toString());
            return resultRspBO;
        }
        log.error("fsc--\u67e5\u9a8c\u53d1\u7968--\u67e5\u8be2\u7ed3\u679c\uff0ccode={},result={}", (Object)busiInvoiceBaiwangCheckRspBO.getCode(), (Object)busiInvoiceBaiwangCheckRspBO.toString());
        throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u9a8c\u53d1\u7968\u4fe1\u606f\u9519\u8bef\uff1bcode=" + resCode);
    }

    private void checkParams(BusiInvoiceBaiwangCheckErpReqBO busiInvoiceBaiwangCheckReqBO) {
        String fplxdm = busiInvoiceBaiwangCheckReqBO.getFplx();
        if (StringUtils.isEmpty((Object)fplxdm)) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u7c7b\u578b\u4ee3\u7801\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u9a8c\u53d1\u7968\u7c7b\u578b\u4ee3\u7801\u51fa\u9519");
        }
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getFphm())) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u53f7\u7801\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u9a8c\u53d1\u7968\u53f7\u7801\u51fa\u9519");
        }
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getFphm())) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u4ee3\u7801\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u9a8c\u53d1\u7968\u4ee3\u7801\u51fa\u9519");
        }
        boolean present = Arrays.asList("04", "10", "11", "14").stream().filter(code -> code.equals(fplxdm.trim())).findAny().isPresent();
        if (present && StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getJym())) {
            log.error("\u67e5\u9a8c\u6821\u9a8c\u7801\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u9a8c\u6821\u9a8c\u7801\u51fa\u9519");
        }
        boolean fpkePresent = Arrays.asList("01", "02", "03", "15").stream().filter(code -> code.equals(fplxdm.trim())).findAny().isPresent();
        if (fpkePresent && StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getFpje())) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u91d1\u989d\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u9a8c\u53d1\u7968\u91d1\u989d\u51fa\u9519");
        }
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getKprq())) {
            log.error("\u67e5\u9a8c\u5f00\u7968\u65e5\u671f\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u9a8c\u5f00\u7968\u65e5\u671f\u51fa\u9519");
        }
    }
}

