/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.DzcsInvoiceReturnAuthApplyService;
import com.tydic.pfscext.api.busi.bo.DzcsInvoiceReturnAuthApplyReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.InvoiceReturnMapper;
import com.tydic.pfscext.dao.po.InvoiceReturn;
import com.tydic.pfscext.enums.InvoiceReturnStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsInvoiceReturnAuthApplyServiceImpl
implements DzcsInvoiceReturnAuthApplyService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnAuthApplyServiceImpl.class);
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;

    public PfscExtRspBaseBO process(DzcsInvoiceReturnAuthApplyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u5ba1\u6279\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        String authType = reqBO.getAuthType();
        String billNo = reqBO.getBillNo();
        String type = reqBO.getType();
        String remark = reqBO.getRemark();
        String authRemark = reqBO.getAuthRemark();
        if (!"1".equals(authType) && !"0".equals(authType)) {
            throw new PfscExtBusinessException("0001", "authType\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)billNo)) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)type)) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)remark)) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        if (!InvoiceReturnStatus.TO_APPROVE.getCode().equals(invoiceReturn.getStatus()) && !InvoiceReturnStatus.TO_RETURN.getCode().equals(invoiceReturn.getStatus())) {
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\u4ee5\u4e0b\u72b6\u6001\u652f\u6301\u5ba1\u6279\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.TO_APPROVE) + "\u3001" + this.enumsService.getDescr(InvoiceReturnStatus.TO_RETURN));
        }
        invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setType(type);
        invoiceReturn.setRemark(remark);
        invoiceReturn.setStatus("1".equals(authType) ? InvoiceReturnStatus.TO_RETURN.getCode() : InvoiceReturnStatus.REJECTED.getCode());
        invoiceReturn.setAuthRemark(authRemark);
        invoiceReturn.setAuthUser(this.userInfoService.queryUserNameByUserId(reqBO.getUserId()));
        invoiceReturn.setAuthDate(new Date());
        this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        return new PfscExtRspBaseBO();
    }
}

