/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.deal.QueryPayOrderInfoDetailService;
import com.tydic.pfscext.api.deal.bo.PayOrderInfoDetailReqBO;
import com.tydic.pfscext.api.deal.bo.PayOrderInfoDetailRspBO;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayOrderInfoType;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.enums.PayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryPayOrderInfoDetailService.class)
public class QueryPayOrderInfoDetailServiceImpl
implements QueryPayOrderInfoDetailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPayOrderInfoDetailServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    public PayOrderInfoDetailRspBO queryPayOrderInfoDetail(PayOrderInfoDetailReqBO payOrderInfoDetailReqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5165\u53c2\uff1a" + payOrderInfoDetailReqBO);
        }
        if (payOrderInfoDetailReqBO.getPayOrderId() == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayOrderInfoDetailRspBO payOrderInfoDetailRspBO = new PayOrderInfoDetailRspBO();
        try {
            PayOrderInfoPO payOrderInfoPO = this.payOrderInfoMapper.selectByPrimaryKey(payOrderInfoDetailReqBO.getPayOrderId());
            BeanUtils.copyProperties((Object)payOrderInfoPO, (Object)payOrderInfoDetailRspBO);
            if (payOrderInfoPO.getPayOrderStatus() != null && !payOrderInfoPO.getPayOrderStatus().equals("")) {
                payOrderInfoDetailRspBO.setPayOrderStatusStr(PayOrderStatus.getInstance(payOrderInfoPO.getPayOrderStatus()).getDescr());
            }
            if (payOrderInfoPO.getPayOrderType() != null && !payOrderInfoPO.getPayOrderType().equals("")) {
                payOrderInfoDetailRspBO.setPayOrderTypeStr(PayOrderInfoType.getInstance(payOrderInfoPO.getPayOrderType()).getDescr());
            }
            if (payOrderInfoPO.getPayType() != null && !payOrderInfoPO.getPayType().equals("")) {
                payOrderInfoDetailRspBO.setPayTypeStr(PayType.getInstance(payOrderInfoPO.getPayType()).getDescr());
            }
            if (payOrderInfoPO.getPayChannel() != null) {
                payOrderInfoDetailRspBO.setPayChannelStr(PayChannel.getInstance(payOrderInfoPO.getPayChannel()).getDescr());
            }
            try {
                if (payOrderInfoPO.getPayOrderYear() != null && payOrderInfoPO.getPayOrderMonth() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708");
                    String orderTime = payOrderInfoPO.getPayOrderYear() + "\u5e74" + payOrderInfoPO.getPayOrderMonth() + "\u6708";
                    payOrderInfoDetailRspBO.setPayOrderTime(sdf.parse(orderTime));
                }
            }
            catch (ParseException ee) {
                LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)ee);
                throw new PfscExtBusinessException("18000", "\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u5931\u8d25");
        }
        return payOrderInfoDetailRspBO;
    }
}

