/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingAnBankAcCheckingFile {
    private static final Log logger = LogFactory.getLog(PingAnBankAcCheckingFile.class);
    private FileInputStream fis;
    private InputStreamReader reader;
    private BufferedReader bufferReader;
    private boolean hasReadHeader = false;
    private String filename;
    private String mainAcctNo;
    private BigDecimal totalAmt;
    private int totalCount;
    private int fileCount;
    private int fileIndex;
    private static final int NEXT_DATA_LINE_NUM = 1000;
    private static final int HEADER_INFO_LENGTH = 3;
    private static final int TEXT_ARR_LENGTH = 9;
    private static final int SSN_DATA_LINE_LENGTH = 10;
    private static final int PAYACCTNO_DATA_LINE_LENGTH = 2;
    private static final int RECVACCTNO_DATA_LINE_LENGTH = 3;
    private static final int TXNAMT_DATA_LINE_LENGTH = 9;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean open(String fileName, boolean needReadHeader) {
        File f = new File(fileName);
        if (!f.exists()) {
            logger.info((Object)("\u5e73\u5b89\u5bf9\u8d26\u6587\u4ef6,file not found:" + fileName));
            return false;
        }
        this.filename = fileName;
        try {
            this.fis = new FileInputStream(fileName);
            this.reader = new InputStreamReader((InputStream)this.fis, "gbk");
            this.bufferReader = new BufferedReader(this.reader);
        }
        catch (Exception e) {
            logger.error((Object)("\u5e73\u5b89\u5bf9\u8d26\u6587\u4ef6,open file failed," + e.getMessage()), (Throwable)e);
            return false;
        }
        boolean bl = this.hasReadHeader = !needReadHeader;
        if (needReadHeader) {
            this.loadHeader();
        }
        return true;
    }

    public boolean open(byte[] byteBuffer, boolean needReadHeader) {
        ByteArrayInputStream input = new ByteArrayInputStream(byteBuffer);
        try {
            this.reader = new InputStreamReader((InputStream)input, "gbk");
            this.bufferReader = new BufferedReader(this.reader);
        }
        catch (Exception e) {
            return false;
        }
        boolean bl = this.hasReadHeader = !needReadHeader;
        if (needReadHeader) {
            this.loadHeader();
        }
        return true;
    }

    public void close() {
        try {
            if (this.bufferReader != null) {
                this.bufferReader.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        this.fis = null;
        this.reader = null;
        this.bufferReader = null;
    }

    public List<String[]> load() {
        String line;
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < 1000 && (line = this.readLine()) != null && line.trim().length() != 0 && this.parseText(list, line); ++i) {
        }
        return list;
    }

    private String readLine() {
        try {
            return this.bufferReader.readLine();
        }
        catch (IOException e) {
            logger.error((Object)("\u5e73\u5b89\u5bf9\u8d26\u6587\u4ef6,read error " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private boolean loadHeader() {
        String[] headerInfo;
        int idx = 0;
        String text = this.readLine();
        if (text == null) {
            return false;
        }
        if (!this.hasReadHeader && (headerInfo = text.split("#")).length > 3) {
            this.mainAcctNo = headerInfo[idx++];
            ++idx;
            int n = ++idx;
            this.fileCount = Integer.valueOf(headerInfo[n]);
            int n2 = ++idx;
            this.fileIndex = Integer.valueOf(headerInfo[n2]);
            int n3 = ++idx;
            this.totalCount = Integer.valueOf(headerInfo[n3]);
            int n4 = ++idx;
            ++idx;
            this.totalAmt = new BigDecimal(headerInfo[n4]);
            this.hasReadHeader = true;
        }
        return true;
    }

    private boolean parseText(List<String[]> list, String text) {
        String[] inf = text.split("\\|");
        if (inf.length < 9) {
            return false;
        }
        list.add(inf);
        return true;
    }

    public String getSsn(String[] lineData) {
        if (lineData == null || lineData.length < 10) {
            return null;
        }
        return lineData[9];
    }

    public String getBusiSsn(String[] lineData) {
        if (lineData == null || lineData.length < 1) {
            return null;
        }
        return lineData[0];
    }

    public String getPayAcctNo(String[] lineData) {
        if (lineData == null || lineData.length < 2) {
            return null;
        }
        return lineData[1];
    }

    public String getRecvAcctNo(String[] lineData) {
        if (lineData == null || lineData.length < 3) {
            return null;
        }
        return lineData[2];
    }

    public BigDecimal getTxnAmt(String[] lineData) {
        if (lineData == null || lineData.length < 9) {
            return null;
        }
        String v = lineData[8];
        BigDecimal amt = null;
        try {
            amt = new BigDecimal(v);
        }
        catch (Exception e) {
            logger.error((Object)("\u91d1\u989d\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38" + e.getMessage()), (Throwable)e);
        }
        return amt;
    }

    public void print(List<String[]> data) {
        for (Object[] objectArray : data) {
            System.out.println(Arrays.toString(objectArray));
        }
    }

    public String getMainAcctNo() {
        return this.mainAcctNo;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public BigDecimal getTotalAmt() {
        return this.totalAmt;
    }

    public String toString() {
        return "PingAnBankAcCheckingFile [fileIndex=" + this.fileIndex + ", mainAcctNo=" + this.mainAcctNo + ", totalCount=" + this.totalCount + ", hasReadHeader=" + this.hasReadHeader + ", fileCount=" + this.fileCount + "]";
    }
}

