/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.BusiBillingModifyConfirmService;
import com.tydic.pfscext.api.busi.bo.BusiBillingModifyConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.BusiBillingModifyConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.InvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.vo.BillSummaryInfoVO;
import com.tydic.pfscext.dao.BillDetailInfoMapper;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.InvoiceInfoTempMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.PriceSettlementSummaryInfoMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.InvoiceInfoTemp;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.NInvoiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiInvoiceCreatePushErpSercive;
import com.tydic.pfscext.external.api.bo.BusiInvoiceCreatePushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceCreatePushErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiStoreInvoiceCreateBodyPushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiStoreInvoiceCreatePushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiSummaryInvoiceBodyPushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiSummaryInvoiceCreatePushErpReqBO;
import com.tydic.pfscext.external.api.bo.InvoicePushErpItemInfo;
import com.tydic.pfscext.external.api.bo.InvoicePushErpRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiBillingModifyConfirmService.class)
public class BusiBillingModifyConfirmServiceImpl
implements BusiBillingModifyConfirmService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillingModifyConfirmServiceImpl.class);
    private static final String BILLING = "1";
    private static final String MODIFY = "2";
    private static final String CONFIRM = "3";
    private static final String PREFIX = "HBDH";
    @Autowired
    private InvoiceInfoTempMapper invoiceInfoTempMapper;
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private PriceSettlementSummaryInfoMapper priceSettlementSummaryInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;
    @Autowired
    private BusiInvoiceCreatePushErpSercive busiInvoiceCreatePushErpSercive;

    public BusiBillingModifyConfirmRspBO billingModifyConfirm(BusiBillingModifyConfirmReqBO reqBO) {
        log.info("\u91c7\u8d2d\u5165\u5e93\u5f00\u7968\uff0c\u4fee\u6539\uff0c\u786e\u8ba4\u5165\u53c2\uff1a{}", (Object)reqBO);
        this.billingVerification(reqBO);
        if (BILLING.equals(reqBO.getOperationType()) || CONFIRM.equals(reqBO.getOperationType())) {
            this.billingOrConfirm(reqBO);
        } else if (MODIFY.equals(reqBO.getOperationType())) {
            this.modify(reqBO);
        }
        BusiBillingModifyConfirmRspBO rspBO = new BusiBillingModifyConfirmRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    /*
     * WARNING - void declaration
     */
    private void billingOrConfirm(BusiBillingModifyConfirmReqBO reqBO) {
        String mergeNO = BILLING.equals(reqBO.getOperationType()) ? this.getMergeNO() : reqBO.getMergeDocumentNo();
        List documentNos = reqBO.getDocumentNos();
        List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(documentNos);
        List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.selectSummeriesByDocumentNos(documentNos);
        List<String> documentNoList = getOriginalDocumentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getDocumentNo).collect(Collectors.toList());
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        BillMergeInfo billMergeInfo = new BillMergeInfo();
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<Object> amtList = new ArrayList<Object>();
        if (NInvoiceType.CHEMICAL_STRO_BILL.getCode().equals(reqBO.getType()) || NInvoiceType.NON_DEPOSIT_MATERIAL.getCode().equals(reqBO.getType())) {
            List billSummaryInfoVos = reqBO.getBillSummaryInfos();
            if (billSummaryInfoVos.size() == 0) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u6c47\u603b\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List list = billSummaryInfoVos.stream().map(BillSummaryInfoVO::getInvoicableAmt).collect(Collectors.toList());
            amtList.addAll(list);
        } else if (NInvoiceType.DEPOSIT_MATERIAL.getCode().equals(reqBO.getType())) {
            Map<String, BillSummaryInfo> summaryInfoMap = billSummaryInfos.stream().collect(Collectors.toMap(BillSummaryInfo::getStatementNo, billSummaryInfo -> billSummaryInfo));
            Double d = new Double("0");
            BigDecimal totalNoTaxAmt = BigDecimal.ZERO;
            BigDecimal totalTaxAmt = BigDecimal.ZERO;
            for (GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO : getOriginalDocumentsInfoVOS) {
                void var12_14;
                Double d2 = var12_14.doubleValue() + new Double(getOriginalDocumentsInfoVO.getSetTotalNum());
                BigDecimal qua = new BigDecimal(getOriginalDocumentsInfoVO.getSumTotalNum());
                BigDecimal noTaxPrice = new BigDecimal(getOriginalDocumentsInfoVO.getNoTaxPrice());
                totalNoTaxAmt = totalNoTaxAmt.add(qua.multiply(noTaxPrice));
                BillSummaryInfo billSummaryInfo2 = summaryInfoMap.get(getOriginalDocumentsInfoVO.getDocumentNo());
                String taxRate = billSummaryInfo2.getTaxRate();
                BigDecimal tax = totalNoTaxAmt.divide(new BigDecimal(taxRate).add(BigDecimal.ONE), RoundingMode.HALF_UP).setScale(5);
                totalTaxAmt = totalTaxAmt.add(totalNoTaxAmt.add(tax));
            }
            amtList.add(totalTaxAmt.toString());
        } else {
            List amts = getOriginalDocumentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getActualPayAmt).collect(Collectors.toList());
            amtList.addAll(amts);
        }
        for (String string : amtList) {
            if (!StringUtils.hasText((String)string)) continue;
            BigDecimal bigDecimal = new BigDecimal(string);
            totalAmt = totalAmt.add(bigDecimal);
        }
        billMergeInfo.setTotalAmt(String.valueOf(totalAmt));
        billMergeInfo.setMergeSetNo(mergeNO);
        billMergeInfo.setSupplierId(getOriginalDocumentsInfoVOS.get(0).getSupplier());
        billMergeInfo.setSetUnitCode(getOriginalDocumentsInfoVOS.get(0).getSettlementSupplier());
        billMergeInfo.setTotalIncoicedNum(invoiceInfoReqBO.getActualInvoicedQuantity());
        billMergeInfo.setInvoiceType(invoiceInfoReqBO.getInvoceType());
        if (null != invoiceInfoReqBO.getCreditDate()) {
            billMergeInfo.setCreditDate(invoiceInfoReqBO.getCreditDate());
        }
        if (null != invoiceInfoReqBO.getDArriveDate()) {
            billMergeInfo.setDArriveDate(invoiceInfoReqBO.getDArriveDate());
        }
        if (null != invoiceInfoReqBO.getInvoiceIssuanceDate()) {
            billMergeInfo.setInvoiceIssuanceDate(invoiceInfoReqBO.getInvoiceIssuanceDate());
        }
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            billMergeInfo.setInvoiceStatus(FscBillStatus.INVOICED.getCode());
        } else {
            billMergeInfo.setInvoiceStatus(FscBillStatus.ENTERED.getCode());
        }
        String type = reqBO.getType();
        if (CtrantType.RAW_COAL.getCode().equals(type) || CtrantType.CHEMICAL.getCode().equals(type)) {
            reqBO.setType(BILLING);
        } else if (CtrantType.CHEMICAL_STORE.getCode().equals(type) || CtrantType.NON_HOSTED.getCode().equals(type)) {
            reqBO.setType(MODIFY);
        } else {
            reqBO.setType(CONFIRM);
        }
        billMergeInfo.setBillType(reqBO.getType());
        billMergeInfo.setEffectiveState(BILLING);
        InvoiceInfoTemp invoiceInfoTemp = new InvoiceInfoTemp();
        BeanUtils.copyProperties((Object)invoiceInfoReqBO, (Object)invoiceInfoTemp);
        invoiceInfoTemp.setInoviceInfoId(mergeNO);
        invoiceInfoTemp.setEffectiveState(BILLING);
        invoiceInfoTemp.setBillType(reqBO.getType());
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            this.purInvoice(reqBO, mergeNO, getOriginalDocumentsInfoVOS, billSummaryInfos, documentNoList, invoiceInfoReqBO, billMergeInfo, invoiceInfoTemp);
        } else {
            this.supInvoice(reqBO, mergeNO, getOriginalDocumentsInfoVOS, documentNoList, billMergeInfo);
        }
        if (BILLING.equals(reqBO.getOperationType())) {
            int insert = this.billMergeInfoMapper.insert(billMergeInfo);
            if (insert < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u4fdd\u5b58\u5f00\u7968\u4fe1\u606f\u5931\u8d25");
            }
            int insert1 = this.invoiceInfoTempMapper.insert(invoiceInfoTemp);
            if (insert1 < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u4fdd\u5b58\u53d1\u7968\u4e34\u65f6\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            int i = this.billMergeInfoMapper.updateByMergrNo(billMergeInfo);
            if (i < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5f00\u7968\u4fe1\u606f\u5931\u8d25");
            }
            int i1 = this.invoiceInfoTempMapper.updateByMergrNo(invoiceInfoTemp);
            if (i1 < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u53d1\u7968\u4e34\u65f6\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    private void purInvoice(BusiBillingModifyConfirmReqBO reqBO, String mergeNO, List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, List<String> documentNoList, InvoiceInfoReqBO invoiceInfoReqBO, BillMergeInfo billMergeInfo, InvoiceInfoTemp invoiceInfoTemp) {
        billMergeInfo.setOrgCode(reqBO.getOrgCode());
        billMergeInfo.setPurDeptId(reqBO.getOrgCode());
        this.updateSummary(reqBO, FscBillStatus.INVOICED.getCode(), mergeNO);
        if (CONFIRM.equals(reqBO.getType()) || BILLING.equals(reqBO.getType())) {
            try {
                this.billSummaryInfoMapper.updateByDocumentNos(documentNoList, FscBillStatus.INVOICED.getCode(), mergeNO);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u6c47\u603b\u5355\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u91c7\u8d2d\u5165\u5e93\u6c47\u603b\u5355\u5931\u8d25");
            }
        }
        for (String documentNo : reqBO.getDocumentNos()) {
            ArrayList<String> documentList = new ArrayList<String>();
            documentList.add(documentNo);
            List<BillSummaryInfo> billSummaryInfoList = this.billSummaryInfoMapper.selectListByDocumentNo(documentNo);
            List summaryInfos = billSummaryInfoList.stream().filter(billSummaryInfo -> FscBillStatus.NOT_INVOICED.getCode().equals(billSummaryInfo.getInvoiceStatus())).collect(Collectors.toList());
            if (summaryInfos.size() != 0) continue;
            try {
                this.originalDocumentsInfoMapper.updateByDocumentNos(documentList, FscBillStatus.INVOICED.getCode());
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u91c7\u8d2d\u5165\u5e93\u5355\u72b6\u6001\u5931\u8d25,\u5355\u636e\u53f7\uff1a{}", (Object)documentNo);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u91c7\u8d2d\u5165\u5e93\u5355\u72b6\u6001\u5931\u8d25");
            }
        }
        if (CONFIRM.equals(getOriginalDocumentsInfoVOS.get(0).getBillType())) {
            this.createSummeryInvoice(invoiceInfoReqBO, getOriginalDocumentsInfoVOS, billSummaryInfos, invoiceInfoTemp, billMergeInfo, reqBO);
        }
        if (MODIFY.equals(getOriginalDocumentsInfoVOS.get(0).getBillType())) {
            this.createStoreInvoice(invoiceInfoReqBO, getOriginalDocumentsInfoVOS, billSummaryInfos, invoiceInfoTemp, billMergeInfo, reqBO);
        }
        if (BILLING.equals(getOriginalDocumentsInfoVOS.get(0).getBillType())) {
            this.createInvoice(invoiceInfoReqBO, getOriginalDocumentsInfoVOS, billSummaryInfos, invoiceInfoTemp, billMergeInfo, reqBO);
        }
    }

    private void supInvoice(BusiBillingModifyConfirmReqBO reqBO, String mergeNO, List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS, List<String> documentNoList, BillMergeInfo billMergeInfo) {
        billMergeInfo.setOrgCode(getOriginalDocumentsInfoVOS.get(0).getOrgCode());
        billMergeInfo.setPurDeptId(getOriginalDocumentsInfoVOS.get(0).getOrgCode());
        this.updateSummary(reqBO, FscBillStatus.ENTERED.getCode(), mergeNO);
        if (!MODIFY.equals(reqBO.getType())) {
            try {
                this.billSummaryInfoMapper.updateByDocumentNos(documentNoList, FscBillStatus.ENTERED.getCode(), mergeNO);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u6c47\u603b\u5355\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u91c7\u8d2d\u5165\u5e93\u6c47\u603b\u5355\u5931\u8d25");
            }
        }
        for (String documentNo : reqBO.getDocumentNos()) {
            ArrayList<String> documentList = new ArrayList<String>();
            documentList.add(documentNo);
            List<BillSummaryInfo> billSummaryInfoList = this.billSummaryInfoMapper.selectListByDocumentNos(documentList);
            List summaryInfos = billSummaryInfoList.stream().filter(billSummaryInfo -> FscBillStatus.NOT_INVOICED.getCode().equals(billMergeInfo.getInvoiceStatus())).collect(Collectors.toList());
            if (summaryInfos.size() != 0) continue;
            try {
                this.originalDocumentsInfoMapper.updateByDocumentNos(documentList, FscBillStatus.ENTERED.getCode());
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u91c7\u8d2d\u5165\u5e93\u5355\u72b6\u6001\u5931\u8d25,\u5355\u636e\u53f7\uff1a{}", (Object)documentNo);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u91c7\u8d2d\u5165\u5e93\u5355\u72b6\u6001\u5931\u8d25");
            }
        }
    }

    private void createInvoice(InvoiceInfoReqBO invoiceInfoReqBO, List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, InvoiceInfoTemp invoiceInfoTemp, BillMergeInfo billMergeInfo, BusiBillingModifyConfirmReqBO reqBO) {
        BusiInvoiceCreatePushErpReqBO erpReqBO = new BusiInvoiceCreatePushErpReqBO();
        erpReqBO.setCtrantypeid(reqBO.getInvoiceInfoReqBO().getErpBillType());
        if (InvoiceType.NORMAL.getCode().equals(Integer.valueOf(invoiceInfoReqBO.getInvoceType()))) {
            erpReqBO.setFinvoiceclass("10");
        } else if (InvoiceType.SPECIAL.getCode().equals(Integer.valueOf(invoiceInfoReqBO.getInvoceType()))) {
            erpReqBO.setFinvoiceclass("00");
        } else {
            erpReqBO.setFinvoiceclass("20");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        erpReqBO.setVbillcode(invoiceInfoReqBO.getInvoceCode());
        erpReqBO.setDbilldate(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setDarrivedate(format.format(invoiceInfoReqBO.getDArriveDate()));
        erpReqBO.setPkSupplier(getOriginalDocumentsInfoVOS.get(0).getSupplierId());
        erpReqBO.setVdef5(invoiceInfoReqBO.getInvoceNum());
        erpReqBO.setVdef6(invoiceInfoReqBO.getReasonLossNum());
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setPkBizpsn(getOriginalDocumentsInfoVOS.get(0).getPreparedMan());
        erpReqBO.setPkDeptv(invoiceInfoReqBO.getPurchaseName());
        erpReqBO.setVdef4(invoiceInfoReqBO.getInputTaxType());
        erpReqBO.setVdef18(getOriginalDocumentsInfoVOS.get(0).getSupplierId());
        erpReqBO.setVdef19(Integer.valueOf(invoiceInfoReqBO.getAnnexNum()));
        erpReqBO.setVdef68(getOriginalDocumentsInfoVOS.get(0).getCoalSupplierId());
        erpReqBO.setFinvoiceclass(BILLING);
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setVdef70(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setCorigcurrencyid(billSummaryInfos.get(0).getCurrency());
        erpReqBO.setNexchangerate(Double.valueOf(1.0));
        erpReqBO.setVdef2(billSummaryInfos.get(0).getSettlementContract());
        ArrayList<String> settlehlist = new ArrayList<String>();
        Double num = new Double("0");
        for (GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO : getOriginalDocumentsInfoVOS) {
            settlehlist.add(getOriginalDocumentsInfoVO.getSummeryHeadId());
            num = num + new Double(getOriginalDocumentsInfoVO.getSetTotalNum());
        }
        erpReqBO.setSettlehlist(settlehlist);
        ArrayList<InvoicePushErpItemInfo> invoicePushErpItemInfos = new ArrayList<InvoicePushErpItemInfo>();
        int crown = 10;
        for (BillSummaryInfo billSummaryInfo : billSummaryInfos) {
            InvoicePushErpItemInfo invoicePushErpItemInfo = new InvoicePushErpItemInfo();
            invoicePushErpItemInfo.setCrowno(String.valueOf(crown));
            invoicePushErpItemInfo.setPkMaterial(billSummaryInfo.getMaterialCode());
            invoicePushErpItemInfo.setCastunitid(billSummaryInfo.getUnit());
            invoicePushErpItemInfo.setNorigmny(billSummaryInfo.getNoTaxAmt());
            invoicePushErpItemInfo.setNorigtaxmny(billSummaryInfo.getPriceTaxTotal());
            invoicePushErpItemInfo.setCgeneralbid(billSummaryInfo.getExtBodyId());
            invoicePushErpItemInfo.setNnum(num.toString());
            invoicePushErpItemInfo.setFtaxtypeflag(BILLING);
            invoicePushErpItemInfo.setPkApfinanceorgV(getOriginalDocumentsInfoVOS.get(0).getSetFinance());
            invoicePushErpItemInfos.add(invoicePushErpItemInfo);
            crown += 10;
        }
        erpReqBO.setInvoicelist(invoicePushErpItemInfos);
        BusiInvoiceCreatePushErpRspBO erpRspBO = this.busiInvoiceCreatePushErpSercive.invoiceCreatePushErp(erpReqBO);
        if (!"0".equals(erpRspBO.getCode())) {
            log.error("\u53d1\u7968\u63a8\u9001erp\u5931\u8d25\uff1a{}", (Object)erpRspBO.getMsg());
            throw new PfscExtBusinessException("\u5931\u8d25", erpRspBO.getMsg());
        }
        InvoicePushErpRspBO data = erpRspBO.getData();
        if (null != data) {
            invoiceInfoTemp.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setInvoceCode(data.getVbillcode());
            String jsonString = JSON.toJSONString((Object)data.getPkInvoiceBList(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            billMergeInfo.setIncoiveCrownoList(jsonString);
        }
    }

    private void createStoreInvoice(InvoiceInfoReqBO invoiceInfoReqBO, List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, InvoiceInfoTemp invoiceInfoTemp, BillMergeInfo billMergeInfo, BusiBillingModifyConfirmReqBO reqBO) {
        BusiStoreInvoiceCreatePushErpReqBO erpReqBO = new BusiStoreInvoiceCreatePushErpReqBO();
        List billSummaryInfos1 = reqBO.getBillSummaryInfos();
        List ids = billSummaryInfos1.stream().map(BillSummaryInfoVO::getId).collect(Collectors.toList());
        List summaryInfos = billSummaryInfos.stream().filter(billSummaryInfo -> ids.contains(billSummaryInfo.getId())).collect(Collectors.toList());
        Map<String, BillSummaryInfoVO> summaryInfoVOMap = billSummaryInfos1.stream().collect(Collectors.toMap(BillSummaryInfoVO::getId, billSummaryInfoVO -> billSummaryInfoVO));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        erpReqBO.setVbillcode(invoiceInfoReqBO.getInvoceCode());
        erpReqBO.setPkSupplier(getOriginalDocumentsInfoVOS.get(0).getSupplierId());
        erpReqBO.setDbilldate(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setVdef3(invoiceInfoReqBO.getTransactionType());
        erpReqBO.setVdef2(invoiceInfoReqBO.getSourceContractNum());
        erpReqBO.setVdef4(invoiceInfoReqBO.getInputTaxType());
        erpReqBO.setVdef5(invoiceInfoReqBO.getInvoceNum());
        erpReqBO.setPkBizpsn(reqBO.getUsername());
        erpReqBO.setVdef19(invoiceInfoReqBO.getAnnexNum());
        erpReqBO.setVdef6(invoiceInfoReqBO.getReasonLossNum());
        erpReqBO.setVdef22(invoiceInfoReqBO.getPayType());
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setVdef70(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setVmemo(invoiceInfoReqBO.getRemark());
        ArrayList<String> settlehlist = new ArrayList<String>();
        for (GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO : getOriginalDocumentsInfoVOS) {
            settlehlist.add(getOriginalDocumentsInfoVO.getSummeryHeadId());
        }
        erpReqBO.setPkInstorHeadList(settlehlist);
        ArrayList<BusiStoreInvoiceCreateBodyPushErpReqBO> invoicePushErpItemInfos = new ArrayList<BusiStoreInvoiceCreateBodyPushErpReqBO>();
        int crown = 10;
        for (BillSummaryInfo billSummaryInfo2 : summaryInfos) {
            BusiStoreInvoiceCreateBodyPushErpReqBO invoicePushErpItemInfo = new BusiStoreInvoiceCreateBodyPushErpReqBO();
            invoicePushErpItemInfo.setPkInStoBody(billSummaryInfo2.getExtBodyId());
            invoicePushErpItemInfo.setCrowno(String.valueOf(crown));
            invoicePushErpItemInfo.setPkMaterial(billSummaryInfo2.getMaterialCode());
            invoicePushErpItemInfo.setNnum(summaryInfoVOMap.get(billSummaryInfo2.getId()).getInvoicableQuantity());
            invoicePushErpItemInfo.setNorigtaxprice(billSummaryInfo2.getTaxPrice());
            invoicePushErpItemInfos.add(invoicePushErpItemInfo);
            crown += 10;
        }
        erpReqBO.setPkInstorBodyList(invoicePushErpItemInfos);
        log.info("\u521b\u5efa\u5165\u5e93\u5355\u53d1\u7968\uff1a{}", (Object)JSON.toJSONString((Object)erpReqBO));
        BusiInvoiceCreatePushErpRspBO erpRspBO = this.busiInvoiceCreatePushErpSercive.storeSummaryInvoiceCreate(erpReqBO);
        if (!"0".equals(erpRspBO.getCode())) {
            log.error("\u53d1\u7968\u63a8\u9001erp\u5931\u8d25\uff1a{}", (Object)erpRspBO.getMsg());
            throw new PfscExtBusinessException("\u5931\u8d25", erpRspBO.getMsg());
        }
        InvoicePushErpRspBO data = erpRspBO.getData();
        if (null != data) {
            invoiceInfoTemp.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setInvoceCode(data.getVbillcode());
            String jsonString = JSON.toJSONString((Object)data.getPkInvoiceBList(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            billMergeInfo.setIncoiveCrownoList(jsonString);
        }
    }

    private void createSummeryInvoice(InvoiceInfoReqBO invoiceInfoReqBO, List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, InvoiceInfoTemp invoiceInfoTemp, BillMergeInfo billMergeInfo, BusiBillingModifyConfirmReqBO reqBO) {
        Map<String, BillSummaryInfo> summaryInfoMap = billSummaryInfos.stream().collect(Collectors.toMap(BillSummaryInfo::getStatementNo, billSummaryInfo -> billSummaryInfo));
        BusiSummaryInvoiceCreatePushErpReqBO erpReqBO = new BusiSummaryInvoiceCreatePushErpReqBO();
        if (InvoiceType.NORMAL.getCode().equals(Integer.valueOf(invoiceInfoReqBO.getInvoceType()))) {
            erpReqBO.setFinvoiceclass("10");
        } else if (InvoiceType.SPECIAL.getCode().equals(Integer.valueOf(invoiceInfoReqBO.getInvoceType()))) {
            erpReqBO.setFinvoiceclass("00");
        } else {
            erpReqBO.setFinvoiceclass("20");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        erpReqBO.setPkOrg(String.valueOf(reqBO.getOrgId()));
        erpReqBO.setVbillcode(invoiceInfoReqBO.getInvoceCode());
        erpReqBO.setPkSupplier(getOriginalDocumentsInfoVOS.get(0).getSupplierId());
        erpReqBO.setDbilldate(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setDarrivedate(format.format(invoiceInfoReqBO.getDArriveDate()));
        erpReqBO.setVdef18(getOriginalDocumentsInfoVOS.get(0).getSupplierId());
        erpReqBO.setPkDeptV(reqBO.getOrgName());
        erpReqBO.setVdef22(invoiceInfoReqBO.getPayType());
        erpReqBO.setVdef4(invoiceInfoReqBO.getInputTaxType());
        erpReqBO.setPkBankaccbas(invoiceInfoReqBO.getBankAccNo());
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setVdef2(invoiceInfoReqBO.getSourceContractNum());
        erpReqBO.setVdef70(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setCorigcurrencyid(billSummaryInfos.get(0).getCurrency());
        erpReqBO.setVdef2(billSummaryInfos.get(0).getSettlementContract());
        erpReqBO.setNexchangerate(getOriginalDocumentsInfoVOS.get(0).getConversionRate());
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setVdef19(invoiceInfoReqBO.getAnnexNum());
        erpReqBO.setPkBizpsn(reqBO.getUsername());
        ArrayList<String> headKeyList = new ArrayList<String>();
        for (GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO : getOriginalDocumentsInfoVOS) {
            headKeyList.add(getOriginalDocumentsInfoVO.getSummeryHeadId());
        }
        erpReqBO.setCvmihidlist(headKeyList);
        Double quantity = new Double("0");
        BigDecimal totalNoTaxAmt = BigDecimal.ZERO;
        BigDecimal totalTaxAmt = BigDecimal.ZERO;
        for (GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO : getOriginalDocumentsInfoVOS) {
            quantity = quantity + new Double(getOriginalDocumentsInfoVO.getSetTotalNum());
            BigDecimal qua = new BigDecimal(getOriginalDocumentsInfoVO.getSumTotalNum());
            BigDecimal noTaxPrice = new BigDecimal(getOriginalDocumentsInfoVO.getNoTaxPrice());
            totalNoTaxAmt = totalNoTaxAmt.add(qua.multiply(noTaxPrice));
            BillSummaryInfo billSummaryInfo2 = summaryInfoMap.get(getOriginalDocumentsInfoVO.getDocumentNo());
            String taxRate = billSummaryInfo2.getTaxRate();
            BigDecimal tax = totalNoTaxAmt.divide(new BigDecimal(taxRate).add(BigDecimal.ONE), RoundingMode.HALF_UP).setScale(5);
            totalTaxAmt = totalTaxAmt.add(totalNoTaxAmt.add(tax));
        }
        ArrayList<BusiSummaryInvoiceBodyPushErpReqBO> invoicePushErpItemInfos = new ArrayList<BusiSummaryInvoiceBodyPushErpReqBO>();
        int crown = 10;
        for (BillSummaryInfo billSummaryInfo3 : billSummaryInfos) {
            BusiSummaryInvoiceBodyPushErpReqBO invoicePushErpItemInfo = new BusiSummaryInvoiceBodyPushErpReqBO();
            invoicePushErpItemInfo.setCrowno(String.valueOf(crown));
            invoicePushErpItemInfo.setPkMaterial(billSummaryInfo3.getMaterialCode());
            invoicePushErpItemInfo.setNnum(billSummaryInfo3.getSettlementQuantity());
            invoicePushErpItemInfo.setCastunitid(billSummaryInfo3.getUnit());
            invoicePushErpItemInfo.setNorigmny(totalNoTaxAmt.toString());
            invoicePushErpItemInfo.setNorigtaxmny(totalTaxAmt.toString());
            invoicePushErpItemInfo.setCvmihid(billSummaryInfo3.getExtBodyId());
            invoicePushErpItemInfos.add(invoicePushErpItemInfo);
            crown += 10;
        }
        erpReqBO.setInvoiceList(invoicePushErpItemInfos);
        BusiInvoiceCreatePushErpRspBO erpRspBO = this.busiInvoiceCreatePushErpSercive.consumptionSummaryInvoiceCreate(erpReqBO);
        if (!"0".equals(erpRspBO.getCode())) {
            log.error("\u53d1\u7968\u63a8\u9001erp\u5931\u8d25\uff1a{}", (Object)erpRspBO.getMsg());
            throw new PfscExtBusinessException("\u5931\u8d25", erpRspBO.getMsg());
        }
        InvoicePushErpRspBO data = erpRspBO.getData();
        if (null != data) {
            invoiceInfoTemp.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setInvoceCode(data.getVbillcode());
            String jsonString = JSON.toJSONString((Object)data.getPkInvoiceBList(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            billMergeInfo.setIncoiveCrownoList(jsonString);
        }
    }

    private void modify(BusiBillingModifyConfirmReqBO reqBO) {
        String mergeNO = reqBO.getMergeDocumentNo();
        InvoiceInfoTemp invoiceInfoTemp = new InvoiceInfoTemp();
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        BeanUtils.copyProperties((Object)invoiceInfoReqBO, (Object)invoiceInfoTemp);
        invoiceInfoTemp.setInoviceInfoId(mergeNO);
        invoiceInfoTemp.setEffectiveState(BILLING);
        String type = reqBO.getType();
        if (CtrantType.RAW_COAL.getCode().equals(type) || CtrantType.CHEMICAL.getCode().equals(type)) {
            reqBO.setType(BILLING);
        } else if (CtrantType.CHEMICAL_STORE.getCode().equals(type) || CtrantType.NON_HOSTED.getCode().equals(type)) {
            reqBO.setType(MODIFY);
        } else {
            reqBO.setType(CONFIRM);
        }
        invoiceInfoTemp.setBillType(reqBO.getType());
        this.invoiceInfoTempMapper.updateByMergrNo(invoiceInfoTemp);
    }

    private String getMergeNO() {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.billMergeInfoMapper.selectMaxPayAbleNoNum(PREFIX + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(PREFIX).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5408\u5e76\u5355\u53f7\u751f\u6210\u5931\u8d25");
        }
    }

    private void updateSummary(BusiBillingModifyConfirmReqBO reqBO, String invoiceType, String mergeNO) {
        if (MODIFY.equals(reqBO.getType())) {
            List billSummaryInfos = reqBO.getBillSummaryInfos();
            String jsonString = JSON.toJSONString((Object)billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            List billSummaryInfoList = JSON.parseArray((String)jsonString, BillSummaryInfo.class);
            for (BillSummaryInfo billSummaryInfo : billSummaryInfoList) {
                billSummaryInfo.setInvoiceStatus(invoiceType);
                billSummaryInfo.setMergeSetNo(mergeNO);
                try {
                    this.billSummaryInfoMapper.updateById(billSummaryInfo);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u6c47\u603b\u5355\u5931\u8d25\uff0c\u5355\u636e\u53f7\uff1a{}", (Object)billSummaryInfo.getStatementNo());
                    throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6c47\u603b\u5355\u5931\u8d25");
                }
            }
        }
    }

    private void billingVerification(BusiBillingModifyConfirmReqBO reqBO) {
        InvoiceInfoReqBO invoiceInfoReqBO;
        if (null == reqBO.getType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperationType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDocumentNos().size() == 0) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!BILLING.equals(reqBO.getOperationType()) && null == reqBO.getMergeDocumentNo()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u3010\u4fee\u6539\u3011\u6216\u3010\u786e\u8ba4\u3011\u65f6\u5408\u5e76\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfoReqBO()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            if (MODIFY.equals(reqBO.getOperationType())) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u5546\u53ea\u80fd\u3010\u5f00\u7968\u3011\u548c\u3010\u786e\u8ba4\u3011");
            }
        } else if (CONFIRM.equals(reqBO.getOperationType())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4f9b\u5e94\u5546\u53ea\u80fd\u3010\u5f00\u7968\u3011\u548c \u3010\u4fee\u6539\u3011");
        }
        if (null == (invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO()).getName()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTaxpayerId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getAddress()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceInfoReqBO.getAddress().trim().length() > 25) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5730\u5740\u957f\u5ea6\u8d85\u8fc725");
        }
        if (null == invoiceInfoReqBO.getMobile()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getBankName()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceInfoReqBO.getBankName().trim().length() > 19) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u6237\u94f6\u884c\u957f\u5ea6\u8d85\u8fc719");
        }
        if (null == invoiceInfoReqBO.getBankAccNo()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getActualInvoicedQuantity()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5b9e\u9645\u5f00\u7968\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTotalAmtTax()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u6c47\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTotalAmt()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u6c47\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTaxRate()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getInvoceType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getInvoceCode()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            if (null == invoiceInfoReqBO.getCreditDate()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u5165\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getDArriveDate()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u7968\u5230\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInvoiceIssuanceDate()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u5f00\u5177\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInvoceNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u8f93\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getReasonLossNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u5408\u7406\u635f\u8017\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInputTaxType()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u8fdb\u9879\u7a0e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getSettlementType()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getPayType()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getAnnexNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u9644\u4ef6\u5f20\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getPurchaseName()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getSourceContractNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u6765\u6e90\u5408\u540c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

