/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.BusiGetInspectionReportService;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetInspectionReportErpService;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpInfoRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetInspectionReportService.class)
public class BusiGetInspectionReportServiceImpl
implements BusiGetInspectionReportService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetInspectionReportServiceImpl.class);
    @Autowired
    private BusiGetInspectionReportErpService busiGetInspectionReportErpService;

    public BusiGetInspectionReportRspBO getInspectionReport(BusiGetInspectionReportReqBO reqBO) {
        log.info("\u67e5\u8be2\u8d28\u68c0\u62a5\u544a\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        if (null == reqBO.getPkOrg() || "".equals(reqBO.getPkOrg())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGetInspectionReportRspBO rspBO = new BusiGetInspectionReportRspBO();
        BusiGetInspectionReportErpReqBO erpReqBO = new BusiGetInspectionReportErpReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)erpReqBO);
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != reqBO.getStartDate()) {
            erpReqBO.setStartDate(formater.format(reqBO.getStartDate()));
        }
        if (null != reqBO.getEndDate()) {
            erpReqBO.setEndDate(formater.format(reqBO.getEndDate()));
        }
        erpReqBO.setPageSize(reqBO.getPageSize());
        erpReqBO.setPageNum(reqBO.getPageNo());
        BusiGetInspectionReportErpRspBO inspectionReport = this.busiGetInspectionReportErpService.getInspectionReport(erpReqBO);
        List dataList = inspectionReport.getDataList();
        ArrayList<BusiGetInspectionReportInfoRspBO> rows = new ArrayList<BusiGetInspectionReportInfoRspBO>();
        if (null != dataList) {
            for (BusiGetInspectionReportErpInfoRspBO erpInfoRspBO : dataList) {
                BusiGetInspectionReportInfoRspBO receiptPageRspBO = new BusiGetInspectionReportInfoRspBO();
                BeanUtils.copyProperties((Object)erpInfoRspBO, (Object)receiptPageRspBO);
                rows.add(receiptPageRspBO);
            }
        }
        Integer recordsTotal = Integer.valueOf(inspectionReport.getData());
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

