/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.api.busi.BusiGetBasicFileInfoService;
import com.tydic.pfscext.api.busi.BusiGetFileInformationService;
import com.tydic.pfscext.api.busi.BusiGetInvoiceTempInfoService;
import com.tydic.pfscext.api.busi.bo.BusiGetBasicFileInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBasicFileInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBasicFileItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetFileInformationDataRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetFileInformationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetFileInformationRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceTempInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceTempInfoRspBO;
import com.tydic.pfscext.api.busi.bo.InvoiceTempRspBO;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.InvoiceInfoTempMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.InvoiceInfoTemp;
import com.tydic.pfscext.enums.AgreePayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetInvoiceTempInfoService.class)
public class BusiGetInvoiceTempInfoServiceImpl
implements BusiGetInvoiceTempInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetInvoiceTempInfoServiceImpl.class);
    @Autowired
    private InvoiceInfoTempMapper invoiceInfoTempMapper;
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private BusiGetFileInformationService busiGetFileInformationService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private BusiGetBasicFileInfoService busiGetBasicFileInfoService;

    public BusiGetInvoiceTempInfoRspBO getInvoiceTempInfo(BusiGetInvoiceTempInfoReqBO reqBO) {
        log.info("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)reqBO);
        if ("".equals(reqBO.getMergeDocumentNo()) || null == reqBO.getMergeDocumentNo()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5408\u5e76\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceInfoTemp invoiceInfoTemp = this.invoiceInfoTempMapper.selectByInoviceInfoId(reqBO.getMergeDocumentNo());
        BillMergeInfo billMergeInfo = this.billMergeInfoMapper.selectByMergeNO(reqBO.getMergeDocumentNo());
        InvoiceTempRspBO invoiceTempRspBO = (InvoiceTempRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)invoiceInfoTemp), InvoiceTempRspBO.class);
        BusiGetInvoiceTempInfoRspBO rspBO = new BusiGetInvoiceTempInfoRspBO();
        if (null != billMergeInfo.getOrgCode()) {
            BusiGetFileInformationReqBO busiGetFileInformationReqBO = new BusiGetFileInformationReqBO();
            busiGetFileInformationReqBO.setPkOrg(billMergeInfo.getOrgCode());
            busiGetFileInformationReqBO.setFileType("balatype");
            BusiGetFileInformationRspBO balaType = this.busiGetFileInformationService.getFileInformation(busiGetFileInformationReqBO);
            busiGetFileInformationReqBO.setFileType("invattype");
            BusiGetFileInformationRspBO invatType = this.busiGetFileInformationService.getFileInformation(busiGetFileInformationReqBO);
            BusiGetBasicFileInfoReqBO busiGetBasicFileInfoReqBO = new BusiGetBasicFileInfoReqBO();
            busiGetBasicFileInfoReqBO.setFileType("invice_billtype");
            busiGetBasicFileInfoReqBO.setPkOrg(reqBO.getPkOrg());
            BusiGetBasicFileInfoRspBO basicFileInfo = this.busiGetBasicFileInfoService.getBasicFileInfo(busiGetBasicFileInfoReqBO);
            List basicFileInfoDataList = basicFileInfo.getDataList();
            List balaTypeList = balaType.getData();
            List invatTypeList = invatType.getData();
            Map<String, String> balaTypeMap = balaTypeList.stream().collect(Collectors.toMap(BusiGetFileInformationDataRspBO::getId, BusiGetFileInformationDataRspBO::getName));
            Map<String, String> invatTypeMap = invatTypeList.stream().collect(Collectors.toMap(BusiGetFileInformationDataRspBO::getId, BusiGetFileInformationDataRspBO::getName));
            Map<String, String> basicInvoiceMap = basicFileInfoDataList.stream().collect(Collectors.toMap(BusiGetBasicFileItemRspBO::getId, BusiGetBasicFileItemRspBO::getName));
            invoiceTempRspBO.setInputTaxTypeStr(invatTypeMap.get(invoiceTempRspBO.getInputTaxType()));
            invoiceTempRspBO.setSettlementTypeStr(balaTypeMap.get(invoiceTempRspBO.getSettlementType()));
            if (StringUtils.hasText((String)invoiceTempRspBO.getPayType())) {
                invoiceTempRspBO.setPayTypeStr(AgreePayType.getInstance(invoiceTempRspBO.getPayType()).getDescr());
            }
            invoiceTempRspBO.setErpBillTypeStr(basicInvoiceMap.get(invoiceTempRspBO.getErpBillType()));
        }
        rspBO.setInvoiceTempRspBO(invoiceTempRspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

