/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiGetOriginalDocumentsInfoPageService;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsInfoPageReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsInfoPageRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsInfoRspBO;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umcext.ability.supplier.UmcPurSupInfoListQryAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcPurQrySupInfoListBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetOriginalDocumentsInfoPageService.class)
public class BusiGetOriginalDocumentsInfoPageServiceImpl
implements BusiGetOriginalDocumentsInfoPageService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetOriginalDocumentsInfoPageServiceImpl.class);
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcPurSupInfoListQryAbilityService umcPurSupInfoListQryAbilityService;

    public BusiGetOriginalDocumentsInfoPageRspBO getPageInfo(BusiGetOriginalDocumentsInfoPageReqBO reqBO) {
        log.info("\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u5165\u53c2\uff1a{}", (Object)reqBO);
        if (null == reqBO.getType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getPurDeptId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getSupplierId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String type = reqBO.getType();
        if (CtrantType.RAW_COAL.getCode().equals(type) || CtrantType.CHEMICAL.getCode().equals(type)) {
            reqBO.setType("1");
        } else if (CtrantType.CHEMICAL_STORE.getCode().equals(type) || CtrantType.NON_HOSTED.getCode().equals(type)) {
            reqBO.setType("2");
        } else {
            reqBO.setType("3");
        }
        BusiGetOriginalDocumentsInfoPageRspBO rspBO = new BusiGetOriginalDocumentsInfoPageRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        String supplierId = reqBO.getSupplierId();
        if (StringUtils.hasText((String)supplierId)) {
            String creditNo;
            UmcPurSupInfoListQryAbilityReqBO umcPurSupInfoListQryAbilityReqBO = new UmcPurSupInfoListQryAbilityReqBO();
            log.debug("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u5165\u53c2\uff1a{}", (Object)supplierId);
            umcPurSupInfoListQryAbilityReqBO.setSupplierId(Long.valueOf(supplierId));
            UmcPurSupInfoListQryAbilityRspBO umcPurSupInfoListQryAbilityRspBO = this.umcPurSupInfoListQryAbilityService.qryPurSupInfoList(umcPurSupInfoListQryAbilityReqBO);
            log.debug("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcPurSupInfoListQryAbilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if ("0000".equals(umcPurSupInfoListQryAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcPurSupInfoListQryAbilityRspBO.getRows()) && StringUtils.hasText((String)(creditNo = ((UmcPurQrySupInfoListBO)umcPurSupInfoListQryAbilityRspBO.getRows().get(0)).getCreditNo()))) {
                String boType = reqBO.getType();
                if ("1".equals(boType)) {
                    reqBO.setCoalSupplierId(creditNo);
                    reqBO.setSupplierId(null);
                } else {
                    reqBO.setSupplierId(creditNo);
                }
            }
        }
        List<GetOriginalDocumentsInfoVO> pageVos = this.originalDocumentsInfoMapper.selectUnionPage(reqBO, (Page<Map<String, Object>>)page);
        List dataList = JSON.parseArray((String)JSON.toJSONString(pageVos), BusiGetOriginalDocumentsInfoRspBO.class);
        dataList.forEach(documentsInfo -> documentsInfo.setInvoiceStatusDesc(FscBillStatus.getInstance(documentsInfo.getInvoiceStatus()).getDescr()));
        rspBO.setRows(dataList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

