/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.BusiGetPurchaseStorageService;
import com.tydic.pfscext.api.busi.bo.BusiGetPurchaseStorageInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetPurchaseStorageReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetPurchaseStorageRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetPurchaseStorageErpService;
import com.tydic.pfscext.external.api.bo.BusiGetPurchaseStorageErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetPurchaseStorageErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetPurchaseStorageInfoErpRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetPurchaseStorageService.class)
public class BusiGetPurchaseStorageServiceImpl
implements BusiGetPurchaseStorageService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetPurchaseStorageServiceImpl.class);
    @Autowired
    private BusiGetPurchaseStorageErpService busiGetPurchaseStorageErpService;

    public BusiGetPurchaseStorageRspBO getPurchaseStorage(BusiGetPurchaseStorageReqBO reqBO) {
        log.info("\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        if (null == reqBO.getPkOrg() || "".equals(reqBO.getPkOrg())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGetPurchaseStorageRspBO rspBO = new BusiGetPurchaseStorageRspBO();
        BusiGetPurchaseStorageErpReqBO erpReqBO = new BusiGetPurchaseStorageErpReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)erpReqBO);
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != reqBO.getStartdate()) {
            erpReqBO.setStartdate(formater.format(reqBO.getStartdate()));
        }
        if (null != reqBO.getEnddate()) {
            erpReqBO.setEnddate(formater.format(reqBO.getEnddate()));
        }
        erpReqBO.setPageSize(reqBO.getPageSize());
        erpReqBO.setPageNum(reqBO.getPageNo());
        BusiGetPurchaseStorageErpRspBO purchaseStorage = this.busiGetPurchaseStorageErpService.getPurchaseStorage(erpReqBO);
        List dataList = purchaseStorage.getDataList();
        ArrayList<BusiGetPurchaseStorageInfoRspBO> rows = new ArrayList<BusiGetPurchaseStorageInfoRspBO>();
        if (null != dataList) {
            for (BusiGetPurchaseStorageInfoErpRspBO busiGetPurchaseStorageInfoErpRspBO : dataList) {
                BusiGetPurchaseStorageInfoRspBO receiptPageRspBO = new BusiGetPurchaseStorageInfoRspBO();
                BeanUtils.copyProperties((Object)busiGetPurchaseStorageInfoErpRspBO, (Object)receiptPageRspBO);
                rows.add(receiptPageRspBO);
            }
        }
        Integer recordsTotal = Integer.valueOf(purchaseStorage.getData());
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

