/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.BusiInvoiceProofreadService;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceProofreadReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceProofreadRspBO;
import com.tydic.pfscext.dao.BillDetailInfoMapper;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.InvoiceInfoTempMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PriceSettlementSummaryInfoMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiInvoiceProofreadService.class)
public class BusiInvoiceProofreadServiceImpl
implements BusiInvoiceProofreadService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceProofreadServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private InvoiceInfoTempMapper invoiceInfoTempMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private PriceSettlementSummaryInfoMapper priceSettlementSummaryInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    /*
     * Enabled aggressive block sorting
     */
    public BusiInvoiceProofreadRspBO erpInvoiceProofread(BusiInvoiceProofreadReqBO busiInvoiceProofreadReqBO) {
        this.checkParams(busiInvoiceProofreadReqBO);
        BusiInvoiceProofreadRspBO busiInvoiceProofreadRspBO = new BusiInvoiceProofreadRspBO();
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(busiInvoiceProofreadReqBO.getExtPurInvoiceNo());
        if (billNotificationInfo == null) {
            BillMergeInfo billMergeInfo = this.billMergeInfoMapper.selectByInvoiceCode(busiInvoiceProofreadReqBO.getPkInvoice());
            if (null != billMergeInfo) return this.modifyAndCreatePayment(busiInvoiceProofreadReqBO, billMergeInfo);
            log.error("ExtPurInvoiceNo\u53d1\u7968\u53f7\u672a\u67e5\u8be2\u5230\u6570\u636e");
            throw new PfscExtBusinessException("\u5931\u8d25", "ExtPurInvoiceNo\u53d1\u7968\u53f7\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        String invoiceStatus = billNotificationInfo.getInvoiceStatus();
        boolean anyMatch = Arrays.asList("07", "08").stream().anyMatch(invoiceStatus::equals);
        if (!anyMatch) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u901a\u77e5\u5355\uff1a" + billNotificationInfo.getNotificationNo() + " \u72b6\u6001\u4e0d\u6b63\u786e,\u53ea\u6709\u3010\u5df2\u7b7e\u6536\u3011\u3001\u3010\u5ba1\u6838\u4e0d\u901a\u8fc7\u3011\u72b6\u6001\u624d\u53ef\u8fdb\u884c\u4fee\u6539\u72b6\u6001\u64cd\u4f5c");
        }
        if ("3".equals(busiInvoiceProofreadReqBO.getStatus())) {
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.RECEIVED.getCode());
        } else {
            if (!"4".equals(busiInvoiceProofreadReqBO.getStatus())) {
                log.error("status={}\uff0c\u4e0d\u4e3a (3,\u5ba1\u6838\u901a\u8fc7) or (4,\u5ba1\u6838\u4e0d\u901a\u8fc7)\u3002", (Object)busiInvoiceProofreadReqBO.getStatus());
                busiInvoiceProofreadRspBO.setRespCode("18003");
                busiInvoiceProofreadRspBO.setRespDesc("\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff0cstatus=" + busiInvoiceProofreadReqBO.getStatus() + ",\u4e0d\u662f\u671f\u671b\u53c2\u6570");
                busiInvoiceProofreadRspBO.setRemark("\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff0cstatus=" + busiInvoiceProofreadReqBO.getStatus() + ",\u4e0d\u662f\u671f\u671b\u53c2\u6570");
                return busiInvoiceProofreadRspBO;
            }
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.AUDIT_REJECTION.getCode());
        }
        this.billNotificationInfoMapper.updateByPrimaryKey(billNotificationInfo);
        log.debug("fsc-\u8c03\u8bd5\uff1a\u66f4\u65b0result={}", (Object)billNotificationInfo);
        busiInvoiceProofreadRspBO.setRespCode("0000");
        busiInvoiceProofreadRspBO.setRespDesc("\u66f4\u65b0\u6210\u529f");
        busiInvoiceProofreadRspBO.setRemark("\u66f4\u65b0\u6210\u529f");
        return busiInvoiceProofreadRspBO;
    }

    private void checkParams(BusiInvoiceProofreadReqBO busiInvoiceProofreadReqBO) {
        if (StringUtils.isEmpty((Object)busiInvoiceProofreadReqBO.getExtPurInvoiceNo())) {
            log.error("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5931\u8d25\uff0c\u53d1\u7968\u53f7\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)busiInvoiceProofreadReqBO.getStatus())) {
            log.error("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a\u7a7a\uff01");
        }
    }

    private BusiInvoiceProofreadRspBO modifyAndCreatePayment(BusiInvoiceProofreadReqBO reqBO, BillMergeInfo billMergeInfo) {
        log.info("\u66f4\u65b0\u539f\u6599\u7164\u7b49\u53d1\u7968\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        BusiInvoiceProofreadRspBO rspBO = new BusiInvoiceProofreadRspBO();
        if ("3".equals(reqBO.getStatus())) {
            log.info("\u5f85\u66f4\u65b0\u6c47\u603b\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)billMergeInfo));
            int i = this.billMergeInfoMapper.updateStatusBymergeNo(FscBillStatus.TICKETS_RECEIVED.getCode(), billMergeInfo.getMergeSetNo());
            if (i != 1) {
                log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)billMergeInfo.getMergeSetNo());
                throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
            }
            int i1 = this.invoiceInfoTempMapper.updateStatusBymergeNo(FscBillStatus.TICKETS_RECEIVED.getCode(), billMergeInfo.getMergeSetNo());
            if (i1 != 1) {
                log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)billMergeInfo.getMergeSetNo());
                throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
            }
            List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.selectByMergeNo(billMergeInfo.getMergeSetNo());
            List<String> idList = billSummaryInfos.stream().map(BillSummaryInfo::getId).collect(Collectors.toList());
            int i2 = this.billSummaryInfoMapper.updateStatusByIdList(idList, FscBillStatus.TICKETS_RECEIVED.getCode());
            if (i2 < 1) {
                log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)billMergeInfo.getMergeSetNo());
                throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
            }
            List<String> documentNoList = billSummaryInfos.stream().map(BillSummaryInfo::getStatementNo).distinct().collect(Collectors.toList());
            List<BillSummaryInfo> billSummaryInfoList = this.billSummaryInfoMapper.selectByDocumentNos(documentNoList);
            for (String documentNo : documentNoList) {
                int i3;
                List collect = billSummaryInfoList.stream().filter(billSummaryInfo -> documentNo.equals(billSummaryInfo.getStatementNo()) && !FscBillStatus.TICKETS_RECEIVED.getCode().equals(billSummaryInfo.getInvoiceStatus())).collect(Collectors.toList());
                if (collect.size() != 0 || (i3 = this.originalDocumentsInfoMapper.updateByDocumentNo(FscBillStatus.TICKETS_RECEIVED.getCode(), documentNo)) >= 1) continue;
                log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)billMergeInfo.getMergeSetNo());
                throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
            }
            PayableDetailPO po = new PayableDetailPO();
            Date now = new Date();
            String snNo = this.getPayInfoId("CG");
            po.setPayableNo(snNo);
            po.setPayableAmt(new BigDecimal(billMergeInfo.getTotalAmt()));
            po.setPaidAmt(BigDecimal.ZERO);
            po.setPendingAmt(BigDecimal.ZERO);
            po.setPaidDate(now);
            po.setNeedAgainstAmt(BigDecimal.ZERO);
            po.setPayableStatus(PayableStatus.PENDING.getCode());
            po.setCreateDate(now);
            po.setPayableType(6);
            po.setPayType("2");
            int insert = this.payableDetailMapper.insert(po);
            if (insert != 1) {
                log.error("\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25");
                throw new PfscExtBusinessException("\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25", "18000");
            }
            billMergeInfo.setPayableNo(snNo);
            int i5 = this.billMergeInfoMapper.updatePayableNoByMergeSetNo(billMergeInfo);
            if (i5 != 1) {
                log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)billMergeInfo.getMergeSetNo());
                throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
            }
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        rspBO.setRespDesc("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u624d\u4f1a\u521b\u5efa\u4ed8\u6b3e\u5355");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private String getPayInfoId(String prefix) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.payableDetailMapper.selectMaxPayNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

