/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.InvoicePushErpService;
import com.tydic.pfscext.api.busi.bo.InvoicePushErpRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.DPayItemStroInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.DPayItemStroInfo;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.BillNotificationInfoVO;
import com.tydic.pfscext.dao.vo.PayInvoiceDetailVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiApplyInvoiceSyncErpService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpRspDataBO;
import com.tydic.pfscext.vo.DPayItemStroVO;
import com.tydic.umcext.ability.supplier.UmcMemInfoQryListAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcMemInfoQryListAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcMemInfoQryListAbilityRspBO;
import com.tydic.umcext.bo.base.UmcReqInfoBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=InvoicePushErpService.class)
public class InvoicePushErpServiceImpl
extends UmcReqInfoBO
implements InvoicePushErpService {
    private static final Logger logger = LoggerFactory.getLogger(InvoicePushErpServiceImpl.class);
    @Value(value="${SEND_ERP_WAIT_MILLISECOND:500}")
    private int WAIT_SECONDS;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BusiApplyInvoiceSyncErpService busiApplyInvoiceSyncErpService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcMemInfoQryListAbilityService umcMemInfoQryListAbilityService;
    @Autowired
    private DPayItemStroInfoMapper dPayItemStroInfoMapper;

    public InvoicePushErpRspBO pushErp() {
        InvoicePushErpRspBO rspBO = new InvoicePushErpRspBO();
        ArrayList busiApplyInvoiceSyncErpReqBOList = new ArrayList();
        PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
        invoiceInfo.setInvoiceStatus("03");
        List<PayInvoiceDetailVO> payInvoiceDetailVOList = this.payInvoiceInfoMapper.selectJoinDetailByStatus(invoiceInfo);
        if (payInvoiceDetailVOList == null) {
            rspBO.setRespCode("\u6ca1\u6709\u53ef\u4ee5\u5f00\u7684\u53d1\u7968");
            return rspBO;
        }
        HashMap payInvoiceDetailVOMap = new HashMap();
        payInvoiceDetailVOList.forEach(payInvoiceDetailVO -> payInvoiceDetailVOMap.put(payInvoiceDetailVO.getInvoiceNo(), payInvoiceDetailVO));
        payInvoiceDetailVOMap.values().forEach(payInvoiceDetailVO -> {
            BusiApplyInvoiceSyncErpReqBO busiApplyInvoiceSyncErpReqBO = new BusiApplyInvoiceSyncErpReqBO();
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByExtPurNo(payInvoiceDetailVO.getInvoiceNo());
            if (billNotificationInfo == null) {
                List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(payInvoiceDetailVO.getNotificationNo());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String format = simpleDateFormat.format(payInvoiceDetailVO.getInvoiceDate());
                busiApplyInvoiceSyncErpReqBO.setDbilldate(format);
                if (payPurchaseOrderInfos != null && payPurchaseOrderInfos.size() > 0) {
                    busiApplyInvoiceSyncErpReqBO.setPkSupplier(String.valueOf(payPurchaseOrderInfos.get(0).getSupplierNo()));
                    logger.info("pk_order", (Object)payPurchaseOrderInfos.get(0).getExtPurOrderNo());
                    busiApplyInvoiceSyncErpReqBO.setPkOrder(payPurchaseOrderInfos.get(0).getExtPurOrderNo());
                    BillNotificationInfo billNotificationInfos = this.billNotificationInfoMapper.selectByNotion(payPurchaseOrderInfos.get(0).getNotificationNo());
                    if (billNotificationInfos != null) {
                        busiApplyInvoiceSyncErpReqBO.setPkOrg(billNotificationInfos.getStartOrgId());
                        busiApplyInvoiceSyncErpReqBO.setVdef3(billNotificationInfos.getTransType());
                        busiApplyInvoiceSyncErpReqBO.setVdef4(billNotificationInfos.getInputTaxType());
                        String format1 = simpleDateFormat.format(billNotificationInfos.getInoviceIssunaceDate());
                        busiApplyInvoiceSyncErpReqBO.setVdef70(format1);
                        busiApplyInvoiceSyncErpReqBO.setPkBalaType(billNotificationInfos.getSettleType());
                        busiApplyInvoiceSyncErpReqBO.setVdef2(billNotificationInfos.getPurchContractNo());
                    }
                    Long supplierNo = payPurchaseOrderInfos.get(0).getSupplierNo();
                    busiApplyInvoiceSyncErpReqBO.setPkSupplier(supplierNo.toString());
                }
                busiApplyInvoiceSyncErpReqBO.setVbillcode(payInvoiceDetailVO.getInvoiceNo());
                UmcMemInfoQryListAbilityReqBO bo = new UmcMemInfoQryListAbilityReqBO();
                ArrayList ids = new ArrayList();
                bo.setMemIds(ids);
                UmcMemInfoQryListAbilityRspBO infoBy = this.umcMemInfoQryListAbilityService.getMemInfoBy(bo);
                List rows = infoBy.getRows();
                if (rows == null) {
                    throw new PfscExtBusinessException("\u4f1a\u5458\u8d26\u53f7\u4e3a\u7a7a\u5f02\u5e38", "18003");
                }
                HashSet<String> head = new HashSet<String>();
                ArrayList<BusiApplyInvoiceSyncErpBO> bodys = new ArrayList<BusiApplyInvoiceSyncErpBO>();
                List<DPayItemStroInfo> dPayItemStroInfos = this.dPayItemStroInfoMapper.selectByNotionNo(payInvoiceDetailVO.getNotificationNo());
                int crown = 10;
                for (DPayItemStroInfo dPayItemStroInfo : dPayItemStroInfos) {
                    head.add(dPayItemStroInfo.getPkInstroHeadNo());
                    BusiApplyInvoiceSyncErpBO erpBO = new BusiApplyInvoiceSyncErpBO();
                    erpBO.setRowno(String.valueOf(crown));
                    erpBO.setNnum(dPayItemStroInfo.getNnum().toString());
                    erpBO.setNorigtaxprice(dPayItemStroInfo.getNorigTaxPrice().toString());
                    erpBO.setPkInfoBody(dPayItemStroInfo.getPkInstoBody());
                    erpBO.setPkMaterial(dPayItemStroInfo.getPkMaterial());
                    bodys.add(erpBO);
                    crown += 10;
                }
                ArrayList heads = new ArrayList(head);
                busiApplyInvoiceSyncErpReqBO.setPkInstorHeadKList(heads);
                busiApplyInvoiceSyncErpReqBO.setInvoicelist(bodys);
                BusiApplyInvoiceSyncErpRspBO busiApplyInvoiceSyncErpRspBO = null;
                try {
                    busiApplyInvoiceSyncErpRspBO = this.busiApplyInvoiceSyncErpService.applyInvoice(busiApplyInvoiceSyncErpReqBO);
                    if (!StringUtils.isBlank((CharSequence)busiApplyInvoiceSyncErpRspBO.getCode()) && !"0".equals(busiApplyInvoiceSyncErpRspBO.getCode())) {
                        logger.info("\u8c03\u7528erp\u5931\u8d25, \u51fa\u53c2{}", (Object)busiApplyInvoiceSyncErpRspBO);
                    }
                    String jsonStr = busiApplyInvoiceSyncErpRspBO.getData();
                    logger.info("\u8fd4\u56de\u7684\u53c2\u6570\u662f\uff1a{}", (Object)jsonStr);
                    BusiApplyInvoiceSyncErpRspDataBO busiApplyInvoiceSyncErpRspDataBO = (BusiApplyInvoiceSyncErpRspDataBO)JSON.parseObject((String)jsonStr, BusiApplyInvoiceSyncErpRspDataBO.class);
                    BillNotificationInfoVO info = new BillNotificationInfoVO();
                    info.setNotificationNo(payInvoiceDetailVO.getNotificationNo());
                    info.setExtPur(busiApplyInvoiceSyncErpRspDataBO.getVbillcode());
                    logger.info("\u5f00\u7968\u4fe1\u606f\u662f\uff1a [{}]", (Object)info);
                    List pkInvoiceBList = busiApplyInvoiceSyncErpRspDataBO.getPkInvoiceBList();
                    logger.info("\u53d1\u7968\u8868\u4f53\u662f\uff1a [{}]", (Object)busiApplyInvoiceSyncErpRspDataBO);
                    String json = JSON.toJSONString((Object)pkInvoiceBList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    logger.info("\u66f4\u65b0\u8fd4\u56de\u7684JSON\u6570\u636e:{}", (Object)json);
                    PayInvoiceInfo payInvoiceInfo = new PayInvoiceInfo();
                    payInvoiceInfo.setIncoiveCrownoList(json);
                    payInvoiceInfo.setPkInvoice(busiApplyInvoiceSyncErpRspDataBO.getPkInvoice());
                    payInvoiceInfo.setInvoiceNo(busiApplyInvoiceSyncErpReqBO.getVbillcode());
                    int updateResult = this.payInvoiceInfoMapper.updateByInvoiceNo(payInvoiceInfo);
                    if (updateResult < 0) {
                        throw new PfscExtBusinessException("0001", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
                    }
                    int update = this.billNotificationInfoMapper.updateExtPur(info);
                    if (update < 0) {
                        throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    logger.info("\u8c03\u7528erp\u5931\u8d25, \u5165\u53c2{}, \u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)busiApplyInvoiceSyncErpReqBO, (Object)e);
                }
            } else {
                logger.info("\u53d1\u7968[{}]\u5df2\u540c\u6b65\u5230erp", (Object)payInvoiceDetailVO.getInvoiceNo());
            }
        });
        return rspBO;
    }

    public List<DPayItemStroVO> groupList(List<DPayItemStroInfo> dPayItemStroInfos) {
        HashMap headToBody = new HashMap(16);
        LinkedList<DPayItemStroVO> items = new LinkedList<DPayItemStroVO>();
        dPayItemStroInfos.forEach(dPayItemStroInfo -> {
            String pkInstroHeadNo = dPayItemStroInfo.getPkInstroHeadNo();
            BusiApplyInvoiceSyncErpBO erpBO = new BusiApplyInvoiceSyncErpBO();
            erpBO.setNnum(dPayItemStroInfo.getNnum().toString());
            erpBO.setNorigtaxprice(dPayItemStroInfo.getNorigTaxPrice().toString());
            erpBO.setPkInfoBody(dPayItemStroInfo.getPkInstoBody());
            erpBO.setPkMaterial(dPayItemStroInfo.getPkMaterial());
            if (!headToBody.containsKey(dPayItemStroInfo.getPkInstroHeadNo())) {
                ArrayList<BusiApplyInvoiceSyncErpBO> busiApplyInvoiceSyncErpBOs = new ArrayList<BusiApplyInvoiceSyncErpBO>();
                busiApplyInvoiceSyncErpBOs.add(erpBO);
                headToBody.put(pkInstroHeadNo, busiApplyInvoiceSyncErpBOs);
            } else {
                List list = (List)headToBody.get(pkInstroHeadNo);
                list.add(erpBO);
                headToBody.put(pkInstroHeadNo, list);
            }
        });
        Set entries = headToBody.entrySet();
        entries.forEach(entey -> {
            DPayItemStroVO vo = new DPayItemStroVO();
            vo.setPkStroHead((String)entey.getKey());
            vo.setBusiApplyInvoiceSyncErpBOS((List)entey.getValue());
        });
        return items;
    }

    public static void main(String[] args) {
        String jsonStr = "{\"pk_invoice\":\"1001A610000000BIIUDZ\",\"vbillcode\":\"202101260000004\",\"pk_invoice_b_list\":[{\"crowno\":\"00\",\"pk_invoice_b\":\"1001A610000000BIIUE0\"}]}} ";
        BusiApplyInvoiceSyncErpRspDataBO busiApplyInvoiceSyncErpRspDataBO = (BusiApplyInvoiceSyncErpRspDataBO)JSON.parseObject((String)jsonStr, BusiApplyInvoiceSyncErpRspDataBO.class);
    }
}

