/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.aop;

import com.tydic.pfscext.aop.annotation.FscCommitDateLimit;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class FscCommitDateLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(FscCommitDateLimitAspect.class);
    @Value(value="${FSC_ANNOTATION_COMMIT_DATE_LIMIT_EFFICIENT:1}")
    private String dataEfficient;
    @Value(value="${FSC_ANNOTATION_COMMIT_DATE_LIMIT_TIMESTAMP:2021-08-15 23:59:59}")
    private String TIMESTAMP;
    private final String EFFICIENT = "1";

    @Pointcut(value="@annotation(com.tydic.pfscext.aop.annotation.FscCommitDateLimit)")
    public void fscCommitDateLimit() {
    }

    @Around(value="fscCommitDateLimit()&&@annotation(limit)")
    public Object around(ProceedingJoinPoint joinPoint, FscCommitDateLimit limit) throws Throwable {
        Object[] args = joinPoint.getArgs();
        log.debug("\u751f\u6548\u72b6\u6001\uff1a{}", (Object)this.dataEfficient);
        if ("1".equals(this.dataEfficient)) {
            Object obj;
            String clazzName = joinPoint.getSignature().getDeclaringTypeName();
            String methodName = joinPoint.getSignature().getName();
            log.error("args:{}", args);
            log.error("clazzName:{}", (Object)clazzName);
            log.error("methodName:{}", (Object)methodName);
            log.debug("\u6ce8\u89e3\u5bf9\u8c61\u4fe1\u606f:{}", (Object)limit);
            if (null != args && args.length > 0 && Objects.nonNull(obj = args[0]) && StringUtils.hasText((String)limit.fieldName())) {
                Field field = obj.getClass().getDeclaredField(limit.fieldName());
                log.debug("\u53c2\u6570\u7684\u7c7b\u578b\uff1a{}", (Object)field.getType().getTypeName());
                if (Objects.nonNull(field)) {
                    field.setAccessible(true);
                    String timestamp = limit.time();
                    if (!StringUtils.hasText((String)timestamp)) {
                        timestamp = this.TIMESTAMP;
                    }
                    Object fieldDate = field.get(obj);
                    log.debug("\u5165\u53c2\u65f6\u95f4\u7684\u539f\u59cb\u503c\uff1a{}.\u914d\u7f6e\u503c\uff1a{}", fieldDate, (Object)timestamp);
                    SimpleDateFormat formatSource = new SimpleDateFormat("yyyy-MM-dd");
                    if (Date.class.getTypeName().equals(field.getType().getTypeName())) {
                        Date parse = formatSource.parse(timestamp);
                        Date paramDate = (Date)fieldDate;
                        if (Objects.isNull(fieldDate) || paramDate.getTime() < parse.getTime()) {
                            field.set(obj, parse);
                        }
                    } else if (String.class.getTypeName().equals(field.getType().getTypeName())) {
                        String paramDateStr = (String)fieldDate;
                        Date parse = formatSource.parse(timestamp);
                        if (!StringUtils.hasText((String)paramDateStr) || formatSource.parse(paramDateStr).getTime() < parse.getTime()) {
                            field.set(obj, new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(parse));
                        }
                    }
                }
            }
        }
        Object result = joinPoint.proceed(args);
        return result;
    }
}

