/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pfscext.aop.annotation.FscDuplicateCommitLimit;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Hex;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FscDuplicateCommitLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(FscDuplicateCommitLimitAspect.class);
    @Resource
    private CacheClient cacheService;

    @Pointcut(value="@annotation(com.tydic.pfscext.aop.annotation.FscDuplicateCommitLimit)")
    public void fscDuplicateCommitLimit() {
    }

    @Around(value="fscDuplicateCommitLimit()&&@annotation(limit)")
    public Object around(ProceedingJoinPoint joinPoint, FscDuplicateCommitLimit limit) throws Throwable {
        String reqMd = null;
        String message = "\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4";
        Object[] args = joinPoint.getArgs();
        String clazzName = joinPoint.getSignature().getDeclaringTypeName();
        String methodName = joinPoint.getSignature().getName();
        log.debug("\u63d0\u4ea4\u6b21\u6570\u62e6\u622a\u6ce8\u89e3\u4fe1\u606f:{}.--{}", (Object)limit, (Object)limit.toast());
        if (null != args && args.length > 0) {
            block11: {
                message = limit.toast();
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    reqMd = Hex.encodeHexString((byte[])md.digest(JSON.toJSONString((Object)args[0]).getBytes(StandardCharsets.UTF_8)));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
                    Long userIdIn = (Long)jsonObject.get((Object)"userId");
                    if (null == userIdIn || 0L == userIdIn) break block11;
                    reqMd = userIdIn + joinPoint.toShortString();
                }
            }
            if (null != reqMd) {
                Object o = null;
                try {
                    o = this.cacheService.get(reqMd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    reqMd = null;
                }
                if (null != o) {
                    log.debug("\u63d0\u4ea4\u6b21\u6570\u62e6\u622a--\u62e6\u622a\u6210\u529f---\u63d0\u793a\u6d88\u606f:{}.", (Object)message);
                    throw new PfscExtBusinessException("18000", message);
                }
                if (null != reqMd) {
                    try {
                        this.cacheService.set(reqMd, (Object)"", 5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Object result = joinPoint.proceed(args);
        if (null != reqMd) {
            log.debug("\u63d0\u4ea4\u6b21\u6570\u62e6\u622a---\u6267\u884c\u5b8c\u6210\u5220\u9664redis\u7f13\u5b58:{}.{}-result:{}", new Object[]{clazzName, methodName, result});
            this.cacheService.delete(reqMd);
        }
        return result;
    }
}

