/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.vo.BillSummaryInfoConditionVO;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.api.FscBillSummaryInfoAtomService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillSummaryInfoAtomServiceImpl
implements FscBillSummaryInfoAtomService {
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;

    @Override
    public List<BillSummaryInfo> qryListByDocumentNos(List<String> documentNos) {
        ArrayList<BillSummaryInfo> list = new ArrayList<BillSummaryInfo>();
        if (!CollectionUtils.isEmpty(documentNos)) {
            BillSummaryInfoConditionVO conditionVO = new BillSummaryInfoConditionVO();
            conditionVO.setStatementNoListIn(documentNos);
            conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            return Optional.ofNullable(this.billSummaryInfoMapper.getList(conditionVO)).orElse(Lists.newArrayList());
        }
        return list;
    }

    @Override
    public List<BillSummaryInfo> qryListByDocumentNo(String documentNo) {
        ArrayList<BillSummaryInfo> list = new ArrayList<BillSummaryInfo>();
        if (StringUtils.hasText((String)documentNo)) {
            ArrayList<String> docs = new ArrayList<String>();
            docs.add(documentNo);
            List<BillSummaryInfo> summaryInfos = this.qryListByDocumentNos(docs);
            if (!CollectionUtils.isEmpty(summaryInfos)) {
                list.addAll(summaryInfos);
            }
        }
        return list;
    }

    @Override
    public int insertBatch(List<BillSummaryInfo> infos) {
        if (!CollectionUtils.isEmpty(infos)) {
            int count = 0;
            for (BillSummaryInfo info : infos) {
                if (StringUtils.hasText((String)info.getId())) {
                    int i = this.billSummaryInfoMapper.insert(info);
                    count += i;
                    continue;
                }
                throw new PfscExtBusinessException("18000", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u4e3b\u952e\u4e3a\u7a7a");
            }
            return count;
        }
        return 0;
    }
}

