/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.dao.vo.OriginalDocumentsInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.api.FscOriginalDocumentsInfoAtomService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscOriginalDocumentsInfoAtomServiceImpl
implements FscOriginalDocumentsInfoAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOriginalDocumentsInfoAtomServiceImpl.class);
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;

    @Override
    public List<OriginalDocumentsInfo> qryListByDocumentNos(List<String> documentNos) {
        ArrayList<OriginalDocumentsInfo> list = new ArrayList<OriginalDocumentsInfo>();
        if (!CollectionUtils.isEmpty(documentNos)) {
            OriginalDocumentsInfoVO condition = new OriginalDocumentsInfoVO();
            condition.setDocumentNoInList(documentNos.stream().distinct().collect(Collectors.toList()));
            List<OriginalDocumentsInfo> documentsInfos = this.originalDocumentsInfoMapper.selectListCondition(condition);
            if (!CollectionUtils.isEmpty(documentsInfos)) {
                list.addAll(documentsInfos);
            }
        }
        return list;
    }

    @Override
    public List<String> qryListDocumentNo(List<String> documentNos) {
        List<String> list = this.originalDocumentsInfoMapper.selectCountByDocumentNos(documentNos);
        return list;
    }

    @Override
    public int insertBatch(List<OriginalDocumentsInfo> infos) {
        if (!CollectionUtils.isEmpty(infos)) {
            int count = 0;
            for (OriginalDocumentsInfo info : infos) {
                if (StringUtils.hasText((String)info.getDocumentNo())) {
                    int i = this.originalDocumentsInfoMapper.insert(info);
                    count += i;
                    continue;
                }
                throw new PfscExtBusinessException("18000", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u5355\u636e\u53f7\u4e3a\u7a7a");
            }
            return count;
        }
        return 0;
    }
}

