/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.aop.annotation.FscDuplicateCommitLimit;
import com.tydic.pfscext.api.busi.BusiBillingModifyConfirmService;
import com.tydic.pfscext.api.busi.bo.BusiBillingModifyConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.BusiBillingModifyConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.InvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.vo.BillSummaryInfoVO;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoInvoiceMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.InvoiceInfoTempMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfoInvoicePO;
import com.tydic.pfscext.dao.po.InvoiceInfoTemp;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.dao.vo.BillSummaryInfoConditionVO;
import com.tydic.pfscext.dao.vo.BillSummaryInfoInvoiceConditionVO;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.enums.NInvoiceStatus;
import com.tydic.pfscext.enums.NInvoiceType;
import com.tydic.pfscext.enums.OperationType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiInvoiceCreatePushErpSercive;
import com.tydic.pfscext.external.api.bo.BusiInvoiceCreatePushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceCreatePushErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiStoreInvoiceCreateBodyPushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiStoreInvoiceCreatePushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiSummaryInvoiceBodyPushErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiSummaryInvoiceCreatePushErpReqBO;
import com.tydic.pfscext.external.api.bo.InvoicePushErpItemInfo;
import com.tydic.pfscext.external.api.bo.InvoicePushErpRspBO;
import com.tydic.pfscext.external.umc.api.UmcPurSupInfoListQryExternalService;
import com.tydic.pfscext.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiBillingModifyConfirmService.class)
public class BusiBillingModifyConfirmServiceImpl
implements BusiBillingModifyConfirmService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillingModifyConfirmServiceImpl.class);
    private static final String PURCHASE_USER = "1";
    private static final String SUPPLIER_USER = "2";
    private static final String FSC_ERP_TRANSACTION_TYPE_MANAGE = "1001A31000000000161A";
    private static final String PREFIX = "HBDH";
    @Autowired
    private UmcPurSupInfoListQryExternalService umcPurSupInfoListQryExternalService;
    @Autowired
    private InvoiceInfoTempMapper invoiceInfoTempMapper;
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillSummaryInfoInvoiceMapper billSummaryInfoInvoiceMapper;
    @Autowired
    private BusiInvoiceCreatePushErpSercive busiInvoiceCreatePushErpSercive;

    @FscDuplicateCommitLimit(toast="\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u5f00\u7968\u6570\u636e")
    public BusiBillingModifyConfirmRspBO billingModifyConfirm(BusiBillingModifyConfirmReqBO reqBO) {
        log.info("\u91c7\u8d2d\u6267\u884c\u3010\u5f00\u7968\u3011\u3010\u4fee\u6539\u3011\u3010\u786e\u8ba4\u3011\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        this.billingVerification(reqBO);
        if (OperationType.BILLING.getCode().equals(reqBO.getOperationType()) || OperationType.CONFIRM.getCode().equals(reqBO.getOperationType())) {
            this.billingOrConfirm(reqBO);
        } else if (OperationType.MODIFY.getCode().equals(reqBO.getOperationType())) {
            this.modify(reqBO);
        }
        BusiBillingModifyConfirmRspBO rspBO = new BusiBillingModifyConfirmRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void billingOrConfirm(BusiBillingModifyConfirmReqBO reqBO) {
        String mergeNO = this.getMergeNO(reqBO.getOperationType(), reqBO.getMergeDocumentNo());
        List documentNos = reqBO.getDocumentNos();
        List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(documentNos);
        BillSummaryInfoConditionVO billSummaryInfoConditionVO = new BillSummaryInfoConditionVO();
        billSummaryInfoConditionVO.setStatementNoListIn(documentNos);
        billSummaryInfoConditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
        List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.getList(billSummaryInfoConditionVO);
        BillSummaryInfoInvoiceConditionVO conditionVO = new BillSummaryInfoInvoiceConditionVO();
        conditionVO.setStatementNoInList(documentNos);
        conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
        List<BillSummaryInfoInvoicePO> billSummaryInfoInvoicePOList = this.billSummaryInfoInvoiceMapper.selectListCondition(conditionVO);
        List<String> documentNoList = getOriginalDocumentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getDocumentNo).distinct().collect(Collectors.toList());
        this.checkMergeBillingSupper(reqBO, getOriginalDocumentsInfoVOS);
        this.checkMergeBilling(reqBO);
        this.checkBillSummaryInfoInvoicedQuantity(reqBO, billSummaryInfos, billSummaryInfoInvoicePOList, mergeNO);
        BillMergeInfo billMergeInfo = new BillMergeInfo();
        billMergeInfo.setMergeSetNo(mergeNO);
        this.initBillMergeInfoData(billMergeInfo, reqBO, getOriginalDocumentsInfoVOS);
        InvoiceInfoTemp invoiceInfoTemp = new InvoiceInfoTemp();
        invoiceInfoTemp.setInoviceInfoId(mergeNO);
        this.initInvoiceInfoTempData(invoiceInfoTemp, reqBO);
        if (PURCHASE_USER.equals(reqBO.getIsProfessionalOrgExt())) {
            this.purInvoice(reqBO, getOriginalDocumentsInfoVOS, billSummaryInfos, billMergeInfo, invoiceInfoTemp);
        } else {
            this.supInvoice(reqBO, getOriginalDocumentsInfoVOS, billMergeInfo);
        }
        this.insertOrUpdateData(reqBO, billMergeInfo, invoiceInfoTemp);
        this.insertOrUpdateSummaryData(reqBO, documentNoList, billSummaryInfos, billMergeInfo);
    }

    private void insertOrUpdateSummaryData(BusiBillingModifyConfirmReqBO reqBO, List<String> documentNoList, List<BillSummaryInfo> billSummaryInfos, BillMergeInfo billMergeInfo) {
        block7: {
            String invoiceStatus;
            List<BillSummaryInfoInvoicePO> infoInvoicePOS;
            block5: {
                block6: {
                    BillSummaryInfoInvoiceConditionVO conditionVO = new BillSummaryInfoInvoiceConditionVO();
                    conditionVO.setMergeSetNo(billMergeInfo.getMergeSetNo());
                    conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                    infoInvoicePOS = this.billSummaryInfoInvoiceMapper.selectListCondition(conditionVO);
                    ArrayList<String> mergeSetNo = new ArrayList<String>();
                    mergeSetNo.add(billMergeInfo.getMergeSetNo());
                    this.billSummaryInfoInvoiceMapper.deleteByMergeSetNo(mergeSetNo);
                    invoiceStatus = billMergeInfo.getInvoiceStatus();
                    CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
                    if (!PURCHASE_USER.equals(ctrantType.getCtrantType())) break block5;
                    for (BillSummaryInfo billSummaryInfo : billSummaryInfos) {
                        long nextId = Sequence.getInstance().nextId();
                        BillSummaryInfoInvoicePO billSummaryInfoInvoicePO = (BillSummaryInfoInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)billSummaryInfo), BillSummaryInfoInvoicePO.class);
                        billSummaryInfoInvoicePO.setId(String.valueOf(nextId));
                        billSummaryInfoInvoicePO.setRid(billSummaryInfo.getId());
                        billSummaryInfoInvoicePO.setInvoiceStatus(invoiceStatus);
                        billSummaryInfoInvoicePO.setMergeSetNo(billMergeInfo.getMergeSetNo());
                        this.billSummaryInfoInvoiceMapper.insert(billSummaryInfoInvoicePO);
                        BillSummaryInfo record = new BillSummaryInfo();
                        record.setId(billSummaryInfo.getId());
                        record.setInvoiceStatus(invoiceStatus);
                        this.billSummaryInfoMapper.updateByPrimaryKeySelective(record);
                    }
                    if (documentNoList.size() <= 1) break block6;
                    this.originalDocumentsInfoMapper.updateByDocumentNos(documentNoList, invoiceStatus);
                    break block7;
                }
                if (documentNoList.size() != 1) break block7;
                OriginalDocumentsInfo info = new OriginalDocumentsInfo();
                info.setDocumentNo((String)reqBO.getDocumentNos().get(0));
                info.setInvoicedNum(reqBO.getInvoiceInfoReqBO().getInvoceNum());
                info.setInvoicedAmt(reqBO.getInvoiceInfoReqBO().getTotalAmtTax());
                info.setInvoiceStatus(invoiceStatus);
                this.originalDocumentsInfoMapper.updateByPrimaryKeySelective(info);
                break block7;
            }
            Map<String, BillSummaryInfo> collectMap = billSummaryInfos.stream().collect(Collectors.toMap(BillSummaryInfo::getId, item -> item, (oldItem, newItem) -> newItem));
            Map<String, BillSummaryInfoInvoicePO> infoInvoicePOSMap = infoInvoicePOS.stream().collect(Collectors.toMap(BillSummaryInfoInvoicePO::getRid, item -> item, (oldItem, newItem) -> newItem));
            List summaryInfos = reqBO.getBillSummaryInfos();
            for (BillSummaryInfoVO summaryInfo : summaryInfos) {
                long nextId = Sequence.getInstance().nextId();
                BillSummaryInfo billSummaryInfo = collectMap.get(summaryInfo.getId());
                BillSummaryInfoInvoicePO billSummaryInfoInvoicePO = (BillSummaryInfoInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)billSummaryInfo), BillSummaryInfoInvoicePO.class);
                billSummaryInfoInvoicePO.setId(String.valueOf(nextId));
                billSummaryInfoInvoicePO.setRid(billSummaryInfo.getId());
                billSummaryInfoInvoicePO.setInvoiceStatus(invoiceStatus);
                billSummaryInfoInvoicePO.setMergeSetNo(billMergeInfo.getMergeSetNo());
                billSummaryInfoInvoicePO.setTaxInvoice(summaryInfo.getTaxInvoice());
                billSummaryInfoInvoicePO.setTaxPriceInvoice(summaryInfo.getTaxPriceInvoice());
                billSummaryInfoInvoicePO.setNoTaxPriceInvoice(summaryInfo.getNoTaxPriceInvoice());
                billSummaryInfoInvoicePO.setInvoicableQuantityInvoice(summaryInfo.getInvoicableQuantityInvoice());
                billSummaryInfoInvoicePO.setInvoicableAmtInvoice(summaryInfo.getInvoicableAmtInvoice());
                billSummaryInfoInvoicePO.setNoTaxAmtInvoice(summaryInfo.getNoTaxAmtInvoice());
                this.billSummaryInfoInvoiceMapper.insert(billSummaryInfoInvoicePO);
                BillSummaryInfo record = new BillSummaryInfo();
                record.setId(billSummaryInfo.getId());
                record.setInvoiceStatus(invoiceStatus);
                BillSummaryInfoInvoicePO invoicePO = infoInvoicePOSMap.get(summaryInfo.getId());
                String invoicedQuantity = this.getInvoicedQuantity(billSummaryInfo.getInvoicedQuantity(), summaryInfo.getInvoicableQuantityInvoice(), invoicePO == null ? null : invoicePO.getInvoicableQuantityInvoice());
                record.setInvoicedQuantity(invoicedQuantity);
                this.billSummaryInfoMapper.updateByPrimaryKeySelective(record);
            }
            for (String documentNo : documentNoList) {
                BillSummaryInfoConditionVO condition = new BillSummaryInfoConditionVO();
                condition.setStatementNo(documentNo);
                condition.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                List<BillSummaryInfo> billSummaryInfoList = this.billSummaryInfoMapper.getList(condition);
                log.debug("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString(billSummaryInfoList));
                List collect = billSummaryInfoList.stream().filter(item -> BigDecimalUtils.getStr2BigDecimal(item.getInventoryQuantity()).compareTo(BigDecimalUtils.getStr2BigDecimal(item.getInvoicedQuantity())) != 0).collect(Collectors.toList());
                OriginalDocumentsInfo info = new OriginalDocumentsInfo();
                info.setDocumentNo(documentNo);
                Double sum = summaryInfos.stream().filter(item -> documentNo.equals(item.getStatementNo())).mapToDouble(item -> Double.valueOf(item.getInvoicableAmtInvoice())).sum();
                info.setInvoicedAmt(sum.toString());
                Double sum2 = summaryInfos.stream().filter(item -> documentNo.equals(item.getStatementNo())).mapToDouble(item -> Double.valueOf(item.getInvoicableQuantityInvoice())).sum();
                info.setInvoicedNum(sum2.toString());
                if (collect.size() == 0) {
                    info.setInvoiceStatus(invoiceStatus);
                } else {
                    info.setInvoiceStatus(NInvoiceStatus.NOT_MAKE.getCode());
                }
                this.originalDocumentsInfoMapper.updateByPrimaryKeySelective(info);
            }
        }
    }

    private String getInvoicedQuantity(String invoicedQuantityStr, String invoicableQuantityInvoiceStr, String invoicableQuantityInvoiceOldStr) {
        BigDecimal invoicedQuantity = BigDecimalUtils.getStr2BigDecimal(invoicedQuantityStr);
        BigDecimal invoicableQuantityInvoice = BigDecimalUtils.getStr2BigDecimal(invoicableQuantityInvoiceStr);
        BigDecimal invoicableQuantityInvoiceOld = BigDecimalUtils.getStr2BigDecimal(invoicableQuantityInvoiceOldStr);
        BigDecimal invoicedQuantityNew = invoicedQuantity.add(invoicableQuantityInvoice).subtract(invoicableQuantityInvoiceOld);
        return invoicedQuantityNew.setScale(2, 4).toString();
    }

    private void insertOrUpdateData(BusiBillingModifyConfirmReqBO reqBO, BillMergeInfo billMergeInfo, InvoiceInfoTemp invoiceInfoTemp) {
        if (OperationType.BILLING.getCode().equals(reqBO.getOperationType())) {
            int insert = this.billMergeInfoMapper.insert(billMergeInfo);
            if (insert < 1) {
                throw new PfscExtBusinessException("18000", "\u4fdd\u5b58\u5f00\u7968\u4fe1\u606f\u5931\u8d25");
            }
            int insert1 = this.invoiceInfoTempMapper.insert(invoiceInfoTemp);
            if (insert1 < 1) {
                throw new PfscExtBusinessException("18000", "\u4fdd\u5b58\u53d1\u7968\u4e34\u65f6\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            int i = this.billMergeInfoMapper.updateByMergrNo(billMergeInfo);
            if (i < 1) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5f00\u7968\u4fe1\u606f\u5931\u8d25");
            }
            int i1 = this.invoiceInfoTempMapper.updateByMergrNo(invoiceInfoTemp);
            if (i1 < 1) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u53d1\u7968\u4e34\u65f6\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    private void initInvoiceInfoTempData(InvoiceInfoTemp invoiceInfoTemp, BusiBillingModifyConfirmReqBO reqBO) {
        BeanUtils.copyProperties((Object)reqBO.getInvoiceInfoReqBO(), (Object)invoiceInfoTemp);
        invoiceInfoTemp.setEffectiveState(PURCHASE_USER);
        invoiceInfoTemp.setBillType(CtrantType.getInstance(reqBO.getType()).getCtrantType());
        if (PURCHASE_USER.equals(reqBO.getIsProfessionalOrgExt())) {
            invoiceInfoTemp.setInvoiceStatus(FscBillStatus.INVOICED.getCode());
        } else {
            invoiceInfoTemp.setInvoiceStatus(FscBillStatus.ENTERED.getCode());
        }
    }

    private void initBillMergeInfoData(BillMergeInfo billMergeInfo, BusiBillingModifyConfirmReqBO reqBO, List<GetOriginalDocumentsInfoVO> documentsInfoVOS) {
        String supplierId = documentsInfoVOS.get(0).getSupplierId();
        String coalSupplierId = documentsInfoVOS.get(0).getCoalSupplierId();
        billMergeInfo.setSupplierId(StringUtils.hasText((String)supplierId) ? supplierId : coalSupplierId);
        CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
        if (CtrantType.RAW_COAL.getCtrantType().equals(ctrantType.getCtrantType())) {
            billMergeInfo.setSetUnitCode(documentsInfoVOS.get(0).getSettlementSupplier());
        } else if (CtrantType.NON_HOSTED.getCtrantType().equals(ctrantType.getCtrantType()) || CtrantType.HOSTED.getCode().equals(ctrantType.getCode())) {
            billMergeInfo.setSetUnitCode(documentsInfoVOS.get(0).getStoreOrgName());
        }
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        billMergeInfo.setTotalIncoicedNum(invoiceInfoReqBO.getInvoceNum());
        billMergeInfo.setTotalAmt(invoiceInfoReqBO.getTotalAmtTax());
        billMergeInfo.setInvoiceType(invoiceInfoReqBO.getInvoceType());
        if (null != invoiceInfoReqBO.getCreditDate()) {
            billMergeInfo.setCreditDate(invoiceInfoReqBO.getCreditDate());
        }
        if (null != invoiceInfoReqBO.getDArriveDate()) {
            billMergeInfo.setDArriveDate(invoiceInfoReqBO.getDArriveDate());
        }
        if (null != invoiceInfoReqBO.getInvoiceIssuanceDate()) {
            billMergeInfo.setInvoiceIssuanceDate(invoiceInfoReqBO.getInvoiceIssuanceDate());
        }
        if (PURCHASE_USER.equals(reqBO.getIsProfessionalOrgExt())) {
            billMergeInfo.setInvoiceStatus(FscBillStatus.INVOICED.getCode());
        } else {
            billMergeInfo.setInvoiceStatus(FscBillStatus.ENTERED.getCode());
        }
        billMergeInfo.setBillType(ctrantType.getCtrantType());
        billMergeInfo.setEffectiveState(PURCHASE_USER);
    }

    private void checkMergeBilling(BusiBillingModifyConfirmReqBO reqBO) {
        CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
        if (!CtrantType.RAW_COAL.getCtrantType().equals(ctrantType.getCode()) && !CtrantType.CHEMICAL_STORE.getCode().equals(ctrantType.getCode()) && (CtrantType.NON_HOSTED.getCode().equals(ctrantType.getCode()) || CtrantType.HOSTED.getCode().equals(ctrantType.getCode()))) {
            InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
            BigDecimal totalAmtTax = BigDecimalUtils.getStr2BigDecimal(invoiceInfoReqBO.getTotalAmtTax());
            BigDecimal totalAmt = BigDecimalUtils.getStr2BigDecimal(invoiceInfoReqBO.getTotalAmt());
            BigDecimal taxRate = BigDecimalUtils.getStr2BigDecimal(invoiceInfoReqBO.getTaxRate());
            BigDecimal invoiceNum = BigDecimalUtils.getStr2BigDecimal(invoiceInfoReqBO.getInvoceNum());
            if (totalAmtTax.compareTo(totalAmt.add(taxRate)) != 0) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u6ee1\u8db3[\u542b\u7a0e\u91d1\u989d] = [\u4e0d\u542b\u7a0e\u91d1\u989d] + [\u7a0e\u989d]");
            }
            if (CtrantType.NON_HOSTED.getCode().equals(reqBO.getType()) || CtrantType.HOSTED.getCode().equals(reqBO.getType())) {
                List billSumInfoVos = reqBO.getBillSummaryInfos();
                if (billSumInfoVos.size() == 0) {
                    throw new PfscExtBusinessException("18000", "\u6c47\u603b\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                BigDecimal vosTaxInvoice = BigDecimal.ZERO;
                BigDecimal vosInvoicableQuantityInvoice = BigDecimal.ZERO;
                BigDecimal vosInvoicableAmtInvoice = BigDecimal.ZERO;
                BigDecimal vosNoTaxAmtInvoice = BigDecimal.ZERO;
                for (BillSummaryInfoVO item : billSumInfoVos) {
                    BigDecimal taxInvoice = BigDecimalUtils.getStr2BigDecimal(item.getTaxInvoice());
                    BigDecimal invoicableAmtInvoice = BigDecimalUtils.getStr2BigDecimal(item.getInvoicableAmtInvoice());
                    BigDecimal noTaxAmtInvoice = BigDecimalUtils.getStr2BigDecimal(item.getNoTaxAmtInvoice());
                    BigDecimal invoicableQuantityInvoice = BigDecimalUtils.getStr2BigDecimal(item.getInvoicableQuantityInvoice());
                    if (invoicableAmtInvoice.compareTo(noTaxAmtInvoice.add(taxInvoice)) != 0) {
                        log.error("\u53d1\u7968\u8be6\u60c5\u4e0d\u6ee1\u8db3[\u542b\u7a0e\u91d1\u989d] = [\u4e0d\u542b\u7a0e\u91d1\u989d] + [\u7a0e\u989d]:{}", (Object)JSON.toJSONString((Object)item, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        throw new PfscExtBusinessException("18000", "\u53d1\u7968\u8be6\u60c5\u4e0d\u6ee1\u8db3[\u542b\u7a0e\u91d1\u989d\uff1a" + invoicableAmtInvoice + "] = [\u4e0d\u542b\u7a0e\u91d1\u989d:" + noTaxAmtInvoice + "] + [\u7a0e\u989d:" + taxInvoice + "]");
                    }
                    vosTaxInvoice = vosTaxInvoice.add(taxInvoice);
                    vosInvoicableAmtInvoice = vosInvoicableAmtInvoice.add(invoicableAmtInvoice);
                    vosNoTaxAmtInvoice = vosNoTaxAmtInvoice.add(noTaxAmtInvoice);
                    vosInvoicableQuantityInvoice = vosInvoicableQuantityInvoice.add(invoicableQuantityInvoice);
                }
                if (totalAmtTax.compareTo(vosInvoicableAmtInvoice) != 0) {
                    log.error("\u53d1\u7968[\u542b\u7a0e\u91d1\u989d\uff1a{}] \u4e0d\u7b49\u4e8e [\u5f00\u7968\u91d1\u989d\u884c\u5408\u8ba1\uff1a{}]", (Object)totalAmtTax, (Object)vosInvoicableAmtInvoice);
                    throw new PfscExtBusinessException("18000", "\u53d1\u7968[\u542b\u7a0e\u91d1\u989d\uff1a" + totalAmtTax + "] \u4e0d\u7b49\u4e8e [\u5f00\u7968\u91d1\u989d\u884c\u5408\u8ba1\uff1a" + vosInvoicableAmtInvoice + "]");
                }
                if (totalAmt.compareTo(vosNoTaxAmtInvoice) != 0) {
                    log.error("\u53d1\u7968[\u4e0d\u542b\u7a0e\u91d1\u989d\uff1a{}] \u4e0d\u7b49\u4e8e [\u65e0\u7a0e\u91d1\u989d\u884c\u5408\u8ba1\uff1a{}]", (Object)totalAmt, (Object)vosNoTaxAmtInvoice);
                    throw new PfscExtBusinessException("18000", "\u53d1\u7968[\u542b\u7a0e\u91d1\u989d\uff1a" + totalAmt + "] \u4e0d\u7b49\u4e8e [\u542b\u7a0e\u91d1\u989d\u884c\u5408\u8ba1\uff1a" + vosNoTaxAmtInvoice + "]");
                }
                if (taxRate.compareTo(vosTaxInvoice) != 0) {
                    log.error("\u53d1\u7968[\u7a0e\u989d\uff1a{}] \u4e0d\u7b49\u4e8e [\u7a0e\u989d\u884c\u5408\u8ba1\uff1a{}]", (Object)taxRate, (Object)vosTaxInvoice);
                    throw new PfscExtBusinessException("18000", "\u53d1\u7968[\u7a0e\u989d\uff1a" + taxRate + "] \u4e0d\u7b49\u4e8e [\u7a0e\u989d\u884c\u5408\u8ba1\uff1a" + vosTaxInvoice + "]");
                }
                if (invoiceNum.compareTo(vosInvoicableQuantityInvoice) != 0) {
                    log.error("\u53d1\u7968[\u603b\u6570\u91cf\uff1a{}] \u4e0d\u7b49\u4e8e [\u5f00\u7968\u6570\u91cf\u884c\u5408\u8ba1\uff1a{}]", (Object)invoiceNum, (Object)vosInvoicableQuantityInvoice);
                    throw new PfscExtBusinessException("18000", "\u53d1\u7968[\u603b\u6570\u91cf\uff1a" + invoiceNum + "] \u4e0d\u7b49\u4e8e [\u5f00\u7968\u6570\u91cf\u884c\u5408\u8ba1\uff1a" + vosInvoicableQuantityInvoice + "]");
                }
            }
        }
    }

    private void checkBillSummaryInfoInvoicedQuantity(BusiBillingModifyConfirmReqBO reqBO, List<BillSummaryInfo> billSummaryInfos, List<BillSummaryInfoInvoicePO> billSummaryInfoInvoicePOList, String mergeNO) {
        if (CollectionUtils.isEmpty(billSummaryInfos)) {
            throw new PfscExtBusinessException("18000", "\u539f\u59cb\u7269\u6599\u4e3a\u7a7a");
        }
        List collect = billSummaryInfos.stream().filter(item -> NInvoiceStatus.BILLING.getCode().equals(item.getInvoiceStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u3010\u5f00\u7968\u4e2d\u3011\u7684\u7269\u6599\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u91cd\u8bd5");
        }
        List billSumInfoVos = reqBO.getBillSummaryInfos();
        if (CtrantType.NON_HOSTED.getCode().equals(reqBO.getType()) || CtrantType.HOSTED.getCode().equals(reqBO.getType())) {
            Map<String, List<BillSummaryInfoInvoicePO>> infoInvoicePOMap = billSummaryInfoInvoicePOList.stream().collect(Collectors.groupingBy(BillSummaryInfoInvoicePO::getRid));
            Map<String, BillSummaryInfo> summaryInfoMap = billSummaryInfos.stream().collect(Collectors.toMap(BillSummaryInfo::getId, item -> item, (oldItem, newItem) -> newItem));
            for (BillSummaryInfoVO infoVo : billSumInfoVos) {
                BillSummaryInfo billSummaryInfo = summaryInfoMap.get(infoVo.getId());
                if (billSummaryInfo == null) {
                    throw new PfscExtBusinessException("18000", "\u6821\u9a8c\u5f00\u7968\u6570\u91cf\u51fa\u9519");
                }
                List<BillSummaryInfoInvoicePO> infoInvoicePOS = infoInvoicePOMap.get(infoVo.getId());
                BigDecimal invoicedQuantityAll = BigDecimal.ZERO;
                BigDecimal inventoryQuantity = BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getInventoryQuantity());
                BigDecimal invoicableQuantityInvoice = BigDecimalUtils.getStr2BigDecimal(infoVo.getInvoicableQuantityInvoice());
                if (!CollectionUtils.isEmpty(infoInvoicePOS)) {
                    double sum = infoInvoicePOS.stream().filter(item -> !mergeNO.equals(item.getMergeSetNo())).mapToDouble(item -> Double.valueOf(item.getInvoicableQuantityInvoice())).sum();
                    invoicedQuantityAll = invoicedQuantityAll.add(new BigDecimal(sum));
                }
                if (inventoryQuantity.compareTo(invoicedQuantityAll.add(invoicableQuantityInvoice)) >= 0) continue;
                StringBuilder sb = new StringBuilder("\u6821\u9a8c\u5f00\u7968\u6570\u91cf\u51fa\u9519\uff1a");
                sb.append("\u884c\u53f7[").append(billSummaryInfo.getLineNumber());
                sb.append("]\u7269\u6599[").append(billSummaryInfo.getMaterialCode());
                sb.append("]\u7684\u5f00\u7968\u6570\u91cf[").append(infoVo.getInvoicableQuantityInvoice());
                sb.append("]\u5927\u4e8e\u6700\u5927\u53ef\u5f00\u7968\u6570\u91cf[").append(inventoryQuantity.subtract(invoicedQuantityAll).setScale(2, 4).toString()).append("]");
                throw new PfscExtBusinessException("18000", sb.toString());
            }
            List ids = billSumInfoVos.stream().map(BillSummaryInfoVO::getId).collect(Collectors.toList());
            this.billSummaryInfoMapper.updateStatusByIdList(new ArrayList<String>(ids), NInvoiceStatus.BILLING.getCode());
        } else {
            double sum;
            BigDecimal invoceNum = BigDecimalUtils.getStr2BigDecimal(reqBO.getInvoiceInfoReqBO().getInvoceNum());
            if (invoceNum.compareTo(new BigDecimal(sum = billSummaryInfos.stream().mapToDouble(item -> Double.valueOf(item.getInventoryQuantity())).sum())) > 0) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u6570\u91cf\u5927\u4e8e\u7ed3\u7b97\u6570\u91cf");
            }
            List ids = billSummaryInfos.stream().map(BillSummaryInfo::getId).collect(Collectors.toList());
            this.billSummaryInfoMapper.updateStatusByIdList(new ArrayList<String>(ids), NInvoiceStatus.BILLING.getCode());
        }
    }

    private void checkMergeBillingSupper(BusiBillingModifyConfirmReqBO reqBO, List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS) {
        String type = reqBO.getType();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getDocumentNos()) && reqBO.getDocumentNos().size() > 1) {
            List<String> typeList2 = Arrays.asList("3", "4", "5");
            if (CtrantType.RAW_COAL.getCode().equals(type)) {
                this.judgeSupplier(getOriginalDocumentsInfoVOS, "\u7164\u70ad\u4f9b\u5e94\u5546");
            } else if (CtrantType.CHEMICAL.getCode().equals(type)) {
                this.judgeSupplier(getOriginalDocumentsInfoVOS, "\u7ed3\u7b97\u5355\u4f4d");
            } else if (typeList2.contains(type)) {
                this.judgeSupplier(getOriginalDocumentsInfoVOS, "\u4f9b\u5e94\u5546");
            } else {
                throw new PfscExtBusinessException("18000", "TYPE[ " + type + " ] \u672a\u77e5\u503c");
            }
        }
    }

    private void judgeSupplier(List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS, String prefix) {
        LinkedHashSet<String> supplierIdList = new LinkedHashSet<String>();
        for (GetOriginalDocumentsInfoVO item : getOriginalDocumentsInfoVOS) {
            if (!StringUtils.hasText((String)item.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u5355\u636e[" + item.getDocumentNo() + "]\u7684" + prefix + "\u4e3a\u7a7a");
            }
            supplierIdList.add(item.getSupplierId());
        }
        if (supplierIdList.size() > 1) {
            throw new PfscExtBusinessException("18000", "[" + prefix + "]\u90fd\u76f8\u540c\u7684\u5355\u636e\u624d\u80fd\u5408\u5e76\u5f00\u7968");
        }
    }

    private void purInvoice(BusiBillingModifyConfirmReqBO reqBO, List<GetOriginalDocumentsInfoVO> documentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, BillMergeInfo billMergeInfo, InvoiceInfoTemp invoiceInfoTemp) {
        billMergeInfo.setOrgCode(reqBO.getOrgCode());
        billMergeInfo.setPurDeptId(reqBO.getOrgCode());
        CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
        if ("3".equals(ctrantType.getCtrantType())) {
            this.createSummeryInvoice(reqBO, documentsInfoVOS, billSummaryInfos, invoiceInfoTemp, billMergeInfo);
        }
        if (SUPPLIER_USER.equals(ctrantType.getCtrantType())) {
            this.createStoreInvoice(reqBO, documentsInfoVOS, billSummaryInfos, invoiceInfoTemp, billMergeInfo);
        }
        if (PURCHASE_USER.equals(ctrantType.getCtrantType())) {
            this.createInvoice(reqBO, documentsInfoVOS, billSummaryInfos, invoiceInfoTemp, billMergeInfo);
        }
    }

    private void supInvoice(BusiBillingModifyConfirmReqBO reqBO, List<GetOriginalDocumentsInfoVO> documentsInfoVOS, BillMergeInfo billMergeInfo) {
        log.info("\u4f9b\u5e94\u5546\u5f00\u7968--reqBO:{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u4f9b\u5e94\u5546\u5f00\u7968--documentsInfoVOS:{}", (Object)JSON.toJSONString(documentsInfoVOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u4f9b\u5e94\u5546\u5f00\u7968--billMergeInfo:{}", (Object)JSON.toJSONString((Object)billMergeInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String supplierId = this.umcPurSupInfoListQryExternalService.getCreditNoFromUMC((String)Optional.ofNullable(reqBO.getOrgId()).map(String::valueOf).orElse(null));
        billMergeInfo.setSupplierId(supplierId);
        billMergeInfo.setOrgCode(documentsInfoVOS.get(0).getOrgCode());
        billMergeInfo.setPurDeptId(documentsInfoVOS.get(0).getOrgCode());
        billMergeInfo.setInvoiceStatus(NInvoiceStatus.ENTERED.getCode());
    }

    private void createInvoice(BusiBillingModifyConfirmReqBO reqBO, List<GetOriginalDocumentsInfoVO> documentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, InvoiceInfoTemp invoiceInfoTemp, BillMergeInfo billMergeInfo) {
        log.info("\u521b\u5efa\u7ed3\u7b97\u5355\u53d1\u7968-\u91c7\u8d2d\u53d1\u7968\u521b\u5efa-reqBO-{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u7ed3\u7b97\u5355\u53d1\u7968-\u91c7\u8d2d\u53d1\u7968\u521b\u5efa-documentsInfoVOS-{}", (Object)JSON.toJSONString(documentsInfoVOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u7ed3\u7b97\u5355\u53d1\u7968-\u91c7\u8d2d\u53d1\u7968\u521b\u5efa-billSummaryInfos-{}", (Object)JSON.toJSONString(billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u7ed3\u7b97\u5355\u53d1\u7968-\u91c7\u8d2d\u53d1\u7968\u521b\u5efa-invoiceInfoTemp-{}", (Object)JSON.toJSONString((Object)invoiceInfoTemp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u7ed3\u7b97\u5355\u53d1\u7968-\u91c7\u8d2d\u53d1\u7968\u521b\u5efa-billMergeInfo-{}", (Object)JSON.toJSONString((Object)billMergeInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiInvoiceCreatePushErpReqBO erpReqBO = new BusiInvoiceCreatePushErpReqBO();
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        erpReqBO.setCtrantypeid(invoiceInfoReqBO.getErpBillType());
        NInvoiceType invoiceType = NInvoiceType.getInstance(invoiceInfoReqBO.getInvoceType());
        if (null != invoiceType) {
            erpReqBO.setFinvoiceclass(invoiceType.getErpType());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        erpReqBO.setVbillcode(invoiceInfoReqBO.getInvoceCode());
        erpReqBO.setDbilldate(format.format(invoiceInfoReqBO.getCreditDate()));
        erpReqBO.setDarrivedate(format.format(invoiceInfoReqBO.getDArriveDate()));
        erpReqBO.setPkSupplier(StringUtils.hasText((String)documentsInfoVOS.get(0).getSupplierId()) ? documentsInfoVOS.get(0).getSupplierId() : documentsInfoVOS.get(0).getCoalSupplierId());
        erpReqBO.setVdef5(invoiceInfoReqBO.getInvoceNum());
        erpReqBO.setVdef6(invoiceInfoReqBO.getReasonLossNum());
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setPkBizpsn(documentsInfoVOS.get(0).getPreparedMan());
        erpReqBO.setPkDeptv(invoiceInfoReqBO.getPurchaseCode());
        erpReqBO.setVdef4(invoiceInfoReqBO.getInputTaxType());
        erpReqBO.setVdef18(documentsInfoVOS.get(0).getSettlementSupplierCode());
        erpReqBO.setVdef19(Integer.valueOf(invoiceInfoReqBO.getAnnexNum()));
        erpReqBO.setVdef68(documentsInfoVOS.get(0).getCoalSupplierId());
        erpReqBO.setVdef3(StringUtils.hasText((String)invoiceInfoReqBO.getTransactionType()) ? invoiceInfoReqBO.getTransactionType() : FSC_ERP_TRANSACTION_TYPE_MANAGE);
        erpReqBO.setVdef7(invoiceInfoReqBO.getEngineerType());
        erpReqBO.setVdef8(invoiceInfoReqBO.getCommissionType());
        erpReqBO.setVdef28(invoiceInfoReqBO.getOverhaulType());
        if (!CollectionUtils.isEmpty(documentsInfoVOS)) {
            Double sum = documentsInfoVOS.stream().filter(item -> StringUtils.hasText((String)item.getSetTotalNum())).mapToDouble(item -> Double.valueOf(item.getSetTotalNum())).sum();
            erpReqBO.setNtotalastnum(sum.toString());
        }
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setVdef70(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setCorigcurrencyid(billSummaryInfos.get(0).getCurrency());
        erpReqBO.setNtotalorigmny(this.getBigDecimalFormat(invoiceInfoReqBO.getTotalAmtTax(), 2));
        erpReqBO.setNexchangerate(Double.valueOf(1.0));
        erpReqBO.setVdef2(billSummaryInfos.get(0).getSettlementContract());
        erpReqBO.setVmemo(invoiceInfoReqBO.getRemark());
        erpReqBO.setVdef50("N");
        List settlehlist = documentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getSummeryHeadId).collect(Collectors.toList());
        erpReqBO.setSettlehlist(settlehlist);
        ArrayList<InvoicePushErpItemInfo> invoicePushErpItemInfos = new ArrayList<InvoicePushErpItemInfo>();
        int crown = 10;
        for (BillSummaryInfo billSummaryInfo : billSummaryInfos) {
            InvoicePushErpItemInfo invoicePushErpItemInfo = new InvoicePushErpItemInfo();
            invoicePushErpItemInfo.setCrowno(String.valueOf(crown));
            invoicePushErpItemInfo.setPkMaterial(billSummaryInfo.getMaterialCode());
            invoicePushErpItemInfo.setCastunitid(billSummaryInfo.getUnit());
            invoicePushErpItemInfo.setNorigmny(this.getBigDecimalFormat(billSummaryInfo.getNoTaxAmt(), 2));
            invoicePushErpItemInfo.setNorigtaxmny(this.getBigDecimalFormat(billSummaryInfo.getPriceTaxTotal(), 2));
            invoicePushErpItemInfo.setCgeneralbid(billSummaryInfo.getExtBodyId());
            invoicePushErpItemInfo.setNnum(billSummaryInfo.getSettlementQuantity());
            invoicePushErpItemInfo.setFtaxtypeflag(PURCHASE_USER);
            invoicePushErpItemInfo.setPkApfinanceorgV(documentsInfoVOS.get(0).getSetFinance());
            invoicePushErpItemInfos.add(invoicePushErpItemInfo);
            crown += 10;
        }
        erpReqBO.setInvoicelist(invoicePushErpItemInfos);
        erpReqBO.setBillmaker(this.umcPurSupInfoListQryExternalService.getBillMakerUMC(reqBO.getUserId()));
        log.info("\u521b\u5efa\u7ed3\u7b97\u5355\u53d1\u7968-\u91c7\u8d2d\u53d1\u7968\u521b\u5efa-invoiceCreatePushErp-{}", (Object)JSON.toJSONString((Object)erpReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiInvoiceCreatePushErpRspBO erpRspBO = null;
        try {
            erpRspBO = this.busiInvoiceCreatePushErpSercive.invoiceCreatePushErp(erpReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("18000", "\u4ef7\u683c\u7ed3\u7b97\u53d1\u7968\u521b\u5efa\u5931\u8d25");
        }
        if (!"0".equals(erpRspBO.getCode())) {
            log.error("\u53d1\u7968\u63a8\u9001erp\u5931\u8d25\uff1a{}", (Object)erpRspBO.getMsg());
            StringBuilder sb = new StringBuilder("\u4ef7\u683c\u7ed3\u7b97\u53d1\u7968\u521b\u5efa\u5931\u8d25");
            if (null != erpRspBO.getMsg()) {
                sb.append("-ERP\u8fd4\u56de\u4fe1\u606f\uff1a").append(erpRspBO.getMsg());
            }
            throw new PfscExtBusinessException("18000", sb.toString());
        }
        InvoicePushErpRspBO data = erpRspBO.getData();
        if (null != data) {
            invoiceInfoTemp.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setInvoceCode(data.getVbillcode());
            String jsonString = JSON.toJSONString((Object)data.getPkInvoiceBList(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            billMergeInfo.setIncoiveCrownoList(jsonString);
        }
    }

    private String getBigDecimalFormat(String amtStr, int scale) {
        BigDecimal amt = BigDecimal.ZERO;
        if (!StringUtils.hasText((String)amtStr)) {
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u7cbe\u5ea6\u8f6c\u6362\u9519\u8bef");
        }
        try {
            amt = amt.add(new BigDecimal(amtStr));
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u7cbe\u5ea6\u8f6c\u6362\u9519\u8bef");
        }
        return amt.setScale(scale, 4).toString();
    }

    private void createStoreInvoice(BusiBillingModifyConfirmReqBO reqBO, List<GetOriginalDocumentsInfoVO> documentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, InvoiceInfoTemp invoiceInfoTemp, BillMergeInfo billMergeInfo) {
        log.info("\u521b\u5efa\u5165\u5e93\u5355-\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u521b\u5efa-reqBO-{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u5165\u5e93\u5355-\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u521b\u5efa-documentsInfoVOS-{}", (Object)JSON.toJSONString(documentsInfoVOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u5165\u5e93\u5355-\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u521b\u5efa-billSummaryInfos-{}", (Object)JSON.toJSONString(billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u5165\u5e93\u5355-\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u521b\u5efa-invoiceInfoTemp-{}", (Object)JSON.toJSONString((Object)invoiceInfoTemp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u5165\u5e93\u5355-\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u521b\u5efa-billMergeInfo-{}", (Object)JSON.toJSONString((Object)billMergeInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiStoreInvoiceCreatePushErpReqBO erpReqBO = new BusiStoreInvoiceCreatePushErpReqBO();
        List billSummaryInfoVOList = reqBO.getBillSummaryInfos();
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        erpReqBO.setVbillcode(invoiceInfoReqBO.getInvoceCode());
        erpReqBO.setPkSupplier(documentsInfoVOS.get(0).getSupplierId());
        erpReqBO.setDbilldate(format.format(invoiceInfoReqBO.getCreditDate()));
        erpReqBO.setVdef2(invoiceInfoReqBO.getSourceContractNum());
        erpReqBO.setVdef4(invoiceInfoReqBO.getInputTaxType());
        erpReqBO.setPkBizpsn(reqBO.getUsername());
        erpReqBO.setVdef19(invoiceInfoReqBO.getAnnexNum());
        erpReqBO.setVdef6(invoiceInfoReqBO.getReasonLossNum());
        erpReqBO.setVdef22(invoiceInfoReqBO.getPayType());
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setDarrivedate(format.format(invoiceInfoReqBO.getDArriveDate()));
        erpReqBO.setPkDeptv(invoiceInfoReqBO.getPurchaseCode());
        if (CtrantType.CHEMICAL_STORE.getCode().equals(reqBO.getType())) {
            erpReqBO.setNtotalorigmny(invoiceInfoReqBO.getInvoicableTotalAmt());
            erpReqBO.setVdef5(invoiceInfoReqBO.getInvoceNum());
        } else if (CtrantType.NON_HOSTED.getCode().equals(reqBO.getType())) {
            erpReqBO.setNtotalorigmny(invoiceInfoReqBO.getTotalAmtTax());
            erpReqBO.setNtotalastnum(invoiceInfoReqBO.getInvoceNum());
        }
        erpReqBO.setVdef3(StringUtils.hasText((String)invoiceInfoReqBO.getTransactionType()) ? invoiceInfoReqBO.getTransactionType() : FSC_ERP_TRANSACTION_TYPE_MANAGE);
        erpReqBO.setVdef7(invoiceInfoReqBO.getEngineerType());
        erpReqBO.setVdef8(invoiceInfoReqBO.getCommissionType());
        erpReqBO.setVdef28(invoiceInfoReqBO.getOverhaulType());
        erpReqBO.setVdef70(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setVmemo(invoiceInfoReqBO.getRemark());
        ArrayList<String> settlehlist = new ArrayList<String>();
        for (GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO : documentsInfoVOS) {
            settlehlist.add(getOriginalDocumentsInfoVO.getSummeryHeadId());
        }
        erpReqBO.setPkInstorHeadList(settlehlist);
        ArrayList<BusiStoreInvoiceCreateBodyPushErpReqBO> invoicePushErpItemInfos = new ArrayList<BusiStoreInvoiceCreateBodyPushErpReqBO>();
        Map<String, BillSummaryInfo> billSummaryInfoMap = billSummaryInfos.stream().collect(Collectors.toMap(BillSummaryInfo::getId, item -> item, (oldItem, newItem) -> newItem));
        int crown = 10;
        for (BillSummaryInfoVO infoVO : billSummaryInfoVOList) {
            BillSummaryInfo billSummaryInfo = billSummaryInfoMap.get(infoVO.getId());
            BusiStoreInvoiceCreateBodyPushErpReqBO invoicePushErpItemInfo = new BusiStoreInvoiceCreateBodyPushErpReqBO();
            invoicePushErpItemInfo.setPkInStoBody(billSummaryInfo.getExtBodyId());
            invoicePushErpItemInfo.setCrowno(String.valueOf(crown));
            invoicePushErpItemInfo.setPkMaterial(billSummaryInfo.getMaterialCode());
            if (CtrantType.CHEMICAL_STORE.getCode().equals(reqBO.getType())) {
                invoicePushErpItemInfo.setNnum(infoVO.getInvoicableQuantity());
                invoicePushErpItemInfo.setNorigtaxprice(billSummaryInfo.getTaxPrice());
                invoicePushErpItemInfo.setNastorigprice(billSummaryInfo.getNoTaxPrice());
                invoicePushErpItemInfo.setNorigmny(billSummaryInfo.getNoTaxAmt());
                invoicePushErpItemInfo.setNorigtaxmny(billSummaryInfo.getPriceTaxTotal());
                invoicePushErpItemInfo.setNorigtaxmny(billSummaryInfo.getPriceTaxTotal());
            } else if (CtrantType.NON_HOSTED.getCode().equals(reqBO.getType())) {
                invoicePushErpItemInfo.setNorigprice(infoVO.getNoTaxPriceInvoice());
                invoicePushErpItemInfo.setNorigtaxprice(infoVO.getTaxPriceInvoice());
                invoicePushErpItemInfo.setNorigmny(infoVO.getNoTaxAmtInvoice());
                invoicePushErpItemInfo.setNorigtaxmny(infoVO.getInvoicableAmtInvoice());
                invoicePushErpItemInfo.setNtax(infoVO.getTaxInvoice());
                invoicePushErpItemInfo.setNnum(infoVO.getInvoicableQuantityInvoice());
            }
            invoicePushErpItemInfos.add(invoicePushErpItemInfo);
            crown += 10;
        }
        erpReqBO.setBillmaker(this.umcPurSupInfoListQryExternalService.getBillMakerUMC(reqBO.getUserId()));
        erpReqBO.setPkInstorBodyList(invoicePushErpItemInfos);
        log.info("\u521b\u5efa\u5165\u5e93\u5355-\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u521b\u5efa-storeSummaryInvoiceCreate-{}", (Object)JSON.toJSONString((Object)erpReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiInvoiceCreatePushErpRspBO erpRspBO = null;
        try {
            erpRspBO = this.busiInvoiceCreatePushErpSercive.storeSummaryInvoiceCreate(erpReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25");
        }
        if (!"0".equals(erpRspBO.getCode())) {
            log.error("\u53d1\u7968\u63a8\u9001erp\u5931\u8d25\uff1a{}", (Object)erpRspBO.getMsg());
            StringBuilder sb = new StringBuilder("\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u521b\u5efa\u5931\u8d25");
            if (null != erpRspBO.getMsg()) {
                sb.append("-ERP\u8fd4\u56de\u4fe1\u606f\uff1a").append(erpRspBO.getMsg());
            }
            throw new PfscExtBusinessException("18000", sb.toString());
        }
        InvoicePushErpRspBO data = erpRspBO.getData();
        if (null != data) {
            invoiceInfoTemp.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setInvoceCode(data.getVbillcode());
            String jsonString = JSON.toJSONString((Object)data.getPkInvoiceBList(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            billMergeInfo.setIncoiveCrownoList(jsonString);
        }
    }

    private void createSummeryInvoice(BusiBillingModifyConfirmReqBO reqBO, List<GetOriginalDocumentsInfoVO> documentsInfoVOS, List<BillSummaryInfo> billSummaryInfos, InvoiceInfoTemp invoiceInfoTemp, BillMergeInfo billMergeInfo) {
        log.info("\u521b\u5efa\u6d88\u8017\u6c47\u603b\u53d1\u7968-\u5907\u54c1\u5907\u4ef6\u53d1\u7968\u521b\u5efa-reqBO-{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u6d88\u8017\u6c47\u603b\u53d1\u7968-\u5907\u54c1\u5907\u4ef6\u53d1\u7968\u521b\u5efa-documentsInfoVOS-{}", (Object)JSON.toJSONString(documentsInfoVOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u6d88\u8017\u6c47\u603b\u53d1\u7968-\u5907\u54c1\u5907\u4ef6\u53d1\u7968\u521b\u5efa-billSummaryInfos-{}", (Object)JSON.toJSONString(billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u6d88\u8017\u6c47\u603b\u53d1\u7968-\u5907\u54c1\u5907\u4ef6\u53d1\u7968\u521b\u5efa-invoiceInfoTemp-{}", (Object)JSON.toJSONString((Object)invoiceInfoTemp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u521b\u5efa\u6d88\u8017\u6c47\u603b\u53d1\u7968-\u5907\u54c1\u5907\u4ef6\u53d1\u7968\u521b\u5efa-billMergeInfo-{}", (Object)JSON.toJSONString((Object)billMergeInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        List billSummaryInfosVoList = reqBO.getBillSummaryInfos();
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        BusiSummaryInvoiceCreatePushErpReqBO erpReqBO = new BusiSummaryInvoiceCreatePushErpReqBO();
        NInvoiceType invoiceType = NInvoiceType.getInstance(invoiceInfoReqBO.getInvoceType());
        if (null != invoiceType) {
            erpReqBO.setFinvoiceclass(invoiceType.getErpType());
        }
        erpReqBO.setPkOrg(String.valueOf(reqBO.getOrgId()));
        erpReqBO.setVbillcode(invoiceInfoReqBO.getInvoceCode());
        erpReqBO.setPkSupplier(documentsInfoVOS.get(0).getSupplierId());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        erpReqBO.setDbilldate(format.format(invoiceInfoReqBO.getCreditDate()));
        erpReqBO.setDarrivedate(format.format(invoiceInfoReqBO.getDArriveDate()));
        erpReqBO.setVdef18(documentsInfoVOS.get(0).getSupplierId());
        erpReqBO.setPkDeptV(invoiceInfoReqBO.getPurchaseCode());
        erpReqBO.setVdef22(invoiceInfoReqBO.getPayType());
        erpReqBO.setVdef4(invoiceInfoReqBO.getInputTaxType());
        erpReqBO.setPkBankaccbas(invoiceInfoReqBO.getBankAccNo());
        erpReqBO.setPkBalatype(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setVdef2(invoiceInfoReqBO.getSourceContractNum());
        erpReqBO.setVmemo(invoiceInfoReqBO.getRemark());
        erpReqBO.setVdef16(invoiceInfoReqBO.getSettlementType());
        erpReqBO.setVdef3(StringUtils.hasText((String)invoiceInfoReqBO.getTransactionType()) ? invoiceInfoReqBO.getTransactionType() : FSC_ERP_TRANSACTION_TYPE_MANAGE);
        erpReqBO.setVdef7(invoiceInfoReqBO.getEngineerType());
        erpReqBO.setVdef8(invoiceInfoReqBO.getCommissionType());
        erpReqBO.setVdef28(invoiceInfoReqBO.getOverhaulType());
        erpReqBO.setNnumsum(invoiceInfoReqBO.getInvoceNum());
        erpReqBO.setNtotalastnum(invoiceInfoReqBO.getInvoceNum());
        erpReqBO.setNtotalorigmny(invoiceInfoReqBO.getTotalAmtTax());
        erpReqBO.setVdef70(format.format(invoiceInfoReqBO.getInvoiceIssuanceDate()));
        erpReqBO.setCorigcurrencyid(billSummaryInfos.get(0).getCurrency());
        erpReqBO.setNexchangerate(documentsInfoVOS.get(0).getConversionRate());
        erpReqBO.setVdef19(invoiceInfoReqBO.getAnnexNum());
        erpReqBO.setPkBizpsn(documentsInfoVOS.get(0).getPreparedMan());
        erpReqBO.setVdef50("N");
        ArrayList<String> headKeyList = new ArrayList<String>();
        for (GetOriginalDocumentsInfoVO getOriginalDocumentsInfoVO : documentsInfoVOS) {
            headKeyList.add(getOriginalDocumentsInfoVO.getSummeryHeadId());
        }
        erpReqBO.setCvmihidlist(headKeyList);
        Map<String, BillSummaryInfo> billSummaryInfoMap = billSummaryInfos.stream().collect(Collectors.toMap(BillSummaryInfo::getId, item -> item, (oldItem, newItem) -> newItem));
        ArrayList<BusiSummaryInvoiceBodyPushErpReqBO> invoicePushErpItemInfos = new ArrayList<BusiSummaryInvoiceBodyPushErpReqBO>();
        int crown = 10;
        for (BillSummaryInfoVO infoVO : billSummaryInfosVoList) {
            BillSummaryInfo billSummaryInfo = billSummaryInfoMap.get(infoVO.getId());
            BusiSummaryInvoiceBodyPushErpReqBO invoicePushErpItemInfo = new BusiSummaryInvoiceBodyPushErpReqBO();
            invoicePushErpItemInfo.setCrowno(String.valueOf(crown));
            invoicePushErpItemInfo.setPkMaterial(billSummaryInfo.getMaterialCode());
            invoicePushErpItemInfo.setCastunitid(billSummaryInfo.getUnit());
            invoicePushErpItemInfo.setCvmihid(billSummaryInfo.getExtBodyId());
            invoicePushErpItemInfo.setNorigmny(infoVO.getInvoicableQuantityInvoice());
            invoicePushErpItemInfo.setNorigprice(infoVO.getNoTaxPriceInvoice());
            invoicePushErpItemInfo.setNorigtaxprice(infoVO.getTaxPriceInvoice());
            invoicePushErpItemInfo.setNorigmny(infoVO.getNoTaxAmtInvoice());
            invoicePushErpItemInfo.setNorigtaxmny(infoVO.getInvoicableAmtInvoice());
            invoicePushErpItemInfo.setNtax(infoVO.getTaxInvoice());
            invoicePushErpItemInfo.setNnum(infoVO.getInvoicableQuantityInvoice());
            invoicePushErpItemInfos.add(invoicePushErpItemInfo);
            crown += 10;
        }
        erpReqBO.setInvoiceList(invoicePushErpItemInfos);
        erpReqBO.setBillmaker(this.umcPurSupInfoListQryExternalService.getBillMakerUMC(reqBO.getUserId()));
        log.info("\u521b\u5efa\u6d88\u8017\u6c47\u603b\u53d1\u7968-\u5907\u54c1\u5907\u4ef6\u53d1\u7968\u521b\u5efa-consumptionSummaryInvoiceCreate-{}", (Object)JSON.toJSONString((Object)erpReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiInvoiceCreatePushErpRspBO erpRspBO = null;
        try {
            erpRspBO = this.busiInvoiceCreatePushErpSercive.consumptionSummaryInvoiceCreate(erpReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u5907\u54c1\u5907\u4ef6\uff08\u6d88\u8017\u6c47\u603b\uff09\u53d1\u7968\u5931\u8d25");
        }
        if (!"0".equals(erpRspBO.getCode())) {
            log.error("\u53d1\u7968\u63a8\u9001erp\u5931\u8d25\uff1a{}", (Object)erpRspBO.getMsg());
            StringBuilder sb = new StringBuilder("\u5907\u54c1\u5907\u4ef6\u53d1\u7968\u521b\u5efa\u5931\u8d25");
            if (null != erpRspBO.getMsg()) {
                sb.append("-ERP\u8fd4\u56de\u4fe1\u606f\uff1a").append(erpRspBO.getMsg());
            }
            throw new PfscExtBusinessException("18000", sb.toString());
        }
        InvoicePushErpRspBO data = erpRspBO.getData();
        if (null != data) {
            invoiceInfoTemp.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setExtInvoicePreKey(data.getPkInvoice());
            billMergeInfo.setInvoceCode(data.getVbillcode());
            String jsonString = JSON.toJSONString((Object)data.getPkInvoiceBList(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            billMergeInfo.setIncoiveCrownoList(jsonString);
        }
    }

    private void modify(BusiBillingModifyConfirmReqBO reqBO) {
        String mergeNO = reqBO.getMergeDocumentNo();
        InvoiceInfoTemp invoiceInfoTemp = new InvoiceInfoTemp();
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        BeanUtils.copyProperties((Object)invoiceInfoReqBO, (Object)invoiceInfoTemp);
        invoiceInfoTemp.setInoviceInfoId(mergeNO);
        invoiceInfoTemp.setEffectiveState(PURCHASE_USER);
        String billType = CtrantType.getInstance(reqBO.getType()).getCtrantType();
        invoiceInfoTemp.setBillType(billType);
        this.invoiceInfoTempMapper.updateByMergrNo(invoiceInfoTemp);
        BillMergeInfo billMergeInfo = this.billMergeInfoMapper.selectByMergeNO(mergeNO);
        billMergeInfo.setInvoiceStatus(NInvoiceStatus.ENTERED.getCode());
        List documentNos = reqBO.getDocumentNos();
        List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(documentNos);
        BillSummaryInfoConditionVO billSummaryInfoConditionVO = new BillSummaryInfoConditionVO();
        billSummaryInfoConditionVO.setStatementNoListIn(documentNos);
        billSummaryInfoConditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
        List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.getList(billSummaryInfoConditionVO);
        List<String> documentNoList = getOriginalDocumentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getDocumentNo).distinct().collect(Collectors.toList());
        this.insertOrUpdateSummaryData(reqBO, documentNoList, billSummaryInfos, billMergeInfo);
        BillMergeInfo updateCondition = new BillMergeInfo();
        updateCondition.setTotalAmt(invoiceInfoTemp.getTotalAmtTax());
        updateCondition.setTotalIncoicedNum(invoiceInfoTemp.getInvoceNum());
        updateCondition.setMergeSetNo(mergeNO);
        this.billMergeInfoMapper.updateByMergrNo(updateCondition);
    }

    private String getMergeNO(String operationType, String mergeDocumentNo) {
        if (!OperationType.BILLING.getCode().equals(operationType)) {
            return mergeDocumentNo;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.billMergeInfoMapper.selectMaxPayAbleNoNum(PREFIX + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(PREFIX).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5408\u5e76\u5355\u53f7\u751f\u6210\u5931\u8d25");
        }
    }

    private void billingVerification(BusiBillingModifyConfirmReqBO reqBO) {
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u6267\u884c\u7684\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CtrantType.getInstance(reqBO.getType()) == null) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u6267\u884c\u7684\u8ba2\u5355\u7c7b\u578b\u672a\u77e5");
        }
        if (!StringUtils.hasText((String)reqBO.getOperationType())) {
            throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OperationType.getInstance(reqBO.getOperationType()) == null || OperationType.SHOW.getCode().equals(reqBO.getOperationType())) {
            throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u7c7b\u578b\u672a\u77e5");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDocumentNos())) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u6267\u884c\u7684\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OperationType.BILLING.getCode().equals(reqBO.getOperationType()) && !StringUtils.hasText((String)reqBO.getMergeDocumentNo())) {
            throw new PfscExtBusinessException("18000", "\u3010\u4fee\u6539\u3011\u6216\u3010\u786e\u8ba4\u3011\u65f6\u5408\u5e76\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfoReqBO()) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PURCHASE_USER.equals(reqBO.getIsProfessionalOrgExt())) {
            if (OperationType.MODIFY.getCode().equals(reqBO.getOperationType())) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5546\u53ea\u80fd\u3010\u5f00\u7968\u3011\u548c\u3010\u786e\u8ba4\u3011");
            }
        } else if (OperationType.CONFIRM.equals(reqBO.getOperationType())) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546\u53ea\u80fd\u3010\u5f00\u7968\u3011\u548c \u3010\u4fee\u6539\u3011");
        }
        if ((CtrantType.CHEMICAL_STORE.getCode().equals(reqBO.getType()) || CtrantType.NON_HOSTED.getCode().equals(reqBO.getType()) || CtrantType.HOSTED.getCode().equals(reqBO.getType())) && CollectionUtils.isEmpty((Collection)reqBO.getBillSummaryInfos())) {
            throw new PfscExtBusinessException("18000", "\u6c47\u603b\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        if (null == invoiceInfoReqBO) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getName()) {
            throw new PfscExtBusinessException("18000", "\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTaxpayerId()) {
            throw new PfscExtBusinessException("18000", "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getAddress()) {
            throw new PfscExtBusinessException("18000", "\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceInfoReqBO.getAddress().trim().length() > 25) {
            throw new PfscExtBusinessException("18000", "\u5730\u5740\u957f\u5ea6\u8d85\u8fc725");
        }
        if (null == invoiceInfoReqBO.getMobile()) {
            throw new PfscExtBusinessException("18000", "\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getBankName()) {
            throw new PfscExtBusinessException("18000", "\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceInfoReqBO.getBankName().trim().length() > 19) {
            throw new PfscExtBusinessException("18000", "\u5f00\u6237\u94f6\u884c\u957f\u5ea6\u8d85\u8fc719");
        }
        if (null == invoiceInfoReqBO.getBankAccNo()) {
            throw new PfscExtBusinessException("18000", "\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getActualInvoicedQuantity()) {
            throw new PfscExtBusinessException("18000", "\u5b9e\u9645\u5f00\u7968\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTotalAmtTax()) {
            throw new PfscExtBusinessException("18000", "\u6c47\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTotalAmt()) {
            throw new PfscExtBusinessException("18000", "\u6c47\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTaxRate()) {
            throw new PfscExtBusinessException("18000", "\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getInvoceType()) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == NInvoiceType.getInstance(invoiceInfoReqBO.getInvoceType())) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7c7b\u578b\u672a\u77e5");
        }
        if (null == invoiceInfoReqBO.getInvoceCode()) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PURCHASE_USER.equals(reqBO.getIsProfessionalOrgExt())) {
            if (null == invoiceInfoReqBO.getCreditDate()) {
                throw new PfscExtBusinessException("18000", "\u5165\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getDArriveDate()) {
                throw new PfscExtBusinessException("18000", "\u7968\u5230\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInvoiceIssuanceDate()) {
                throw new PfscExtBusinessException("18000", "\u53d1\u7968\u5f00\u5177\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInvoceNum()) {
                throw new PfscExtBusinessException("18000", "\u53d1\u7968\u8f93\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getReasonLossNum() && !CtrantType.NON_HOSTED.getCode().equals(reqBO.getType()) && !CtrantType.HOSTED.getCode().equals(reqBO.getType())) {
                throw new PfscExtBusinessException("18000", "\u5408\u7406\u635f\u8017\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInputTaxType()) {
                throw new PfscExtBusinessException("18000", "\u8fdb\u9879\u7a0e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getSettlementType()) {
                throw new PfscExtBusinessException("18000", "\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getPayType()) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getAnnexNum()) {
                throw new PfscExtBusinessException("18000", "\u9644\u4ef6\u5f20\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getPurchaseName()) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getSourceContractNum()) {
                throw new PfscExtBusinessException("18000", "\u6765\u6e90\u5408\u540c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CtrantType.CHEMICAL_STORE.getCode().equals(reqBO.getType())) {
                if (!StringUtils.hasText((String)invoiceInfoReqBO.getTotalAmtTax())) {
                    throw new PfscExtBusinessException("18000", "\u6c47\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)invoiceInfoReqBO.getTotalAmt())) {
                    throw new PfscExtBusinessException("18000", "\u6c47\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)invoiceInfoReqBO.getTaxRate())) {
                    throw new PfscExtBusinessException("18000", "\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }
}

