/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiCancelBillApplyInfoService;
import com.tydic.pfscext.api.busi.bo.BusiCancelBillApplyInfoReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SaleItemApplyInfoStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiCancelBillApplyInfoService.class)
public class BusiCancelBillApplyInfoServiceImpl
implements BusiCancelBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelBillApplyInfoServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public PfscExtRspBaseBO update(BusiCancelBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u7533\u8bf7\u5355\u53f7\u3010applyNoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        ArrayList<String> billStatusNotIn = new ArrayList<String>();
        billStatusNotIn.add(BillStatus.NO_APPLY.getCode());
        billApplyInfoVO.setBillStatusNotIn(billStatusNotIn);
        int count = this.billApplyInfoMapper.selectCount(billApplyInfoVO);
        if (count > 0) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f" + this.enumsService.getDescr(BillStatus.NO_APPLY));
        }
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        billApplyInfoVO.setBillStatus(BillStatus.NO_APPLY.getCode());
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setBillStatus(BillStatus.CANCEL_APPLY.getCode());
        try {
            this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5931\u8d25");
        }
        ArrayList<String> oldApplyNoList = new ArrayList<String>();
        ArrayList<String> newApplyNoList = new ArrayList<String>();
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
        if (billApplyInfoList != null) {
            for (BillApplyInfo billApplyBO : billApplyInfoList) {
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyBO.getApplyType())) {
                    newApplyNoList.add(billApplyBO.getApplyNo());
                    continue;
                }
                oldApplyNoList.add(billApplyBO.getApplyNo());
            }
        }
        try {
            if (!CollectionUtils.isEmpty(oldApplyNoList)) {
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setApplyNoList(oldApplyNoList);
                saleOrderInfoVO.setOrderStatus(OrderStatus.APPLIED.getCode());
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setApplyNo(null);
                saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.cancelBillApplyInfo(saleOrderInfoVO, saleOrderInfo);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNoList(oldApplyNoList);
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setApplyNo(null);
                saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
                this.saleItemInfoMapper.cancelBillApplyInfo(saleItemInfoVO, saleItemInfo);
            }
            if (!CollectionUtils.isEmpty(newApplyNoList)) {
                SaleItemApplyInfoVO updateInfoVO = new SaleItemApplyInfoVO();
                updateInfoVO.setStatus(SaleItemApplyInfoStatus.INVALID.getCode());
                updateInfoVO.setOldStatus(SaleItemApplyInfoStatus.VALID.getCode());
                updateInfoVO.setApplyNoList(newApplyNoList);
                this.saleItemApplyInfoMapper.updateByVO(updateInfoVO);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNoList(newApplyNoList);
                saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
                this.saleItemInfoMapper.updateByItemApplyInfo(saleItemInfoVO);
                SaleOrderInfoVO updateOrderBO = new SaleOrderInfoVO();
                updateOrderBO.setApplyNoList(newApplyNoList);
                updateOrderBO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.updateOrderStatusByCondition(updateOrderBO);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5931\u8d25");
        }
        return new PfscExtRspBaseBO();
    }
}

