/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.tydic.pfscext.api.busi.BusiCheckDetailAndSummeryService;
import com.tydic.pfscext.api.busi.bo.BillDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BillSummaryInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckDetailAndSummeryReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckDetailAndSummeryRspBO;
import com.tydic.pfscext.api.busi.bo.OriginalDocumentsInfoRspBO;
import com.tydic.pfscext.dao.BillSummaryInfoInvoiceMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillDetailInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfoInvoicePO;
import com.tydic.pfscext.dao.vo.BillSummaryInfoConditionVO;
import com.tydic.pfscext.dao.vo.BillSummaryInfoInvoiceConditionVO;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.enums.NInvoiceStatus;
import com.tydic.pfscext.enums.OperationType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiPurchaseStorageConsumptionSummaryService;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailItem;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailReqBO;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailRspBO;
import com.tydic.pfscext.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiCheckDetailAndSummeryService.class)
public class BusiCheckDetailAndSummeryServiceImpl
implements BusiCheckDetailAndSummeryService {
    private static final Logger log = LoggerFactory.getLogger(BusiCheckDetailAndSummeryServiceImpl.class);
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillSummaryInfoInvoiceMapper billSummaryInfoInvoiceMapper;
    @Autowired
    private BusiPurchaseStorageConsumptionSummaryService purchaseStorageConsumptionSummaryService;

    public BusiCheckDetailAndSummeryRspBO checkDetailAndSummery(BusiCheckDetailAndSummeryReqBO reqBO) {
        this.checkParamsNotBlank(reqBO);
        this.checkBillSummeryInvoiceData(reqBO);
        if (CtrantType.RAW_COAL.getCode().equals(reqBO.getType())) {
            return this.checkDetailAndSummeryType1Or2(reqBO);
        }
        if (CtrantType.CHEMICAL.getCode().equals(reqBO.getType())) {
            return this.checkDetailAndSummeryType1Or2(reqBO);
        }
        if (!CtrantType.CHEMICAL_STORE.getCode().equals(reqBO.getType())) {
            if (CtrantType.NON_HOSTED.getCode().equals(reqBO.getType())) {
                return this.checkDetailAndSummeryType4Or5(reqBO);
            }
            if (CtrantType.HOSTED.getCode().equals(reqBO.getType())) {
                return this.checkDetailAndSummeryType4Or5(reqBO);
            }
        }
        throw new PfscExtBusinessException("18000", "\u5355\u636e\u7c7b\u578b\u672a\u77e5");
    }

    private void checkBillSummeryInvoiceData(BusiCheckDetailAndSummeryReqBO reqBO) {
        if (StringUtils.hasText((String)reqBO.getMergeNo())) {
            BillSummaryInfoConditionVO conditionVO = new BillSummaryInfoConditionVO();
            conditionVO.setStatementNoListIn(reqBO.getDocumentNo());
            conditionVO.setEffectiveState(EffectiveState.NOT_EFFECT.getCode());
            List<BillSummaryInfo> list = this.billSummaryInfoMapper.getList(conditionVO);
            if (!CollectionUtils.isEmpty(list)) {
                List<String> collect = list.stream().map(BillSummaryInfo::getId).distinct().collect(Collectors.toList());
                BillSummaryInfoInvoiceConditionVO infoInvoiceConditionVO = new BillSummaryInfoInvoiceConditionVO();
                infoInvoiceConditionVO.setRidListIn(collect);
                infoInvoiceConditionVO.setMergeSetNo(reqBO.getMergeNo());
                infoInvoiceConditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                List<BillSummaryInfoInvoicePO> billSummaryInfoInvoicePOS = this.billSummaryInfoInvoiceMapper.selectListCondition(infoInvoiceConditionVO);
                if (!CollectionUtils.isEmpty(billSummaryInfoInvoicePOS)) {
                    for (BillSummaryInfoInvoicePO item : billSummaryInfoInvoicePOS) {
                        BillSummaryInfoInvoicePO record = new BillSummaryInfoInvoicePO();
                        record.setId(item.getId());
                        record.setEffectiveState(EffectiveState.NOT_EFFECT.getCode());
                        this.billSummaryInfoInvoiceMapper.updateByPrimaryKeySelective(record);
                    }
                }
            }
        }
    }

    public BusiCheckDetailAndSummeryRspBO checkDetailAndSummeryType1Or2(BusiCheckDetailAndSummeryReqBO reqBO) {
        CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
        List documentNos = reqBO.getDocumentNo();
        List<GetOriginalDocumentsInfoVO> documents = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(new ArrayList<String>(documentNos));
        if (documentNos.size() > 1) {
            this.checkMergeBilling(ctrantType.getCode(), documents);
        }
        BillSummaryInfoConditionVO billSummaryInfoConditionVO = new BillSummaryInfoConditionVO();
        billSummaryInfoConditionVO.setStatementNoListIn(documentNos);
        billSummaryInfoConditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
        List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.getList(billSummaryInfoConditionVO);
        BusiCheckDetailAndSummeryRspBO rspBO = new BusiCheckDetailAndSummeryRspBO();
        this.initDataResult(ctrantType, billSummaryInfos, documents, rspBO);
        return rspBO;
    }

    public BusiCheckDetailAndSummeryRspBO checkDetailAndSummeryType4Or5(BusiCheckDetailAndSummeryReqBO reqBO) {
        BillSummaryInfoConditionVO billSummaryInfoConditionVO;
        CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
        OperationType operationType = OperationType.getInstance(reqBO.getOperationType());
        List documentNos = reqBO.getDocumentNo();
        ArrayList<BillSummaryInfo> summaryInfos = new ArrayList<BillSummaryInfo>();
        List<GetOriginalDocumentsInfoVO> documents = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(new ArrayList<String>(documentNos));
        if (documentNos.size() > 1) {
            this.checkMergeBilling(ctrantType.getCode(), documents);
        }
        BillSummaryInfoInvoiceConditionVO conditionVO = new BillSummaryInfoInvoiceConditionVO();
        conditionVO.setStatementNoInList(new ArrayList<String>(documentNos));
        conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
        List<BillSummaryInfoInvoicePO> billSummaryInfoInvoicePOS = this.billSummaryInfoInvoiceMapper.selectListCondition(conditionVO);
        Map<String, List<BillSummaryInfoInvoicePO>> collectInvoiceMap = billSummaryInfoInvoicePOS.stream().collect(Collectors.groupingBy(BillSummaryInfoInvoicePO::getRid));
        String mergeNo = reqBO.getMergeNo();
        if (OperationType.SHOW.getCode().equals(operationType.getCode())) {
            if (NInvoiceStatus.NOT_MAKE.getCode().equals(reqBO.getInvoiceStatus())) {
                billSummaryInfoConditionVO = new BillSummaryInfoConditionVO();
                billSummaryInfoConditionVO.setStatementNoListIn(documentNos);
                billSummaryInfoConditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.getList(billSummaryInfoConditionVO);
                if (!CollectionUtils.isEmpty(billSummaryInfos)) {
                    for (BillSummaryInfo summaryInfo : billSummaryInfos) {
                        BigDecimal inventoryQuantity = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getInventoryQuantity());
                        List<BillSummaryInfoInvoicePO> infoInvoicePOList = collectInvoiceMap.get(summaryInfo.getId());
                        BigDecimal invoicableQuantityInvoiceAll = BigDecimal.ZERO;
                        if (!CollectionUtils.isEmpty(infoInvoicePOList)) {
                            double sum = infoInvoicePOList.stream().filter(item -> StringUtils.hasText((String)item.getInvoicableQuantityInvoice())).mapToDouble(item -> Double.valueOf(item.getInvoicableQuantityInvoice())).sum();
                            invoicableQuantityInvoiceAll = invoicableQuantityInvoiceAll.add(new BigDecimal(sum));
                        }
                        BigDecimal invoicableQuantity = inventoryQuantity.subtract(invoicableQuantityInvoiceAll).setScale(2, 4);
                        summaryInfo.setInvoicableQuantity(invoicableQuantity.toString());
                        BigDecimal taxPrice = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getTaxPrice());
                        BigDecimal invoicableAmt = taxPrice.multiply(invoicableQuantity).setScale(2, 4);
                        summaryInfo.setInvoicableAmt(invoicableAmt.toString());
                        summaryInfos.add(summaryInfo);
                    }
                }
            } else if (!CollectionUtils.isEmpty(billSummaryInfoInvoicePOS)) {
                List collect = billSummaryInfoInvoicePOS.stream().filter(item -> mergeNo.equals(item.getMergeSetNo())).collect(Collectors.toList());
                String toJSONString = JSON.toJSONString(new ArrayList(collect));
                List summaryInfoInvoices = JSON.parseArray((String)toJSONString, BillSummaryInfo.class);
                summaryInfos.addAll(summaryInfoInvoices);
            }
        } else {
            billSummaryInfoConditionVO = new BillSummaryInfoConditionVO();
            billSummaryInfoConditionVO.setStatementNoListIn(documentNos);
            billSummaryInfoConditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.getList(billSummaryInfoConditionVO);
            if (!CollectionUtils.isEmpty(billSummaryInfoInvoicePOS)) {
                for (BillSummaryInfo billSummaryInfo : billSummaryInfos) {
                    List<BillSummaryInfoInvoicePO> pos = collectInvoiceMap.get(billSummaryInfo.getId());
                    if (CollectionUtils.isEmpty(pos)) {
                        billSummaryInfo.setInvoicableQuantity(billSummaryInfo.getInventoryQuantity());
                    } else if (OperationType.BILLING.getCode().equals(operationType.getCode())) {
                        this.subtractionQuantity(billSummaryInfo, pos, BigDecimal.ZERO);
                    } else {
                        List collect = pos.stream().filter(item -> mergeNo.equals(item.getMergeSetNo())).collect(Collectors.toList());
                        log.debug("\u6839\u636e\u5408\u5e76\u5355\u53f7[{}]\u67e5\u7684\u7684\u5f00\u7968\u8bb0\u5f55\uff1a{}.\u539f\u59cb\u8bb0\u5f55\uff1a{}", new Object[]{mergeNo, JSON.toJSONString(collect), JSON.toJSONString(pos)});
                        if (!CollectionUtils.isEmpty(collect)) {
                            String invoicableQuantityInvoice = ((BillSummaryInfoInvoicePO)collect.get(0)).getInvoicableQuantityInvoice();
                            this.subtractionQuantity(billSummaryInfo, pos, BigDecimalUtils.getStr2BigDecimal(invoicableQuantityInvoice));
                            billSummaryInfo.setTaxInvoice(((BillSummaryInfoInvoicePO)collect.get(0)).getTaxInvoice());
                            billSummaryInfo.setTaxPriceInvoice(((BillSummaryInfoInvoicePO)collect.get(0)).getTaxPriceInvoice());
                            billSummaryInfo.setNoTaxPriceInvoice(((BillSummaryInfoInvoicePO)collect.get(0)).getNoTaxPriceInvoice());
                            billSummaryInfo.setInvoicableQuantityInvoice(((BillSummaryInfoInvoicePO)collect.get(0)).getInvoicableQuantityInvoice());
                            billSummaryInfo.setInvoicableAmtInvoice(((BillSummaryInfoInvoicePO)collect.get(0)).getInvoicableAmtInvoice());
                            billSummaryInfo.setNoTaxAmtInvoice(((BillSummaryInfoInvoicePO)collect.get(0)).getNoTaxAmtInvoice());
                        }
                    }
                    this.initDataSummaryInfoAmount(billSummaryInfo);
                    summaryInfos.add(billSummaryInfo);
                }
            } else {
                for (BillSummaryInfo billSummaryInfo : billSummaryInfos) {
                    billSummaryInfo.setInvoicableQuantity(billSummaryInfo.getInventoryQuantity());
                    this.initDataSummaryInfoAmount(billSummaryInfo);
                }
                summaryInfos.addAll(billSummaryInfos);
            }
        }
        BusiCheckDetailAndSummeryRspBO rspBO = new BusiCheckDetailAndSummeryRspBO();
        this.initDataResult(ctrantType, summaryInfos, documents, rspBO);
        return rspBO;
    }

    private void initDataSummaryInfoAmount(BillSummaryInfo billSummaryInfo) {
        BigDecimal invoicableQuantity = BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getInvoicableQuantity());
        BigDecimal invoicableAmt = BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getTaxPrice()).multiply(invoicableQuantity).setScale(2, 4);
        billSummaryInfo.setInvoicableAmt(invoicableAmt.toString());
        BigDecimal noTaxAmt = BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getNoTaxPrice()).multiply(invoicableQuantity).setScale(2, 4);
        billSummaryInfo.setNoTaxAmt(noTaxAmt.toString());
        billSummaryInfo.setTax(invoicableAmt.subtract(noTaxAmt).setScale(2, 4).toString());
    }

    private void subtractionQuantity(BillSummaryInfo billSummaryInfo, List<BillSummaryInfoInvoicePO> pos, BigDecimal invoicableQuantityInvoice) {
        BigDecimal inventoryQuantity = BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getInventoryQuantity());
        BigDecimal invoicedQuantity = BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getInvoicedQuantity());
        BigDecimal num = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(pos)) {
            double sum = pos.stream().filter(item -> StringUtils.hasText((String)item.getInvoicableQuantityInvoice())).mapToDouble(item -> Double.valueOf(item.getInvoicableQuantityInvoice())).sum();
            num = num.add(new BigDecimal(sum));
        }
        if (num.compareTo(inventoryQuantity) > 0 || num.compareTo(invoicedQuantity) > 0) {
            log.debug("\u539f\u59cb\u7269\u6599\uff1a{}", (Object)JSON.toJSONString((Object)billSummaryInfo));
            log.debug("\u5df2\u5f00\u7968\u7269\u6599\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(pos));
            throw new PfscExtBusinessException("18000", "\u5df2\u5f00\u7968\u6570\u91cf\u9519\u8bef");
        }
        BigDecimal invoicableQuantity = inventoryQuantity.subtract(num.subtract(invoicableQuantityInvoice)).setScale(2, 4);
        log.debug("\n \u7269\u6599\uff1a{}. \n \u53d1\u7968\u8bb0\u5f55\uff1a{}. \n \u5df2\u5f00\u7968\u6570\u91cf\uff1a{} . \n \u5f53\u524d\u5355\u636e\u7684\u5f00\u7968\u6570\u91cf\uff1a{} . \n \u6700\u5927\u53ef\u5f00\u7968\u6570\u91cf\uff1a{}", new Object[]{JSON.toJSONString((Object)billSummaryInfo), JSON.toJSONString(pos), num, invoicableQuantityInvoice, invoicableQuantity});
        billSummaryInfo.setInvoicableQuantity(invoicableQuantity.toString());
    }

    private BusiCheckDetailAndSummeryRspBO initDataResult(CtrantType ctrantType, List<BillSummaryInfo> summaryInfos, List<GetOriginalDocumentsInfoVO> documents, BusiCheckDetailAndSummeryRspBO rspBO) {
        ArrayList detailInfos = new ArrayList();
        if (CollectionUtils.isEmpty(documents)) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u672a\u67e5\u8be2\u5230\u539f\u59cb\u5355\u636e\u6570\u636e");
        }
        if ("1".equals(ctrantType.getCtrantType())) {
            ArrayList<BillDetailInfo> billDetailInfos = new ArrayList<BillDetailInfo>();
            for (GetOriginalDocumentsInfoVO document : documents) {
                BusiOriginalDocumentDetailReqBO erpReqBo = new BusiOriginalDocumentDetailReqBO();
                erpReqBo.setCgeneralhId(document.getSummeryHeadId());
                BusiOriginalDocumentDetailRspBO originalDocumentDetailErp = this.purchaseStorageConsumptionSummaryService.getOriginalDocumentDetailErp(erpReqBo);
                if (null == originalDocumentDetailErp.getDataList() || originalDocumentDetailErp.getDataList().size() == 0) continue;
                List dataList = originalDocumentDetailErp.getDataList();
                for (BusiOriginalDocumentDetailErpRspBO detailErpRspBO : dataList) {
                    List bvos = detailErpRspBO.getBvos();
                    for (BusiOriginalDocumentDetailItem bvo : bvos) {
                        BillDetailInfo billDetailInfo = new BillDetailInfo();
                        BeanUtils.copyProperties((Object)bvo, (Object)billDetailInfo);
                        billDetailInfos.add(billDetailInfo);
                    }
                }
            }
            if (billDetailInfos.size() != 0) {
                detailInfos.addAll(billDetailInfos);
            }
        }
        rspBO.setDocuments(Optional.ofNullable(JSON.parseArray((String)JSON.toJSONString(documents), OriginalDocumentsInfoRspBO.class)).orElse(Lists.newArrayList()));
        rspBO.setSummaries(Optional.ofNullable(JSON.parseArray((String)JSON.toJSONString(summaryInfos), BillSummaryInfoRspBO.class)).orElse(Lists.newArrayList()));
        rspBO.setDetails(Optional.ofNullable(JSON.parseArray((String)JSON.toJSONString(detailInfos), BillDetailInfoRspBO.class)).orElse(Lists.newArrayList()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkMergeBilling(String type, List<GetOriginalDocumentsInfoVO> originalDocumentsInfoVOS) {
        if (CollectionUtils.isEmpty(originalDocumentsInfoVOS)) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u5355\u636e\u53f7\u67e5\u8be2\u7684\u539f\u59cb\u5355\u636e\u51fa\u9519");
        }
        List<String> typeList2 = Arrays.asList("3", "4", "5");
        if (CtrantType.RAW_COAL.getCode().equals(type)) {
            this.judgeSupplier(originalDocumentsInfoVOS, "\u7164\u70ad\u4f9b\u5e94\u5546");
        } else if (CtrantType.CHEMICAL.getCode().equals(type)) {
            this.judgeSupplier(originalDocumentsInfoVOS, "\u7ed3\u7b97\u5355\u4f4d");
        } else if (typeList2.contains(type)) {
            this.judgeSupplier(originalDocumentsInfoVOS, "\u4f9b\u5e94\u5546");
        } else {
            throw new PfscExtBusinessException("18000", "TYPE[ " + type + " ] \u672a\u77e5\u503c");
        }
    }

    private void judgeSupplier(List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS, String prefix) {
        LinkedHashSet<String> supplierIdList = new LinkedHashSet<String>();
        for (GetOriginalDocumentsInfoVO item : getOriginalDocumentsInfoVOS) {
            if (!StringUtils.hasText((String)item.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u5355\u636e[" + item.getDocumentNo() + "]\u7684" + prefix + "\u4e3a\u7a7a");
            }
            supplierIdList.add(item.getSupplierId());
        }
        if (supplierIdList.size() > 1) {
            throw new PfscExtBusinessException("18000", "[" + prefix + "]\u90fd\u76f8\u540c\u7684\u5355\u636e\u624d\u80fd\u5408\u5e76\u5f00\u7968");
        }
    }

    private void checkParamsNotBlank(BusiCheckDetailAndSummeryReqBO reqBO) {
        log.info("\u67e5\u770b\u6c47\u603b\u548c\u660e\u7ec6\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CtrantType.getInstance(reqBO.getType()) == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5355\u636e\u7c7b\u578b\u672a\u77e5");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDocumentNo())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getInvoiceStatus())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u7968\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (NInvoiceStatus.getInstance(reqBO.getInvoiceStatus()) == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u7968\u72b6\u6001\u672a\u77e5");
        }
        if (!StringUtils.hasText((String)reqBO.getOperationType())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OperationType.getInstance(reqBO.getOperationType()) == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u64cd\u4f5c\u7c7b\u578b\u672a\u77e5");
        }
        if (OperationType.CONFIRM.getCode().equals(reqBO.getOperationType()) || OperationType.MODIFY.getCode().equals(reqBO.getOperationType())) {
            if (!StringUtils.hasText((String)reqBO.getMergeNo())) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u3010\u4fee\u6539\u3011\u3010\u786e\u8ba4\u3011\u65f6\uff0c\u5408\u5e76\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (OperationType.SHOW.getCode().equals(reqBO.getOperationType()) && !NInvoiceStatus.NOT_MAKE.getCode().equals(reqBO.getInvoiceStatus()) && !StringUtils.hasText((String)reqBO.getMergeNo())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u975e\u672a\u5f00\u7968\u72b6\u6001\u67e5\u770b\u8be6\u60c5\uff0c\u5408\u5e76\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

