/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.aop.annotation.FscCommitDateLimit;
import com.tydic.pfscext.api.busi.BusiGetBillingRecordService;
import com.tydic.pfscext.api.busi.FscDictionaryBusiService;
import com.tydic.pfscext.api.busi.bo.BillingRecordRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBillingRecordReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBillingRecordRspBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiReqBo;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiRspBo;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiRspDataBo;
import com.tydic.pfscext.api.busi.vo.BillMergeInfoVO;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoInvoiceMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfoInvoicePO;
import com.tydic.pfscext.dao.vo.BillSummaryInfoInvoiceConditionVO;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umcext.ability.supplier.UmcPurSupInfoListQryAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcPurQrySupInfoListBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetBillingRecordService.class)
public class BusiGetBillingRecordServiceImpl
implements BusiGetBillingRecordService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetBillingRecordServiceImpl.class);
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillSummaryInfoInvoiceMapper billSummaryInfoInvoiceMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcPurSupInfoListQryAbilityService umcPurSupInfoListQryAbilityService;
    private final String PCODE = "APPLY_ARGEE_PAY_TYPE";
    ValueFilter filter = new ValueFilter(){

        public Object process(Object obj, String s, Object v) {
            if (v == null) {
                return "";
            }
            return v;
        }
    };

    @FscCommitDateLimit(fieldName="startDate")
    public BusiGetBillingRecordRspBO getBillingRecord(BusiGetBillingRecordReqBO reqBO) {
        log.info("\u67e5\u8be2\u5f00\u7968\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CtrantType.getInstance(reqBO.getType()) == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u5165\u5e93\u7c7b\u578b\u672a\u77e5");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getPurDeptId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getSupplierId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ptype = this.getDicCode(reqBO);
        reqBO.setPayType(ptype);
        reqBO.setSupplierId(this.getCreditNoFromUMC(reqBO.getSupplierId()));
        if (StringUtils.hasText((String)reqBO.getDocumentNo()) || StringUtils.hasText((String)reqBO.getSettlementSupplier()) || StringUtils.hasText((String)reqBO.getPayType()) || StringUtils.hasText((String)reqBO.getCoalSupplierId()) || StringUtils.hasText((String)reqBO.getWarehouseId()) || StringUtils.hasText((String)reqBO.getCtrantTypeId()) || StringUtils.hasText((String)reqBO.getStartDate()) || StringUtils.hasText((String)reqBO.getEndDate()) || StringUtils.hasText((String)reqBO.getSupplierId()) || StringUtils.hasText((String)reqBO.getMaterialCode())) {
            return this.getPageByCondition(reqBO);
        }
        reqBO.setType(CtrantType.getInstance(reqBO.getType()).getCtrantType());
        return this.getBillingRecordDefault(reqBO);
    }

    private BusiGetBillingRecordRspBO getBillingRecordDefault(BusiGetBillingRecordReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        log.debug("\u5206\u9875\u5b9e\u4f53\uff1a{}", (Object)JSON.toJSONString((Object)page));
        BusiGetBillingRecordRspBO rspBO = new BusiGetBillingRecordRspBO();
        rspBO.setRecordsTotal(Integer.valueOf(0));
        rspBO.setTotal(Integer.valueOf(1));
        rspBO.setPageNo(Integer.valueOf(1));
        List<BillMergeInfo> billMergeInfos = this.billMergeInfoMapper.selectPage(reqBO, (Page<Map<String, Object>>)page, reqBO.getType());
        ArrayList billingRecordRspBOS = new ArrayList();
        if (billMergeInfos.size() != 0) {
            billingRecordRspBOS.addAll(JSON.parseArray((String)JSON.toJSONString(billMergeInfos), BillingRecordRspBO.class));
            List mergeNoList = billMergeInfos.stream().map(BillMergeInfo::getMergeSetNo).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mergeNoList)) {
                BillSummaryInfoInvoiceConditionVO conditionVO = new BillSummaryInfoInvoiceConditionVO();
                conditionVO.setMergeNoInList(new ArrayList<String>(mergeNoList));
                conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                List<BillSummaryInfoInvoicePO> summaryInfoInvoicePOS = this.billSummaryInfoInvoiceMapper.selectListCondition(conditionVO);
                List<String> statementNoList = summaryInfoInvoicePOS.stream().map(BillSummaryInfoInvoicePO::getStatementNo).distinct().collect(Collectors.toList());
                Map<String, Map<String, List<BillSummaryInfoInvoicePO>>> summaryInfoInvoicePOMap = summaryInfoInvoicePOS.stream().collect(Collectors.groupingBy(BillSummaryInfoInvoicePO::getMergeSetNo, Collectors.groupingBy(BillSummaryInfoInvoicePO::getStatementNo)));
                if (!CollectionUtils.isEmpty(statementNoList)) {
                    List<GetOriginalDocumentsInfoVO> documentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByStatementNos(statementNoList);
                    Map<String, GetOriginalDocumentsInfoVO> documentsInfoVOMap = documentsInfoVOS.stream().collect(Collectors.toMap(GetOriginalDocumentsInfoVO::getDocumentNo, item -> item, (oldItem, newItem) -> newItem));
                    for (BillingRecordRspBO billingRecord : billingRecordRspBOS) {
                        Map<String, List<BillSummaryInfoInvoicePO>> infoInvoicePOList = summaryInfoInvoicePOMap.get(billingRecord.getMergeSetNo());
                        ArrayList<GetOriginalDocumentsInfoVO> documentsInfoVOList = new ArrayList<GetOriginalDocumentsInfoVO>();
                        if (!CollectionUtils.isEmpty(infoInvoicePOList)) {
                            for (Map.Entry<String, List<BillSummaryInfoInvoicePO>> entry : infoInvoicePOList.entrySet()) {
                                GetOriginalDocumentsInfoVO documentsInfoVO = documentsInfoVOMap.get(entry.getKey());
                                documentsInfoVOList.add(documentsInfoVO);
                                if (!StringUtils.hasText((String)documentsInfoVO.getSupplierId())) continue;
                                billingRecord.setSupplier(documentsInfoVO.getSupplier());
                            }
                        }
                        String jsonString = JSON.toJSONString(documentsInfoVOList, (SerializeFilter)this.filter, (SerializerFeature[])new SerializerFeature[0]);
                        List billMergeInfoVOS = JSON.parseArray((String)jsonString, BillMergeInfoVO.class);
                        billingRecord.setMergeInfoList(billMergeInfoVOS);
                        billingRecord.setInvoiceStatusDesc(FscBillStatus.getInstance(billingRecord.getInvoiceStatus()).getDescr());
                        billingRecord.setInvoiceType(InvoiceType.getInstance(billingRecord.getInvoiceType()).getDescr());
                    }
                }
            }
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        rspBO.setRows(billingRecordRspBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getCreditNoFromUMC(String supplierId) {
        if (StringUtils.hasText((String)supplierId)) {
            String creditNo;
            UmcPurSupInfoListQryAbilityReqBO umcPurSupInfoListQryAbilityReqBO = new UmcPurSupInfoListQryAbilityReqBO();
            log.debug("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u5165\u53c2\uff1a{}", (Object)supplierId);
            umcPurSupInfoListQryAbilityReqBO.setSupplierId(Long.valueOf(supplierId));
            UmcPurSupInfoListQryAbilityRspBO umcPurSupInfoListQryAbilityRspBO = this.umcPurSupInfoListQryAbilityService.qryPurSupInfoList(umcPurSupInfoListQryAbilityReqBO);
            log.debug("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcPurSupInfoListQryAbilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if ("0000".equals(umcPurSupInfoListQryAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcPurSupInfoListQryAbilityRspBO.getRows()) && StringUtils.hasText((String)(creditNo = ((UmcPurQrySupInfoListBO)umcPurSupInfoListQryAbilityRspBO.getRows().get(0)).getCreditNo()))) {
                return creditNo;
            }
        }
        return supplierId;
    }

    private String getDicCode(BusiGetBillingRecordReqBO reqBO) {
        String payType = reqBO.getPayType();
        if (StringUtils.hasText((String)payType)) {
            List collect;
            FscDictionaryBusiReqBo fscDictionaryBusiReqBo = new FscDictionaryBusiReqBo();
            fscDictionaryBusiReqBo.setpCode("APPLY_ARGEE_PAY_TYPE");
            FscDictionaryBusiRspBo fscDictionaryBusiRspBo = this.fscDictionaryBusiService.qryDic(fscDictionaryBusiReqBo);
            log.info("\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u65b9\u5f0f:{}", (Object)JSON.toJSONString((Object)fscDictionaryBusiReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (StringUtils.hasText((String)reqBO.getPayType()) && !CollectionUtils.isEmpty((Collection)fscDictionaryBusiRspBo.getRows()) && !CollectionUtils.isEmpty(collect = fscDictionaryBusiRspBo.getRows().stream().filter(row -> row.getCode().equals(payType)).collect(Collectors.toList()))) {
                return ((FscDictionaryBusiRspDataBo)collect.get(0)).getDescrip().trim();
            }
        }
        return reqBO.getPayType();
    }

    private BusiGetBillingRecordRspBO getPageByCondition(BusiGetBillingRecordReqBO reqBO) {
        BusiGetBillingRecordRspBO rspBO = new BusiGetBillingRecordRspBO();
        String supplierId = reqBO.getSupplierId();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.hasText((String)reqBO.getStartDate())) {
            DateTimeFormatter formatterStart = DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00");
            reqBO.setStartDate(LocalDateTime.parse(reqBO.getStartDate(), formatter).format(formatterStart));
        }
        if (StringUtils.hasText((String)reqBO.getEndDate())) {
            DateTimeFormatter formatterEnd = DateTimeFormatter.ofPattern("yyyy-MM-dd 23:59:59");
            reqBO.setEndDate(LocalDateTime.parse(reqBO.getEndDate(), formatter).format(formatterEnd));
        }
        reqBO.setSettlementSupplierCode(this.getCreditNoFromUMC(reqBO.getSettlementSupplier()));
        reqBO.setSettlementSupplier(null);
        reqBO.setCoalSupplierId(this.getCreditNoFromUMC(reqBO.getCoalSupplierId()));
        if (CtrantType.RAW_COAL.getCode().equals(reqBO.getType())) {
            if (StringUtils.hasText((String)supplierId)) {
                reqBO.setSupplierId(null);
                reqBO.setSettlementSupplierCode(supplierId);
            }
        } else if (!CtrantType.CHEMICAL.getCode().equals(reqBO.getType()) && !CtrantType.CHEMICAL_STORE.getCode().equals(reqBO.getType()) && !CtrantType.NON_HOSTED.getCode().equals(reqBO.getType()) && CtrantType.HOSTED.getCode().equals(reqBO.getType())) {
            if (StringUtils.hasText((String)reqBO.getStartDate())) {
                reqBO.setSumStartDate(reqBO.getStartDate());
                reqBO.setStartDate(null);
            }
            if (StringUtils.hasText((String)reqBO.getEndDate())) {
                reqBO.setSumEndDate(reqBO.getEndDate());
                reqBO.setEndDate(null);
            }
        }
        reqBO.setType(CtrantType.getInstance(reqBO.getType()).getCtrantType());
        List<GetOriginalDocumentsInfoVO> documentsInfoVOS = this.originalDocumentsInfoMapper.selectByBillingRecordReqBO(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        rspBO.setRecordsTotal(Integer.valueOf(0));
        rspBO.setPageNo(Integer.valueOf(1));
        rspBO.setTotal(Integer.valueOf(1));
        ArrayList billingRecordRspBOS = new ArrayList();
        if (documentsInfoVOS.size() != 0) {
            List<String> documentsNoList = documentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getDocumentNo).collect(Collectors.toList());
            BillSummaryInfoInvoiceConditionVO conditionVO = new BillSummaryInfoInvoiceConditionVO();
            conditionVO.setStatementNoInList(documentsNoList);
            conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            List<BillSummaryInfoInvoicePO> billSummaryInfoInvoicePOList = this.billSummaryInfoInvoiceMapper.selectListCondition(conditionVO);
            if (!CollectionUtils.isEmpty(billSummaryInfoInvoicePOList)) {
                List<String> mergeSetNoList = billSummaryInfoInvoicePOList.stream().map(BillSummaryInfoInvoicePO::getMergeSetNo).distinct().collect(Collectors.toList());
                BillSummaryInfoInvoiceConditionVO condition = new BillSummaryInfoInvoiceConditionVO();
                condition.setMergeNoInList(mergeSetNoList);
                condition.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                List<BillSummaryInfoInvoicePO> summaryInfoInvoiceAll = this.billSummaryInfoInvoiceMapper.selectListCondition(condition);
                Map<String, List<BillSummaryInfoInvoicePO>> summaryInfoInvoiceMap = summaryInfoInvoiceAll.stream().collect(Collectors.groupingBy(BillSummaryInfoInvoicePO::getMergeSetNo));
                List<BillMergeInfo> billMergeInfos = this.billMergeInfoMapper.selectPageByMergeNo(mergeSetNoList, (Page<Map<String, Object>>)page);
                billingRecordRspBOS.addAll(JSON.parseArray((String)JSON.toJSONString(billMergeInfos), BillingRecordRspBO.class));
                for (BillingRecordRspBO billingRecord : billingRecordRspBOS) {
                    List<GetOriginalDocumentsInfoVO> infoVOS;
                    ArrayList<GetOriginalDocumentsInfoVO> documentsInfoVOList = new ArrayList<GetOriginalDocumentsInfoVO>();
                    List<BillSummaryInfoInvoicePO> infoInvoiceSubList = summaryInfoInvoiceMap.get(billingRecord.getMergeSetNo());
                    List<String> statementNos = infoInvoiceSubList.stream().map(BillSummaryInfoInvoicePO::getStatementNo).distinct().collect(Collectors.toList());
                    if (StringUtils.hasText((String)reqBO.getDocumentNo())) {
                        infoVOS = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(statementNos);
                        documentsInfoVOList.addAll(infoVOS);
                    } else {
                        infoVOS = documentsInfoVOS.stream().filter(item -> statementNos.contains(item.getDocumentNo())).collect(Collectors.toList());
                        documentsInfoVOList.addAll(infoVOS);
                    }
                    String jsonString = JSON.toJSONString(documentsInfoVOList, (SerializeFilter)this.filter, (SerializerFeature[])new SerializerFeature[0]);
                    List billMergeInfoVOS = JSON.parseArray((String)jsonString, BillMergeInfoVO.class);
                    billingRecord.setMergeInfoList(billMergeInfoVOS);
                    billingRecord.setInvoiceStatusDesc(FscBillStatus.getInstance(billingRecord.getInvoiceStatus()).getDescr());
                    billingRecord.setInvoiceType(InvoiceType.getInstance(billingRecord.getInvoiceType()).getDescr());
                    if (CollectionUtils.isEmpty(documentsInfoVOList)) continue;
                    for (GetOriginalDocumentsInfoVO vo : documentsInfoVOList) {
                        billingRecord.setSupplier(vo.getSupplier());
                        billingRecord.setSupplierId(vo.getSupplierId());
                    }
                }
            }
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        rspBO.setRows(billingRecordRspBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

