/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.aop.annotation.FscCommitDateLimit;
import com.tydic.pfscext.api.busi.BusiGetInspectionReportService;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportCheckRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInspectionReportRspBO;
import com.tydic.pfscext.enums.InspectionType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetInspectionReportErpService;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpInfoRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetInspectionReportErpRspBO;
import com.tydic.umcext.ability.supplier.UmcPurSupInfoListQryAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcPurQrySupInfoListBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetInspectionReportService.class)
public class BusiGetInspectionReportServiceImpl
implements BusiGetInspectionReportService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetInspectionReportServiceImpl.class);
    @Autowired
    private BusiGetInspectionReportErpService busiGetInspectionReportErpService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcPurSupInfoListQryAbilityService umcPurSupInfoListQryAbilityService;
    @Value(value="${ERP_INSPECTION_PAGE_SIZE:1000}")
    private String erpPageSize;

    @FscCommitDateLimit(fieldName="startDate")
    public BusiGetInspectionReportRspBO getInspectionReport(BusiGetInspectionReportReqBO reqBO) {
        log.info("\u67e5\u8be2\u8d28\u68c0\u62a5\u544a\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        this.checkParams(reqBO);
        reqBO.setPageNo(Integer.valueOf(1));
        reqBO.setPageSize(this.getErpPageSize());
        reqBO.setPkSupplier(this.getCreditCode(reqBO.getPkSupplier()));
        reqBO.setCoalSupplier(this.getCreditCode(reqBO.getCoalSupplier()));
        if ("0".equals(reqBO.getType())) {
            return this.getInspectionReportCoal(reqBO);
        }
        if ("1".equals(reqBO.getType())) {
            return this.getInspectionReportChemical(reqBO);
        }
        throw new PfscExtBusinessException("0001", "\u672a\u77e5\u7c7b\u522btype=" + reqBO.getType());
    }

    private BusiGetInspectionReportRspBO getInspectionReportCoal(BusiGetInspectionReportReqBO reqBO) {
        BusiGetInspectionReportErpReqBO erpReqBO = new BusiGetInspectionReportErpReqBO();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.hasText((String)reqBO.getPkMaterial()) && null == reqBO.getStartDate() && null == reqBO.getEndDate()) {
            LocalDateTime startTime;
            if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
                if (StringUtils.hasText((String)reqBO.getCoalSupplier())) {
                    startTime = LocalDateTime.now().minusMonths(3L);
                    reqBO.setStartDate(Date.from(startTime.atZone(ZoneId.systemDefault()).toInstant()));
                    reqBO.setEndDate(new Date());
                }
            } else if (!StringUtils.hasText((String)reqBO.getCoalSupplier()) && StringUtils.hasText((String)reqBO.getPkOrg())) {
                startTime = LocalDateTime.now().minusMonths(3L);
                reqBO.setStartDate(Date.from(startTime.atZone(ZoneId.systemDefault()).toInstant()));
                reqBO.setEndDate(new Date());
            }
        }
        if (null != reqBO.getStartDate()) {
            erpReqBO.setStartDate(format.format(reqBO.getStartDate()));
        }
        if (null != reqBO.getEndDate()) {
            erpReqBO.setEndDate(format.format(reqBO.getEndDate()));
        }
        if (StringUtils.hasText((String)reqBO.getCoalSupplier())) {
            erpReqBO.setVdef4(reqBO.getCoalSupplier());
        }
        erpReqBO.setPkSupplier(reqBO.getPkSupplier());
        erpReqBO.setPkMaterial(reqBO.getPkMaterial());
        erpReqBO.setPkOrg(reqBO.getPkOrg());
        erpReqBO.setBillType("ylm");
        erpReqBO.setPageNum(reqBO.getPageNo());
        erpReqBO.setPageSize(reqBO.getPageSize());
        BusiGetInspectionReportErpRspBO inspectionReport = this.busiGetInspectionReportErpService.getInspectionReport(erpReqBO);
        List dataList = inspectionReport.getDataList();
        ArrayList<BusiGetInspectionReportInfoRspBO> resultList = new ArrayList<BusiGetInspectionReportInfoRspBO>();
        resultList.addAll(this.initCoalData(dataList));
        BusiGetInspectionReportRspBO rspBO = new BusiGetInspectionReportRspBO();
        int recordsTotal = Integer.valueOf(inspectionReport.getData() == null ? "0" : inspectionReport.getData());
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRecordsTotal(Integer.valueOf(recordsTotal));
        rspBO.setRows(resultList);
        return rspBO;
    }

    private List<BusiGetInspectionReportInfoRspBO> initCoalData(List<BusiGetInspectionReportErpInfoRspBO> dataList) {
        ArrayList<BusiGetInspectionReportInfoRspBO> list = new ArrayList<BusiGetInspectionReportInfoRspBO>();
        if (!CollectionUtils.isEmpty(dataList)) {
            Map<String, List<BusiGetInspectionReportErpInfoRspBO>> map = dataList.stream().filter(item -> StringUtils.hasText((String)item.getVassayno())).collect(Collectors.groupingBy(BusiGetInspectionReportErpInfoRspBO::getVassayno));
            for (Map.Entry<String, List<BusiGetInspectionReportErpInfoRspBO>> entry : map.entrySet()) {
                List<BusiGetInspectionReportErpInfoRspBO> value = entry.getValue();
                if (CollectionUtils.isEmpty(value)) continue;
                String toJSONString = JSON.toJSONString((Object)value.get(0));
                BusiGetInspectionReportInfoRspBO infoRspBO = (BusiGetInspectionReportInfoRspBO)JSON.parseObject((String)toJSONString, BusiGetInspectionReportInfoRspBO.class);
                infoRspBO.setMvdef14(value.size() + "");
                BigDecimal allWeight = BigDecimal.ZERO;
                for (BusiGetInspectionReportErpInfoRspBO valueItem : value) {
                    Double netWeight = valueItem.getBvoList().stream().filter(item -> StringUtils.hasText((String)item.getNastnum())).mapToDouble(item -> Double.valueOf(item.getNastnum())).sum();
                    allWeight = allWeight.add(new BigDecimal(netWeight));
                }
                infoRspBO.setMvdef15(allWeight.setScale(2, 4).toString());
                this.initInspectionInfo(infoRspBO);
                list.add(infoRspBO);
            }
        }
        return list;
    }

    private void initInspectionInfo(BusiGetInspectionReportInfoRspBO infoRspBO) {
        List itemList = infoRspBO.getCheckbillList();
        if (!CollectionUtils.isEmpty((Collection)itemList)) {
            Map<String, List<BusiGetInspectionReportCheckRspBO>> collectMap = itemList.stream().collect(Collectors.groupingBy(BusiGetInspectionReportCheckRspBO::getPkCheckitem));
            infoRspBO.setMvdef1(this.getVchkvalue(collectMap.get(InspectionType.STAD.getErpKey())));
            infoRspBO.setMvdef2(this.getVchkvalue(collectMap.get(InspectionType.AD.getErpKey())));
            infoRspBO.setMvdef3(this.getVchkvalue(collectMap.get(InspectionType.VDAF.getErpKey())));
            infoRspBO.setMvdef4(this.getVchkvalue(collectMap.get(InspectionType.SMSC.getErpKey())));
            infoRspBO.setMvdef5(this.getVchkvalue(collectMap.get(InspectionType.LOWCV.getErpKey())));
            infoRspBO.setMvdef6(this.getVchkvalue(collectMap.get(InspectionType.CARBONC.getErpKey())));
            infoRspBO.setMvdef7(this.getVchkvalue(collectMap.get(InspectionType.MT.getErpKey())));
            infoRspBO.setMvdef8(this.getVchkvalue(collectMap.get(InspectionType.STD.getErpKey())));
            infoRspBO.setMvdef9(this.getVchkvalue(collectMap.get(InspectionType.G.getErpKey())));
            infoRspBO.setMvdef10(this.getVchkvalue(collectMap.get(InspectionType.X.getErpKey())));
            infoRspBO.setMvdef11(this.getVchkvalue(collectMap.get(InspectionType.Y.getErpKey())));
            infoRspBO.setMvdef12(this.getVchkvalue(collectMap.get(InspectionType.FINENESS.getErpKey())));
            infoRspBO.setMvdef13(this.getVchkvalue(collectMap.get(InspectionType.CALORIFIC.getErpKey())));
        }
    }

    private String getVchkvalue(List<BusiGetInspectionReportCheckRspBO> item) {
        if (item != null && item.size() > 0) {
            return item.get(0).getVchkvalue();
        }
        return "";
    }

    private void initInspectionInfoOld(BusiGetInspectionReportInfoRspBO infoRspBO) {
        List itemList = infoRspBO.getItemList();
        if (!CollectionUtils.isEmpty((Collection)itemList)) {
            Map<String, String> collectMap = itemList.stream().collect(Collectors.toMap(BusiGetInspectionReportItemRspBO::getPk_checkitem, BusiGetInspectionReportItemRspBO::getNtotalsample));
            infoRspBO.setMvdef1(collectMap.get("1001Q1100000001FZXP7"));
            infoRspBO.setMvdef2(collectMap.get("1001A3100000000005PI"));
            infoRspBO.setMvdef3(collectMap.get("1001A3100000000005PP"));
            infoRspBO.setMvdef4(collectMap.get("1001Q1100000001FZXQA"));
            infoRspBO.setMvdef5(collectMap.get("1001Q1100000001FZXU1"));
            infoRspBO.setMvdef6(collectMap.get("1001A31000000000064I"));
            infoRspBO.setMvdef7(collectMap.get("1001A3100000000005PH"));
            infoRspBO.setMvdef8(collectMap.get("1001A3100000000005PL"));
            infoRspBO.setMvdef9(collectMap.get("1001A310000000000663"));
            infoRspBO.setMvdef10(collectMap.get("1001A310000000000668"));
            infoRspBO.setMvdef11(collectMap.get("1001A3100000000008HL"));
            infoRspBO.setMvdef12(collectMap.get("1001A3100000000008ID"));
            infoRspBO.setMvdef13(collectMap.get("1001Q11000000019TI75"));
        }
    }

    private BusiGetInspectionReportRspBO getInspectionReportChemical(BusiGetInspectionReportReqBO reqBO) {
        BusiGetInspectionReportRspBO rspBO = new BusiGetInspectionReportRspBO();
        BusiGetInspectionReportErpReqBO erpReqBO = new BusiGetInspectionReportErpReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)erpReqBO);
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != reqBO.getStartDate()) {
            erpReqBO.setStartDate(formater.format(reqBO.getStartDate()));
        }
        if (null != reqBO.getEndDate()) {
            erpReqBO.setEndDate(formater.format(reqBO.getEndDate()));
        }
        erpReqBO.setPageSize(reqBO.getPageSize());
        erpReqBO.setPageNum(reqBO.getPageNo());
        erpReqBO.setBillType("hg");
        BusiGetInspectionReportErpRspBO inspectionReport = this.busiGetInspectionReportErpService.getInspectionReport(erpReqBO);
        List dataList = inspectionReport.getDataList();
        ArrayList<BusiGetInspectionReportInfoRspBO> rows = new ArrayList<BusiGetInspectionReportInfoRspBO>();
        if (null != dataList) {
            for (BusiGetInspectionReportErpInfoRspBO item : dataList) {
                BusiGetInspectionReportInfoRspBO receiptPageRspBO = (BusiGetInspectionReportInfoRspBO)JSON.parseObject((String)JSON.toJSONString((Object)item), BusiGetInspectionReportInfoRspBO.class);
                this.initInspectionInfo(receiptPageRspBO);
                rows.add(receiptPageRspBO);
            }
        }
        int recordsTotal = Integer.valueOf(inspectionReport.getData() == null ? "0" : inspectionReport.getData());
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(recordsTotal));
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getCreditCode(String supplierId) {
        if (StringUtils.hasText((String)supplierId)) {
            String creditNo;
            UmcPurSupInfoListQryAbilityReqBO umcPurSupInfoListQryAbilityReqBO = new UmcPurSupInfoListQryAbilityReqBO();
            log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u5165\u53c2\uff1a{}", (Object)supplierId);
            umcPurSupInfoListQryAbilityReqBO.setSupplierId(Long.valueOf(supplierId));
            UmcPurSupInfoListQryAbilityRspBO umcPurSupInfoListQryAbilityRspBO = this.umcPurSupInfoListQryAbilityService.qryPurSupInfoList(umcPurSupInfoListQryAbilityReqBO);
            log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcPurSupInfoListQryAbilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if ("0000".equals(umcPurSupInfoListQryAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcPurSupInfoListQryAbilityRspBO.getRows()) && StringUtils.hasText((String)(creditNo = ((UmcPurQrySupInfoListBO)umcPurSupInfoListQryAbilityRspBO.getRows().get(0)).getCreditNo()))) {
                log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801-creditNo\uff1a{}", (Object)creditNo);
                return creditNo;
            }
        }
        log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801-\u672a\u53d8\u66f4\uff1a{}", (Object)supplierId);
        return supplierId;
    }

    private void checkParams(BusiGetInspectionReportReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u7c7b\u522btype\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && !StringUtils.hasText((String)reqBO.getPkOrg())) {
            throw new PfscExtBusinessException("0001", "\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Integer getErpPageSize() {
        int size;
        try {
            size = Integer.valueOf(this.erpPageSize);
        }
        catch (NumberFormatException e) {
            size = 1000;
        }
        return size;
    }
}

