/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.BusiGetInvoiceService;
import com.tydic.pfscext.api.busi.BusiUpdateNotificationExcepService;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceRspBO;
import com.tydic.pfscext.api.busi.vo.BusiGetInvoiceResultVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.InvoiceMailStatus;
import com.tydic.pfscext.enums.InvoiceStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.SupplierId;
import com.tydic.pfscext.external.api.BusiGetInvoiceDataService;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataRspVO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataServiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemListRspBO;
import com.tydic.pfscext.service.atom.PayInvoiceService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetInvoiceService.class)
public class BusiGetInvoiceServiceImpl
implements BusiGetInvoiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiGetInvoiceServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    @Autowired
    private PayInvoiceService payInvoiceService;
    @Autowired
    private BusiUpdateNotificationExcepService busiUpdateNotificationExcepService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    private boolean isBusy = false;
    private Long SUPPLIER_NO = 100055L;

    public boolean isBusy() {
        return this.isBusy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusiGetInvoiceServiceRspBO dealInvoice(BusiGetInvoiceServiceReqBO busiGetInvoiceServiceReqBO) {
        this.isBusy = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiGetInvoiceServiceReqBO.toString());
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)busiGetInvoiceServiceReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        List notifiations = busiGetInvoiceServiceReqBO.getNotificationNos();
        try {
            if (notifiations == null || notifiations.isEmpty()) {
                BusiGetInvoiceServiceRspBO busiGetInvoiceServiceRspBO = this.process();
                return busiGetInvoiceServiceRspBO;
            }
            BusiGetInvoiceServiceRspBO busiGetInvoiceServiceRspBO = this.getInvoiceInfoAgain(notifiations);
            return busiGetInvoiceServiceRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiGetInvoiceServiceRspBO process() {
        BusiGetInvoiceServiceRspBO rspBO = new BusiGetInvoiceServiceRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        List<BillNotificationInfo> invoiceList = this.notificationInfomapper.selectList(billNotificationInfo);
        if (invoiceList.isEmpty()) {
            LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashMap<String, Long> orgIdMap = new HashMap<String, Long>();
        for (BillNotificationInfo info : invoiceList) {
            List<PayPurchaseOrderInfo> orders;
            String markId = info.getNotificationNo();
            String id = String.valueOf(info.getSupplierNo());
            dataMap.put(markId, id);
            if (null == id || "".equals(id) || !SupplierId.JD.getCode().equals(id) || null == (orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(info.getNotificationNo())) || orders.size() <= 0) continue;
            if (BusiModel.MATCH_UP_MODEL.getCode().equals(orders.get(0).getBusiModel())) {
                orgIdMap.put(markId, orders.get(0).getJdOrgId());
                continue;
            }
            orgIdMap.put(markId, orders.get(0).getOperUnitNo());
        }
        LOGGER.debug("\u83b7\u53d6\u53d1\u7968---\u4eac\u4e1ctoken\u6d4b\u8bd5--------orgIdMap=" + orgIdMap);
        LOGGER.debug("\u9700\u8981\u8f6e\u8be2\u53d1\u7968\u8d44\u6599\u7684\u901a\u77e5\u5355,count=" + invoiceList.size() + ",dataMap=" + dataMap + ",orgIdMap" + orgIdMap);
        BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
        getInvoiceDataReqBO.setIdMap(dataMap);
        getInvoiceDataReqBO.setOrgIdMap(orgIdMap);
        List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
        if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
            LOGGER.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u6570\u636e\uff0c\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        ArrayList list = new ArrayList();
        rspBO.setResultList(list);
        return this.dealData(invoiceDataList, rspBO);
    }

    private BusiGetInvoiceServiceRspBO dealData(List<BusiGetInvoiceDataRspVO> invoiceDataList, BusiGetInvoiceServiceRspBO rspBO) {
        ArrayList<PayInvoiceDetail> payInvoiceDetails = new ArrayList<PayInvoiceDetail>();
        for (BusiGetInvoiceDataRspVO invoiceData : invoiceDataList) {
            try {
                BusiGetInvoiceResultVO resultVO = new BusiGetInvoiceResultVO();
                LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:" + invoiceData.getNotificationNo() + "," + invoiceData.getResultCode() + "," + invoiceData.getResultMsg() + ",sup=" + invoiceData.getSupplierNo() + "(" + invoiceData.getSupplierCode() + ")");
                LOGGER.info("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)invoiceData));
                BeanUtils.copyProperties((Object)invoiceData, (Object)resultVO);
                rspBO.getResultList().add(resultVO);
                PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
                BeanUtils.copyProperties((Object)invoiceData, (Object)invoiceInfo);
                if (StringUtils.hasText((String)invoiceData.getInvoiceNo())) {
                    LOGGER.info("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)invoiceData));
                    invoiceInfo.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
                    invoiceInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
                    invoiceInfo.setPushStatus("0");
                    try {
                        List<PayPurchaseOrderInfo> orders;
                        LOGGER.info("\u66f4\u65b0\u53d1\u7968\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)invoiceInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        this.payInvoiceService.createInvoice(invoiceInfo);
                        BusiGetInvoiceDataServiceReqBO busiGetInvoiceDataServiceReqBO = new BusiGetInvoiceDataServiceReqBO();
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("invoiceId", invoiceInfo.getInvoiceNo());
                        map.put("invoiceCode", invoiceInfo.getInvoiceCode());
                        map.put("supplierId", invoiceInfo.getSupplierNo());
                        if (null != invoiceInfo.getSupplierNo() && !"".equals(invoiceInfo.getSupplierNo()) && SupplierId.JD.getCode().equals(invoiceInfo.getSupplierNo()) && null != (orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(invoiceData.getNotificationNo())) && orders.size() > 0 && null != orders && orders.size() > 0) {
                            if (BusiModel.MATCH_UP_MODEL.getCode().equals(orders.get(0).getBusiModel())) {
                                map.put("orgId", orders.get(0).getJdOrgId().toString());
                            } else {
                                map.put("orgId", orders.get(0).getOperUnitNo().toString());
                            }
                        }
                        busiGetInvoiceDataServiceReqBO.setIdMap(map);
                        BusiGetInvoiceItemListRspBO busiGetInvoiceItemListRspBO = this.apiGetInvoiceDataService.getInvoiceItems(busiGetInvoiceDataServiceReqBO);
                        if (busiGetInvoiceItemListRspBO == null || busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs() == null || busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs().size() <= 0) continue;
                        List<PayInvoiceDetail> invoiceDetails = this.payInvoiceDetailMapper.selectByInvoiceListPK(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
                        if (!invoiceDetails.isEmpty()) {
                            try {
                                this.payInvoiceDetailMapper.deleteByInvoiceNo(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
                            }
                            catch (Exception e) {
                                LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                                continue;
                            }
                        }
                        List<PayItemInfo> list = this.payItemInfoMapper.selectByNotifNo(invoiceData.getNotificationNo());
                        List<PayPurchaseOrderInfo> orders2 = this.payPurchaseOrderInfoMapper.selectByNotifNo(invoiceData.getNotificationNo());
                        HashMap<String, String> mapExtOrderId = new HashMap<String, String>();
                        for (PayPurchaseOrderInfo po : orders2) {
                            StringBuffer str = new StringBuffer();
                            str.append(po.getOrderId()).append("-").append(po.getInspectionId());
                            mapExtOrderId.put(str.toString(), po.getExtOrderId());
                        }
                        for (BusiGetInvoiceItemBO busiGetInvoiceItemBO : busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs()) {
                            PayInvoiceDetail payInvoiceDetail = new PayInvoiceDetail();
                            BeanUtils.copyProperties((Object)busiGetInvoiceItemBO, (Object)payInvoiceDetail);
                            payInvoiceDetail.setInvoiceCode(invoiceInfo.getInvoiceCode());
                            payInvoiceDetail.setInvoiceNo(invoiceInfo.getInvoiceNo());
                            payInvoiceDetail.setInvoiceDate(invoiceInfo.getInvoiceDate());
                            for (PayItemInfo payItemInfo : list) {
                                if (!invoiceInfo.getSupplierNo().equals(this.SUPPLIER_NO.toString())) {
                                    boolean flag = false;
                                    if (String.valueOf(payItemInfo.getOrderId()).equals(busiGetInvoiceItemBO.getOrderCode()) || String.valueOf(payItemInfo.getPurchaseOrderCode()).equals(busiGetInvoiceItemBO.getOrderCode())) {
                                        flag = true;
                                    }
                                    if (!flag || !payItemInfo.getExtSkuId().equals(busiGetInvoiceItemBO.getExtSkuId())) continue;
                                    BigDecimal taxRate = payInvoiceDetail.getTaxRate().divide(new BigDecimal(100));
                                    payInvoiceDetail.setTaxRate(taxRate);
                                    payInvoiceDetail.setOrderId(payItemInfo.getOrderId());
                                    payInvoiceDetail.setInspectionId(payItemInfo.getInspectionId());
                                    payInvoiceDetail.setItemNo(payItemInfo.getItemNo());
                                    payInvoiceDetail.setSkuId(payItemInfo.getSkuId());
                                    payInvoiceDetails.add(payInvoiceDetail);
                                    continue;
                                }
                                StringBuffer str = new StringBuffer();
                                str.append(payItemInfo.getOrderId()).append("-").append(payItemInfo.getInspectionId());
                                if (!((String)mapExtOrderId.get(str.toString())).equals(busiGetInvoiceItemBO.getOrderCode()) || !payItemInfo.getExtSkuId().equals(busiGetInvoiceItemBO.getExtSkuId())) continue;
                                payInvoiceDetail.setOrderId(payItemInfo.getOrderId());
                                payInvoiceDetail.setInspectionId(payItemInfo.getInspectionId());
                                payInvoiceDetail.setItemNo(payItemInfo.getItemNo());
                                payInvoiceDetail.setSkuId(payItemInfo.getSkuId());
                                payInvoiceDetail.setTaxRate(busiGetInvoiceItemBO.getTaxRate());
                                payInvoiceDetails.add(payInvoiceDetail);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                        continue;
                    }
                }
                this.busiUpdateNotificationExcepService.updateNotificationException(invoiceData.getResultMsg(), invoiceData.getNotificationNo());
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25:", (Throwable)e);
            }
        }
        try {
            LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u6570\u91cf\uff1a" + payInvoiceDetails.size());
            if (payInvoiceDetails.size() > 0) {
                LOGGER.info("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(payInvoiceDetails, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                this.payInvoiceDetailMapper.insertByBatch(payInvoiceDetails);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25", e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BusiGetInvoiceServiceRspBO getInvoiceInfoAgain(List<String> billNotificationInfos) {
        BusiGetInvoiceServiceRspBO rspBO = new BusiGetInvoiceServiceRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        billNotificationInfo.setNotificationNos(billNotificationInfos);
        List<BillNotificationInfo> invoiceList = this.notificationInfomapper.selectList(billNotificationInfo);
        if (invoiceList.isEmpty()) {
            LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a[\u5df2\u63d0\u4ea4]\u7684\u8bb0\u5f55");
            return rspBO;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashMap<String, Long> orgIdMap = new HashMap<String, Long>();
        for (BillNotificationInfo info : invoiceList) {
            List<PayPurchaseOrderInfo> orders;
            String markId = info.getNotificationNo();
            String id = String.valueOf(info.getSupplierNo());
            dataMap.put(markId, id);
            if (null == id || "".equals(id) || !SupplierId.JD.getCode().equals(id) || null == (orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(info.getNotificationNo())) || orders.size() <= 0) continue;
            if (BusiModel.MATCH_UP_MODEL.getCode().equals(orders.get(0).getBusiModel())) {
                orgIdMap.put(markId, orders.get(0).getJdOrgId());
                continue;
            }
            orgIdMap.put(markId, orders.get(0).getOperUnitNo());
        }
        LOGGER.debug("\u91cd\u65b0\u83b7\u53d6\u53d1\u7968---\u4eac\u4e1ctoken\u6d4b\u8bd5--------orgIdMap=" + orgIdMap);
        LOGGER.debug("\u9700\u8981\u8f6e\u8be2\u53d1\u7968\u8d44\u6599\u7684\u901a\u77e5\u5355,count=" + invoiceList.size() + ",dataMap=" + dataMap);
        BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
        getInvoiceDataReqBO.setIdMap(dataMap);
        getInvoiceDataReqBO.setOrgIdMap(orgIdMap);
        List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
        if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
            LOGGER.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u6570\u636e\uff0c\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        ArrayList list = new ArrayList();
        rspBO.setResultList(list);
        return this.dealData(invoiceDataList, rspBO);
    }
}

