/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.BusiGetOriginalDocumentsFromErpService;
import com.tydic.pfscext.api.busi.bo.BusiGetDOcumentsInfoRspBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.dao.vo.BillSummaryInfoConditionVO;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiPurchaseStorageConsumptionSummaryService;
import com.tydic.pfscext.external.api.bo.BusiConsumptionSummaryInfoRspBO;
import com.tydic.pfscext.external.api.bo.BusiConsumptionSummaryReqBO;
import com.tydic.pfscext.external.api.bo.BusiConsumptionSummaryRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetOriginalDocumentErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetOriginalDocumentsByTSReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetOriginalDocumentsItemRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetOriginalDocumentsReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetOriginalDocumentsRspBO;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentSummaryInfoRspBO;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentSummaryItem;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentSummaryReqBO;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentSummaryRspBO;
import com.tydic.pfscext.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetOriginalDocumentsFromErpService.class)
public class BusiGetOriginalDocumentsFromErpServiceImpl
implements BusiGetOriginalDocumentsFromErpService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetOriginalDocumentsFromErpServiceImpl.class);
    @Resource
    private CacheClient cacheService;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BusiPurchaseStorageConsumptionSummaryService purchaseStorageConsumptionSummaryService;
    @Value(value="${ERP_TYPE_SYN_DATA_TIME:2021-08-05 00:00:00}")
    private String ERP_TYPE_SYN_DATA_TIME;
    @Value(value="${ERP_TYPE_SYN_DATA_END_TIME:2021-08-05 00:00:00}")
    private String ERP_TYPE_SYN_DATA_END_TIME;
    @Value(value="${ERP_TYPE_SYN_TAKE_EFFECT:0}")
    private String ERP_TYPE_SYN_TAKE_EFFECT;
    private final String TAKE_EFFECT = "1";
    @Value(value="${ERP_TYPE_SYN_DATA_PAGE_SIZE:100}")
    private String ERP_TYPE_SYN_DATA_PAGE_SIZE;
    private final String TYPE_PURCHASE_STORAGE = "ERP_TYPE_SYN_DATA_PURCHASE_STORAGE";
    private final String TYPE_PRICE_SETTLEMENT = "ERP_TYPE_SYN_DATA_PRICE_SETTLEMENT";
    private final String TYPE_CONSUMPTION_SUMMARY = "ERP_TYPE_SYN_DATA_CONSUMPTION_SUMMARY";

    public BusiGetDOcumentsInfoRspBO getOriginalDocuments() {
        log.info("\u540c\u6b65erp\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        PfscExtRspBaseBO purchaseStorages = this.getSynPurchaseStorages();
        PfscExtRspBaseBO priceSettlements = this.getSynPriceSettlements();
        PfscExtRspBaseBO consumptionSummaries = this.getSynConsumptionSummaries();
        BusiGetDOcumentsInfoRspBO rspBO = new BusiGetDOcumentsInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u540c\u6b65erp\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
        return rspBO;
    }

    public PfscExtRspBaseBO getSynPurchaseStorages() {
        log.info("==============\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93==============");
        String timestamp = this.getTimestamp("ERP_TYPE_SYN_DATA_PURCHASE_STORAGE");
        BusiGetOriginalDocumentsByTSReqBO reqBO = new BusiGetOriginalDocumentsByTSReqBO();
        reqBO.setStartTS(timestamp);
        reqBO.setEndTS(this.getEndTimestamp());
        BusiGetOriginalDocumentsRspBO erpRspBO = this.purchaseStorageConsumptionSummaryService.getOriginalDocumentFromErpByTS(reqBO);
        ArrayList<OriginalDocumentsInfo> originalDocumentsInfoList = new ArrayList<OriginalDocumentsInfo>();
        ArrayList<BillSummaryInfo> billSummaryInfos = new ArrayList<BillSummaryInfo>();
        if (erpRspBO.getDataList() != null && erpRspBO.getDataList().size() > 0) {
            List dataList = erpRspBO.getDataList();
            Date datats = dataList.stream().filter(item -> item.getDatats() != null).map(BusiGetOriginalDocumentErpRspBO::getDatats).distinct().max((t1, t2) -> t1.compareTo((Date)t2)).get();
            this.initDataOriginalDocumentFromErp(originalDocumentsInfoList, billSummaryInfos, dataList);
            log.info("erp-\u540c\u6b65-\u91c7\u8d2d\u5165\u5e93-\u4e3b\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(originalDocumentsInfoList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            log.info("erp-\u540c\u6b65-\u91c7\u8d2d\u5165\u5e93-\u5b50\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.insertOrUpdateData(originalDocumentsInfoList, billSummaryInfos);
            this.setTimestamp("ERP_TYPE_SYN_DATA_PURCHASE_STORAGE", datats);
        }
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u91c7\u8d2d\u5165\u5e93\u540c\u6b65\u7ed3\u675f");
        return rspBO;
    }

    public PfscExtRspBaseBO getSynPriceSettlements() {
        log.info("==============\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355==============");
        String timestamp = this.getTimestamp("ERP_TYPE_SYN_DATA_PRICE_SETTLEMENT");
        BusiGetOriginalDocumentsByTSReqBO reqBO = new BusiGetOriginalDocumentsByTSReqBO();
        reqBO.setStartTS(timestamp);
        reqBO.setEndTS(this.getEndTimestamp());
        BusiOriginalDocumentSummaryRspBO erpRspBO = this.purchaseStorageConsumptionSummaryService.getOriginalDocumentSummeryErpByTS(reqBO);
        ArrayList<OriginalDocumentsInfo> originalDocumentsInfoList = new ArrayList<OriginalDocumentsInfo>();
        ArrayList<BillSummaryInfo> billSummaryInfos = new ArrayList<BillSummaryInfo>();
        if (erpRspBO.getDataList() != null && erpRspBO.getDataList().size() > 0) {
            List dataList = erpRspBO.getDataList();
            Date datats = dataList.stream().filter(item -> item.getDatats() != null).map(BusiOriginalDocumentSummaryInfoRspBO::getDatats).distinct().max((t1, t2) -> t1.compareTo((Date)t2)).get();
            this.initDataOriginalDocumentSummeryErp(originalDocumentsInfoList, billSummaryInfos, dataList);
            log.info("erp-\u540c\u6b65-\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b-\u4e3b\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(originalDocumentsInfoList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            log.info("erp-\u540c\u6b65-\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b-\u5b50\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.insertOrUpdateData(originalDocumentsInfoList, billSummaryInfos);
            this.setTimestamp("ERP_TYPE_SYN_DATA_PRICE_SETTLEMENT", datats);
        }
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u540c\u6b65\u7ed3\u675f");
        return rspBO;
    }

    public PfscExtRspBaseBO getSynConsumptionSummaries() {
        log.info("==============\u83b7\u53d6\u6d88\u8017\u6c47\u603b==============");
        String timestamp = this.getTimestamp("ERP_TYPE_SYN_DATA_CONSUMPTION_SUMMARY");
        BusiConsumptionSummaryReqBO busiConsumptionSummaryReqBO = new BusiConsumptionSummaryReqBO();
        busiConsumptionSummaryReqBO.setPageSize(this.getErpPageSize());
        busiConsumptionSummaryReqBO.setPageNum(Integer.valueOf(1));
        busiConsumptionSummaryReqBO.setTbStartTime(timestamp);
        busiConsumptionSummaryReqBO.setInvoiceStatus(Integer.valueOf(2));
        BusiConsumptionSummaryRspBO erpRspBO = this.purchaseStorageConsumptionSummaryService.getConsumptionSummaryErp(busiConsumptionSummaryReqBO);
        ArrayList<OriginalDocumentsInfo> originalDocumentsInfoList = new ArrayList<OriginalDocumentsInfo>();
        ArrayList<BillSummaryInfo> billSummaryInfos = new ArrayList<BillSummaryInfo>();
        if (erpRspBO.getVmisum() != null && erpRspBO.getVmisum().size() > 0) {
            List dataList = erpRspBO.getVmisum();
            Date datats = dataList.stream().filter(item -> item.getDatats() != null).map(BusiConsumptionSummaryInfoRspBO::getDatats).distinct().max((t1, t2) -> t1.compareTo((Date)t2)).get();
            this.initDataConsumptionSummaryErp(originalDocumentsInfoList, billSummaryInfos, dataList);
            log.info("erp-\u540c\u6b65-\u6d88\u8017\u6c47\u603b-\u4e3b\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(originalDocumentsInfoList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            log.info("erp-\u540c\u6b65-\u6d88\u8017\u6c47\u603b-\u5b50\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.insertOrUpdateData(originalDocumentsInfoList, billSummaryInfos);
            this.setTimestamp("ERP_TYPE_SYN_DATA_CONSUMPTION_SUMMARY", datats);
        }
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u8017\u6c47\u603b\u540c\u6b65\u7ed3\u675f");
        return rspBO;
    }

    private String getTimestamp(String type) {
        String timestamp = (String)this.cacheService.get(type, String.class);
        log.debug("\u8bfb\u53d6redis\u7f13\u5b58\u6570\u636ekey\uff1a{}.value:{}", (Object)type, (Object)timestamp);
        if (!StringUtils.hasText((String)timestamp)) {
            timestamp = LocalDateTime.now().minusMinutes(5L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        if ("1".equals(this.ERP_TYPE_SYN_TAKE_EFFECT)) {
            timestamp = this.ERP_TYPE_SYN_DATA_TIME;
        }
        return timestamp;
    }

    private String getEndTimestamp() {
        if ("1".equals(this.ERP_TYPE_SYN_TAKE_EFFECT)) {
            try {
                Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(this.ERP_TYPE_SYN_DATA_END_TIME);
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(parse);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void setTimestamp(String type, Date datats) {
        log.debug("\u7c7b\u578b\uff1a{}.\u65f6\u95f4\u6233\uff1a{}", (Object)type, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datats));
        try {
            Date parse;
            String timestamp = (String)this.cacheService.get(type, String.class);
            if (Objects.nonNull(timestamp) && (parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(timestamp)).getTime() < datats.getTime()) {
                log.debug("\u8bbe\u7f6eredis\u7f13\u5b58\u6570\u636ekey\uff1a{}.value:{}", (Object)type, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datats));
                this.cacheService.set(type, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datats));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug("\u8bbe\u7f6eredis\u7f13\u5b58\u6570\u636ekey\uff1a{}.value:{}", (Object)type, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datats));
        this.cacheService.set(type, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datats));
    }

    private Integer getErpPageSize() {
        try {
            Integer pageSize = Integer.valueOf(this.ERP_TYPE_SYN_DATA_PAGE_SIZE);
            return pageSize;
        }
        catch (NumberFormatException e) {
            log.error("\u67e5\u8be2\u6570\u636e\u6761\u6570\u8f6c\u6362int\u9519\u8bef\uff1a{}", (Object)this.ERP_TYPE_SYN_DATA_PAGE_SIZE);
            return 100;
        }
    }

    public BusiGetDOcumentsInfoRspBO getOriginalDocuments111(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("\u5f00\u59cb\u540c\u6b65\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a\u3010{}\u3011,\u7ed3\u675f\u65f6\u95f4\uff1a\u3010{}\u3011", (Object)startDate, (Object)endDate);
        log.info("==============\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93==============");
        BusiGetOriginalDocumentsReqBO busiGetOriginalDocumentsReqBO = new BusiGetOriginalDocumentsReqBO();
        busiGetOriginalDocumentsReqBO.setPageSize(Integer.valueOf(1000));
        busiGetOriginalDocumentsReqBO.setPageNum(Integer.valueOf(1));
        busiGetOriginalDocumentsReqBO.setTbStartTime(startDate);
        busiGetOriginalDocumentsReqBO.setTbEndTime(endDate);
        busiGetOriginalDocumentsReqBO.setInvoiceStatus(Integer.valueOf(2));
        BusiGetOriginalDocumentsRspBO busiGetOriginalDocumentsRspBO = this.purchaseStorageConsumptionSummaryService.getOriginalDocumentFromErp(busiGetOriginalDocumentsReqBO);
        log.info("==============\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355==============");
        BusiOriginalDocumentSummaryReqBO busiOriginalDocumentSummaryReqBO = new BusiOriginalDocumentSummaryReqBO();
        busiOriginalDocumentSummaryReqBO.setPageSize(Integer.valueOf(1000));
        busiOriginalDocumentSummaryReqBO.setPageNum(Integer.valueOf(1));
        busiOriginalDocumentSummaryReqBO.setTbStartTime(startDate);
        busiOriginalDocumentSummaryReqBO.setTbEndDate(endDate);
        busiOriginalDocumentSummaryReqBO.setInvoiceStatus(Integer.valueOf(2));
        BusiOriginalDocumentSummaryRspBO busiOriginalDocumentSummaryRspBO = this.purchaseStorageConsumptionSummaryService.getOriginalDocumentSummeryErp(busiOriginalDocumentSummaryReqBO);
        log.info("==============\u83b7\u53d6\u6d88\u8017\u6c47\u603b==============");
        BusiConsumptionSummaryReqBO busiConsumptionSummaryReqBO = new BusiConsumptionSummaryReqBO();
        busiConsumptionSummaryReqBO.setPageSize(Integer.valueOf(1000));
        busiConsumptionSummaryReqBO.setPageNum(Integer.valueOf(1));
        busiConsumptionSummaryReqBO.setTbStartTime(startDate);
        busiConsumptionSummaryReqBO.setTbEndDate(endDate);
        busiConsumptionSummaryReqBO.setInvoiceStatus(Integer.valueOf(2));
        BusiConsumptionSummaryRspBO busiConsumptionSummaryRspBO = this.purchaseStorageConsumptionSummaryService.getConsumptionSummaryErp(busiConsumptionSummaryReqBO);
        ArrayList<OriginalDocumentsInfo> originalDocumentsInfoList = new ArrayList<OriginalDocumentsInfo>();
        ArrayList<BillSummaryInfo> billSummaryInfos = new ArrayList<BillSummaryInfo>();
        if (busiGetOriginalDocumentsRspBO.getDataList() != null && busiGetOriginalDocumentsRspBO.getDataList().size() > 0) {
            List documentsRspDataList = busiGetOriginalDocumentsRspBO.getDataList();
            this.initDataOriginalDocumentFromErp(originalDocumentsInfoList, billSummaryInfos, documentsRspDataList);
        }
        if (busiOriginalDocumentSummaryRspBO.getDataList() != null && busiOriginalDocumentSummaryRspBO.getDataList().size() > 0) {
            List summaryRspDataList = busiOriginalDocumentSummaryRspBO.getDataList();
            this.initDataOriginalDocumentSummeryErp(originalDocumentsInfoList, billSummaryInfos, summaryRspDataList);
        }
        if (busiConsumptionSummaryRspBO.getVmisum() != null && busiConsumptionSummaryRspBO.getVmisum().size() > 0) {
            List consumptionList = busiConsumptionSummaryRspBO.getVmisum();
            this.initDataConsumptionSummaryErp(originalDocumentsInfoList, billSummaryInfos, consumptionList);
        }
        log.info("\u91c7\u8d2d\u5165\u5e93\u539f\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)busiGetOriginalDocumentsRspBO.getDataList()));
        log.info("\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u539f\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)busiGetOriginalDocumentsRspBO.getDataList()));
        log.info("\u6d88\u8017\u6c47\u603b\u539f\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)busiGetOriginalDocumentsRspBO.getDataList()));
        log.info("erp-\u540c\u6b65-\u4e3b\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(originalDocumentsInfoList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("erp-\u540c\u6b65-\u5b50\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(billSummaryInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        this.insertOrUpdateData(originalDocumentsInfoList, billSummaryInfos);
        BusiGetDOcumentsInfoRspBO rspBO = new BusiGetDOcumentsInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void insertOrUpdateData(List<OriginalDocumentsInfo> infoList, List<BillSummaryInfo> billSummaryInfos) {
        if (!CollectionUtils.isEmpty(infoList)) {
            int n;
            List<String> documentNoList = infoList.stream().map(OriginalDocumentsInfo::getDocumentNo).collect(Collectors.toList());
            List<String> documentNos = this.originalDocumentsInfoMapper.selectCountByDocumentNos(documentNoList);
            if (CollectionUtils.isEmpty(documentNos)) {
                try {
                    int n2;
                    for (BillSummaryInfo billSummaryInfo : billSummaryInfos) {
                        n2 = this.billSummaryInfoMapper.insert(billSummaryInfo);
                    }
                    for (OriginalDocumentsInfo originalDocumentsInfo : infoList) {
                        n2 = this.originalDocumentsInfoMapper.insert(originalDocumentsInfo);
                    }
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                    throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
                }
            }
            List subInsertDocumentsInfos = infoList.stream().filter(item -> !documentNos.contains(item.getDocumentNo())).collect(Collectors.toList());
            List subInsertSummaryInfos = billSummaryInfos.stream().filter(item -> !documentNos.contains(item.getStatementNo())).collect(Collectors.toList());
            try {
                for (OriginalDocumentsInfo insertDocumentsInfo : subInsertDocumentsInfos) {
                    n = this.originalDocumentsInfoMapper.insert(insertDocumentsInfo);
                }
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
            }
            try {
                for (BillSummaryInfo billSummaryInfo : subInsertSummaryInfos) {
                    n = this.billSummaryInfoMapper.insert(billSummaryInfo);
                }
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
            }
            List<OriginalDocumentsInfo> updateInfoList = infoList.stream().filter(item -> documentNos.contains(item.getDocumentNo())).collect(Collectors.toList());
            if (updateInfoList.size() > 0) {
                List<BillSummaryInfo> updateSummaryInfos = billSummaryInfos.stream().filter(item -> documentNos.contains(item.getStatementNo())).collect(Collectors.toList());
                this.updateDataOperate(updateInfoList, updateSummaryInfos);
            }
        }
    }

    private void updateDataOperate(List<OriginalDocumentsInfo> updateInfoList, List<BillSummaryInfo> updateSummaryInfos) {
        List<String> documents = updateSummaryInfos.stream().map(BillSummaryInfo::getStatementNo).distinct().collect(Collectors.toList());
        BillSummaryInfoConditionVO conditionVO = new BillSummaryInfoConditionVO();
        conditionVO.setStatementNoListIn(documents);
        conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
        List<BillSummaryInfo> localSummaryInfos = this.billSummaryInfoMapper.getList(conditionVO);
        Map<String, List<BillSummaryInfo>> localSummaryInfosMap = localSummaryInfos.stream().collect(Collectors.groupingBy(BillSummaryInfo::getStatementNo));
        Map<String, List<BillSummaryInfo>> updateSummaryInfosMap = updateSummaryInfos.stream().collect(Collectors.groupingBy(BillSummaryInfo::getStatementNo));
        for (OriginalDocumentsInfo itemInfo : updateInfoList) {
            List<BillSummaryInfo> summaryInfosLocal = localSummaryInfosMap.get(itemInfo.getDocumentNo());
            List<BillSummaryInfo> summaryInfosUpdate = updateSummaryInfosMap.get(itemInfo.getDocumentNo());
            Set extBodyIdSet = summaryInfosLocal.stream().map(BillSummaryInfo::getExtBodyId).collect(Collectors.toSet());
            long count = summaryInfosUpdate.stream().filter(item -> !extBodyIdSet.contains(item.getExtBodyId())).count();
            if (count > 0L) {
                for (BillSummaryInfo billSummaryInfo : summaryInfosLocal) {
                    BillSummaryInfo record = new BillSummaryInfo();
                    record.setId(billSummaryInfo.getId());
                    record.setEffectiveState(EffectiveState.NOT_EFFECT.getCode());
                    this.billSummaryInfoMapper.updateByPrimaryKeySelective(record);
                }
                try {
                    for (BillSummaryInfo billSummaryInfo : summaryInfosUpdate) {
                        int record = this.billSummaryInfoMapper.insert(billSummaryInfo);
                    }
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                    throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
                }
            } else {
                Map<String, BillSummaryInfo> localSummaryInfosItemMap = localSummaryInfos.stream().collect(Collectors.toMap(BillSummaryInfo::getExtBodyId, item -> item, (oldValue, newValue) -> newValue));
                for (BillSummaryInfo summaryFilterInfo : summaryInfosUpdate) {
                    BillSummaryInfo billSummaryInfo = localSummaryInfosItemMap.get(summaryFilterInfo.getExtBodyId());
                    summaryFilterInfo.setId(billSummaryInfo.getId());
                    try {
                        summaryFilterInfo.setInvoiceStatus(null);
                        summaryFilterInfo.setInvoicedQuantity(null);
                        int n = this.billSummaryInfoMapper.updateByPrimaryKeySelective(summaryFilterInfo);
                    }
                    catch (Exception e) {
                        log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                        throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
                    }
                }
            }
            try {
                itemInfo.setInvoiceStatus(null);
                int localSummaryInfosItemMap = this.originalDocumentsInfoMapper.updateByPrimaryKeySelective(itemInfo);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
    }

    private void initDataConsumptionSummaryErp(List<OriginalDocumentsInfo> originalDocumentsInfoList, List<BillSummaryInfo> billSummaryInfos, List<BusiConsumptionSummaryInfoRspBO> consumptionList) {
        for (BusiConsumptionSummaryInfoRspBO busiConsumptionSummaryInfoRspBO : consumptionList) {
            OriginalDocumentsInfo originalDocumentsInfo = new OriginalDocumentsInfo();
            this.convert(busiConsumptionSummaryInfoRspBO, originalDocumentsInfo);
            log.info("\u6d88\u8017\u6c47\u603b\uff1a{}", (Object)JSON.toJSONString((Object)originalDocumentsInfo));
            originalDocumentsInfo.setBillType("3");
            originalDocumentsInfo.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            originalDocumentsInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
            originalDocumentsInfoList.add(originalDocumentsInfo);
            BillSummaryInfo billSummaryInfo = new BillSummaryInfo();
            long nextId = Sequence.getInstance().nextId();
            billSummaryInfo.setId(String.valueOf(nextId));
            billSummaryInfo.setBillType("3");
            billSummaryInfo.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            billSummaryInfo.setMaterialCode(originalDocumentsInfo.getMaterialCode());
            billSummaryInfo.setMaterialName(originalDocumentsInfo.getMaterialName());
            billSummaryInfo.setUnit(originalDocumentsInfo.getUnit());
            billSummaryInfo.setSpecification(originalDocumentsInfo.getSpecification());
            billSummaryInfo.setModel(originalDocumentsInfo.getModel());
            billSummaryInfo.setTaxRate(busiConsumptionSummaryInfoRspBO.getTaxRate());
            billSummaryInfo.setNoTaxPrice(busiConsumptionSummaryInfoRspBO.getNoTaxPrice());
            billSummaryInfo.setStatementNo(originalDocumentsInfo.getDocumentNo());
            billSummaryInfo.setSettlementQuantity(originalDocumentsInfo.getSumTotalNum());
            billSummaryInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
            billSummaryInfo.setExtBodyId(originalDocumentsInfo.getSummeryHeadId());
            billSummaryInfo.setInventoryQuantity(busiConsumptionSummaryInfoRspBO.getSumTotalNum());
            billSummaryInfo.setInvoicedQuantity(busiConsumptionSummaryInfoRspBO.getInvoicedNum());
            this.initData(busiConsumptionSummaryInfoRspBO, originalDocumentsInfo, billSummaryInfo);
            this.initDataSetAmoutScale(billSummaryInfo);
            billSummaryInfos.add(billSummaryInfo);
        }
    }

    private void initData(BusiConsumptionSummaryInfoRspBO busiConsumptionSummaryInfoRspBO, OriginalDocumentsInfo originalDocumentsInfo, BillSummaryInfo billSummaryInfo) {
        String actualReceiveCount = originalDocumentsInfo.getSumTotalNum();
        BigDecimal receiveCount = this.getString2BigDecimal(actualReceiveCount, false);
        BigDecimal quantity = this.getString2BigDecimal(originalDocumentsInfo.getInvoicedNum(), false);
        if (StringUtils.hasText((String)originalDocumentsInfo.getSumTotalNum())) {
            BigDecimal num = receiveCount.subtract(quantity).setScale(2, 4);
            billSummaryInfo.setInvoicableQuantity(num.toString());
            BigDecimal noTaxPrice = this.getString2BigDecimal(originalDocumentsInfo.getNoTaxPrice(), false);
            BigDecimal taxRate = this.getString2BigDecimal(busiConsumptionSummaryInfoRspBO.getTaxRate(), false);
            BigDecimal taxPrice = noTaxPrice.multiply(new BigDecimal(100).add(taxRate)).divide(new BigDecimal(100)).setScale(4, 4);
            billSummaryInfo.setTaxPrice(taxPrice.toString());
            BigDecimal invoicableAmt = num.multiply(taxPrice).setScale(2, 4);
            billSummaryInfo.setInvoicableAmt(invoicableAmt.toString());
            BigDecimal noTaxAmt = num.multiply(noTaxPrice).setScale(2, 4);
            billSummaryInfo.setNoTaxAmt(noTaxAmt.toString());
            BigDecimal tax = invoicableAmt.subtract(noTaxAmt).setScale(2, 4);
            billSummaryInfo.setTax(tax.toString());
        }
    }

    private void initDataOriginalDocumentSummeryErp(List<OriginalDocumentsInfo> originalDocumentsInfoList, List<BillSummaryInfo> billSummaryInfos, List<BusiOriginalDocumentSummaryInfoRspBO> summaryRspDataList) {
        for (BusiOriginalDocumentSummaryInfoRspBO busiOriginalDocumentSummaryInfoRspBO : summaryRspDataList) {
            OriginalDocumentsInfo originalDocumentsInfo = new OriginalDocumentsInfo();
            this.convert(busiOriginalDocumentSummaryInfoRspBO, originalDocumentsInfo);
            log.info("\u4ef7\u683c\u7ed3\u7b97\uff1a{}", (Object)JSON.toJSONString((Object)originalDocumentsInfo));
            originalDocumentsInfo.setBillType("1");
            originalDocumentsInfo.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            originalDocumentsInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
            originalDocumentsInfo.setPartySettlement(StringUtils.hasText((String)originalDocumentsInfo.getPartySettlement()) ? originalDocumentsInfo.getPartySettlement() : "N");
            originalDocumentsInfoList.add(originalDocumentsInfo);
            List bvos = busiOriginalDocumentSummaryInfoRspBO.getBvos();
            for (BusiOriginalDocumentSummaryItem bvo : bvos) {
                log.info("\u4ef7\u683c\u7ed3\u7b97\u5b50\u8868erp\uff1a{}", (Object)JSON.toJSONString((Object)bvo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                BillSummaryInfo billSummaryInfo = new BillSummaryInfo();
                this.convert(bvo, billSummaryInfo);
                log.info("\u4ef7\u683c\u7ed3\u7b97\u5b50\u8868\uff1a{}", (Object)JSON.toJSONString((Object)billSummaryInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                long nextId = Sequence.getInstance().nextId();
                billSummaryInfo.setId(String.valueOf(nextId));
                billSummaryInfo.setBillType("1");
                billSummaryInfo.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                billSummaryInfo.setStatementNo(originalDocumentsInfo.getDocumentNo());
                billSummaryInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                billSummaryInfo.setOriginalDeliverNum(BigDecimalUtils.getStr2BigDecimal(bvo.getOriginalDeliverNum()).setScale(2, 4).toString());
                billSummaryInfo.setActualReceiptNum(BigDecimalUtils.getStr2BigDecimal(bvo.getActualReceiptNum()).setScale(2, 4).toString());
                billSummaryInfo.setSettlementQuantity(BigDecimalUtils.getStr2BigDecimal(bvo.getSettlementQuantity()).setScale(2, 4).toString());
                billSummaryInfo.setContractPrice(BigDecimalUtils.getStr2BigDecimal(bvo.getContractPrice()).setScale(4, 4).toString());
                billSummaryInfo.setSettlementPrice(BigDecimalUtils.getStr2BigDecimal(bvo.getSettlementPrice()).setScale(4, 4).toString());
                billSummaryInfo.setApplyPayAmt(BigDecimalUtils.getStr2BigDecimal(bvo.getApplyPayAmt()).setScale(2, 4).toString());
                billSummaryInfo.setNoTaxPrice(BigDecimalUtils.getStr2BigDecimal(bvo.getNoTaxPrice()).setScale(4, 4).toString());
                billSummaryInfo.setNoTaxAmt(BigDecimalUtils.getStr2BigDecimal(bvo.getNoTaxAmt()).setScale(2, 4).toString());
                billSummaryInfo.setConsAcceptAmt(BigDecimalUtils.getStr2BigDecimal(bvo.getConsAcceptAmt()).setScale(2, 4).toString());
                billSummaryInfo.setConsAcceptCount(BigDecimalUtils.getStr2BigDecimal(bvo.getConsAcceptCount()).setScale(2, 4).toString());
                billSummaryInfo.setPriceTaxTotal(BigDecimalUtils.getStr2BigDecimal(bvo.getPriceTaxTotal()).setScale(2, 4).toString());
                billSummaryInfo.setInventoryQuantity(BigDecimalUtils.getStr2BigDecimal(bvo.getSettlementQuantity()).setScale(2, 4).toString());
                billSummaryInfo.setInvoicedQuantity("0.00");
                billSummaryInfos.add(billSummaryInfo);
            }
        }
    }

    private void initDataOriginalDocumentFromErp(List<OriginalDocumentsInfo> originalDocumentsInfoList, List<BillSummaryInfo> billSummaryInfos, List<BusiGetOriginalDocumentErpRspBO> documentsRspDataList) {
        for (BusiGetOriginalDocumentErpRspBO busiGetOriginalDocumentErpRspBO : documentsRspDataList) {
            OriginalDocumentsInfo originalDocumentsInfo = new OriginalDocumentsInfo();
            this.convert(busiGetOriginalDocumentErpRspBO, originalDocumentsInfo);
            log.info("\u91c7\u8d2d\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)originalDocumentsInfo));
            originalDocumentsInfo.setBillType("2");
            originalDocumentsInfo.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            originalDocumentsInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
            originalDocumentsInfoList.add(originalDocumentsInfo);
            List bvos = busiGetOriginalDocumentErpRspBO.getBvos();
            for (BusiGetOriginalDocumentsItemRspBO bvo : bvos) {
                BillSummaryInfo billSummaryInfo = new BillSummaryInfo();
                this.convert(bvo, billSummaryInfo);
                log.info("\u91c7\u8d2d\u5165\u5e93\u5b50\u8868\uff1a{}", (Object)JSON.toJSONString((Object)billSummaryInfo));
                long nextId = Sequence.getInstance().nextId();
                billSummaryInfo.setId(String.valueOf(nextId));
                billSummaryInfo.setBillType("2");
                billSummaryInfo.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                billSummaryInfo.setStatementNo(originalDocumentsInfo.getDocumentNo());
                billSummaryInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                billSummaryInfo.setInventoryQuantity(billSummaryInfo.getActualReceiveCount());
                billSummaryInfo.setInvoicedQuantity(billSummaryInfo.getCumuInvoicableQuantity());
                String actualReceiveCount = bvo.getActualReceiveCount();
                BigDecimal receiveCount = this.getString2BigDecimal(actualReceiveCount, false);
                BigDecimal quantity = this.getString2BigDecimal(bvo.getCumuInvoicableQuantity(), false);
                if (StringUtils.hasText((String)actualReceiveCount)) {
                    BigDecimal num = receiveCount.subtract(quantity).setScale(2, 4);
                    billSummaryInfo.setInvoicableQuantity(num.toString());
                    BigDecimal taxPrice = this.getString2BigDecimal(bvo.getTaxPrice(), false);
                    BigDecimal invoicableAmt = num.multiply(taxPrice).setScale(2, 4);
                    billSummaryInfo.setInvoicableAmt(invoicableAmt.toString());
                    if (!StringUtils.hasText((String)bvo.getTax()) && StringUtils.hasText((String)bvo.getNoTaxAmt())) {
                        BigDecimal noTaxAmt = this.getString2BigDecimal(bvo.getNoTaxAmt(), false);
                        billSummaryInfo.setTax(invoicableAmt.subtract(noTaxAmt).toString());
                    }
                }
                this.initDataSetAmoutScale(billSummaryInfo);
                billSummaryInfos.add(billSummaryInfo);
            }
        }
    }

    private void initDataSetAmoutScale(BillSummaryInfo billSummaryInfo) {
        billSummaryInfo.setTaxPrice(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getTaxPrice()).setScale(4, 4).toString());
        billSummaryInfo.setTax(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getTax()).setScale(2, 4).toString());
        billSummaryInfo.setPriceTaxTotal(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getPriceTaxTotal()).setScale(2, 4).toString());
        billSummaryInfo.setInvoicableAmt(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getInvoicableAmt()).setScale(2, 4).toString());
        billSummaryInfo.setInvoicableQuantity(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getInvoicableQuantity()).setScale(2, 4).toString());
        billSummaryInfo.setCumuInvoicableQuantity(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getCumuInvoicableQuantity()).setScale(2, 4).toString());
        billSummaryInfo.setActualReceiveMainCount(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getActualReceiveMainCount()).setScale(2, 4).toString());
        billSummaryInfo.setActualReceiveCount(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getActualReceiveCount()).setScale(2, 4).toString());
        billSummaryInfo.setReceivableMainCount(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getReceivableMainCount()).setScale(2, 4).toString());
        billSummaryInfo.setReceivableCount(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getReceivableCount()).setScale(2, 4).toString());
        billSummaryInfo.setNoTaxAmt(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getNoTaxAmt()).setScale(2, 4).toString());
        billSummaryInfo.setNoTaxPrice(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getNoTaxPrice()).setScale(4, 4).toString());
        billSummaryInfo.setApplyPayAmt(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getApplyPayAmt()).setScale(2, 4).toString());
        billSummaryInfo.setSettlementPrice(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getSettlementPrice()).setScale(4, 4).toString());
        billSummaryInfo.setContractPrice(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getContractPrice()).setScale(4, 4).toString());
        billSummaryInfo.setSettlementQuantity(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getSettlementQuantity()).setScale(2, 4).toString());
        billSummaryInfo.setActualReceiptNum(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getActualReceiptNum()).setScale(2, 4).toString());
        billSummaryInfo.setOriginalDeliverNum(BigDecimalUtils.getStr2BigDecimal(billSummaryInfo.getOriginalDeliverNum()).setScale(2, 4).toString());
    }

    private BigDecimal getString2BigDecimal(String strNum, Boolean resultNull) {
        BigDecimal num = BigDecimal.ZERO;
        if (resultNull == null || !resultNull.booleanValue()) {
            if (StringUtils.hasText((String)strNum)) {
                try {
                    num = num.add(new BigDecimal(strNum));
                    return num;
                }
                catch (Exception e) {
                    return num;
                }
            }
            return num;
        }
        if (StringUtils.hasText((String)strNum)) {
            try {
                num = num.add(new BigDecimal(strNum));
                return num;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void convert(Object source, Object target) {
        BeanCopier copy = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        copy.copy(source, target, null);
    }
}

