/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.aop.annotation.FscCommitDateLimit;
import com.tydic.pfscext.api.busi.BusiGetOriginalDocumentsInfoPageService;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsInfoPageReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsInfoPageRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsInfoRspBO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.umc.api.UmcPurSupInfoListQryExternalService;
import com.tydic.pfscext.service.comb.api.FscOriginalDocumentsInfoCombService;
import com.tydic.pfscext.service.comb.bo.FscConsumptionSummaryReqBO;
import com.tydic.pfscext.service.comb.bo.FscConsumptionSummaryRspBO;
import com.tydic.pfscext.service.comb.bo.FscPriceSettlementReqBO;
import com.tydic.pfscext.service.comb.bo.FscPriceSettlementRspBO;
import com.tydic.pfscext.service.comb.bo.FscPurchaseStorageReqBO;
import com.tydic.pfscext.service.comb.bo.FscPurchaseStorageRspBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetOriginalDocumentsInfoPageService.class)
public class BusiGetOriginalDocumentsInfoPageServiceImpl
implements BusiGetOriginalDocumentsInfoPageService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetOriginalDocumentsInfoPageServiceImpl.class);
    @Autowired
    private FscOriginalDocumentsInfoCombService fscOriginalDocumentsInfoCombService;
    @Autowired
    private UmcPurSupInfoListQryExternalService umcPurSupInfoListQryExternalService;

    @FscCommitDateLimit(fieldName="startDate")
    public BusiGetOriginalDocumentsInfoPageRspBO getPageInfo(BusiGetOriginalDocumentsInfoPageReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u672a\u5f00\u7968\u6570\u636e\u5206\u9875\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        this.checkParams(reqBO);
        String type = reqBO.getType();
        if (CtrantType.RAW_COAL.getCode().equals(type)) {
            return this.getPriceSettlementSummary(reqBO);
        }
        if (CtrantType.CHEMICAL.getCode().equals(type)) {
            return this.getPriceSettlementSummary(reqBO);
        }
        if (CtrantType.CHEMICAL_STORE.getCode().equals(type)) {
            reqBO.setType(null);
            return this.getPurchaseStorageSummary(reqBO, null);
        }
        if (CtrantType.NON_HOSTED.getCode().equals(type)) {
            reqBO.setType(null);
            return this.getPurchaseStorageSummary(reqBO, "bpbj");
        }
        if (CtrantType.HOSTED.getCode().equals(type)) {
            return this.getConsumptionSummary(reqBO);
        }
        throw new PfscExtBusinessException("18000", "\u672a\u77e5\u7c7b\u522btype:" + type);
    }

    private BusiGetOriginalDocumentsInfoPageRspBO getPriceSettlementSummary(BusiGetOriginalDocumentsInfoPageReqBO reqBO) {
        BusiGetOriginalDocumentsInfoPageRspBO rspBO = new BusiGetOriginalDocumentsInfoPageRspBO();
        ArrayList rows = new ArrayList();
        FscPriceSettlementReqBO settlementReqBO = new FscPriceSettlementReqBO();
        this.convert(reqBO, settlementReqBO);
        settlementReqBO.setPkOrg(reqBO.getPurDeptId());
        settlementReqBO.setDocumentNo(reqBO.getStatementNo());
        settlementReqBO.setSettlementSupplier(this.umcPurSupInfoListQryExternalService.getCreditNoFromUMC(reqBO.getSettlementSupplier()));
        settlementReqBO.setCoalSupplierId(this.umcPurSupInfoListQryExternalService.getCreditNoFromUMC(reqBO.getCoalSupplierId()));
        FscPriceSettlementRspBO settlementsErp = this.fscOriginalDocumentsInfoCombService.getPriceSettlementsErp(settlementReqBO);
        if (!CollectionUtils.isEmpty(settlementsErp.getInfoList())) {
            rows.addAll(JSON.parseArray((String)JSON.toJSONString(settlementsErp.getInfoList()), BusiGetOriginalDocumentsInfoRspBO.class));
        }
        rspBO.setRows(rows);
        Integer recordsTotal = settlementsErp.getRecordsTotal();
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\u5217\u8868\u6210\u529f");
        return rspBO;
    }

    private BusiGetOriginalDocumentsInfoPageRspBO getPurchaseStorageSummary(BusiGetOriginalDocumentsInfoPageReqBO reqBO, String billType) {
        BusiGetOriginalDocumentsInfoPageRspBO rspBO = new BusiGetOriginalDocumentsInfoPageRspBO();
        ArrayList rows = new ArrayList();
        FscPurchaseStorageReqBO storageReqBO = new FscPurchaseStorageReqBO();
        this.convert(reqBO, storageReqBO);
        storageReqBO.setCtrantTypeId(reqBO.getCtrantTypeId());
        storageReqBO.setBillType(billType);
        storageReqBO.setDocumentNo(reqBO.getStatementNo());
        storageReqBO.setPkOrg(reqBO.getPurDeptId());
        storageReqBO.setPkSupplier(this.umcPurSupInfoListQryExternalService.getCreditNoFromUMC(reqBO.getSupplierId()));
        FscPurchaseStorageRspBO storageErp = this.fscOriginalDocumentsInfoCombService.getPurchaseStorageErp(storageReqBO);
        if (!CollectionUtils.isEmpty(storageErp.getInfoList())) {
            rows.addAll(JSON.parseArray((String)JSON.toJSONString(storageErp.getInfoList()), BusiGetOriginalDocumentsInfoRspBO.class));
        }
        rspBO.setRows(rows);
        Integer recordsTotal = storageErp.getRecordsTotal();
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5165\u5e93\u5355\u5217\u8868\u6210\u529f");
        return rspBO;
    }

    private BusiGetOriginalDocumentsInfoPageRspBO getConsumptionSummary(BusiGetOriginalDocumentsInfoPageReqBO reqBO) {
        FscConsumptionSummaryReqBO consumptionSummaryReqBO = new FscConsumptionSummaryReqBO();
        this.convert(reqBO, consumptionSummaryReqBO);
        consumptionSummaryReqBO.setDocumentNo(reqBO.getStatementNo());
        consumptionSummaryReqBO.setInvoiceStatus("2");
        consumptionSummaryReqBO.setPkOrg(reqBO.getPurDeptId());
        consumptionSummaryReqBO.setPkSupplier(this.umcPurSupInfoListQryExternalService.getCreditNoFromUMC(reqBO.getSupplierId()));
        FscConsumptionSummaryRspBO consumptionSummaryErp = this.fscOriginalDocumentsInfoCombService.getConsumptionSummaryErp(consumptionSummaryReqBO);
        BusiGetOriginalDocumentsInfoPageRspBO rspBO = new BusiGetOriginalDocumentsInfoPageRspBO();
        ArrayList rows = new ArrayList();
        if (!CollectionUtils.isEmpty(consumptionSummaryErp.getInfoList())) {
            rows.addAll(JSON.parseArray((String)JSON.toJSONString(consumptionSummaryErp.getInfoList()), BusiGetOriginalDocumentsInfoRspBO.class));
        }
        rspBO.setRows(rows);
        Integer recordsTotal = consumptionSummaryErp.getRecordsTotal();
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5bc4\u5b58\u6d88\u8017\u6c47\u603b\u5355\u5217\u8868\u6210\u529f");
        log.debug("busi-{}", (Object)JSON.toJSONString((Object)rspBO));
        return rspBO;
    }

    private void checkParams(BusiGetOriginalDocumentsInfoPageReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7c7b\u522btype\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void convert(Object source, Object target) {
        BeanCopier copy = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        copy.copy(source, target, null);
    }
}

