/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.aop.annotation.FscCommitDateLimit;
import com.tydic.pfscext.api.busi.BusiGetPriceSettlementSummaryService;
import com.tydic.pfscext.api.busi.bo.BillDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BillSummaryInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetPriceSettlementSummaryInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetPriceSettlementSummaryReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetPriceSettlementSummaryRspBO;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillDetailInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.dao.vo.BillSummaryInfoConditionVO;
import com.tydic.pfscext.dao.vo.OriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.enums.FscBillStatusType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiPurchaseStorageConsumptionSummaryService;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailItem;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailReqBO;
import com.tydic.pfscext.external.api.bo.BusiOriginalDocumentDetailRspBO;
import com.tydic.umcext.ability.supplier.UmcPurSupInfoListQryAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcPurQrySupInfoListBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetPriceSettlementSummaryService.class)
public class BusiGetPriceSettlementSummaryServiceImpl
implements BusiGetPriceSettlementSummaryService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetPriceSettlementSummaryServiceImpl.class);
    @Autowired
    private BusiPurchaseStorageConsumptionSummaryService purchaseStorageConsumptionSummaryService;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcPurSupInfoListQryAbilityService umcPurSupInfoListQryAbilityService;

    @FscCommitDateLimit(fieldName="startDate")
    public BusiGetPriceSettlementSummaryRspBO getPriceSettlementSummary(BusiGetPriceSettlementSummaryReqBO reqBO) {
        log.debug("\u67e5\u8be2\u4ef7\u683c\u7ed3\u7b97\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPageNo() || null == reqBO.getPageSize()) {
            throw new PfscExtBusinessException("18000", "\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGetPriceSettlementSummaryRspBO rspBO = new BusiGetPriceSettlementSummaryRspBO();
        OriginalDocumentsInfoVO whereVO = new OriginalDocumentsInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)whereVO);
        this.initSelectParams(reqBO, whereVO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        whereVO.setOrderByClause(" INVOICE_DATE DESC ");
        List<OriginalDocumentsInfo> documentsInfoList = this.originalDocumentsInfoMapper.selectListPageCondition(whereVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiGetPriceSettlementSummaryInfoRspBO> rspBOList = new ArrayList<BusiGetPriceSettlementSummaryInfoRspBO>();
        if (!CollectionUtils.isEmpty(documentsInfoList)) {
            List<String> collect = documentsInfoList.stream().map(OriginalDocumentsInfo::getDocumentNo).distinct().collect(Collectors.toList());
            BillSummaryInfoConditionVO conditionVO = new BillSummaryInfoConditionVO();
            conditionVO.setStatementNoListIn(collect);
            conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            List<BillSummaryInfo> billSummaryInfoList = this.billSummaryInfoMapper.getList(conditionVO);
            Map<String, List<BillSummaryInfo>> billSummaryInfoMap = billSummaryInfoList.stream().collect(Collectors.groupingBy(BillSummaryInfo::getStatementNo));
            for (OriginalDocumentsInfo documentsInfo : documentsInfoList) {
                List<BillDetailInfo> billDetailInfos;
                BusiGetPriceSettlementSummaryInfoRspBO info = new BusiGetPriceSettlementSummaryInfoRspBO();
                BeanUtils.copyProperties((Object)documentsInfo, (Object)info);
                List<BillSummaryInfo> summaryInfos = billSummaryInfoMap.get(documentsInfo.getDocumentNo());
                if (!CollectionUtils.isEmpty(summaryInfos)) {
                    info.setMaterialCode(summaryInfos.get(0).getMaterialCode());
                    info.setMaterialName(summaryInfos.get(0).getMaterialName());
                    info.setSummaries(JSON.parseArray((String)JSON.toJSONString(summaryInfos), BillSummaryInfoRspBO.class));
                }
                if (!CollectionUtils.isEmpty(billDetailInfos = this.getDetailFromErp(info))) {
                    info.setDetails(JSON.parseArray((String)JSON.toJSONString(billDetailInfos), BillDetailInfoRspBO.class));
                }
                info.setPurchase(reqBO.getPkOrgName());
                String billStatus = Optional.ofNullable(info.getInvoiceStatus()).orElse("0");
                if (Arrays.asList(FscBillStatus.NOT_INVOICED.getCode(), FscBillStatus.ENTERED.getCode()).contains(billStatus)) {
                    info.setBillStatus(FscBillStatusType.NOT_INVOICED.getCode());
                    info.setBillStatusName(FscBillStatusType.NOT_INVOICED.getDescr());
                } else if (Arrays.asList(FscBillStatus.INVOICED.getCode(), FscBillStatus.TICKETS_RECEIVED.getCode()).contains(billStatus)) {
                    info.setBillStatus(FscBillStatusType.INVOICED.getCode());
                    info.setBillStatusName(FscBillStatusType.INVOICED.getDescr());
                }
                rspBOList.add(info);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u6210\u529f");
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(rspBOList);
        return rspBO;
    }

    private void initSelectParams(BusiGetPriceSettlementSummaryReqBO reqBO, OriginalDocumentsInfoVO whereVO) {
        ArrayList<String> docNoList = new ArrayList<String>();
        if (StringUtils.hasText((String)reqBO.getMaterialCode())) {
            BillSummaryInfoConditionVO vo = new BillSummaryInfoConditionVO();
            vo.setMaterialCode(reqBO.getMaterialCode());
            vo.setStatementNo(reqBO.getDocumentNo());
            vo.setBillType(CtrantType.RAW_COAL.getCtrantType());
            vo.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            List<BillSummaryInfo> summaryInfos = this.billSummaryInfoMapper.getList(vo);
            List collect = summaryInfos.stream().map(BillSummaryInfo::getStatementNo).distinct().collect(Collectors.toList());
            docNoList.addAll(collect);
        } else if (StringUtils.hasText((String)reqBO.getDocumentNo())) {
            docNoList.add(reqBO.getDocumentNo());
            whereVO.setDocumentNo(null);
        }
        if (docNoList.size() > 0) {
            whereVO.setDocumentNoInList(docNoList);
            whereVO.setDocumentNo(null);
        }
        if (null != reqBO.getStartDate()) {
            whereVO.setStartDate(new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(reqBO.getStartDate()));
        }
        if (null != reqBO.getEndDate()) {
            whereVO.setEndDate(new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(reqBO.getEndDate()));
        }
        whereVO.setCoalSupplierId(this.getCreditNo(reqBO.getCoalSupplierId()));
        whereVO.setSettlementSupplierCode(this.getCreditNo(reqBO.getSettlementSupplierCode()));
        if (StringUtils.hasText((String)reqBO.getType())) {
            whereVO.setType(null);
        }
        if (StringUtils.hasText((String)reqBO.getBillStatus())) {
            if ("1".equals(reqBO.getBillStatus())) {
                whereVO.setInvoiceStatusListIn(Arrays.asList(FscBillStatus.INVOICED.getCode(), FscBillStatus.TICKETS_RECEIVED.getCode()));
            } else if ("0".equals(reqBO.getBillStatus())) {
                whereVO.setInvoiceStatusListIn(Arrays.asList(FscBillStatus.NOT_INVOICED.getCode(), FscBillStatus.ENTERED.getCode()));
            }
        }
        whereVO.setBillType(CtrantType.RAW_COAL.getCtrantType());
    }

    private String getCreditNo(String supplierId) {
        if (StringUtils.hasText((String)supplierId)) {
            String creditNo;
            UmcPurSupInfoListQryAbilityReqBO umcPurSupInfoListQryAbilityReqBO = new UmcPurSupInfoListQryAbilityReqBO();
            log.debug("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u5165\u53c2\uff1a{}", (Object)supplierId);
            umcPurSupInfoListQryAbilityReqBO.setSupplierId(Long.valueOf(supplierId));
            UmcPurSupInfoListQryAbilityRspBO umcPurSupInfoListQryAbilityRspBO = this.umcPurSupInfoListQryAbilityService.qryPurSupInfoList(umcPurSupInfoListQryAbilityReqBO);
            log.debug("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcPurSupInfoListQryAbilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if ("0000".equals(umcPurSupInfoListQryAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcPurSupInfoListQryAbilityRspBO.getRows()) && StringUtils.hasText((String)(creditNo = ((UmcPurQrySupInfoListBO)umcPurSupInfoListQryAbilityRspBO.getRows().get(0)).getCreditNo()))) {
                return creditNo;
            }
        }
        return supplierId;
    }

    private List<BillDetailInfo> getDetailFromErp(BusiGetPriceSettlementSummaryInfoRspBO infoRspBO) {
        ArrayList<BillDetailInfo> billDetailInfos = new ArrayList<BillDetailInfo>();
        BusiOriginalDocumentDetailReqBO erpReqBo = new BusiOriginalDocumentDetailReqBO();
        erpReqBo.setCgeneralhId(infoRspBO.getSummeryHeadId());
        BusiOriginalDocumentDetailRspBO originalDocumentDetailErp = this.purchaseStorageConsumptionSummaryService.getOriginalDocumentDetailErp(erpReqBo);
        if (null != originalDocumentDetailErp.getDataList() && originalDocumentDetailErp.getDataList().size() != 0) {
            List dataList = originalDocumentDetailErp.getDataList();
            for (BusiOriginalDocumentDetailErpRspBO detailErpRspBO : dataList) {
                List bvos = detailErpRspBO.getBvos();
                if (CollectionUtils.isEmpty((Collection)bvos)) continue;
                for (BusiOriginalDocumentDetailItem bvo : bvos) {
                    BillDetailInfo billDetailInfo = new BillDetailInfo();
                    BeanUtils.copyProperties((Object)bvo, (Object)billDetailInfo);
                    billDetailInfos.add(billDetailInfo);
                }
            }
        }
        return billDetailInfos;
    }
}

