/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.aop.annotation.FscCommitDateLimit;
import com.tydic.pfscext.api.busi.BusiGetPurchaseStorageService;
import com.tydic.pfscext.api.busi.bo.BusiGetPurchaseStorageInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetPurchaseStorageReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetPurchaseStorageRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetPurchaseStorageErpService;
import com.tydic.pfscext.external.api.bo.BusiGetPurchaseStorageErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetPurchaseStorageErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetPurchaseStorageInfoErpRspBO;
import com.tydic.umcext.ability.supplier.UmcPurSupInfoListQryAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcPurQrySupInfoListBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetPurchaseStorageService.class)
public class BusiGetPurchaseStorageServiceImpl
implements BusiGetPurchaseStorageService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetPurchaseStorageServiceImpl.class);
    @Autowired
    private BusiGetPurchaseStorageErpService busiGetPurchaseStorageErpService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcPurSupInfoListQryAbilityService umcPurSupInfoListQryAbilityService;
    private final String TYPE_BJ_BPBJ = "bpbj";
    private final String TYPE_DZ_HG = "hg";
    private final String TYPE_DZ_YLM = "ylm";

    @FscCommitDateLimit(fieldName="startdate")
    public BusiGetPurchaseStorageRspBO getPurchaseStorage(BusiGetPurchaseStorageReqBO reqBO) {
        log.info("\u67e5\u8be2\u91c7\u8d2d\u5165\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        this.checkParams(reqBO);
        BusiGetPurchaseStorageRspBO rspBO = new BusiGetPurchaseStorageRspBO();
        BusiGetPurchaseStorageErpReqBO erpReqBO = new BusiGetPurchaseStorageErpReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)erpReqBO);
        if ("hg".equals(reqBO.getType()) || "ylm".equals(reqBO.getType())) {
            if (null != erpReqBO.getStartdate()) {
                erpReqBO.setArrivestartdate(erpReqBO.getStartdate());
                erpReqBO.setStartdate(null);
            }
            if (null != erpReqBO.getEnddate()) {
                erpReqBO.setArriveenddate(erpReqBO.getEnddate());
                erpReqBO.setEnddate(null);
            }
        }
        BusiGetPurchaseStorageErpRspBO purchaseStorage = this.busiGetPurchaseStorageErpService.getPurchaseStorage(erpReqBO);
        List dataList = purchaseStorage.getDataList();
        ArrayList<BusiGetPurchaseStorageInfoRspBO> rows = new ArrayList<BusiGetPurchaseStorageInfoRspBO>();
        if (null != dataList) {
            for (BusiGetPurchaseStorageInfoErpRspBO busiGetPurchaseStorageInfoErpRspBO : dataList) {
                BusiGetPurchaseStorageInfoRspBO receiptPageRspBO = new BusiGetPurchaseStorageInfoRspBO();
                BeanUtils.copyProperties((Object)busiGetPurchaseStorageInfoErpRspBO, (Object)receiptPageRspBO);
                rows.add(receiptPageRspBO);
            }
        }
        Integer recordsTotal = Integer.valueOf(purchaseStorage.getData());
        int total = recordsTotal / reqBO.getPageSize();
        if (recordsTotal % reqBO.getPageSize() != 0) {
            ++total;
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getCreditCode(String supplierId) {
        if (StringUtils.hasText((String)supplierId)) {
            String creditNo;
            UmcPurSupInfoListQryAbilityReqBO umcPurSupInfoListQryAbilityReqBO = new UmcPurSupInfoListQryAbilityReqBO();
            log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u5165\u53c2\uff1a{}", (Object)supplierId);
            umcPurSupInfoListQryAbilityReqBO.setSupplierId(Long.valueOf(supplierId));
            UmcPurSupInfoListQryAbilityRspBO umcPurSupInfoListQryAbilityRspBO = this.umcPurSupInfoListQryAbilityService.qryPurSupInfoList(umcPurSupInfoListQryAbilityReqBO);
            log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcPurSupInfoListQryAbilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if ("0000".equals(umcPurSupInfoListQryAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcPurSupInfoListQryAbilityRspBO.getRows()) && StringUtils.hasText((String)(creditNo = ((UmcPurQrySupInfoListBO)umcPurSupInfoListQryAbilityRspBO.getRows().get(0)).getCreditNo()))) {
                log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801-creditNo\uff1a{}", (Object)creditNo);
                return creditNo;
            }
        }
        log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801-\u672a\u53d8\u66f4\uff1a{}", (Object)supplierId);
        return supplierId;
    }

    private void checkParams(BusiGetPurchaseStorageReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPkOrg() || "".equals(reqBO.getPkOrg())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("0001", "\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

