/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.BusiGetStockOrgService;
import com.tydic.pfscext.api.busi.bo.BusiGetStockOrgInfoBO;
import com.tydic.pfscext.api.busi.bo.BusiGetStockOrgReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetStockOrgRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetStockOrgErpService;
import com.tydic.pfscext.external.api.bo.BusiGetStockOrgErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetStockOrgErpRspBO;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetStockOrgService.class)
public class BusiGetStockOrgServiceImpl
implements BusiGetStockOrgService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetStockOrgServiceImpl.class);
    @Autowired
    private BusiGetStockOrgErpService busiGetStockOrgErpService;
    private String SUCCESS_CODE = "0";

    public BusiGetStockOrgRspBO getStockOrg(BusiGetStockOrgReqBO reqBO) {
        BusiGetStockOrgErpRspBO orgFromErp = this.busiGetStockOrgErpService.getStockOrgFromErp(new BusiGetStockOrgErpReqBO());
        if (!this.SUCCESS_CODE.equals(orgFromErp.getCode())) {
            throw new PfscExtBusinessException("18000", orgFromErp.getMsg());
        }
        List dataList = Optional.ofNullable(orgFromErp.getDataList()).orElseGet(Lists::newArrayList);
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)dataList), BusiGetStockOrgInfoBO.class);
        BusiGetStockOrgRspBO rspBO = new BusiGetStockOrgRspBO();
        rspBO.setDataList(rows);
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

