/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.BusiInvoiceDeleteService;
import com.tydic.pfscext.api.busi.BusiInvoiceProofreadService;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceDeleteReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceDeleteRspBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceProofreadReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceProofreadRspBO;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoInvoiceMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.InvoiceInfoTempMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayableDetailItemMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfoInvoicePO;
import com.tydic.pfscext.dao.po.InvoiceInfoTemp;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayableDetailItemPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.BillSummaryInfoConditionVO;
import com.tydic.pfscext.dao.vo.BillSummaryInfoInvoiceConditionVO;
import com.tydic.pfscext.dao.vo.PayableDetailItemVO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.enums.NInvoiceStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.UserDetailInfoBO;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiInvoiceProofreadService.class)
public class BusiInvoiceProofreadServiceImpl
implements BusiInvoiceProofreadService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceProofreadServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private InvoiceInfoTempMapper invoiceInfoTempMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillSummaryInfoInvoiceMapper billSummaryInfoInvoiceMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayableDetailItemMapper payableDetailItemMapper;
    @Autowired
    private BusiInvoiceDeleteService busiInvoiceDeleteService;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayableService payableService;
    @Autowired
    private UserInfoService userInfoService;
    @Value(value="${DELETE_ERP_INVOICE_RESULT_OK:1}")
    private String DELETE_ERP_INVOICE_RESULT_OK;

    public BusiInvoiceProofreadRspBO modifyErpInvoiceProofread(BusiInvoiceProofreadReqBO busiInvoiceProofreadReqBO) {
        this.checkParams(busiInvoiceProofreadReqBO);
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByExtPurNo(busiInvoiceProofreadReqBO.getExtPurInvoiceNo());
        if (billNotificationInfo != null) {
            return this.modifyElectronicProofread(busiInvoiceProofreadReqBO, billNotificationInfo);
        }
        BillMergeInfo billMergeInfo = this.billMergeInfoMapper.selectByInvoiceCode(busiInvoiceProofreadReqBO.getPkInvoice());
        if (null == billMergeInfo) {
            log.error("\u53d1\u7968\u53f7\u672a\u67e5\u8be2\u5230\u6570\u636e-\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)busiInvoiceProofreadReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u53f7\u672a\u67e5\u8be2\u5230\u6570\u636e.pkInvoice:" + busiInvoiceProofreadReqBO.getPkInvoice() + ",vbillcode:" + busiInvoiceProofreadReqBO.getExtPurInvoiceNo());
        }
        return this.modifyAndCreatePayment(busiInvoiceProofreadReqBO, billMergeInfo);
    }

    private BusiInvoiceProofreadRspBO modifyElectronicProofread(BusiInvoiceProofreadReqBO busiInvoiceProofreadReqBO, BillNotificationInfo billNotificationInfo) {
        log.debug("\u901a\u77e5\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)billNotificationInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String invoiceStatus = billNotificationInfo.getInvoiceStatus();
        if (!StringUtils.hasText((String)invoiceStatus)) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u901a\u77e5\u5355[" + billNotificationInfo.getNotificationNo() + "]\u53d1\u7968\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean anyMatch = Arrays.asList(NotificationInvoiceStatus.SIGNED_IN.getCode(), NotificationInvoiceStatus.RECEIVED.getCode(), NotificationInvoiceStatus.AUDIT_REJECTION.getCode()).stream().anyMatch(invoiceStatus::equals);
        if (!anyMatch) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u901a\u77e5\u5355\uff1a" + billNotificationInfo.getNotificationNo() + " \u72b6\u6001\u4e0d\u6b63\u786e,\u53ea\u6709\u3010\u5df2\u7b7e\u6536\u3011\u3001\u3010\u5df2\u6536\u7968\u3011\u72b6\u6001\u624d\u53ef\u8fdb\u884c\u4fee\u6539\u72b6\u6001\u64cd\u4f5c");
        }
        BusiInvoiceProofreadRspBO busiInvoiceProofreadRspBO = new BusiInvoiceProofreadRspBO();
        if ("3".equals(busiInvoiceProofreadReqBO.getStatus())) {
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.RECEIVED.getCode());
            this.createPayableDetail(billNotificationInfo.getNotificationNo(), billNotificationInfo.getVerifyPersonId());
        } else if ("4".equals(busiInvoiceProofreadReqBO.getStatus()) || "0".equals(busiInvoiceProofreadReqBO.getStatus())) {
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.AUDIT_REJECTION.getCode());
            String notificationNo = billNotificationInfo.getNotificationNo();
            if (StringUtils.hasText((String)notificationNo)) {
                this.checkPayableStatusAsWaitApply(notificationNo);
                this.deleteErpInvoiceData(Arrays.asList(notificationNo));
            }
        } else {
            log.error("status={}\uff0c\u4e0d\u4e3a [3-\u5ba1\u6838\u901a\u8fc7] | [4-\u5ba1\u6838\u4e0d\u901a\u8fc7]\u3002", (Object)busiInvoiceProofreadReqBO.getStatus());
            busiInvoiceProofreadRspBO.setRespCode("18003");
            busiInvoiceProofreadRspBO.setRespDesc("\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff0cstatus=" + busiInvoiceProofreadReqBO.getStatus() + ",\u4e0d\u662f\u671f\u671b\u53c2\u6570");
            busiInvoiceProofreadRspBO.setRemark("\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff0cstatus=" + busiInvoiceProofreadReqBO.getStatus() + ",\u4e0d\u662f\u671f\u671b\u53c2\u6570");
            return busiInvoiceProofreadRspBO;
        }
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo);
        log.debug("fsc-\u8c03\u8bd5\uff1a\u66f4\u65b0result={}", (Object)billNotificationInfo);
        busiInvoiceProofreadRspBO.setRespCode("0000");
        busiInvoiceProofreadRspBO.setRespDesc("\u66f4\u65b0\u6210\u529f");
        busiInvoiceProofreadRspBO.setRemark("\u66f4\u65b0\u6210\u529f");
        return busiInvoiceProofreadRspBO;
    }

    private void checkPayableStatusAsWaitApply(String notificationNo) {
        PayableDetailVO vo = new PayableDetailVO();
        vo.setNotificationNo(notificationNo);
        List<PayableDetailPO> detailPOS = this.payableDetailMapper.selectList(vo);
        if (!CollectionUtils.isEmpty(detailPOS)) {
            log.debug("\u4ed8\u6b3e\u5355\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(detailPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            detailPOS.forEach(item -> {
                if (!PayableStatus.WAIT_APPLY.getCode().equals(item.getPayableStatus())) {
                    throw new PfscExtBusinessException("18000", "\u9a73\u56de\u5931\u8d25\uff0c\u5b58\u5728\u4ed8\u6b3e\u5355\u72b6\u6001\u4e0d\u662f\u3010\u5f85\u7533\u8bf7\u3011");
                }
            });
        }
    }

    private void createPayableDetail(String notificationNo, Long verifyPersonId) {
        if (StringUtils.hasText((String)notificationNo)) {
            PayableDetailVO vo = new PayableDetailVO();
            vo.setNotificationNo(notificationNo);
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(vo);
            log.debug("\u67e5\u8be2\u7684\u4ed8\u6b3e\u5355\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(payableDetailPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (!CollectionUtils.isEmpty(payableDetailPOS)) {
                List payableStatusList = payableDetailPOS.stream().map(PayableDetailPO::getPayableStatus).distinct().collect(Collectors.toList());
                if (payableStatusList.size() == 1 && "00".equals(payableStatusList.get(0))) {
                    String snNo = payableDetailPOS.get(0).getPayableNo();
                    PayableDetailPO po = new PayableDetailPO();
                    po.setPayableNo(snNo);
                    this.payableDetailMapper.deleteBy(po);
                    PayableDetailItemVO itemVO = new PayableDetailItemVO();
                    itemVO.setPayableNo(snNo);
                    List<PayableDetailItemPO> itemPOS = this.payableDetailItemMapper.selectList(itemVO);
                    log.debug("\u4ed8\u6b3e\u5355\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString(itemPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    this.payableDetailItemMapper.deleteByPayableNo(snNo);
                } else {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4e0d\u662f[\u5f85\u7533\u8bf7]\u72b6\u6001\u7684\u4ed8\u6b3e\u5355\uff0c\u5ba1\u6838\u7ed3\u679c\u56de\u4f20\u5931\u8d25");
                }
            }
        }
        UserDetailInfoBO userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(verifyPersonId);
        Long companyId = userDetailInfoBO.getCompanyId();
        String isProfessionalOrgExt = "1";
        List<PayableDetailPO> payLs = this.payableService.createPayableBill(notificationNo, companyId, isProfessionalOrgExt);
        log.debug("\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff1a{}", (Object)JSON.toJSONString(payLs));
    }

    private void deleteErpInvoiceData(List<String> notifiationNos) {
        block7: {
            List<PayInvoiceInfo> payInvoiceInfos = this.payInvoiceInfoMapper.selectListByNotificationNos(notifiationNos);
            log.info("\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3-\u5220\u9664\u7684\u6570\u636e\u6e90\u53d1\u7968\uff1a{}", (Object)JSON.toJSONString(payInvoiceInfos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            try {
                if (!CollectionUtils.isEmpty(payInvoiceInfos)) {
                    for (PayInvoiceInfo piInfo : payInvoiceInfos) {
                        if (StringUtils.hasText((String)piInfo.getPkInvoice())) {
                            BusiInvoiceDeleteReqBO reqBO = new BusiInvoiceDeleteReqBO();
                            reqBO.setPkInvoice(piInfo.getPkInvoice());
                            BusiInvoiceDeleteRspBO deleteRspBO = this.busiInvoiceDeleteService.invoiceDelete(reqBO);
                            if ("0000".equals(deleteRspBO.getRespCode())) {
                                log.info("\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3-\u5220\u9664erp\u53d1\u7968[{}]\u6210\u529f\u3002", (Object)reqBO.getPkInvoice());
                                continue;
                            }
                            log.error("\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3-\u5220\u9664erp\u53d1\u7968[{}]\u5931\u8d25\u3002\u539f\u56e0\uff1a{}", (Object)reqBO.getPkInvoice(), (Object)deleteRspBO.getRespDesc());
                            throw new PfscExtBusinessException("18000", "\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u62a5\u6587\uff1a" + JSON.toJSONString((Object)deleteRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        }
                        log.error("\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3-\u5220\u9664erp\u53d1\u7968\u5931\u8d25\uff0c\u91c7\u8d2d\u53d1\u7968\u4e3b\u952e[pk_invoice]\u4e3a\u7a7a");
                        throw new PfscExtBusinessException("18000", "\u5220\u9664\u53d1\u7968\u5931\u8d25\uff0c\u91c7\u8d2d\u53d1\u7968\u4e3b\u952e[pk_invoice]\u4e3a\u7a7a");
                    }
                }
            }
            catch (PfscExtBusinessException e) {
                if ("1".equals(this.DELETE_ERP_INVOICE_RESULT_OK)) {
                    log.error("\u5220\u9664\u53d1\u7968\u5931\u8d25\uff0c\u4e0d\u8fd4\u56de\u9519\u8bef\u72b6\u6001\uff1a{}", (Throwable)e);
                }
                if (!"0".equals(this.DELETE_ERP_INVOICE_RESULT_OK)) break block7;
                log.error("\u5220\u9664\u53d1\u7968\u5931\u8d25\uff0c\u8fd4\u56de\u9519\u8bef\u72b6\u6001");
                throw new PfscExtBusinessException("18000", e.getMessage());
            }
        }
    }

    private void checkParams(BusiInvoiceProofreadReqBO busiInvoiceProofreadReqBO) {
        if (null == busiInvoiceProofreadReqBO) {
            log.error("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u51fa\u9519-\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5931\u8d25\uff0c\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)busiInvoiceProofreadReqBO.getExtPurInvoiceNo())) {
            log.error("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u51fa\u9519-\u53d1\u7968\u53f7\u4e3a\u7a7a");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5931\u8d25\uff0c\u53d1\u7968\u53f7\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)busiInvoiceProofreadReqBO.getStatus())) {
            log.error("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u51fa\u9519-\u72b6\u6001\u7801\u4e3a\u7a7a");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a\u7a7a\uff01");
        }
    }

    private BusiInvoiceProofreadRspBO modifyAndCreatePayment(BusiInvoiceProofreadReqBO reqBO, BillMergeInfo billMergeInfo) {
        log.info("\u66f4\u65b0\u539f\u6599\u7164\u7b49\u53d1\u7968\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiInvoiceProofreadRspBO rspBO = new BusiInvoiceProofreadRspBO();
        if ("3".equals(reqBO.getStatus())) {
            String invoiceStatus = FscBillStatus.TICKETS_RECEIVED.getCode();
            this.updateInvoiceStatus(reqBO, billMergeInfo, invoiceStatus);
            this.createPayableDetail(reqBO, billMergeInfo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (Arrays.asList("0", "4").contains(reqBO.getStatus())) {
            List<String> billStatusList = Arrays.asList(FscBillStatus.INVOICED.getCode(), FscBillStatus.TICKETS_RECEIVED.getCode());
            InvoiceInfoTemp invoiceInfoTemp = this.invoiceInfoTempMapper.selectByInoviceInfoId(billMergeInfo.getMergeSetNo());
            log.debug("\u67e5\u8be2\u53d1\u7968\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)invoiceInfoTemp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (billStatusList.contains(invoiceInfoTemp.getInvoiceStatus()) && billStatusList.contains(billMergeInfo.getInvoiceStatus())) {
                this.deleteErpInvoice(billMergeInfo, invoiceInfoTemp);
                this.updateInvoiceStatus(reqBO, billMergeInfo, FscBillStatus.ENTERED.getCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5f00\u7968\u9a73\u56de\u6210\u529f\uff01");
                return rspBO;
            }
            String invoiceStatus = invoiceInfoTemp.getInvoiceStatus();
            String invoiceStatusBill = billMergeInfo.getInvoiceStatus();
            StringBuilder sb = new StringBuilder();
            if (StringUtils.hasText((String)invoiceStatus) && StringUtils.hasText((String)invoiceStatusBill)) {
                sb.append("\u9a73\u56de\u5f00\u7968\u72b6\u6001\u4e0d\u6b63\u786e-\u72b6\u6001:[").append(FscBillStatus.getInstance(invoiceStatus).getDescr()).append("],[").append(FscBillStatus.getInstance(invoiceStatusBill).getDescr()).append("]");
            } else {
                sb.append("\u5b58\u5728\u53d1\u7968\u72b6\u6001\u4e3a\u7a7a-").append(invoiceStatus).append("-").append(invoiceStatusBill);
            }
            throw new PfscExtBusinessException("18000", sb.toString());
        }
        throw new PfscExtBusinessException("18000", "\u672a\u77e5\u72b6\u6001\u3010status:" + reqBO.getStatus() + "\u3011");
    }

    private void deleteErpInvoice(BillMergeInfo billMergeInfo, InvoiceInfoTemp invoiceInfoTemp) {
        block6: {
            String extInvoicePreKey = invoiceInfoTemp.getExtInvoicePreKey();
            try {
                BusiInvoiceDeleteReqBO busiInvoiceDeleteReqBO;
                if (StringUtils.hasText((String)extInvoicePreKey)) {
                    busiInvoiceDeleteReqBO = new BusiInvoiceDeleteReqBO();
                    busiInvoiceDeleteReqBO.setPkInvoice(extInvoicePreKey);
                    BusiInvoiceDeleteRspBO deleteRspBO = this.busiInvoiceDeleteService.invoiceDelete(busiInvoiceDeleteReqBO);
                    if (!"0000".equals(deleteRspBO.getRespCode())) {
                        String jsonString = JSON.toJSONString((Object)deleteRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                        log.error("\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3-\u5220\u9664erp\u53d1\u7968[{}]\u5931\u8d25\u3002\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)busiInvoiceDeleteReqBO.getPkInvoice(), (Object)jsonString);
                        throw new PfscExtBusinessException("18000", "\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u62a5\u6587\uff1a" + jsonString);
                    }
                } else {
                    log.error("\u5355\u636e[{}]\u7684\u53d1\u7968[{}]\u5bf9\u5e94\u7684\u5916\u90e8\u53d1\u7968\u4e3b\u952e\u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", (Object)billMergeInfo.getMergeSetNo(), (Object)invoiceInfoTemp.getInvoceCode());
                    throw new PfscExtBusinessException("18000", "\u5355\u636e[" + billMergeInfo.getMergeSetNo() + "]\u7684\u53d1\u7968[" + invoiceInfoTemp.getInvoceCode() + "]\u5bf9\u5e94\u7684\u5916\u90e8\u53d1\u7968\u4e3b\u952e\u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25");
                }
                log.info("\u8c03\u7528\u53d1\u7968\u5220\u9664\u63a5\u53e3-\u5220\u9664erp\u53d1\u7968[{}]\u6210\u529f\u3002", (Object)busiInvoiceDeleteReqBO.getPkInvoice());
            }
            catch (PfscExtBusinessException e) {
                if ("1".equals(this.DELETE_ERP_INVOICE_RESULT_OK)) {
                    log.error("\u5220\u9664\u53d1\u7968\u5931\u8d25\uff0c\u4e0d\u8fd4\u56de\u9519\u8bef\u72b6\u6001\uff1a{}", (Throwable)e);
                }
                if (!"0".equals(this.DELETE_ERP_INVOICE_RESULT_OK)) break block6;
                log.error("\u5220\u9664\u53d1\u7968\u5931\u8d25\uff0c\u8fd4\u56de\u9519\u8bef\u72b6\u6001");
                throw new PfscExtBusinessException("18000", e.getMessage());
            }
        }
    }

    private void updateInvoiceStatus(BusiInvoiceProofreadReqBO reqBO, BillMergeInfo billMergeInfo, String invoiceStatus) {
        block10: {
            List statementNoList;
            String mergeSetNo;
            block9: {
                log.info("\u5f85\u66f4\u65b0\u6c47\u603b\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)billMergeInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                mergeSetNo = billMergeInfo.getMergeSetNo();
                int i = this.billMergeInfoMapper.updateStatusBymergeNo(invoiceStatus, mergeSetNo);
                if (i != 1) {
                    log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)mergeSetNo);
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo());
                }
                int i1 = this.invoiceInfoTempMapper.updateStatusBymergeNo(invoiceStatus, mergeSetNo);
                if (i1 != 1) {
                    log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)mergeSetNo);
                    throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
                }
                BillSummaryInfoInvoiceConditionVO conditionVO = new BillSummaryInfoInvoiceConditionVO();
                conditionVO.setMergeSetNo(mergeSetNo);
                conditionVO.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                List<BillSummaryInfoInvoicePO> infoInvoicePOList = this.billSummaryInfoInvoiceMapper.selectListCondition(conditionVO);
                statementNoList = infoInvoicePOList.stream().map(BillSummaryInfoInvoicePO::getStatementNo).distinct().collect(Collectors.toList());
                List<String> idList = infoInvoicePOList.stream().map(BillSummaryInfoInvoicePO::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(idList)) {
                    throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u53d1\u7968\u8bb0\u5f55\u4e3a\u7a7a");
                }
                int i2 = this.billSummaryInfoInvoiceMapper.updateInvoiceStatusByIdList(idList, invoiceStatus);
                if (i2 < 1) {
                    log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)mergeSetNo);
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo());
                }
                if (!NInvoiceStatus.RECEIVED.getCode().equals(invoiceStatus)) break block9;
                String billType = infoInvoicePOList.get(0).getBillType();
                if (CtrantType.RAW_COAL.getCtrantType().equals(billType)) {
                    for (String documentNo : statementNoList) {
                        int i3 = this.originalDocumentsInfoMapper.updateByDocumentNo(invoiceStatus, documentNo);
                        if (i3 >= 1) continue;
                        log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)mergeSetNo);
                        throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
                    }
                } else {
                    for (String documentNo : statementNoList) {
                        int i3;
                        BillSummaryInfoConditionVO condition = new BillSummaryInfoConditionVO();
                        condition.setStatementNo(documentNo);
                        condition.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                        List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.getList(condition);
                        List collect = billSummaryInfos.stream().filter(item -> !item.getInventoryQuantity().equals(item.getInvoicedQuantity())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(collect) || (i3 = this.originalDocumentsInfoMapper.updateByDocumentNo(invoiceStatus, documentNo)) >= 1) continue;
                        log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)mergeSetNo);
                        throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
                    }
                }
                break block10;
            }
            if (!NInvoiceStatus.ENTERED.getCode().equals(invoiceStatus)) break block10;
            for (String documentNo : statementNoList) {
                int i3;
                BillSummaryInfoConditionVO condition = new BillSummaryInfoConditionVO();
                condition.setStatementNo(documentNo);
                condition.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
                List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.getList(condition);
                List collect = billSummaryInfos.stream().filter(item -> !item.getInventoryQuantity().equals(item.getInvoicedQuantity())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect) || (i3 = this.originalDocumentsInfoMapper.updateByDocumentNo(invoiceStatus, documentNo)) >= 1) continue;
                log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)mergeSetNo);
                throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
            }
        }
    }

    private void createPayableDetail(BusiInvoiceProofreadReqBO reqBO, BillMergeInfo billMergeInfo) {
        PayableDetailPO po = new PayableDetailPO();
        Date now = new Date();
        String snNo = this.getPayInfoId("CG");
        po.setPayableNo(snNo);
        po.setPayableAmt(new BigDecimal(billMergeInfo.getTotalAmt()));
        po.setPaidAmt(BigDecimal.ZERO);
        po.setPendingAmt(BigDecimal.ZERO);
        po.setPaidDate(now);
        po.setNeedAgainstAmt(BigDecimal.ZERO);
        po.setPayableStatus(PayableStatus.PENDING.getCode());
        po.setCreateDate(now);
        po.setPayableType(6);
        po.setPayType("2");
        int insert = this.payableDetailMapper.insert(po);
        if (insert != 1) {
            log.error("\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25");
            throw new PfscExtBusinessException("\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25", "18000");
        }
        billMergeInfo.setPayableNo(snNo);
        int i5 = this.billMergeInfoMapper.updatePayableNoByMergeSetNo(billMergeInfo);
        if (i5 != 1) {
            log.error("\u66f4\u65b0[{}]\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)billMergeInfo.getMergeSetNo());
            throw new PfscExtBusinessException("\u66f4\u65b0\u53d1\u7968\u5931\u8d25:" + reqBO.getExtPurInvoiceNo(), "18000");
        }
    }

    private String getPayInfoId(String prefix) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            if (prefix == null) {
                prefix = "";
            }
            String maxNum = this.payableDetailMapper.selectMaxPayNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

