/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.aop.annotation.FscCommitDateLimit;
import com.tydic.pfscext.api.busi.BusiPayReceiptService;
import com.tydic.pfscext.api.busi.bo.BusiPayReceiptInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiPayReceiptPageRspBO;
import com.tydic.pfscext.api.busi.bo.BusiPayReceiptReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayReceiptRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiPayReceiptErpService;
import com.tydic.pfscext.external.api.bo.BusiPayReceiptBillErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiPayReceiptErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiPayReceiptErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiPayReceiptInfoErpRspBO;
import com.tydic.umcext.ability.supplier.UmcPurSupInfoListQryAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcPurQrySupInfoListBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcPurSupInfoListQryAbilityRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiPayReceiptService.class)
public class BusiPayReceiptServiceImpl
implements BusiPayReceiptService {
    private static final Logger log = LoggerFactory.getLogger(BusiPayReceiptServiceImpl.class);
    @Autowired
    private BusiPayReceiptErpService busiPayReceiptErpService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcPurSupInfoListQryAbilityService umcPurSupInfoListQryAbilityService;

    @FscCommitDateLimit(fieldName="startDate")
    public BusiPayReceiptRspBO getPayReceipt(BusiPayReceiptReqBO reqBO) {
        log.info("\u67e5\u8be2\u4ed8\u6b3e\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        this.checkParams(reqBO);
        reqBO.setPkSupplier(this.getCreditCode(reqBO.getPkSupplier()));
        reqBO.setDef9(this.getCreditCode(reqBO.getDef9()));
        BusiPayReceiptRspBO rspBO = new BusiPayReceiptRspBO();
        BusiPayReceiptErpReqBO erpReqBO = new BusiPayReceiptErpReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)erpReqBO);
        if (reqBO.getStartDate() != null) {
            erpReqBO.setStartDate(new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(reqBO.getStartDate()));
        }
        if (reqBO.getEndDate() != null) {
            erpReqBO.setEndDate(new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(reqBO.getEndDate()));
        }
        erpReqBO.setPageSize(reqBO.getPageSize());
        erpReqBO.setPageNum(reqBO.getPageNo());
        BusiPayReceiptErpRspBO payReceiptErp = this.busiPayReceiptErpService.getPayReceiptErp(erpReqBO);
        List dataList = payReceiptErp.getDataList();
        ArrayList<BusiPayReceiptPageRspBO> rows = new ArrayList<BusiPayReceiptPageRspBO>();
        Integer recordsTotal = 0;
        Integer total = 0;
        if (null != dataList) {
            for (BusiPayReceiptBillErpRspBO busiPayReceiptBillErpRspBO : dataList) {
                BusiPayReceiptPageRspBO receiptPageRspBO = new BusiPayReceiptPageRspBO();
                BeanUtils.copyProperties((Object)busiPayReceiptBillErpRspBO, (Object)receiptPageRspBO);
                if (!CollectionUtils.isEmpty((Collection)busiPayReceiptBillErpRspBO.getBvoList())) {
                    ArrayList<BusiPayReceiptInfoRspBO> bovs = new ArrayList<BusiPayReceiptInfoRspBO>();
                    for (BusiPayReceiptInfoErpRspBO bov : busiPayReceiptBillErpRspBO.getBvoList()) {
                        BusiPayReceiptInfoRspBO item = new BusiPayReceiptInfoRspBO();
                        BeanUtils.copyProperties((Object)bov, (Object)item);
                        bovs.add(item);
                        receiptPageRspBO.setPkRecpaytype(bov.getPkRecpaytype());
                        receiptPageRspBO.setPrepay(bov.getPrepay());
                        receiptPageRspBO.setRate(bov.getRate());
                        receiptPageRspBO.setSupplier(bov.getSupplierName());
                        receiptPageRspBO.setPkDeptidV(bov.getPkDeptidV());
                    }
                    receiptPageRspBO.setBvoList(bovs);
                }
                rows.add(receiptPageRspBO);
            }
            recordsTotal = Integer.valueOf(payReceiptErp.getData());
            total = recordsTotal / reqBO.getPageSize();
            if (recordsTotal % reqBO.getPageSize() != 0) {
                total = total + 1;
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(total);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkParams(BusiPayReceiptReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
            if (!StringUtils.hasText((String)reqBO.getPkOrg())) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if ("2".equals(reqBO.getIsProfessionalOrgExt()) && !StringUtils.hasText((String)reqBO.getPkSupplier())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String getCreditCode(String supplierId) {
        if (StringUtils.hasText((String)supplierId)) {
            String creditNo;
            UmcPurSupInfoListQryAbilityReqBO umcPurSupInfoListQryAbilityReqBO = new UmcPurSupInfoListQryAbilityReqBO();
            log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u5165\u53c2\uff1a{}", (Object)supplierId);
            umcPurSupInfoListQryAbilityReqBO.setSupplierId(Long.valueOf(supplierId));
            UmcPurSupInfoListQryAbilityRspBO umcPurSupInfoListQryAbilityRspBO = this.umcPurSupInfoListQryAbilityService.qryPurSupInfoList(umcPurSupInfoListQryAbilityReqBO);
            log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcPurSupInfoListQryAbilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if ("0000".equals(umcPurSupInfoListQryAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcPurSupInfoListQryAbilityRspBO.getRows()) && StringUtils.hasText((String)(creditNo = ((UmcPurQrySupInfoListBO)umcPurSupInfoListQryAbilityRspBO.getRows().get(0)).getCreditNo()))) {
                log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801-creditNo\uff1a{}", (Object)creditNo);
                return creditNo;
            }
        }
        log.info("\u6839\u636e\u4f9b\u5e94\u5546id\u67e5\u8be2\u7edf\u4e00\u4fe1\u606f\u793e\u4f1a\u4ee3\u7801-\u672a\u53d8\u66f4\uff1a{}", (Object)supplierId);
        return supplierId;
    }
}

