/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.BusiPayableDetailAuditService;
import com.tydic.pfscext.api.busi.bo.BusiPayableDetailAuditReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayableDetailAuditRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayableDetailItemMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailItemPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayableDetailItemVO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiPayableDetailAuditService.class)
public class BusiPayableDetailAuditServiceImpl
implements BusiPayableDetailAuditService {
    private static final Logger log = LoggerFactory.getLogger(BusiPayableDetailAuditServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayableDetailItemMapper payableDetailItemMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    public BusiPayableDetailAuditRspBO updatePayableDetailFromErp(BusiPayableDetailAuditReqBO reqBO) {
        log.error("ERP\u56de\u4f20\u4ed8\u6b3e\u5355\u5ba1\u6838\u7ed3\u679c-\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiPayableDetailAuditRspBO busiPayableDetailAuditRspBO = new BusiPayableDetailAuditRspBO();
        this.validatorParams(reqBO);
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        payableDetailVO.setExtApplyPayNo(reqBO.getPk_apply());
        ArrayList<PayableDetailPO> payableDetailPOS = new ArrayList<PayableDetailPO>();
        try {
            List<PayableDetailPO> posselectList = this.payableDetailMapper.selectList(payableDetailVO);
            payableDetailPOS.addAll(posselectList);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4ed8\u6b3e\u5355\u5931\u8d25");
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4ed8\u6b3e\u5355\u5931\u8d25");
        }
        log.info("ERP\u56de\u4f20\u4ed8\u6b3e\u5355\u5ba1\u6838\u7ed3\u679c-\u67e5\u8be2\u5e94\u4ed8\u5355\uff1a{}", (Object)JSON.toJSONString(payableDetailPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (CollectionUtils.isEmpty(payableDetailPOS)) {
            throw new PfscExtBusinessException("18000", "\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636e\u4ed8\u6b3e\u7533\u8bf7\u4e3b\u952e[" + reqBO.getPk_apply() + "]\u4e3a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u3002");
        }
        for (PayableDetailPO pdpo : payableDetailPOS) {
            if (PayableStatus.SUCCESS.getCode().equals(pdpo.getPayableStatus())) {
                throw new PfscExtBusinessException("18000", "\u63a5\u6536\u5ba1\u6838\u7ed3\u679c\u5931\u8d25\uff0c\u5b58\u5728\u4ed8\u6b3e\u5355\u5df2\u4ed8\u6b3e");
            }
            String status = reqBO.getStatus();
            PayableDetailVO vo = new PayableDetailVO();
            if ("1".equals(status)) {
                vo.setApproveResult(1);
            } else {
                List<String> payableStatusList = Arrays.asList("01", "02");
                if (!payableStatusList.contains(pdpo.getPayableStatus())) {
                    log.error("\u4ed8\u6b3e\u5355\u72b6\u6001\u9519\u8bef\uff0c\u4ed8\u6b3e\u5355\u5f53\u524d\u72b6\u6001[{}]\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff0c\u4ed8\u6b3e\u5355\uff1a{}", (Object)pdpo.getPayableStatus(), (Object)JSON.toJSONString((Object)pdpo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u5355\u72b6\u6001\u9519\u8bef");
                }
                vo.setApproveResult(0);
                vo.setPaidAmt(pdpo.getPaidAmt());
                vo.setPayableStatus(PayableStatus.WAIT_APPLY.getCode());
                PayableDetailItemVO detailItemVO = new PayableDetailItemVO();
                detailItemVO.setPayableNo(pdpo.getPayableNo());
                detailItemVO.setExtApplyPayNo(reqBO.getPk_apply());
                List<PayableDetailItemPO> list = this.payableDetailItemMapper.selectList(detailItemVO);
                if (!CollectionUtils.isEmpty(list)) {
                    list.forEach(item -> {
                        item.setDelStatus(0);
                        PayableDetailItemVO itemVO = new PayableDetailItemVO();
                        itemVO.setItemNo(item.getItemNo());
                        itemVO.setPayableNo(item.getPayableNo());
                        item.setPayableStatus(PayableStatus.WAIT_APPLY.getCode());
                        try {
                            int n = this.payableDetailItemMapper.updateByConditions(itemVO, (PayableDetailItemPO)item);
                        }
                        catch (Exception e) {
                            log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
                            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
                        }
                    });
                }
            }
            vo.setPayableNo(pdpo.getPayableNo());
            vo.setApproveStatus(1);
            vo.setApproveTime(new Date());
            try {
                this.payableDetailMapper.updateByConditionsReset(vo);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        busiPayableDetailAuditRspBO.setRespCode("0000");
        busiPayableDetailAuditRspBO.setRespDesc("\u4ed8\u6b3e\u5355\u5ba1\u6838\u7ed3\u679c\u56de\u4f20\u6210\u529f");
        return busiPayableDetailAuditRspBO;
    }

    private void validatorParams(BusiPayableDetailAuditReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getPk_apply())) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7533\u8bf7\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getStatus())) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

