/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.BusiDocumentPreviewService;
import com.tydic.pfscext.api.busi.bo.BusiDocumentPreviewDKRspBO;
import com.tydic.pfscext.api.busi.bo.BusiDocumentPreviewQCRspBO;
import com.tydic.pfscext.api.busi.bo.BusiDocumentPreviewReqBO;
import com.tydic.pfscext.api.busi.bo.BusiDocumentPreviewRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetCirculationItemRspBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.dao.vo.BillSummaryInfoConditionVO;
import com.tydic.pfscext.enums.EffectiveState;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetCirculationInfoFromErpService;
import com.tydic.pfscext.external.api.bo.BusiGetCirculationInfoFromErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetCirculationInfoFromErpRspBO;
import com.tydic.pfscext.service.conversion.api.DataToPdfService;
import com.tydic.pfscext.service.conversion.bo.BigMineSettlementDocPreviewReqBO;
import com.tydic.pfscext.service.conversion.bo.BigMineSettlementInfoBO;
import com.tydic.pfscext.service.conversion.bo.BigMineSettlementSummaryInfoBO;
import com.tydic.pfscext.service.conversion.bo.GroupMiningSettlementDocPreviewReqBO;
import com.tydic.pfscext.service.conversion.bo.GroupMiningSettlementInfoBO;
import com.tydic.pfscext.service.conversion.bo.GroupMiningSettlementSummaryInfoBO;
import com.tydic.pfscext.service.conversion.bo.base.BaseDataReqBO;
import com.tydic.pfscext.service.conversion.bo.base.SettlementInfoBO;
import com.tydic.pfscext.utils.AmountUtils;
import com.tydic.pfscext.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiDocumentPreviewService.class)
public class BusiStatementDocumentPreviewServiceImpl
implements BusiDocumentPreviewService {
    private static final Logger log = LoggerFactory.getLogger(BusiStatementDocumentPreviewServiceImpl.class);
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Resource(name="statementDocumentDataToPdfService")
    private DataToPdfService dataToPdfService;
    private static final String STATEMENT_TYPE = "1";
    private static final String CATEGORY_Y = "Y";
    private static final String CATEGORY_N = "N";
    @Autowired
    private BusiGetCirculationInfoFromErpService busiGetCirculationInfoFromErpService;

    public BusiDocumentPreviewRspBO getDocPreview(BusiDocumentPreviewReqBO reqBO) {
        this.paramsNotBlank(reqBO);
        if (STATEMENT_TYPE.equals(reqBO.getType())) {
            return this.getStatementDocPreview(reqBO);
        }
        BusiDocumentPreviewRspBO rspBO = new BusiDocumentPreviewRspBO();
        rspBO.setRespCode("18000");
        rspBO.setRespDesc("\u9884\u89c8\u5931\u8d25");
        return rspBO;
    }

    public BusiDocumentPreviewDKRspBO getDocPreviewExcelDK(BusiDocumentPreviewReqBO reqBO) {
        this.paramsNotBlank(reqBO);
        if (STATEMENT_TYPE.equals(reqBO.getType())) {
            OriginalDocumentsInfo info = this.originalDocumentsInfoMapper.selectByPrimaryKey(reqBO.getDocumentNo());
            log.debug("\u539f\u59cb\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)info));
            BillSummaryInfoConditionVO condition = new BillSummaryInfoConditionVO();
            condition.setStatementNo(reqBO.getDocumentNo());
            condition.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            List<BillSummaryInfo> summaryInfos = this.billSummaryInfoMapper.getList(condition);
            log.debug("\u539f\u59cb\u7269\u6599\uff1a{}", (Object)JSON.toJSONString(summaryInfos));
            if (Objects.isNull(info)) {
                throw new PfscExtBusinessException("18000", "\u6839\u636e\u5355\u636e\u53f7\u4e3a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355");
            }
            if (!StringUtils.hasText((String)info.getPartySettlement())) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6807\u8bc6\u4e3a\u7a7a");
            }
            BigMineSettlementDocPreviewReqBO settlementDocPreviewReqBO = new BigMineSettlementDocPreviewReqBO();
            BigMineSettlementInfoBO settlementInfoBO = new BigMineSettlementInfoBO();
            ArrayList<BigMineSettlementSummaryInfoBO> summaryInfoBOS = new ArrayList<BigMineSettlementSummaryInfoBO>();
            this.initBigMineData(info, summaryInfos, settlementInfoBO, summaryInfoBOS);
            settlementDocPreviewReqBO.setBigMineSettlementInfoBO(settlementInfoBO);
            settlementDocPreviewReqBO.setSummaryInfoBOS(summaryInfoBOS);
            settlementDocPreviewReqBO.setDocumentno(settlementDocPreviewReqBO.getBigMineSettlementInfoBO().getDocumentno());
            settlementDocPreviewReqBO.setRegenerate(reqBO.getRegenerate());
            return (BusiDocumentPreviewDKRspBO)JSON.parseObject((String)JSON.toJSONString((Object)settlementDocPreviewReqBO), BusiDocumentPreviewDKRspBO.class);
        }
        BusiDocumentPreviewDKRspBO rspBO = new BusiDocumentPreviewDKRspBO();
        rspBO.setRespCode("18000");
        rspBO.setRespDesc("\u9884\u89c8\u5931\u8d25");
        return rspBO;
    }

    public BusiDocumentPreviewQCRspBO getDocPreviewExcelQC(BusiDocumentPreviewReqBO reqBO) {
        this.paramsNotBlank(reqBO);
        if (STATEMENT_TYPE.equals(reqBO.getType())) {
            OriginalDocumentsInfo info = this.originalDocumentsInfoMapper.selectByPrimaryKey(reqBO.getDocumentNo());
            log.debug("\u539f\u59cb\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)info));
            BillSummaryInfoConditionVO condition = new BillSummaryInfoConditionVO();
            condition.setStatementNo(reqBO.getDocumentNo());
            condition.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
            List<BillSummaryInfo> summaryInfos = this.billSummaryInfoMapper.getList(condition);
            log.debug("\u539f\u59cb\u7269\u6599\uff1a{}", (Object)JSON.toJSONString(summaryInfos));
            if (Objects.isNull(info)) {
                throw new PfscExtBusinessException("18000", "\u6839\u636e\u5355\u636e\u53f7\u4e3a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355");
            }
            if (!StringUtils.hasText((String)info.getPartySettlement())) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6807\u8bc6\u4e3a\u7a7a");
            }
            GroupMiningSettlementDocPreviewReqBO settlementDocPreviewReqBO = new GroupMiningSettlementDocPreviewReqBO();
            GroupMiningSettlementInfoBO settlementInfoBO = new GroupMiningSettlementInfoBO();
            ArrayList<GroupMiningSettlementSummaryInfoBO> statementSummaryInfoBOS = new ArrayList<GroupMiningSettlementSummaryInfoBO>();
            this.initGroupMiningData(info, summaryInfos, settlementInfoBO, statementSummaryInfoBOS);
            settlementDocPreviewReqBO.setGroupMiningSettlementInfoBO(settlementInfoBO);
            settlementDocPreviewReqBO.setSummaryInfoBOS(new ArrayList<GroupMiningSettlementSummaryInfoBO>(statementSummaryInfoBOS));
            settlementDocPreviewReqBO.setDocumentno(settlementDocPreviewReqBO.getGroupMiningSettlementInfoBO().getDocumentno());
            settlementDocPreviewReqBO.setRegenerate(reqBO.getRegenerate());
            return (BusiDocumentPreviewQCRspBO)JSON.parseObject((String)JSON.toJSONString((Object)settlementDocPreviewReqBO), BusiDocumentPreviewQCRspBO.class);
        }
        BusiDocumentPreviewQCRspBO rspBO = new BusiDocumentPreviewQCRspBO();
        rspBO.setRespCode("18000");
        rspBO.setRespDesc("\u9884\u89c8\u5931\u8d25");
        return rspBO;
    }

    private BusiDocumentPreviewRspBO getStatementDocPreview(BusiDocumentPreviewReqBO reqBO) {
        BaseDataReqBO infoBO = this.getSettlementData(reqBO);
        PfscExtRspBaseBO rspBaseBO = this.dataToPdfService.preview(infoBO);
        if (!"0000".equals(rspBaseBO.getRespCode())) {
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u7ed3\u7b97\u5355\u9884\u89c8\u5931\u8d25");
        }
        BusiDocumentPreviewRspBO rspBO = (BusiDocumentPreviewRspBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBaseBO), BusiDocumentPreviewRspBO.class);
        return rspBO;
    }

    private BaseDataReqBO getSettlementData(BusiDocumentPreviewReqBO reqBO) {
        OriginalDocumentsInfo info = this.originalDocumentsInfoMapper.selectByPrimaryKey(reqBO.getDocumentNo());
        log.debug("\u539f\u59cb\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)info));
        BillSummaryInfoConditionVO condition = new BillSummaryInfoConditionVO();
        condition.setStatementNo(reqBO.getDocumentNo());
        condition.setEffectiveState(EffectiveState.TAKE_EFFECT.getCode());
        List<BillSummaryInfo> summaryInfos = this.billSummaryInfoMapper.getList(condition);
        log.debug("\u539f\u59cb\u7269\u6599\uff1a{}", (Object)JSON.toJSONString(summaryInfos));
        if (Objects.isNull(info)) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u5355\u636e\u53f7\u4e3a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355");
        }
        if (!StringUtils.hasText((String)info.getPartySettlement())) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (CATEGORY_Y.equals(info.getPartySettlement())) {
            BigMineSettlementDocPreviewReqBO settlementDocPreviewReqBO = new BigMineSettlementDocPreviewReqBO();
            BigMineSettlementInfoBO settlementInfoBO = new BigMineSettlementInfoBO();
            ArrayList<BigMineSettlementSummaryInfoBO> summaryInfoBOS = new ArrayList<BigMineSettlementSummaryInfoBO>();
            this.initBigMineData(info, summaryInfos, settlementInfoBO, summaryInfoBOS);
            settlementDocPreviewReqBO.setBigMineSettlementInfoBO(settlementInfoBO);
            settlementDocPreviewReqBO.setSummaryInfoBOS(summaryInfoBOS);
            settlementDocPreviewReqBO.setDocumentno(settlementDocPreviewReqBO.getBigMineSettlementInfoBO().getDocumentno());
            settlementDocPreviewReqBO.setRegenerate(reqBO.getRegenerate());
            return settlementDocPreviewReqBO;
        }
        if (CATEGORY_N.equals(info.getPartySettlement())) {
            GroupMiningSettlementDocPreviewReqBO settlementDocPreviewReqBO = new GroupMiningSettlementDocPreviewReqBO();
            GroupMiningSettlementInfoBO settlementInfoBO = new GroupMiningSettlementInfoBO();
            ArrayList<GroupMiningSettlementSummaryInfoBO> statementSummaryInfoBOS = new ArrayList<GroupMiningSettlementSummaryInfoBO>();
            this.initGroupMiningData(info, summaryInfos, settlementInfoBO, statementSummaryInfoBOS);
            settlementDocPreviewReqBO.setGroupMiningSettlementInfoBO(settlementInfoBO);
            settlementDocPreviewReqBO.setSummaryInfoBOS(new ArrayList<GroupMiningSettlementSummaryInfoBO>(statementSummaryInfoBOS));
            settlementDocPreviewReqBO.setDocumentno(settlementDocPreviewReqBO.getGroupMiningSettlementInfoBO().getDocumentno());
            settlementDocPreviewReqBO.setRegenerate(reqBO.getRegenerate());
            return settlementDocPreviewReqBO;
        }
        log.error("\u539f\u59cb\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)info));
        throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6807\u8bc6\u9519\u8bef");
    }

    private void initBigMineData(OriginalDocumentsInfo info, List<BillSummaryInfo> summaryInfos, BigMineSettlementInfoBO settlementInfoBO, List<BigMineSettlementSummaryInfoBO> summaryInfoBOS) {
        StringBuffer title = new StringBuffer("\u6cb3\u5317\u65ed\u9633\u80fd\u6e90\u6709\u9650\u516c\u53f8\u539f\u6599\u7164\u7ed3\u7b97\u5355");
        settlementInfoBO.setTitle(title.toString());
        settlementInfoBO.setDocumentno(info.getDocumentNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (info.getInvoiceDate() != null) {
            settlementInfoBO.setBilldate(simpleDateFormat.format(info.getInvoiceDate()));
        }
        settlementInfoBO.setUnit("\uff08\u5143\uff09");
        settlementInfoBO.setSettlementsupplier(info.getSettlementSupplier());
        StringJoiner settlementdate = new StringJoiner("\u81f3");
        if (info.getSumStartDate() != null && info.getSumEndDate() != null) {
            settlementdate.add(simpleDateFormat.format(info.getSumStartDate())).add(simpleDateFormat.format(info.getSumEndDate()));
            settlementInfoBO.setSettlementdate(settlementdate.toString());
        }
        settlementInfoBO.setCoalsupplier(info.getCoalSupplier());
        settlementInfoBO.setMaterial(info.getMaterialName());
        settlementInfoBO.setMinepoint(info.getMinePoint());
        settlementInfoBO.setTranstype(info.getTransType());
        settlementInfoBO.setPaytype(info.getPayType());
        if (!CollectionUtils.isEmpty(summaryInfos)) {
            BigDecimal carnumAll = BigDecimal.ZERO;
            BigDecimal netweightAll = BigDecimal.ZERO;
            BigDecimal mingshuiAll = BigDecimal.ZERO;
            BigDecimal shuifenamtAll = BigDecimal.ZERO;
            BigDecimal settlementquantityAll = BigDecimal.ZERO;
            BigDecimal applypayamtAll = BigDecimal.ZERO;
            for (BillSummaryInfo summaryInfo : summaryInfos) {
                if (!StringUtils.hasText((String)settlementInfoBO.getMaterial())) {
                    settlementInfoBO.setMaterial(summaryInfo.getMaterialName());
                }
                if (!StringUtils.hasText((String)settlementInfoBO.getContractno())) {
                    settlementInfoBO.setContractno(summaryInfo.getBindingContract());
                }
                BigMineSettlementSummaryInfoBO item = new BigMineSettlementSummaryInfoBO();
                BigDecimal carnum = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getCarNum());
                item.setCarnum(carnum.setScale(0).toString());
                carnumAll = carnumAll.add(carnum);
                BigDecimal actualReceiptNum = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getActualReceiptNum());
                BigDecimal mingshui = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getMingshui());
                BigDecimal deductImpurity = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getDeductImpurity());
                BigDecimal qualityDeduction = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getQualityDeduction());
                BigDecimal netweightAmt = mingshui.add(deductImpurity).add(actualReceiptNum);
                item.setNetweight(netweightAmt.setScale(2, 4).toString());
                netweightAll = netweightAll.add(netweightAmt);
                BigDecimal mingshuiAmt = mingshui.add(deductImpurity);
                item.setMingshui(mingshuiAmt.setScale(2, 4).toString());
                mingshuiAll = mingshuiAll.add(mingshuiAmt);
                item.setShuifenamt(qualityDeduction.setScale(2, 4).toString());
                shuifenamtAll = shuifenamtAll.add(qualityDeduction);
                BigDecimal settlementquantity = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getSettlementQuantity());
                item.setSettlementquantity(settlementquantity.setScale(2, 4).toString());
                settlementquantityAll = settlementquantityAll.add(settlementquantity);
                BigDecimal contractprice = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getContractPrice(), 2);
                item.setContractprice(contractprice.toString());
                BigDecimal adamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getAshDeductAmt(), 2);
                item.setAdamt(adamt.toString());
                BigDecimal vdafamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getVolatileMatterDeductPrice(), 2);
                item.setVdafamt(vdafamt.toString());
                BigDecimal stdamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getSulfurDeductPrice(), 2);
                item.setStdamt(stdamt.toString());
                BigDecimal gamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getGPrice(), 2);
                item.setGamt(gamt.toString());
                BigDecimal yamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getYPrice(), 2);
                item.setYamt(yamt.toString());
                BigDecimal settlementprice = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getSettlementPrice(), 2);
                item.setSettlementprice(settlementprice.toString());
                BigDecimal applypayamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getApplyPayAmt());
                item.setApplypayamt(applypayamt.setScale(2, 4).toString());
                applypayamtAll = applypayamtAll.add(applypayamt);
                summaryInfoBOS.add(item);
            }
            settlementInfoBO.setCarnumAll(carnumAll.setScale(0).toString());
            settlementInfoBO.setNetweightALl(netweightAll.setScale(2, 4).toString());
            settlementInfoBO.setMingshuiAll(mingshuiAll.setScale(2, 4).toString());
            settlementInfoBO.setShuifenamtAll(shuifenamtAll.setScale(2, 4).toString());
            settlementInfoBO.setApplypayamtAll(applypayamtAll.setScale(2, 4).toString());
            settlementInfoBO.setSettlementquantity(settlementquantityAll.setScale(2, 4).toString());
            BigDecimal orgissuetotalnum = BigDecimalUtils.getStr2BigDecimal(info.getOrgIssueTotalNum(), 4);
            settlementInfoBO.setOrgissuetotalnum(orgissuetotalnum.toString());
            BigDecimal minetotalnum = BigDecimalUtils.getStr2BigDecimal(info.getMineTotalNum(), 4);
            settlementInfoBO.setMinetotalnum(minetotalnum.toString());
            BigDecimal frightrate = BigDecimalUtils.getStr2BigDecimal(info.getFrightRate());
            settlementInfoBO.setFrightrate(new DecimalFormat("#,##0.0000").format(frightrate));
            BigDecimal minetotalamt = BigDecimalUtils.getStr2BigDecimal(info.getMineTotalPrice(), 4);
            settlementInfoBO.setMinetotalamt(minetotalamt.toString());
            BigDecimal adjustamt = BigDecimalUtils.getStr2BigDecimal(info.getAdjustAmt(), 2);
            settlementInfoBO.setAdjustamt(adjustamt.toString());
            BigDecimal setamt = BigDecimalUtils.getStr2BigDecimal(info.getActualPayAmt());
            settlementInfoBO.setSetamt(new DecimalFormat("#,##0.0000").format(setamt));
            String upper = AmountUtils.upper(setamt.setScale(2, 4));
            settlementInfoBO.setSetamtcapital(upper);
            BigDecimal speclineuseamt = BigDecimalUtils.getStr2BigDecimal(info.getSpecialLineUseFee());
            settlementInfoBO.setSpeclineuseamt(new DecimalFormat("#,##0.0000").format(speclineuseamt));
            BigDecimal minereduceamt = BigDecimalUtils.getStr2BigDecimal(info.getSpecialLineUseFee());
            settlementInfoBO.setMinereduceamt(new DecimalFormat("#,##0.0000").format(minereduceamt));
            settlementInfoBO.setRemark(info.getRemark());
            this.initStaff(info, settlementInfoBO);
        }
    }

    private void initGroupMiningData(OriginalDocumentsInfo info, List<BillSummaryInfo> summaryInfos, GroupMiningSettlementInfoBO settlementInfoBO, List<GroupMiningSettlementSummaryInfoBO> statementSummaryInfoBOS) {
        StringBuffer title = new StringBuffer("\u6cb3\u5317\u65ed\u9633\u80fd\u6e90\u6709\u9650\u516c\u53f8\u539f\u6599\u7164\u7ed3\u7b97\u5355");
        settlementInfoBO.setTitle(title.toString());
        settlementInfoBO.setDocumentno(info.getDocumentNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        settlementInfoBO.setBilldate(simpleDateFormat.format(info.getInvoiceDate()));
        settlementInfoBO.setUnit("\uff08\u5143\uff09");
        settlementInfoBO.setSettlementsupplier(info.getSettlementSupplier());
        StringJoiner settlementdate = new StringJoiner("\u81f3");
        if (info.getSumStartDate() != null && info.getSumEndDate() != null) {
            settlementdate.add(simpleDateFormat.format(info.getSumStartDate())).add(simpleDateFormat.format(info.getSumEndDate()));
            settlementInfoBO.setSettlementdate(settlementdate.toString());
        }
        settlementInfoBO.setCoalsupplier(info.getCoalSupplier());
        settlementInfoBO.setMaterial(info.getMaterialName());
        settlementInfoBO.setArea(info.getArea());
        settlementInfoBO.setTranstype(info.getTransType());
        settlementInfoBO.setPaytype(info.getPayType());
        if (!CollectionUtils.isEmpty(summaryInfos)) {
            BigDecimal carnumAll = BigDecimal.ZERO;
            BigDecimal netweightAll = BigDecimal.ZERO;
            BigDecimal mingshuiAll = BigDecimal.ZERO;
            BigDecimal shuifenamtAll = BigDecimal.ZERO;
            BigDecimal settlementquantityAll = BigDecimal.ZERO;
            BigDecimal applypayamtAll = BigDecimal.ZERO;
            for (BillSummaryInfo summaryInfo : summaryInfos) {
                if (!StringUtils.hasText((String)settlementInfoBO.getMaterial())) {
                    settlementInfoBO.setMaterial(summaryInfo.getMaterialName());
                }
                GroupMiningSettlementSummaryInfoBO item = new GroupMiningSettlementSummaryInfoBO();
                BigDecimal carnum = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getCarNum());
                item.setCarnum(carnum.setScale(0).toString());
                carnumAll = carnumAll.add(carnum);
                BigDecimal actualReceiptNum = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getActualReceiptNum());
                BigDecimal mingshui = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getMingshui());
                BigDecimal deductImpurity = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getDeductImpurity());
                BigDecimal qualityDeduction = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getQualityDeduction());
                BigDecimal netweightAmt = mingshui.add(deductImpurity).add(actualReceiptNum);
                item.setNetweight(netweightAmt.setScale(2, 4).toString());
                netweightAll = netweightAll.add(netweightAmt);
                BigDecimal mingshuiAmt = mingshui.add(deductImpurity);
                item.setMingshui(mingshuiAmt.setScale(2, 4).toString());
                mingshuiAll = mingshuiAll.add(mingshuiAmt);
                item.setShuifenamt(qualityDeduction.setScale(2, 4).toString());
                shuifenamtAll = shuifenamtAll.add(qualityDeduction);
                BigDecimal settlementquantity = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getSettlementQuantity());
                item.setSettlementquantity(settlementquantity.setScale(2, 4).toString());
                settlementquantityAll = settlementquantityAll.add(settlementquantity);
                BigDecimal contractprice = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getContractPrice(), 2);
                item.setContractprice(contractprice.toString());
                BigDecimal adamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getAshDeductAmt(), 2);
                item.setAdamt(adamt.toString());
                BigDecimal vdafamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getVolatileMatterDeductPrice(), 2);
                item.setVdafamt(vdafamt.toString());
                BigDecimal stdamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getSulfurDeductPrice(), 2);
                item.setStdamt(stdamt.toString());
                BigDecimal gamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getGPrice(), 2);
                item.setGamt(gamt.toString());
                BigDecimal yamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getYPrice(), 2);
                item.setYamt(yamt.toString());
                BigDecimal settlementprice = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getSettlementPrice(), 2);
                item.setSettlementprice(settlementprice.toString());
                BigDecimal applypayamt = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getApplyPayAmt());
                item.setApplypayamt(applypayamt.setScale(2, 4).toString());
                applypayamtAll = applypayamtAll.add(applypayamt);
                statementSummaryInfoBOS.add(item);
            }
            settlementInfoBO.setCarnumAll(carnumAll.setScale(0).toString());
            settlementInfoBO.setNetweightALl(netweightAll.setScale(2, 4).toString());
            settlementInfoBO.setMingshuiAll(mingshuiAll.setScale(2, 4).toString());
            settlementInfoBO.setShuifenamtAll(shuifenamtAll.setScale(2, 4).toString());
            settlementInfoBO.setApplypayamtAll(applypayamtAll.setScale(2, 4).toString());
            settlementInfoBO.setSettlementquantity(settlementquantityAll.setScale(2, 4).toString());
            BigDecimal compensateweight = BigDecimalUtils.getStr2BigDecimal(info.getHisWeightAmt(), 4);
            settlementInfoBO.setCompensateweight(compensateweight.toString());
            BigDecimal compensatequantif = BigDecimalUtils.getStr2BigDecimal(info.getHisQuantityAmt(), 4);
            settlementInfoBO.setCompensatequantif(compensatequantif.toString());
            BigDecimal concessionamt = BigDecimalUtils.getStr2BigDecimal(info.getConcessionTotalAmt(), 4);
            settlementInfoBO.setConcessionamt(concessionamt.toString());
            BigDecimal adjustamt = BigDecimalUtils.getStr2BigDecimal(info.getAdjustAmt(), 2);
            settlementInfoBO.setAdjustamt(adjustamt.toString());
            BigDecimal setamt = BigDecimalUtils.getStr2BigDecimal(info.getActualPayAmt());
            settlementInfoBO.setSetamt(new DecimalFormat("#,##0.0000").format(setamt));
            String upper = AmountUtils.upper(setamt.setScale(2, 4));
            settlementInfoBO.setSetamtcapital(upper);
            settlementInfoBO.setRemark(info.getRemark());
            this.initStaff(info, settlementInfoBO);
        }
    }

    private void initStaff(OriginalDocumentsInfo info, SettlementInfoBO settlementInfoBO) {
        settlementInfoBO.setSalesman(info.getBuyerId());
        if (StringUtils.hasText((String)info.getSummeryHeadId())) {
            List itemRspBOS;
            BusiGetCirculationInfoFromErpReqBO reqBO = new BusiGetCirculationInfoFromErpReqBO();
            reqBO.setBillid(info.getSummeryHeadId());
            BusiGetCirculationInfoFromErpRspBO rspBO = this.busiGetCirculationInfoFromErpService.getCirculationInfoFromErp(reqBO);
            if ("0000".equals(rspBO.getCode()) && StringUtils.hasText((String)rspBO.getData()) && !CollectionUtils.isEmpty((Collection)(itemRspBOS = JSON.parseArray((String)rspBO.getData(), BusiGetCirculationItemRspBO.class)))) {
                int size = itemRspBOS.size();
                if (size > 0) {
                    settlementInfoBO.setStaff(((BusiGetCirculationItemRspBO)itemRspBOS.get(0)).getSenderman());
                    settlementInfoBO.setStaffmanager(((BusiGetCirculationItemRspBO)itemRspBOS.get(0)).getCheckman());
                }
                if (size > 1) {
                    settlementInfoBO.setTreasurer(((BusiGetCirculationItemRspBO)itemRspBOS.get(1)).getCheckman());
                }
                if (size > 2) {
                    settlementInfoBO.setTreasurermanager(((BusiGetCirculationItemRspBO)itemRspBOS.get(2)).getCheckman());
                }
            }
        }
    }

    private void paramsNotBlank(BusiDocumentPreviewReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new PfscExtBusinessException("18000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getDocumentNo())) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

