/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.InvoicePushErpService;
import com.tydic.pfscext.api.busi.bo.InvoicePushErpRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.DPayItemStroInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.DPayItemStroInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.BillNotificationInfoVO;
import com.tydic.pfscext.dao.vo.PayInvoiceDetailVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiApplyInvoiceSyncErpService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpRspBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceSyncErpRspDataBO;
import com.tydic.pfscext.external.umc.api.UmcPurSupInfoListQryExternalService;
import com.tydic.pfscext.vo.DPayItemStroVO;
import com.tydic.umcext.ability.supplier.UmcMemInfoQryListAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcMemInfoQryListAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcMemInfoQryListAbilityRspBO;
import com.tydic.umcext.bo.base.UmcReqInfoBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=InvoicePushErpService.class)
public class InvoicePushErpServiceImpl
extends UmcReqInfoBO
implements InvoicePushErpService {
    private static final Logger logger = LoggerFactory.getLogger(InvoicePushErpServiceImpl.class);
    @Value(value="${SEND_ERP_WAIT_MILLISECOND:500}")
    private int WAIT_SECONDS;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BusiApplyInvoiceSyncErpService busiApplyInvoiceSyncErpService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcMemInfoQryListAbilityService umcMemInfoQryListAbilityService;
    @Autowired
    private UmcPurSupInfoListQryExternalService umcPurSupInfoListQryExternalService;
    @Autowired
    private DPayItemStroInfoMapper dPayItemStroInfoMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    public InvoicePushErpRspBO pushErp() {
        InvoicePushErpRspBO rspBO = new InvoicePushErpRspBO();
        PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
        invoiceInfo.setInvoiceStatus("03");
        invoiceInfo.setPushStatus("0");
        List<PayInvoiceDetailVO> payInvoiceDetailVOList = this.payInvoiceInfoMapper.selectJoinDetailByStatus(invoiceInfo);
        if (CollectionUtils.isEmpty(payInvoiceDetailVOList)) {
            rspBO.setRespCode("18000");
            rspBO.setRespCode("\u6ca1\u6709\u53ef\u4ee5\u5f00\u7684\u53d1\u7968");
            return rspBO;
        }
        List<String> invoiceNoList = payInvoiceDetailVOList.stream().filter(item -> StringUtils.hasText((String)item.getInvoiceNo())).map(PayInvoiceDetail::getInvoiceNo).distinct().collect(Collectors.toList());
        Map<String, List<PayInvoiceDetailVO>> invoiceNoMap = payInvoiceDetailVOList.stream().filter(item -> StringUtils.hasText((String)item.getInvoiceNo())).collect(Collectors.groupingBy(PayInvoiceDetail::getInvoiceNo));
        Map<String, List<BillNotificationInfo>> billNotificationInfoMap = this.selectBillNotificationInfoByExtPurInvoiceNos(invoiceNoList);
        for (String invoiceNO : invoiceNoList) {
            List<BillNotificationInfo> billNotificationInfos = billNotificationInfoMap.get(invoiceNO);
            if (CollectionUtils.isEmpty(billNotificationInfos)) {
                List<PayInvoiceDetailVO> detailVOS = invoiceNoMap.get(invoiceNO);
                if (CollectionUtils.isEmpty(detailVOS)) {
                    logger.error("\u53d1\u7968\u53f7[{}]\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f", (Object)invoiceNO);
                    continue;
                }
                try {
                    logger.debug("\u5f00\u59cb\u540c\u6b65\u53d1\u7968[ {} ].\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)invoiceNO, (Object)JSON.toJSONString(detailVOS));
                    String rspBOJson = this.initInvoiceDataAndPushErp(detailVOS);
                    logger.debug("\u53d1\u7968[ {} ]\u540c\u6b65\u7ed3\u675f\u3002ERP\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)invoiceNO, (Object)rspBOJson);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u7968\u53f7\uff1a{} \u63a8\u9001ERP\u5931\u8d25\u3002\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)invoiceNO, (Object)JSON.toJSONString(detailVOS));
                    e.printStackTrace();
                }
                continue;
            }
            if (billNotificationInfos.size() > 1) {
                logger.error("\u53d1\u7968\u53f7\uff1a{} \u5b58\u5728\u4e8e\u591a\u6761\u901a\u77e5\u5355\u4e2d\uff1a{}", (Object)invoiceNO, (Object)JSON.toJSONString(billNotificationInfos));
            }
            logger.info("\u53d1\u7968[{}]\u5df2\u540c\u6b65\u81f3ERP", (Object)invoiceNO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u540c\u6b65\u5b8c\u6210");
        return rspBO;
    }

    private String initInvoiceDataAndPushErp(List<PayInvoiceDetailVO> detailVOS) {
        BusiApplyInvoiceSyncErpReqBO busiApplyInvoiceSyncErpReqBO = this.initInvoiceDate(detailVOS);
        BusiApplyInvoiceSyncErpRspBO busiApplyInvoiceSyncErpRspBO = this.busiApplyInvoiceSyncErpService.applyInvoice(busiApplyInvoiceSyncErpReqBO);
        if (busiApplyInvoiceSyncErpRspBO == null || !StringUtils.hasText((String)busiApplyInvoiceSyncErpRspBO.getCode()) || !"0".equals(busiApplyInvoiceSyncErpRspBO.getCode())) {
            logger.info("\u8c03\u7528erp\u5931\u8d25, \u51fa\u53c2{}", (Object)busiApplyInvoiceSyncErpRspBO);
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u63a8\u9001ERP\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)busiApplyInvoiceSyncErpRspBO));
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            String jsonStr = busiApplyInvoiceSyncErpRspBO.getData();
            logger.info("\u8fd4\u56de\u7684\u53c2\u6570\u662f\uff1a{}", (Object)jsonStr);
            BusiApplyInvoiceSyncErpRspDataBO busiApplyInvoiceSyncErpRspDataBO = (BusiApplyInvoiceSyncErpRspDataBO)JSON.parseObject((String)jsonStr, BusiApplyInvoiceSyncErpRspDataBO.class);
            BillNotificationInfoVO info = new BillNotificationInfoVO();
            info.setNotificationNo(detailVOS.get(0).getNotificationNo());
            info.setExtPurInvoiceNo(busiApplyInvoiceSyncErpRspDataBO.getVbillcode());
            logger.info("\u5f00\u7968\u4fe1\u606f\u662f\uff1a [{}]", (Object)info);
            List pkInvoiceBList = busiApplyInvoiceSyncErpRspDataBO.getPkInvoiceBList();
            logger.info("\u53d1\u7968\u8868\u4f53\u662f\uff1a [{}]", (Object)busiApplyInvoiceSyncErpRspDataBO);
            String json = JSON.toJSONString((Object)pkInvoiceBList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            logger.info("\u66f4\u65b0\u8fd4\u56de\u7684JSON\u6570\u636e:{}", (Object)json);
            PayInvoiceInfo payInvoiceInfo = new PayInvoiceInfo();
            payInvoiceInfo.setIncoiveCrownoList(json);
            payInvoiceInfo.setPkInvoice(busiApplyInvoiceSyncErpRspDataBO.getPkInvoice());
            payInvoiceInfo.setInvoiceNo(busiApplyInvoiceSyncErpReqBO.getVbillcode());
            payInvoiceInfo.setPushStatus("1");
            int updateResult = this.payInvoiceInfoMapper.updateByInvoiceNo(payInvoiceInfo);
            if (updateResult < 0) {
                throw new PfscExtBusinessException("0001", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
            int update = this.billNotificationInfoMapper.updateExtPur(info);
            if (update < 0) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25");
            }
            this.dataSourceTransactionManager.commit(status);
            return JSON.toJSONString((Object)busiApplyInvoiceSyncErpRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
        catch (Exception e) {
            logger.info("\u63a8\u9001\u540e\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25\uff0c\u5165\u53c2{}.\u9519\u8bef\u65e5\u5fd7\uff1a{}", (Object)JSON.toJSONString((Object)busiApplyInvoiceSyncErpReqBO), (Object)e.getMessage());
            this.dataSourceTransactionManager.rollback(status);
            e.printStackTrace();
            return JSON.toJSONString((Object)busiApplyInvoiceSyncErpRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
    }

    private BusiApplyInvoiceSyncErpReqBO initInvoiceDate(List<PayInvoiceDetailVO> detailVOS) {
        BusiApplyInvoiceSyncErpReqBO busiApplyInvoiceSyncErpReqBO = new BusiApplyInvoiceSyncErpReqBO();
        List notifNoList = detailVOS.stream().map(PayInvoiceDetailVO::getNotificationNo).distinct().collect(Collectors.toList());
        if (notifNoList.size() > 1) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u53d1\u7968\u7684\u901a\u77e5\u5355\u53f7\u4e0d\u4e00\u81f4");
        }
        PayInvoiceDetailVO payInvoiceDetailVO = detailVOS.get(0);
        List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(payInvoiceDetailVO.getNotificationNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = simpleDateFormat.format(payInvoiceDetailVO.getInvoiceDate());
        busiApplyInvoiceSyncErpReqBO.setDbilldate(format);
        if (!CollectionUtils.isEmpty(payPurchaseOrderInfos)) {
            Long supplierNo = payPurchaseOrderInfos.get(0).getSupplierNo();
            busiApplyInvoiceSyncErpReqBO.setPkSupplier(supplierNo == null ? "" : supplierNo.toString());
            String extPurOrderNo = payPurchaseOrderInfos.get(0).getExtPurOrderNo();
            logger.info("pk_order\uff1a{}", (Object)extPurOrderNo);
            busiApplyInvoiceSyncErpReqBO.setPkOrder(extPurOrderNo);
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByNotion(payPurchaseOrderInfos.get(0).getNotificationNo());
            if (billNotificationInfo != null) {
                busiApplyInvoiceSyncErpReqBO.setBillmaker(this.umcPurSupInfoListQryExternalService.getBillMakerUMC(billNotificationInfo.getUserId()));
                busiApplyInvoiceSyncErpReqBO.setPkOrg(billNotificationInfo.getStartOrgId());
                busiApplyInvoiceSyncErpReqBO.setVdef3(billNotificationInfo.getTransType());
                busiApplyInvoiceSyncErpReqBO.setVdef4(billNotificationInfo.getInputTaxType());
                String format1 = simpleDateFormat.format(billNotificationInfo.getInoviceIssunaceDate());
                busiApplyInvoiceSyncErpReqBO.setVdef70(format1);
                busiApplyInvoiceSyncErpReqBO.setPkBalaType(billNotificationInfo.getSettleType());
                busiApplyInvoiceSyncErpReqBO.setVdef2(billNotificationInfo.getPurchContractNo());
                busiApplyInvoiceSyncErpReqBO.setDarrivedate(simpleDateFormat.format(billNotificationInfo.getArrivalDate()));
                busiApplyInvoiceSyncErpReqBO.setDbilldate(simpleDateFormat.format(billNotificationInfo.getCreditDate()));
                busiApplyInvoiceSyncErpReqBO.setVmemo(billNotificationInfo.getRemark());
            }
        }
        busiApplyInvoiceSyncErpReqBO.setVbillcode(payInvoiceDetailVO.getInvoiceNo());
        BigDecimal quantityAll = BigDecimal.ZERO;
        for (PayInvoiceDetailVO item : detailVOS) {
            if (null == item.getQuantity()) {
                throw new PfscExtBusinessException("18000", "\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            quantityAll = quantityAll.add(item.getQuantity());
        }
        if (null == payInvoiceDetailVO.getAmt()) {
            throw new PfscExtBusinessException("18000", "\u5546\u54c1\u91d1\u989d\u4e3a\u7a7a");
        }
        if (null == payInvoiceDetailVO.getTaxRate()) {
            throw new PfscExtBusinessException("18000", "\u7a0e\u7387\u4e3a\u7a7a");
        }
        busiApplyInvoiceSyncErpReqBO.setNtotalastnum(quantityAll.setScale(2, 4).toString());
        busiApplyInvoiceSyncErpReqBO.setNtotalorigmny(payInvoiceDetailVO.getAmt().toString());
        UmcMemInfoQryListAbilityReqBO bo = new UmcMemInfoQryListAbilityReqBO();
        ArrayList ids = new ArrayList();
        bo.setMemIds(ids);
        UmcMemInfoQryListAbilityRspBO infoBy = this.umcMemInfoQryListAbilityService.getMemInfoBy(bo);
        List rows = infoBy.getRows();
        if (rows == null) {
            throw new PfscExtBusinessException("18003", "\u4f1a\u5458\u8d26\u53f7\u4e3a\u7a7a\u5f02\u5e38");
        }
        this.initInstorHeadAndBody(payInvoiceDetailVO, busiApplyInvoiceSyncErpReqBO);
        return busiApplyInvoiceSyncErpReqBO;
    }

    private void initInstorHeadAndBody(PayInvoiceDetailVO payInvoiceDetailVO, BusiApplyInvoiceSyncErpReqBO busiApplyInvoiceSyncErpReqBO) {
        HashSet<String> head = new HashSet<String>();
        ArrayList<BusiApplyInvoiceSyncErpBO> bodys = new ArrayList<BusiApplyInvoiceSyncErpBO>();
        List<DPayItemStroInfo> dPayItemStroInfos = this.dPayItemStroInfoMapper.selectByNotionNo(payInvoiceDetailVO.getNotificationNo());
        int crown = 10;
        for (DPayItemStroInfo dPayItemStroInfo : dPayItemStroInfos) {
            head.add(dPayItemStroInfo.getPkInstroHeadNo());
            BusiApplyInvoiceSyncErpBO erpBO = new BusiApplyInvoiceSyncErpBO();
            erpBO.setRowno(String.valueOf(crown));
            erpBO.setPkInfoBody(dPayItemStroInfo.getPkInstoBody());
            erpBO.setPkMaterial(dPayItemStroInfo.getPkMaterial());
            if (null == dPayItemStroInfo.getNorigTaxPrice()) {
                throw new PfscExtBusinessException("18000", "\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
            }
            if (null == dPayItemStroInfo.getNnum()) {
                throw new PfscExtBusinessException("18000", "\u5165\u5e93\u5355\u6570\u91cf\u4e3a\u7a7a");
            }
            BigDecimal taxRate = payInvoiceDetailVO.getTaxRate();
            BigDecimal nnum = new BigDecimal(dPayItemStroInfo.getNnum()).setScale(2, 4);
            erpBO.setNnum(nnum.toString());
            BigDecimal norigTaxPrice = new BigDecimal(dPayItemStroInfo.getNorigTaxPrice()).setScale(4, 4);
            erpBO.setNorigtaxprice(norigTaxPrice.toString());
            BigDecimal norigprice = norigTaxPrice.divide(new BigDecimal(1).add(taxRate), 4, 4);
            erpBO.setNorigprice(norigprice.toString());
            BigDecimal norigmny = norigprice.multiply(nnum).setScale(2, 4);
            erpBO.setNorigmny(norigmny.toString());
            BigDecimal norigtaxmny = norigTaxPrice.multiply(nnum).setScale(2, 4);
            erpBO.setNorigtaxmny(norigtaxmny.toString());
            erpBO.setNtax(norigtaxmny.subtract(norigmny).toString());
            bodys.add(erpBO);
            crown += 10;
        }
        ArrayList heads = new ArrayList(head);
        busiApplyInvoiceSyncErpReqBO.setPkInstorHeadKList(heads);
        busiApplyInvoiceSyncErpReqBO.setInvoicelist(bodys);
    }

    private Map<String, List<BillNotificationInfo>> selectBillNotificationInfoByExtPurInvoiceNos(List<String> invoiceNoList) {
        Map<String, List<BillNotificationInfo>> billNotificationInfoMap = new HashMap<String, List<BillNotificationInfo>>();
        if (!CollectionUtils.isEmpty(invoiceNoList)) {
            int MAX_COUNT;
            ArrayList<BillNotificationInfo> billNotificationInfoList = new ArrayList<BillNotificationInfo>();
            int LIST_SIZE = invoiceNoList.size();
            if (LIST_SIZE > (MAX_COUNT = 500)) {
                for (int i = 0; i < LIST_SIZE; i += MAX_COUNT) {
                    int toIndex = i + MAX_COUNT > LIST_SIZE ? LIST_SIZE : i + MAX_COUNT;
                    List<String> subList = invoiceNoList.subList(i, toIndex);
                    BillNotificationInfoExt vo = new BillNotificationInfoExt();
                    vo.setInvoiceNoInList(subList);
                    List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.getList(vo);
                    billNotificationInfoList.addAll(billNotificationInfos);
                }
            } else {
                BillNotificationInfoExt vo = new BillNotificationInfoExt();
                vo.setInvoiceNoInList(invoiceNoList);
                List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.getList(vo);
                billNotificationInfoList.addAll(billNotificationInfos);
            }
            billNotificationInfoMap = billNotificationInfoList.stream().collect(Collectors.groupingBy(BillNotificationInfo::getExtPurInvoiceNo));
        }
        return billNotificationInfoMap;
    }

    public InvoicePushErpRspBO pushErpOld111111111111111() {
        InvoicePushErpRspBO rspBO = new InvoicePushErpRspBO();
        ArrayList busiApplyInvoiceSyncErpReqBOList = new ArrayList();
        PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
        invoiceInfo.setInvoiceStatus("03");
        invoiceInfo.setPushStatus("0");
        List<PayInvoiceDetailVO> payInvoiceDetailVOList = this.payInvoiceInfoMapper.selectJoinDetailByStatus(invoiceInfo);
        if (payInvoiceDetailVOList == null) {
            rspBO.setRespCode("\u6ca1\u6709\u53ef\u4ee5\u5f00\u7684\u53d1\u7968");
            return rspBO;
        }
        HashMap payInvoiceDetailVOMap = new HashMap();
        payInvoiceDetailVOList.forEach(payInvoiceDetailVO -> payInvoiceDetailVOMap.put(payInvoiceDetailVO.getInvoiceNo(), payInvoiceDetailVO));
        payInvoiceDetailVOMap.values().forEach(payInvoiceDetailVO -> {
            BusiApplyInvoiceSyncErpReqBO busiApplyInvoiceSyncErpReqBO = new BusiApplyInvoiceSyncErpReqBO();
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByExtPurNo(payInvoiceDetailVO.getInvoiceNo());
            if (billNotificationInfo == null) {
                List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(payInvoiceDetailVO.getNotificationNo());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String format = simpleDateFormat.format(payInvoiceDetailVO.getInvoiceDate());
                busiApplyInvoiceSyncErpReqBO.setDbilldate(format);
                if (payPurchaseOrderInfos != null && payPurchaseOrderInfos.size() > 0) {
                    busiApplyInvoiceSyncErpReqBO.setPkSupplier(String.valueOf(payPurchaseOrderInfos.get(0).getSupplierNo()));
                    logger.info("pk_order", (Object)payPurchaseOrderInfos.get(0).getExtPurOrderNo());
                    busiApplyInvoiceSyncErpReqBO.setPkOrder(payPurchaseOrderInfos.get(0).getExtPurOrderNo());
                    BillNotificationInfo billNotificationInfos = this.billNotificationInfoMapper.selectByNotion(payPurchaseOrderInfos.get(0).getNotificationNo());
                    if (billNotificationInfos != null) {
                        busiApplyInvoiceSyncErpReqBO.setPkOrg(billNotificationInfos.getStartOrgId());
                        busiApplyInvoiceSyncErpReqBO.setVdef3(billNotificationInfos.getTransType());
                        busiApplyInvoiceSyncErpReqBO.setVdef4(billNotificationInfos.getInputTaxType());
                        String format1 = simpleDateFormat.format(billNotificationInfos.getInoviceIssunaceDate());
                        busiApplyInvoiceSyncErpReqBO.setVdef70(format1);
                        busiApplyInvoiceSyncErpReqBO.setPkBalaType(billNotificationInfos.getSettleType());
                        busiApplyInvoiceSyncErpReqBO.setVdef2(billNotificationInfos.getPurchContractNo());
                        busiApplyInvoiceSyncErpReqBO.setDarrivedate(simpleDateFormat.format(billNotificationInfos.getArrivalDate()));
                        busiApplyInvoiceSyncErpReqBO.setDbilldate(simpleDateFormat.format(billNotificationInfos.getCreditDate()));
                        busiApplyInvoiceSyncErpReqBO.setVmemo(billNotificationInfos.getRemark());
                    }
                    Long supplierNo = payPurchaseOrderInfos.get(0).getSupplierNo();
                    busiApplyInvoiceSyncErpReqBO.setPkSupplier(supplierNo.toString());
                }
                busiApplyInvoiceSyncErpReqBO.setVbillcode(payInvoiceDetailVO.getInvoiceNo());
                if (null == payInvoiceDetailVO.getQuantity()) {
                    throw new PfscExtBusinessException("18000", "\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
                }
                if (null == payInvoiceDetailVO.getAmt()) {
                    throw new PfscExtBusinessException("18000", "\u5546\u54c1\u91d1\u989d\u4e3a\u7a7a");
                }
                if (null == payInvoiceDetailVO.getTaxRate()) {
                    throw new PfscExtBusinessException("18000", "\u7a0e\u7387\u4e3a\u7a7a");
                }
                busiApplyInvoiceSyncErpReqBO.setNtotalastnum(payInvoiceDetailVO.getQuantity().toString());
                busiApplyInvoiceSyncErpReqBO.setNtotalorigmny(payInvoiceDetailVO.getAmt().toString());
                UmcMemInfoQryListAbilityReqBO bo = new UmcMemInfoQryListAbilityReqBO();
                ArrayList ids = new ArrayList();
                bo.setMemIds(ids);
                UmcMemInfoQryListAbilityRspBO infoBy = this.umcMemInfoQryListAbilityService.getMemInfoBy(bo);
                List rows = infoBy.getRows();
                if (rows == null) {
                    throw new PfscExtBusinessException("\u4f1a\u5458\u8d26\u53f7\u4e3a\u7a7a\u5f02\u5e38", "18003");
                }
                HashSet<String> head = new HashSet<String>();
                ArrayList<BusiApplyInvoiceSyncErpBO> bodys = new ArrayList<BusiApplyInvoiceSyncErpBO>();
                List<DPayItemStroInfo> dPayItemStroInfos = this.dPayItemStroInfoMapper.selectByNotionNo(payInvoiceDetailVO.getNotificationNo());
                int crown = 10;
                for (DPayItemStroInfo dPayItemStroInfo : dPayItemStroInfos) {
                    head.add(dPayItemStroInfo.getPkInstroHeadNo());
                    BusiApplyInvoiceSyncErpBO erpBO = new BusiApplyInvoiceSyncErpBO();
                    erpBO.setRowno(String.valueOf(crown));
                    erpBO.setPkInfoBody(dPayItemStroInfo.getPkInstoBody());
                    erpBO.setPkMaterial(dPayItemStroInfo.getPkMaterial());
                    if (null == dPayItemStroInfo.getNorigTaxPrice()) {
                        throw new PfscExtBusinessException("18000", "\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                    }
                    if (null == dPayItemStroInfo.getNnum()) {
                        throw new PfscExtBusinessException("18000", "\u5165\u5e93\u5355\u6570\u91cf\u4e3a\u7a7a");
                    }
                    BigDecimal taxRate = payInvoiceDetailVO.getTaxRate();
                    BigDecimal nnum = new BigDecimal(dPayItemStroInfo.getNnum()).setScale(2, 4);
                    erpBO.setNnum(nnum.toString());
                    BigDecimal norigTaxPrice = new BigDecimal(dPayItemStroInfo.getNorigTaxPrice()).setScale(4, 4);
                    erpBO.setNorigtaxprice(norigTaxPrice.toString());
                    BigDecimal norigprice = norigTaxPrice.divide(new BigDecimal(1).add(taxRate), 4, 4);
                    erpBO.setNorigprice(norigprice.toString());
                    BigDecimal norigmny = norigprice.multiply(nnum).setScale(2, 4);
                    erpBO.setNorigmny(norigmny.toString());
                    BigDecimal norigtaxmny = norigTaxPrice.multiply(nnum).setScale(2, 4);
                    erpBO.setNorigtaxmny(norigtaxmny.toString());
                    erpBO.setNtax(norigtaxmny.subtract(norigmny).toString());
                    bodys.add(erpBO);
                    crown += 10;
                }
                ArrayList heads = new ArrayList(head);
                busiApplyInvoiceSyncErpReqBO.setPkInstorHeadKList(heads);
                busiApplyInvoiceSyncErpReqBO.setInvoicelist(bodys);
                BusiApplyInvoiceSyncErpRspBO busiApplyInvoiceSyncErpRspBO = null;
                try {
                    busiApplyInvoiceSyncErpRspBO = this.busiApplyInvoiceSyncErpService.applyInvoice(busiApplyInvoiceSyncErpReqBO);
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)busiApplyInvoiceSyncErpRspBO.getCode()) && !"0".equals(busiApplyInvoiceSyncErpRspBO.getCode())) {
                        logger.info("\u8c03\u7528erp\u5931\u8d25, \u51fa\u53c2{}", (Object)busiApplyInvoiceSyncErpRspBO);
                    }
                    String jsonStr = busiApplyInvoiceSyncErpRspBO.getData();
                    logger.info("\u8fd4\u56de\u7684\u53c2\u6570\u662f\uff1a{}", (Object)jsonStr);
                    BusiApplyInvoiceSyncErpRspDataBO busiApplyInvoiceSyncErpRspDataBO = (BusiApplyInvoiceSyncErpRspDataBO)JSON.parseObject((String)jsonStr, BusiApplyInvoiceSyncErpRspDataBO.class);
                    BillNotificationInfoVO info = new BillNotificationInfoVO();
                    info.setNotificationNo(payInvoiceDetailVO.getNotificationNo());
                    info.setExtPurInvoiceNo(busiApplyInvoiceSyncErpRspDataBO.getVbillcode());
                    logger.info("\u5f00\u7968\u4fe1\u606f\u662f\uff1a [{}]", (Object)info);
                    List pkInvoiceBList = busiApplyInvoiceSyncErpRspDataBO.getPkInvoiceBList();
                    logger.info("\u53d1\u7968\u8868\u4f53\u662f\uff1a [{}]", (Object)busiApplyInvoiceSyncErpRspDataBO);
                    String json = JSON.toJSONString((Object)pkInvoiceBList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    logger.info("\u66f4\u65b0\u8fd4\u56de\u7684JSON\u6570\u636e:{}", (Object)json);
                    PayInvoiceInfo payInvoiceInfo = new PayInvoiceInfo();
                    payInvoiceInfo.setIncoiveCrownoList(json);
                    payInvoiceInfo.setPkInvoice(busiApplyInvoiceSyncErpRspDataBO.getPkInvoice());
                    payInvoiceInfo.setInvoiceNo(busiApplyInvoiceSyncErpReqBO.getVbillcode());
                    payInvoiceInfo.setPushStatus("1");
                    int updateResult = this.payInvoiceInfoMapper.updateByInvoiceNo(payInvoiceInfo);
                    if (updateResult < 0) {
                        throw new PfscExtBusinessException("0001", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
                    }
                    int update = this.billNotificationInfoMapper.updateExtPur(info);
                    if (update < 0) {
                        throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    logger.info("\u8c03\u7528erp\u5931\u8d25, \u5165\u53c2{}, \u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)busiApplyInvoiceSyncErpReqBO, (Object)e);
                }
            } else {
                logger.info("\u53d1\u7968[{}]\u5df2\u540c\u6b65\u5230erp", (Object)payInvoiceDetailVO.getInvoiceNo());
            }
        });
        return rspBO;
    }

    public List<DPayItemStroVO> groupList(List<DPayItemStroInfo> dPayItemStroInfos) {
        HashMap headToBody = new HashMap(16);
        LinkedList<DPayItemStroVO> items = new LinkedList<DPayItemStroVO>();
        dPayItemStroInfos.forEach(dPayItemStroInfo -> {
            String pkInstroHeadNo = dPayItemStroInfo.getPkInstroHeadNo();
            BusiApplyInvoiceSyncErpBO erpBO = new BusiApplyInvoiceSyncErpBO();
            erpBO.setNnum(dPayItemStroInfo.getNnum().toString());
            erpBO.setNorigtaxprice(dPayItemStroInfo.getNorigTaxPrice().toString());
            erpBO.setPkInfoBody(dPayItemStroInfo.getPkInstoBody());
            erpBO.setPkMaterial(dPayItemStroInfo.getPkMaterial());
            if (!headToBody.containsKey(dPayItemStroInfo.getPkInstroHeadNo())) {
                ArrayList<BusiApplyInvoiceSyncErpBO> busiApplyInvoiceSyncErpBOs = new ArrayList<BusiApplyInvoiceSyncErpBO>();
                busiApplyInvoiceSyncErpBOs.add(erpBO);
                headToBody.put(pkInstroHeadNo, busiApplyInvoiceSyncErpBOs);
            } else {
                List list = (List)headToBody.get(pkInstroHeadNo);
                list.add(erpBO);
                headToBody.put(pkInstroHeadNo, list);
            }
        });
        Set entries = headToBody.entrySet();
        entries.forEach(entey -> {
            DPayItemStroVO vo = new DPayItemStroVO();
            vo.setPkStroHead((String)entey.getKey());
            vo.setBusiApplyInvoiceSyncErpBOS((List)entey.getValue());
        });
        return items;
    }

    public static void main(String[] args) {
        String jsonStr = "{\"pk_invoice\":\"1001A610000000BIIUDZ\",\"vbillcode\":\"202101260000004\",\"pk_invoice_b_list\":[{\"crowno\":\"00\",\"pk_invoice_b\":\"1001A610000000BIIUE0\"}]}} ";
        BusiApplyInvoiceSyncErpRspDataBO busiApplyInvoiceSyncErpRspDataBO = (BusiApplyInvoiceSyncErpRspDataBO)JSON.parseObject((String)jsonStr, BusiApplyInvoiceSyncErpRspDataBO.class);
    }
}

