/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.ReconciliationHisService;
import com.tydic.pfscext.api.busi.bo.BusiPushSaleOrderInfoOrderReqBO;
import com.tydic.pfscext.api.busi.bo.ReconciliationReqBo;
import com.tydic.pfscext.api.busi.vo.ReconciliationHisVo;
import com.tydic.pfscext.api.busi.vo.ReconciliationRspVo;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.ReconciliationSupMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.ReconciliationSup;
import com.tydic.pfscext.dao.po.ReconcilitionHis;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=ReconciliationHisService.class)
public class ReconciliationHisServiceImpl
implements ReconciliationHisService {
    private DictionaryAtomService dicDictionaryService;
    private ReconcilitionHisMapper reconcilitionHisMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private ReconciliationSupMapper reconciliationSupMapper;
    @Autowired
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;

    @Autowired
    public ReconciliationHisServiceImpl(DictionaryAtomService dicDictionaryService, ReconcilitionHisMapper reconcilitionHisMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper) {
        this.dicDictionaryService = dicDictionaryService;
        this.reconcilitionHisMapper = reconcilitionHisMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
    }

    public ReconciliationRspVo getReceiptInfo(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        try {
            if (StringUtils.hasText((String)condition.getOrderId())) {
                Long.valueOf(condition.getOrderId());
            }
        }
        catch (Exception e) {
            rspVo.setPageNo(Integer.valueOf(1));
            rspVo.setRecordsTotal(Integer.valueOf(0));
            rspVo.setTotal(Integer.valueOf(1));
            rspVo.setRows(new ArrayList());
            rspVo.setRespCode("0000");
            rspVo.setRespDesc("\u6210\u529f");
            return rspVo;
        }
        if ("0".equals(condition.getIsProfessionalOrgExt())) {
            condition.setOperUnitNo(condition.getCompanyId());
        } else {
            condition.setPurchaseNo(condition.getCompanyId());
        }
        Map<String, String> reconclStatusMap = this.getDictMap("RECONCIL_STATUS");
        Page page = new Page(condition.getPageNo() < 1 ? 1 : condition.getPageNo(), condition.getPageSize() < 1 ? 10 : condition.getPageSize());
        List<ReconcilitionHis> hisRows = this.reconcilitionHisMapper.getPageListByCondition(condition, (Page<Map<String, Object>>)page);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        for (ReconcilitionHis reconciliationHis : hisRows) {
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconciliationHis, (Object)vo);
            if (null != reconciliationHis.getOrderAmt()) {
                vo.setEorderAmt(reconciliationHis.getOrderAmt());
            }
            if (null != reconciliationHis.getOutAmt()) {
                vo.setOrderAmt(reconciliationHis.getOutAmt());
            }
            if (null != reconciliationHis.getOrderId()) {
                vo.setOrderId(reconciliationHis.getOrderId() + "");
            }
            if (null != reconciliationHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconciliationHis.getReconciliationStatus() + ""));
            }
            if (null != reconciliationHis.getOrderDate()) {
                vo.setOrderDate(DateUtil.dateToStr(reconciliationHis.getOrderDate()));
            }
            if (null != reconciliationHis.getReconciliationDate()) {
                vo.setReconcilDate(DateUtil.dateToStr(reconciliationHis.getReconciliationDate()));
            }
            if (null != reconciliationHis.getRecvDate()) {
                vo.setRecvDate(DateUtil.dateToStr(reconciliationHis.getRecvDate()));
            }
            if (null != reconciliationHis.getOrderId()) {
                String orderId = reconciliationHis.getOrderId();
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setPurchaseOrderCode(orderId);
                PayPurchaseOrderInfo modelBy = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
                if (null != modelBy) {
                    String notificationNo = modelBy.getNotificationNo();
                    vo.setNotificationNo(notificationNo);
                }
            }
            rows.add(vo);
        }
        rspVo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspVo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspVo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspVo.setRows(rows);
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    public ReconciliationRspVo getHisExcel(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(condition.getIsProfessionalOrgExt())) {
            condition.setOperUnitNo(condition.getCompanyId());
        } else {
            condition.setPurchaseNo(condition.getCompanyId());
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map<String, String> reconclStatusMap = this.getDictMap("RECONCIL_STATUS");
        List<ReconcilitionHis> hisRows = this.reconcilitionHisMapper.getHisByCondition(condition);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        for (ReconcilitionHis reconciliationHis : hisRows) {
            if (reconciliationHis == null) continue;
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconciliationHis, (Object)vo);
            if (null != reconciliationHis.getOrderAmt()) {
                vo.setEorderAmt(reconciliationHis.getOrderAmt());
            }
            if (null != reconciliationHis.getOutAmt()) {
                vo.setOrderAmt(reconciliationHis.getOutAmt());
            }
            if (null != reconciliationHis.getOrderId()) {
                vo.setOrderId(reconciliationHis.getOrderId() + "");
            }
            if (null != reconciliationHis.getOrderDate()) {
                vo.setOrderDate(simpleDateFormat.format(reconciliationHis.getOrderDate()));
            }
            if (null != reconciliationHis.getReconciliationDate()) {
                vo.setReconcilDate(simpleDateFormat.format(reconciliationHis.getReconciliationDate()));
            }
            if (null != reconciliationHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconciliationHis.getReconciliationStatus() + ""));
            }
            rows.add(vo);
        }
        rspVo.setRows(rows);
        return rspVo;
    }

    public ReconciliationRspVo getReceiptInfoByTabId(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (condition.getVersionNo() == null) {
            throw new PfscExtBusinessException("18000", "\u5bf9\u8d26\u7248\u672c\u53f7\u4e3a\u7a7a\uff0c\u672a\u5bf9\u8d26\uff0c\u4e0d\u80fd\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5217\u8868");
        }
        Integer tabId = condition.getTabId();
        condition.setReconciliationStatus(tabId);
        boolean withPage = true;
        ReconciliationRspVo rspVo = Integer.valueOf(ReconciliationStatus.NOT_RECONCILED.getCode()).equals(tabId) ? this.getOrderByTabId(condition, withPage) : this.getReceiptInByTabId(condition, tabId, withPage);
        return rspVo;
    }

    public ReconciliationRspVo getExcelByTabId(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer tabId = condition.getTabId();
        boolean withPage = false;
        ReconciliationRspVo rspVo = tabId == 0 ? this.getOrderByTabId(condition, withPage) : this.getReceiptInByTabId(condition, tabId, withPage);
        return rspVo;
    }

    private ReconciliationRspVo getReceiptInByTabId(ReconciliationReqBo condition, Integer tabId, boolean withPage) {
        List<ReconcilitionHis> listrows;
        if (null == condition) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        try {
            if (StringUtils.hasText((String)condition.getOrderId())) {
                Long.valueOf(condition.getOrderId());
            }
        }
        catch (Exception e) {
            rspVo.setPageNo(Integer.valueOf(1));
            rspVo.setRecordsTotal(Integer.valueOf(0));
            rspVo.setTotal(Integer.valueOf(1));
            rspVo.setRows(new ArrayList());
            rspVo.setRespCode("0000");
            rspVo.setRespDesc("\u6210\u529f");
            return rspVo;
        }
        if ("0".equals(condition.getIsProfessionalOrgExt())) {
            condition.setOperUnitNo(condition.getCompanyId());
        } else {
            condition.setPurchaseNo(condition.getCompanyId());
        }
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        Page page = new Page(condition.getPageNo() < 1 ? 1 : condition.getPageNo(), condition.getPageSize() < 1 ? 10 : condition.getPageSize());
        if (withPage) {
            condition.setReconciliationStatus(tabId);
            listrows = this.reconcilitionHisMapper.getPageListByCondition(condition, (Page<Map<String, Object>>)page);
        } else {
            condition.setReconciliationStatus(tabId);
            listrows = this.reconcilitionHisMapper.getHisByCondition(condition);
        }
        ReconciliationSup reconciliationSup = this.reconciliationSupMapper.selectByVersionNo(condition.getVersionNo());
        if (null != reconciliationSup) {
            rspVo.setReconciliationName(reconciliationSup.getUserName());
            rspVo.setReconciliationDate(reconciliationSup.getReconciliationDate());
            rspVo.setSupplierName(reconciliationSup.getSupplierName());
        } else if (!listrows.isEmpty()) {
            rspVo.setReconciliationName(listrows.get(0).getUsername());
            rspVo.setReconciliationDate(listrows.get(0).getReconciliationDate());
            rspVo.setSupplierName(listrows.get(0).getSupplierName());
        }
        List<Object> saleOrderInfos = new ArrayList();
        if (condition.getSaleOrderInfos() != null && !condition.getSaleOrderInfos().isEmpty()) {
            ArrayList<SaleOrderInfo> list = new ArrayList<SaleOrderInfo>();
            for (BusiPushSaleOrderInfoOrderReqBO bo : condition.getSaleOrderInfos()) {
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                BeanUtils.copyProperties((Object)bo, (Object)saleOrderInfo);
                list.add(saleOrderInfo);
            }
            saleOrderInfos = this.saleOrderInfoMapper.getListOrderInfo(list);
        }
        Map<String, String> reconclStatusMap = this.getDictMap("RECONCIL_STATUS");
        for (ReconcilitionHis reconcilitionHis : listrows) {
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconcilitionHis, (Object)vo);
            if (null != reconcilitionHis.getOrderId()) {
                vo.setOrderId(reconcilitionHis.getOrderId() + "");
            }
            if (null != reconcilitionHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconcilitionHis.getReconciliationStatus() + ""));
            }
            if (null != reconcilitionHis.getOrderDate()) {
                vo.setOrderDate(DateUtil.dateToStr(reconcilitionHis.getOrderDate()));
            }
            if (null != reconcilitionHis.getReconciliationDate()) {
                vo.setReconcilDate(DateUtil.dateToStr(reconcilitionHis.getReconciliationDate()));
            }
            if (null != reconcilitionHis.getRecvDate()) {
                vo.setRecvDate(DateUtil.dateToStr(reconcilitionHis.getRecvDate()));
            }
            if (!saleOrderInfos.isEmpty()) {
                BigDecimal orderAmt = reconcilitionHis.getOrderAmt();
                BigDecimal outAmt = reconcilitionHis.getOutAmt();
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    if (!reconcilitionHis.getOrderId().equals(saleOrderInfo.getSaleOrderCode())) continue;
                    BigDecimal amt = saleOrderInfo.getOrderAmt().subtract(reconcilitionHis.getOrderAmt());
                    orderAmt = orderAmt.add(amt);
                    if (null != (outAmt = outAmt.add(amt))) {
                        vo.setOrderAmt(outAmt);
                    }
                    if (null == orderAmt) continue;
                    vo.setEorderAmt(orderAmt);
                }
            } else {
                if (null != reconcilitionHis.getOutAmt()) {
                    vo.setOrderAmt(reconcilitionHis.getOutAmt());
                }
                if (null != reconcilitionHis.getOrderAmt()) {
                    vo.setEorderAmt(reconcilitionHis.getOrderAmt());
                }
            }
            if (null != reconcilitionHis.getUsername()) {
                vo.setReconciliationUser(reconcilitionHis.getUsername());
            }
            try {
                UmcQryEnterpriseAccountDetailAbilityReqBO abilityReqBO = new UmcQryEnterpriseAccountDetailAbilityReqBO();
                abilityReqBO.setAccountId(reconcilitionHis.getPurchaseProjectId());
                UmcQryEnterpriseAccountDetailAbilityRspBO rspBO = this.umcQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(abilityReqBO);
                if (rspBO != null && rspBO.getUmcEnterpriseAccountBO() != null) {
                    vo.setPurchaseProjectName(rspBO.getUmcEnterpriseAccountBO().getAccountName());
                }
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
            }
            if (null != vo.getSaleOrderStatus()) {
                vo.setSaleOrderStatus(OrderStatus.getInstance(reconcilitionHis.getSaleOrderStatus()).getDescr());
            }
            rows.add(vo);
        }
        rspVo.setRows(rows);
        rspVo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspVo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspVo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    private ReconciliationRspVo getOrderByTabId(ReconciliationReqBo condition, boolean withPage) {
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        try {
            if (StringUtils.hasText((String)condition.getOrderId())) {
                Long.valueOf(condition.getOrderId());
            }
        }
        catch (Exception e) {
            rspVo.setPageNo(Integer.valueOf(1));
            rspVo.setRecordsTotal(Integer.valueOf(0));
            rspVo.setTotal(Integer.valueOf(1));
            rspVo.setRows(new ArrayList());
            rspVo.setRespCode("0000");
            rspVo.setRespDesc("\u6210\u529f");
            return rspVo;
        }
        Page page = new Page(condition.getPageNo() < 1 ? 1 : condition.getPageNo(), condition.getPageSize() < 1 ? 10 : condition.getPageSize());
        if (null != condition.getReconciliationDateStart() || null != condition.getReconciliationrDateEnd()) {
            rspVo.setPageNo(Integer.valueOf(1));
            rspVo.setRecordsTotal(Integer.valueOf(0));
            rspVo.setTotal(Integer.valueOf(0));
            rspVo.setRows(new ArrayList());
            rspVo.setRespCode("0000");
            rspVo.setRespDesc("\u6210\u529f");
            return rspVo;
        }
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = withPage ? this.payPurchaseOrderInfoMapper.getReconclListPage(condition, (Page<Map<String, Object>>)page) : this.payPurchaseOrderInfoMapper.getReconclListPage(condition);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        Map<String, String> reconcilStatusMap = this.getDictMap("RECONCIL_STATUS");
        Map<String, String> orderStatusMap = this.getDictMap("D_SALE_ORDER_INFO_ORDER_STATUS");
        if (!CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
            for (PayPurchaseOrderInfo orderInfo : payPurchaseOrderInfoList) {
                ReconciliationHisVo vo = new ReconciliationHisVo();
                BeanUtils.copyProperties((Object)orderInfo, (Object)vo);
                vo.setOrderId(orderInfo.getPurchaseOrderCode());
                vo.setOrderStatusName(orderStatusMap.get(orderInfo.getOrderStatus()));
                if (null != orderInfo.getOrderDate()) {
                    vo.setOrderDate(DateUtil.dateToStr(orderInfo.getOrderDate()));
                }
                if (null != orderInfo.getRecvDate()) {
                    vo.setRecvDate(DateUtil.dateToStr(orderInfo.getRecvDate()));
                }
                if (null != orderInfo.getReconcilitionStatus()) {
                    vo.setReconciliStatusName(reconcilStatusMap.get(orderInfo.getReconcilitionStatus()));
                }
                if (null != orderInfo.getOrderAmt()) {
                    vo.setEorderAmt(orderInfo.getOrderAmt());
                }
                rows.add(vo);
            }
        }
        rspVo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspVo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspVo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspVo.setRows(rows);
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    private Map<String, String> getDictMap(String pcode) {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode(pcode);
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }
}

