/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfoInvoicePO;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.OperationType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.api.FscBillSummaryInfoAtomService;
import com.tydic.pfscext.service.atom.api.FscBillSummaryInfoInvoiceAtomService;
import com.tydic.pfscext.service.atom.api.FscOriginalDocumentsInfoAtomService;
import com.tydic.pfscext.service.comb.api.FscCheckBillingStatusCombService;
import com.tydic.pfscext.service.comb.bo.FscCheckBillingStatusAtomReqBO;
import com.tydic.pfscext.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscCheckBillingStatusCombServiceImpl
implements FscCheckBillingStatusCombService {
    @Autowired
    private FscOriginalDocumentsInfoAtomService fscOriginalDocumentsInfoAtomService;
    @Autowired
    private FscBillSummaryInfoInvoiceAtomService fscBillSummaryInfoInvoiceAtomService;
    @Autowired
    private FscBillSummaryInfoAtomService fscBillSummaryInfoAtomService;

    @Override
    public PfscExtRspBaseBO checkBillingStatus(FscCheckBillingStatusAtomReqBO reqBO) {
        List<String> documentNos = reqBO.getDocumentNos();
        if (CollectionUtils.isEmpty(documentNos)) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
        if (ctrantType == null) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u7c7b\u578b\u9519\u8bef");
        }
        List<OriginalDocumentsInfo> documentsInfos = this.fscOriginalDocumentsInfoAtomService.qryListByDocumentNos(documentNos);
        Set documentNoSet = documentsInfos.stream().map(OriginalDocumentsInfo::getDocumentNo).collect(Collectors.toSet());
        List collect = documentNos.stream().filter(item -> !documentNoSet.contains(item)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            StringJoiner sj = new StringJoiner(", ", "\u5355\u636e\u53f7 [ ", " ]\u672a\u540c\u6b65\uff0c\u8bf7\u7b49\u5f85\u5176\u540c\u6b65");
            for (String doc : collect) {
                sj.add(doc);
            }
            throw new PfscExtBusinessException("18000", sj.toString());
        }
        if (OperationType.SHOW.getCode().equals(reqBO.getOperationType())) {
            PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5355\u636e\u5df2\u5b58\u5728\uff0c\u53ef\u4ee5\u8fdb\u884c\u67e5\u770b");
            return rspBO;
        }
        if (CtrantType.RAW_COAL.getCode().equals(reqBO.getType())) {
            this.judgeSupplier1(documentsInfos, "\u7ed3\u7b97\u5355\u4f4d");
            this.judgeType(documentsInfos);
            this.judgeBillingQuantityRawCoal(documentNos);
        } else if (CtrantType.CHEMICAL.getCode().equals(reqBO.getType())) {
            this.judgeSupplier1(documentsInfos, "\u7ed3\u7b97\u5355\u4f4d");
            this.judgeBillingQuantityRawCoal(documentNos);
        } else if (CtrantType.CHEMICAL_STORE.getCode().equals(reqBO.getType())) {
            this.judgeSupplier2(documentsInfos, "\u4f9b\u5e94\u5546");
            this.judgeBillingQuantityWarehousingList(documentNos);
        } else if (CtrantType.NON_HOSTED.getCode().equals(reqBO.getType())) {
            this.judgeSupplier2(documentsInfos, "\u4f9b\u5e94\u5546");
            this.judgeBillingQuantityWarehousingList(documentNos);
        } else if (CtrantType.HOSTED.getCode().equals(reqBO.getType())) {
            this.judgeSupplier2(documentsInfos, "\u4f9b\u5e94\u5546");
            this.judgeBillingQuantityWarehousingList(documentNos);
        }
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u68c0\u67e5\u5f00\u7968\u5355\u636e\u901a\u8fc7\uff0c\u53ef\u4ee5\u8fdb\u884c\u5f00\u7968");
        return rspBO;
    }

    private void judgeType(List<OriginalDocumentsInfo> documentsInfos) {
        String typeStr = "\u96c6\u4e2d\u8d2d\u9500";
        StringJoiner stringJoiner = new StringJoiner("");
        documentsInfos.forEach(item -> {
            if (StringUtils.hasText((String)item.getType()) && item.getType().contains(typeStr)) {
                stringJoiner.add("\u5355\u636e[ ").add(item.getDocumentNo()).add(" ] \u7684\u4ea4\u6613\u7c7b\u578b\u4e3a [ ").add(item.getType()).add(" ] \u662f\u96c6\u4e2d\u8d2d\u9500\u5355\u636e\uff0c\u4e0d\u80fd\u5f00\u7968.").add(" \n ");
            }
        });
        if (stringJoiner.length() > 10) {
            throw new PfscExtBusinessException("18000", stringJoiner.toString());
        }
    }

    private void judgeBillingQuantityWarehousingList(List<String> documentNos) {
        List<BillSummaryInfo> summaryInfos = this.fscBillSummaryInfoAtomService.qryListByDocumentNos(documentNos);
        List<BillSummaryInfoInvoicePO> infoInvoicePOList = this.fscBillSummaryInfoInvoiceAtomService.qryListByStatementNos(documentNos);
        Map<String, List<BillSummaryInfoInvoicePO>> infoInvoicePOMap = infoInvoicePOList.stream().collect(Collectors.groupingBy(BillSummaryInfoInvoicePO::getRid));
        Map<String, List<BillSummaryInfo>> summaryInfosMap = summaryInfos.stream().collect(Collectors.groupingBy(BillSummaryInfo::getStatementNo));
        ArrayList<String> billingDocmentNos = new ArrayList<String>();
        for (Map.Entry<String, List<BillSummaryInfo>> itemEntry : summaryInfosMap.entrySet()) {
            int count = 0;
            for (BillSummaryInfo summaryInfo : itemEntry.getValue()) {
                List<BillSummaryInfoInvoicePO> pos = infoInvoicePOMap.get(summaryInfo.getId());
                BigDecimal invoicableQuantityInvoice = BigDecimal.ZERO;
                BigDecimal inventoryQuantity = BigDecimalUtils.getStr2BigDecimal(summaryInfo.getInventoryQuantity());
                if (!CollectionUtils.isEmpty(pos)) {
                    double sum = pos.stream().mapToDouble(item -> Double.valueOf(item.getInvoicableQuantityInvoice())).sum();
                    invoicableQuantityInvoice = invoicableQuantityInvoice.add(BigDecimal.valueOf(sum));
                }
                if (BigDecimal.ZERO.compareTo(inventoryQuantity) == 0) {
                    StringJoiner sj = new StringJoiner("", "\u9519\u8bef\uff1a\u5355\u636e [", "");
                    sj.add(summaryInfo.getStatementNo()).add(" ]").add("\u7684\u7269\u6599 \u884c\u53f7[").add(summaryInfo.getLineNumber()).add(" ]").add(" \u7269\u6599\u7f16\u53f7 [").add(summaryInfo.getMaterialCode()).add("] \u7684\u6700\u5927\u53ef\u5f00\u7968\u6570\u91cf\u4e3a0");
                    throw new PfscExtBusinessException("18000", sj.toString());
                }
                if (inventoryQuantity.compareTo(invoicableQuantityInvoice) != 0) continue;
                ++count;
            }
            if (count != itemEntry.getValue().size()) continue;
            billingDocmentNos.add(itemEntry.getKey());
        }
        if (!CollectionUtils.isEmpty(billingDocmentNos)) {
            StringJoiner sj = new StringJoiner("", "\u5355\u636e ", " \u5df2\u5168\u90e8\u5f00\u7968\uff0c\u8bf7\u5728\u5f00\u7968\u8bb0\u5f55\u4e2d\u67e5\u8be2");
            sj.add(JSON.toJSONString(billingDocmentNos));
            throw new PfscExtBusinessException("18000", sj.toString());
        }
    }

    private void judgeBillingQuantityRawCoal(List<String> documentNos) {
        List<BillSummaryInfoInvoicePO> infoInvoicePOList = this.fscBillSummaryInfoInvoiceAtomService.qryListByStatementNos(documentNos);
        Set collecSet = infoInvoicePOList.stream().map(BillSummaryInfoInvoicePO::getStatementNo).collect(Collectors.toSet());
        List collect = documentNos.stream().filter(item -> collecSet.contains(item)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            StringJoiner sj = new StringJoiner("");
            sj.add("\u5355\u636e ").add(JSON.toJSONString(collect)).add(" \u5df2\u53d1\u8d77\u5f00\u7968\uff0c\u8bf7\u5728\u5f00\u7968\u8bb0\u5f55\u4e2d\u67e5\u8be2");
            throw new PfscExtBusinessException("18000", sj.toString());
        }
    }

    private void judgeSupplier1(List<OriginalDocumentsInfo> documentsInfos, String prefix) {
        if (!CollectionUtils.isEmpty(documentsInfos) && documentsInfos.size() > 1) {
            LinkedHashSet<String> supplierIdList = new LinkedHashSet<String>();
            for (OriginalDocumentsInfo item : documentsInfos) {
                if (!StringUtils.hasText((String)item.getSettlementSupplierCode())) {
                    throw new PfscExtBusinessException("18000", "\u5355\u636e [" + item.getDocumentNo() + "] \u5bf9\u5e94\u7684[ " + prefix + " ]\u4e3a\u7a7a");
                }
                supplierIdList.add(item.getSettlementSupplierCode());
            }
            if (supplierIdList.size() > 1) {
                throw new PfscExtBusinessException("18000", "[" + prefix + "]\u90fd\u76f8\u540c\u7684\u5355\u636e\u624d\u80fd\u5408\u5e76\u5f00\u7968");
            }
        }
    }

    private void judgeSupplier2(List<OriginalDocumentsInfo> documentsInfos, String prefix) {
        if (!CollectionUtils.isEmpty(documentsInfos) && documentsInfos.size() > 1) {
            LinkedHashSet<String> supplierIdList = new LinkedHashSet<String>();
            for (OriginalDocumentsInfo item : documentsInfos) {
                if (!StringUtils.hasText((String)item.getSupplierId())) {
                    throw new PfscExtBusinessException("18000", "\u5355\u636e [" + item.getDocumentNo() + "] \u5bf9\u5e94\u7684 [" + prefix + "] \u4e3a\u7a7a");
                }
                supplierIdList.add(item.getSupplierId());
            }
            if (supplierIdList.size() > 1) {
                throw new PfscExtBusinessException("18000", "[" + prefix + "]\u90fd\u76f8\u540c\u7684\u5355\u636e\u624d\u80fd\u5408\u5e76\u5f00\u7968");
            }
        }
    }
}

