/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.dao.po.BillDetailInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.enums.CtrantType;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.esb.api.FscGetOriginalDocumentExternalService;
import com.tydic.pfscext.external.esb.bo.FscConsumptionSummaryExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscConsumptionSummaryExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscConsumptionSummaryInfoExternalBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementDetailExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementDetailExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementInfoExternalBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementSummaryExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementSummaryExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementSummaryInfoExternalBO;
import com.tydic.pfscext.external.esb.bo.FscPriceSettlementSummaryItemExternalBO;
import com.tydic.pfscext.external.esb.bo.FscPurchaseStorageExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscPurchaseStorageExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscPurchaseStorageInfoExternalBO;
import com.tydic.pfscext.external.esb.bo.FscPurchaseStorageSummaryExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscPurchaseStorageSummaryExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscPurchaseStorageSummaryInfoExternalBO;
import com.tydic.pfscext.external.esb.bo.FscPurchaseStorageSummaryItemExternalBO;
import com.tydic.pfscext.service.comb.api.FscOriginalDocumentsInfoCombService;
import com.tydic.pfscext.service.comb.bo.FscConsumptionSummaryInfoBO;
import com.tydic.pfscext.service.comb.bo.FscConsumptionSummaryReqBO;
import com.tydic.pfscext.service.comb.bo.FscConsumptionSummaryRspBO;
import com.tydic.pfscext.service.comb.bo.FscOriginalDocumentsInfoReqBO;
import com.tydic.pfscext.service.comb.bo.FscOriginalDocumentsInfoRspBO;
import com.tydic.pfscext.service.comb.bo.FscPriceSettlementDetailRspBO;
import com.tydic.pfscext.service.comb.bo.FscPriceSettlementInfoBO;
import com.tydic.pfscext.service.comb.bo.FscPriceSettlementReqBO;
import com.tydic.pfscext.service.comb.bo.FscPriceSettlementRspBO;
import com.tydic.pfscext.service.comb.bo.FscPriceSettlementSummaryRspBO;
import com.tydic.pfscext.service.comb.bo.FscPurchaseStorageInfoBO;
import com.tydic.pfscext.service.comb.bo.FscPurchaseStorageReqBO;
import com.tydic.pfscext.service.comb.bo.FscPurchaseStorageRspBO;
import com.tydic.pfscext.service.comb.bo.FscPurchaseStorageSummaryRspBO;
import com.tydic.pfscext.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscOriginalDocumentsInfoCombServiceImpl
implements FscOriginalDocumentsInfoCombService {
    private static final Logger log = LoggerFactory.getLogger(FscOriginalDocumentsInfoCombServiceImpl.class);
    @Autowired
    private FscGetOriginalDocumentExternalService fscGetOriginalDocumentExternalService;
    private final String CODE_SUCCESS = "0";
    private final String SHOW_DETAIL = "2";

    @Override
    public FscOriginalDocumentsInfoRspBO getOriginalDocumentsInfoErp(FscOriginalDocumentsInfoReqBO reqBO) {
        CtrantType ctrantType = CtrantType.getInstance(reqBO.getType());
        if (!StringUtils.hasText((String)reqBO.getDocumentNo())) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ctrantType == null) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u7c7b\u578b\u672a\u77e5");
        }
        if (CtrantType.RAW_COAL.getCode().equals(ctrantType.getCode())) {
            FscPriceSettlementSummaryRspBO settlementSummaryErp = this.getPriceSettlementSummaryErp(reqBO.getDocumentNo(), "1");
            FscOriginalDocumentsInfoRspBO rspBO = (FscOriginalDocumentsInfoRspBO)JSON.parseObject((String)JSON.toJSONString((Object)settlementSummaryErp), FscOriginalDocumentsInfoRspBO.class);
            return rspBO;
        }
        if (CtrantType.CHEMICAL.getCode().equals(ctrantType.getCode())) {
            FscPriceSettlementSummaryRspBO settlementSummaryErp = this.getPriceSettlementSummaryErp(reqBO.getDocumentNo(), null);
            FscOriginalDocumentsInfoRspBO rspBO = (FscOriginalDocumentsInfoRspBO)JSON.parseObject((String)JSON.toJSONString((Object)settlementSummaryErp), FscOriginalDocumentsInfoRspBO.class);
            return rspBO;
        }
        if (CtrantType.CHEMICAL_STORE.getCode().equals(ctrantType.getCode())) {
            FscPurchaseStorageSummaryRspBO purchaseStorageSummaryErp = this.getPurchaseStorageSummaryErp(reqBO.getDocumentNo());
            FscOriginalDocumentsInfoRspBO rspBO = (FscOriginalDocumentsInfoRspBO)JSON.parseObject((String)JSON.toJSONString((Object)purchaseStorageSummaryErp), FscOriginalDocumentsInfoRspBO.class);
            return rspBO;
        }
        if (CtrantType.NON_HOSTED.getCode().equals(ctrantType.getCode())) {
            FscPurchaseStorageSummaryRspBO purchaseStorageSummaryErp = this.getPurchaseStorageSummaryErp(reqBO.getDocumentNo());
            FscOriginalDocumentsInfoRspBO rspBO = (FscOriginalDocumentsInfoRspBO)JSON.parseObject((String)JSON.toJSONString((Object)purchaseStorageSummaryErp), FscOriginalDocumentsInfoRspBO.class);
            return rspBO;
        }
        if (CtrantType.HOSTED.getCode().equals(ctrantType.getCode())) {
            // empty if block
        }
        throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6570\u636e\u9519\u8bef");
    }

    @Override
    public FscPurchaseStorageRspBO getPurchaseStorageErp(FscPurchaseStorageReqBO reqBO) {
        FscPurchaseStorageExternalReqBO externalReqBO = new FscPurchaseStorageExternalReqBO();
        this.convert(reqBO, externalReqBO);
        FscPurchaseStorageExternalRspBO storageFromErp = this.fscGetOriginalDocumentExternalService.getPurchaseStorageFromErp(externalReqBO);
        int recordsTotal = 0;
        ArrayList<FscPurchaseStorageInfoBO> infoList = new ArrayList<FscPurchaseStorageInfoBO>();
        if ("0".equals(storageFromErp.getCode())) {
            List dataList = storageFromErp.getDataList();
            if (!CollectionUtils.isEmpty((Collection)dataList)) {
                ArrayList<FscPurchaseStorageInfoBO> infoBOS = new ArrayList<FscPurchaseStorageInfoBO>();
                for (FscPurchaseStorageInfoExternalBO externalBO : dataList) {
                    FscPurchaseStorageInfoBO infoBO = new FscPurchaseStorageInfoBO();
                    this.convert(externalBO, infoBO);
                    infoBO.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                    infoBOS.add(infoBO);
                }
                if (!CollectionUtils.isEmpty(infoBOS)) {
                    infoList.addAll(infoBOS);
                }
            }
            try {
                recordsTotal = Integer.valueOf(storageFromErp.getData());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new PfscExtBusinessException("18000", "\u5165\u5e93\u5355\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u5165\u5e93\u5355\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
        }
        FscPurchaseStorageRspBO rspBO = new FscPurchaseStorageRspBO();
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setInfoList(infoList);
        return rspBO;
    }

    @Override
    public FscPurchaseStorageSummaryRspBO getPurchaseStorageSummaryErp(String documentNo) {
        ArrayList<BillSummaryInfo> summaryInfos;
        ArrayList<OriginalDocumentsInfo> infos;
        FscPurchaseStorageSummaryRspBO rspBO;
        block10: {
            rspBO = new FscPurchaseStorageSummaryRspBO();
            infos = new ArrayList<OriginalDocumentsInfo>();
            summaryInfos = new ArrayList<BillSummaryInfo>();
            try {
                FscPurchaseStorageSummaryExternalReqBO externalReqBO = new FscPurchaseStorageSummaryExternalReqBO();
                externalReqBO.setBillCode(documentNo);
                externalReqBO.setPageNo(Integer.valueOf(1));
                externalReqBO.setPageSize(Integer.valueOf(10));
                FscPurchaseStorageSummaryExternalRspBO summaryFromErp = this.fscGetOriginalDocumentExternalService.getPurchaseStorageSummaryFromErp(externalReqBO);
                if ("0".equals(summaryFromErp.getCode())) {
                    List dataList = summaryFromErp.getDataList();
                    if (!CollectionUtils.isEmpty((Collection)dataList)) {
                        ArrayList<OriginalDocumentsInfo> infoList = new ArrayList<OriginalDocumentsInfo>();
                        ArrayList<BillSummaryInfo> summaryInfoList = new ArrayList<BillSummaryInfo>();
                        for (FscPurchaseStorageSummaryInfoExternalBO externalBO : dataList) {
                            OriginalDocumentsInfo info = new OriginalDocumentsInfo();
                            this.convert(externalBO, info);
                            info.setBillType("2");
                            info.setEffectiveState("1");
                            info.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                            infoList.add(info);
                            List bvos = externalBO.getBvos();
                            if (CollectionUtils.isEmpty((Collection)bvos)) continue;
                            for (FscPurchaseStorageSummaryItemExternalBO bvo : bvos) {
                                BillSummaryInfo billSummaryInfo = new BillSummaryInfo();
                                this.convert(bvo, billSummaryInfo);
                                long nextId = Sequence.getInstance().nextId();
                                billSummaryInfo.setId(String.valueOf(nextId));
                                billSummaryInfo.setBillType("2");
                                billSummaryInfo.setEffectiveState("1");
                                billSummaryInfo.setStatementNo(externalBO.getDocumentNo());
                                billSummaryInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                                billSummaryInfo.setInventoryQuantity(billSummaryInfo.getActualReceiveCount());
                                billSummaryInfo.setInvoicedQuantity(billSummaryInfo.getCumuInvoicableQuantity());
                                String actualReceiveCount = bvo.getActualReceiveCount();
                                BigDecimal receiveCount = BigDecimalUtils.getStr2BigDecimal(actualReceiveCount);
                                BigDecimal quantity = BigDecimalUtils.getStr2BigDecimal(bvo.getCumuInvoicableQuantity());
                                if (StringUtils.hasText((String)actualReceiveCount)) {
                                    BigDecimal num = receiveCount.subtract(quantity).setScale(2, 4);
                                    billSummaryInfo.setInvoicableQuantity(num.toString());
                                    BigDecimal taxPrice = BigDecimalUtils.getStr2BigDecimal(bvo.getTaxPrice());
                                    billSummaryInfo.setTaxPrice(taxPrice.setScale(2, 4).toString());
                                    BigDecimal invoicableAmt = num.multiply(taxPrice).setScale(2, 4);
                                    billSummaryInfo.setInvoicableAmt(invoicableAmt.toString());
                                    if (!StringUtils.hasText((String)bvo.getTax()) && StringUtils.hasText((String)bvo.getNoTaxAmt())) {
                                        BigDecimal noTaxAmt = BigDecimalUtils.getStr2BigDecimal(bvo.getNoTaxAmt());
                                        billSummaryInfo.setTax(invoicableAmt.subtract(noTaxAmt).toString());
                                    }
                                }
                                summaryInfoList.add(billSummaryInfo);
                            }
                        }
                        if (!CollectionUtils.isEmpty(infoList)) {
                            infos.addAll(JSON.parseArray((String)JSON.toJSONString(infoList), OriginalDocumentsInfo.class));
                        }
                        if (!CollectionUtils.isEmpty(summaryInfoList)) {
                            summaryInfos.addAll(JSON.parseArray((String)JSON.toJSONString(summaryInfoList), BillSummaryInfo.class));
                        }
                    }
                    break block10;
                }
                log.error("\u67e5\u8be2ERP\u5165\u5e93\u5355\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)summaryFromErp));
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2ERP\u5165\u5e93\u5355\u5f02\u5e38");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2ERP\u5165\u5e93\u5355\u5f02\u5e38");
            }
        }
        rspBO.setInfoList(infos);
        rspBO.setSummaryInfoList(summaryInfos);
        return rspBO;
    }

    @Override
    public FscPriceSettlementRspBO getPriceSettlementsErp(FscPriceSettlementReqBO reqBO) {
        FscPriceSettlementExternalReqBO externalReqBO = new FscPriceSettlementExternalReqBO();
        this.convert(reqBO, externalReqBO);
        FscPriceSettlementExternalRspBO settlementFromErp = this.fscGetOriginalDocumentExternalService.getPriceSettlementFromErp(externalReqBO);
        FscPriceSettlementRspBO rspBO = new FscPriceSettlementRspBO();
        ArrayList<FscPriceSettlementInfoBO> infoList = new ArrayList<FscPriceSettlementInfoBO>();
        int recordsTotal = 0;
        if ("0".equals(settlementFromErp.getCode())) {
            List dataList = settlementFromErp.getDataList();
            if (!CollectionUtils.isEmpty((Collection)dataList)) {
                ArrayList<FscPriceSettlementInfoBO> infoBOS = new ArrayList<FscPriceSettlementInfoBO>();
                for (FscPriceSettlementInfoExternalBO externalBO : dataList) {
                    FscPriceSettlementInfoBO infoBO = new FscPriceSettlementInfoBO();
                    this.convert(externalBO, infoBO);
                    infoBO.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                    infoBOS.add(infoBO);
                }
                if (!CollectionUtils.isEmpty(infoBOS)) {
                    infoList.addAll(infoBOS);
                }
            }
            try {
                recordsTotal = Integer.valueOf(settlementFromErp.getData());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new PfscExtBusinessException("18000", "\u4ef7\u683c\u7ed3\u7b97\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u4ef7\u683c\u7ed3\u7b97\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
        }
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setInfoList(infoList);
        return rspBO;
    }

    @Override
    public FscPriceSettlementSummaryRspBO getPriceSettlementSummaryErp(String documentNo, String showDetail) {
        ArrayList<BillDetailInfo> detailInfoList;
        ArrayList<BillSummaryInfo> summaryInfos;
        ArrayList<OriginalDocumentsInfo> infos;
        FscPriceSettlementSummaryRspBO rspBO;
        block9: {
            rspBO = new FscPriceSettlementSummaryRspBO();
            infos = new ArrayList<OriginalDocumentsInfo>();
            summaryInfos = new ArrayList<BillSummaryInfo>();
            detailInfoList = new ArrayList<BillDetailInfo>();
            try {
                FscPriceSettlementSummaryExternalReqBO externalReqBO = new FscPriceSettlementSummaryExternalReqBO();
                externalReqBO.setBillCode(documentNo);
                externalReqBO.setPageNo(Integer.valueOf(1));
                externalReqBO.setPageSize(Integer.valueOf(10));
                FscPriceSettlementSummaryExternalRspBO settlementDetail = this.fscGetOriginalDocumentExternalService.getPriceSettlementSummaryFromErp(externalReqBO);
                if ("0".equals(settlementDetail.getCode())) {
                    List dataList = settlementDetail.getDataList();
                    if (!CollectionUtils.isEmpty((Collection)dataList)) {
                        ArrayList<OriginalDocumentsInfo> infoList = new ArrayList<OriginalDocumentsInfo>();
                        ArrayList<BillSummaryInfo> summaryInfoList = new ArrayList<BillSummaryInfo>();
                        for (FscPriceSettlementSummaryInfoExternalBO infoExternalBO : dataList) {
                            FscPriceSettlementDetailRspBO detailErp;
                            OriginalDocumentsInfo infoBO = new OriginalDocumentsInfo();
                            this.convert(infoExternalBO, infoBO);
                            infoBO.setBillType(CtrantType.RAW_COAL.getCode());
                            infoBO.setEffectiveState("1");
                            infoBO.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                            infoList.add(infoBO);
                            List bvos = infoExternalBO.getBvos();
                            if (!CollectionUtils.isEmpty((Collection)bvos)) {
                                for (FscPriceSettlementSummaryItemExternalBO bvo : bvos) {
                                    BillSummaryInfo itemBO = new BillSummaryInfo();
                                    this.convert(bvo, itemBO);
                                    long nextId = Sequence.getInstance().nextId();
                                    itemBO.setId(String.valueOf(nextId));
                                    itemBO.setBillType(CtrantType.RAW_COAL.getCode());
                                    itemBO.setEffectiveState("1");
                                    itemBO.setStatementNo(infoExternalBO.getDocumentNo());
                                    itemBO.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                                    itemBO.setInventoryQuantity(bvo.getSettlementQuantity());
                                    itemBO.setInvoicedQuantity("0.00");
                                    summaryInfoList.add(itemBO);
                                }
                            }
                            if (!"2".equals(showDetail) || CollectionUtils.isEmpty((detailErp = this.getPriceSettlementDetailErp(infoExternalBO.getSummeryHeadId())).getDetailInfoList())) continue;
                            detailInfoList.addAll(detailErp.getDetailInfoList());
                        }
                        if (!CollectionUtils.isEmpty(infoList)) {
                            infos.addAll(JSON.parseArray((String)JSON.toJSONString(infoList), OriginalDocumentsInfo.class));
                        }
                        if (!CollectionUtils.isEmpty(summaryInfoList)) {
                            summaryInfos.addAll(JSON.parseArray((String)JSON.toJSONString(summaryInfoList), BillSummaryInfo.class));
                        }
                    }
                    break block9;
                }
                log.error("\u67e5\u8be2ERP\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)settlementDetail));
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2ERP\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5f02\u5e38");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2ERP\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5f02\u5e38");
            }
        }
        rspBO.setInfoList(infos);
        rspBO.setSummaryInfoList(summaryInfos);
        rspBO.setDetailInfoList(detailInfoList);
        return rspBO;
    }

    @Override
    public FscPriceSettlementDetailRspBO getPriceSettlementDetailErp(String cgeneralhId) {
        FscPriceSettlementDetailExternalReqBO detailExternalReqBO = new FscPriceSettlementDetailExternalReqBO();
        detailExternalReqBO.setCgeneralhId(cgeneralhId);
        FscPriceSettlementDetailExternalRspBO detailFromErp = this.fscGetOriginalDocumentExternalService.getPriceSettlementDetailFromErp(detailExternalReqBO);
        FscPriceSettlementDetailRspBO rspBO = new FscPriceSettlementDetailRspBO();
        if (!"0".equals(detailFromErp.getCode()) || !CollectionUtils.isEmpty((Collection)detailFromErp.getDataList())) {
            // empty if block
        }
        return rspBO;
    }

    @Override
    public FscConsumptionSummaryRspBO getConsumptionSummaryErp(FscConsumptionSummaryReqBO reqBO) {
        FscConsumptionSummaryExternalReqBO externalReqBO = new FscConsumptionSummaryExternalReqBO();
        this.convert(reqBO, externalReqBO);
        FscConsumptionSummaryExternalRspBO externalRspBO = this.fscGetOriginalDocumentExternalService.getConsumptionSummaryFromErp(externalReqBO);
        FscConsumptionSummaryRspBO rspBO = new FscConsumptionSummaryRspBO();
        ArrayList<FscConsumptionSummaryInfoBO> infoList = new ArrayList<FscConsumptionSummaryInfoBO>();
        int recordsTotal = 0;
        if ("0".equals(externalRspBO.getCode())) {
            List dataList = externalRspBO.getVmisum();
            if (!CollectionUtils.isEmpty((Collection)dataList)) {
                ArrayList<FscConsumptionSummaryInfoBO> infoBOS = new ArrayList<FscConsumptionSummaryInfoBO>();
                for (FscConsumptionSummaryInfoExternalBO externalBO : dataList) {
                    FscConsumptionSummaryInfoBO infoBO = new FscConsumptionSummaryInfoBO();
                    this.convert(externalBO, infoBO);
                    infoBO.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                    infoBOS.add(infoBO);
                }
                if (!CollectionUtils.isEmpty(infoBOS)) {
                    infoList.addAll(infoBOS);
                }
            }
            try {
                recordsTotal = Integer.valueOf(externalRspBO.getData());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new PfscExtBusinessException("18000", "\u5bc4\u5b58\u6d88\u8017\u6c47\u603b\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u5bc4\u5b58\u6d88\u8017\u6c47\u603b\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
        }
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setInfoList(infoList);
        log.debug("comb-{}", (Object)JSON.toJSONString((Object)rspBO));
        return rspBO;
    }

    private void convert(Object source, Object target) {
        BeanCopier copy = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        copy.copy(source, target, null);
    }
}

