/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.conversion.domain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.pfscext.service.conversion.bo.BigMineSettlementDocPreviewReqBO;
import com.tydic.pfscext.service.conversion.bo.BigMineSettlementInfoBO;
import com.tydic.pfscext.service.conversion.bo.BigMineSettlementSummaryInfoBO;
import com.tydic.pfscext.service.conversion.bo.base.BaseDataReqBO;
import com.tydic.pfscext.service.conversion.domain.CellInfo;
import com.tydic.pfscext.service.conversion.domain.base.IDataToPdf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="bigMineToPdf")
public class BigMineToPdf
implements IDataToPdf {
    private static final Logger log = LoggerFactory.getLogger(BigMineToPdf.class);
    private final int NUM_COLUMNS = 13;
    private final int NUM_LINES = 4;
    private final float[] WIDTHS = new float[]{6.29f, 8.71f, 8.43f, 8.71f, 8.86f, 9.0f, 6.29f, 6.29f, 6.29f, 6.29f, 6.29f, 10.57f, 10.57f};
    private BaseFont baseFont;
    private int minHeight = 23;

    public BigMineToPdf() {
        try {
            this.baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dataToPdf(BaseDataReqBO dataReqBO, ByteArrayOutputStream outputStream) throws DocumentException {
        BigMineSettlementDocPreviewReqBO data = (BigMineSettlementDocPreviewReqBO)dataReqBO;
        log.debug("\u751f\u6210\u5927\u77ff\u7ed3\u7b97\u5355\u6587\u6863\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteRootClassName}));
        if (outputStream == null) {
            throw new RuntimeException("\u8f93\u51fa\u6d41\u4e3a\u7a7a");
        }
        Document document = new Document((Rectangle)new RectangleReadOnly(PageSize.A4.getHeight(), PageSize.A4.getWidth()));
        PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        BigMineSettlementInfoBO infoBO = data.getBigMineSettlementInfoBO();
        List<BigMineSettlementSummaryInfoBO> summaryInfoBOS = data.getSummaryInfoBOS();
        Paragraph p = new Paragraph(infoBO.getTitle(), new Font(this.baseFont, 18.0f, 4));
        p.setAlignment(1);
        document.add((Element)p);
        PdfPTable table = new PdfPTable(13);
        table.setSpacingBefore(16.0f);
        table.setWidths(this.WIDTHS);
        Font font = new Font(this.baseFont, 10.0f);
        table.addCell(new CellInfo("\u7ed3\u7b97\u5355\u53f7\uff1a", infoBO.getDocumentno(), 6, 0, 5, this.minHeight, 15, font).getCell());
        table.addCell(new CellInfo("\u5355\u636e\u65e5\u671f\uff1a", infoBO.getBilldate(), 5, 0, 5, this.minHeight, 15, font).getCell());
        table.addCell(new CellInfo("\u5355\u4f4d\uff1a", infoBO.getUnit(), 2, 0, 5, this.minHeight, 15, font).getCell());
        table.addCell(new CellInfo("\u7ed3\u7b97\u5355\u4f4d\uff1a", infoBO.getSettlementsupplier(), 6, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7ed3\u7b97\u671f\u95f4\uff1a", infoBO.getSettlementdate(), 7, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7164\u70ad\u4f9b\u5e94\u5546\uff1a", infoBO.getCoalsupplier(), 13, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7164\u79cd\uff1a", infoBO.getMaterial(), 5, 0, 5, font).getCell());
        table.addCell(new CellInfo("", "\u77ff\u70b9", 1, 1, 5, font).getCell());
        table.addCell(new CellInfo("", infoBO.getMinepoint(), 1, 1, 5, font).getCell());
        table.addCell(new CellInfo("\u8fd0\u8f93\u65b9\u5f0f\uff1a", infoBO.getTranstype(), 3, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7ed3\u7b97\u65b9\u5f0f\uff1a", infoBO.getPaytype(), 3, 0, 5, font).getCell());
        table.addCell(new CellInfo("", "\u5408\u540c\u5355\u53f7\uff1a", 3, 0, 5, font).getCell());
        table.addCell(new CellInfo("", infoBO.getContractno(), 10, 0, 5, font).getCell());
        if (!CollectionUtils.isEmpty(summaryInfoBOS)) {
            table.addCell(new CellInfo("", "\u8f66\u6570", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u8fc7\u78c5\u51c0\u91cd", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u660e\u6c34\u6263\u6742", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u6c34\u4efd\u6263\u91cd", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u7ed3\u7b97\u6570\u91cf", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u5408\u540c\u5355\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u7070\u5206\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u6325\u53d1\u5206\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u786b\u5206\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "G\u503c\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "Y\u503c\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u7ed3\u7b97\u5355\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u5e94\u7ed3\u91d1\u989d", 1, 1, 5, font).getCell());
            for (BigMineSettlementSummaryInfoBO item : summaryInfoBOS) {
                table.addCell(new CellInfo("", item.getCarnum(), 1, 1, 5, font).getCell());
                table.addCell(new CellInfo("", item.getNetweight(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getMingshui(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getShuifenamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getSettlementquantity(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getContractprice(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getAdamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getVdafamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getStdamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getGamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getYamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getSettlementprice(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getApplypayamt(), 1, 0, 5, font).getCell());
            }
            if (summaryInfoBOS.size() < 4) {
                for (int i = 0; i < 13 * (4 - summaryInfoBOS.size()); ++i) {
                    table.addCell(new CellInfo("", "    ", 1, 1, 5, font).getCell());
                }
            }
            table.addCell(new CellInfo("", infoBO.getCarnumAll(), 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getNetweightALl(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getMingshuiAll(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getShuifenamtAll(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getSettlementquantity(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", "    ", 7, 1, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getApplypayamtAll(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u539f\u53d1\u6570\uff1a", infoBO.getOrgissuetotalnum(), 3, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u5927\u77ff\u6570\u91cf\uff1a", infoBO.getMinetotalnum(), 2, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u8fd0\u8d39\uff1a", infoBO.getFrightrate(), 2, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u5927\u77ff\u91d1\u989d\uff1a", infoBO.getMinetotalamt(), 4, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u8c03\u6574\u91d1\u989d\uff1a", infoBO.getAdjustamt(), 2, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u7ed3\u7b97\u91d1\u989d\uff1a", infoBO.getSetamt(), 5, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u91d1\u989d\u5927\u5199\uff1a", infoBO.getSetamtcapital(), 8, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u4e13\u7ebf\u4f7f\u7528\u8d39\uff1a", infoBO.getSpeclineuseamt(), 5, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u5927\u77ff\u6263\u6b3e\u91d1\u989d\uff1a", infoBO.getMinereduceamt(), 8, 0, 5, font).getCell());
        }
        table.addCell(new CellInfo("", "\u5907\u6ce8", 1, 1, 5, font).getCell());
        table.addCell(new CellInfo(" ", infoBO.getRemark(), 12, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u4e1a\u52a1\u5458\uff1a", infoBO.getSalesman(), 3, 0, 5, this.minHeight, 15, font).getCell());
        table.addCell(new CellInfo("\u4f9b\u5e94\u90e8\u5185\u52e4\uff1a", infoBO.getStaff(), 2, 0, 5, this.minHeight, 15, font).getCell());
        table.addCell(new CellInfo("\u4f9b\u5e94\u90e8\u7ecf\u7406\uff1a", infoBO.getStaffmanager(), 3, 0, 5, this.minHeight, 15, font).getCell());
        table.addCell(new CellInfo("\u8d22\u52a1\u5ba1\u6838\uff1a", infoBO.getTreasurer(), 3, 0, 5, this.minHeight, 15, font).getCell());
        table.addCell(new CellInfo("\u8d22\u52a1\u7ecf\u7406\uff1a", infoBO.getTreasurermanager(), 2, 0, 5, this.minHeight, 15, font).getCell());
        table.setSpacingBefore(16.0f);
        document.add((Element)table);
        document.close();
    }
}

