/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.conversion.domain;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import java.io.IOException;
import java.io.Serializable;

public class CellInfo
implements Serializable {
    private final int MINIMUM_HEIGHT_DEFAULT = 23;
    private String prefix;
    private String data;
    private int colspan;
    private int horizontalAlignment;
    private int verticalAlignment;
    private int minimumHeight;
    private int side;
    private Font font;
    private PdfPCell pdfPCell;

    public CellInfo(String data, Font font) {
        this.prefix = null;
        this.data = data;
        this.colspan = 1;
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
        this.minimumHeight = 23;
        this.side = 0;
        this.font = font;
        this.initData();
    }

    public CellInfo(String prefix, String data, int colspan, int horizontalAlignment, int verticalAlignment, int minimumHeight, int side, Font font) {
        this.prefix = prefix;
        this.data = data;
        this.colspan = colspan;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.minimumHeight = minimumHeight;
        this.side = side;
        this.font = font;
        this.initData();
    }

    public CellInfo(String prefix, String data, int colspan, int horizontalAlignment, int verticalAlignment, Font font) {
        this.prefix = prefix;
        this.data = data;
        this.colspan = colspan;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.minimumHeight = 23;
        this.side = 0;
        this.font = font;
        this.initData();
    }

    public CellInfo(String prefix, String data, int colspan) {
        this.prefix = prefix;
        this.data = data;
        this.colspan = colspan;
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
        this.minimumHeight = 23;
        this.side = 0;
        try {
            BaseFont abf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            this.font = new Font(abf, 10.0f);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initData();
    }

    private void initData() {
        this.prefix = this.prefix == null ? "" : this.prefix;
        this.data = this.data == null ? " " : this.data;
        this.pdfPCell = new PdfPCell(new Phrase(this.prefix + this.data, this.font));
        this.pdfPCell.setVerticalAlignment(this.verticalAlignment);
        this.pdfPCell.setHorizontalAlignment(this.horizontalAlignment);
        this.pdfPCell.setColspan(this.colspan);
        this.pdfPCell.disableBorderSide(this.side);
        this.pdfPCell.setMinimumHeight((float)this.minimumHeight);
    }

    public PdfPCell getCell() {
        return this.pdfPCell;
    }

    public int getMINIMUM_HEIGHT_DEFAULT() {
        return this.MINIMUM_HEIGHT_DEFAULT;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getData() {
        return this.data;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public int getSide() {
        return this.side;
    }

    public Font getFont() {
        return this.font;
    }

    public PdfPCell getPdfPCell() {
        return this.pdfPCell;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public void setSide(int side) {
        this.side = side;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPdfPCell(PdfPCell pdfPCell) {
        this.pdfPCell = pdfPCell;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellInfo)) {
            return false;
        }
        CellInfo other = (CellInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMINIMUM_HEIGHT_DEFAULT() != other.getMINIMUM_HEIGHT_DEFAULT()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        if (this.getColspan() != other.getColspan()) {
            return false;
        }
        if (this.getHorizontalAlignment() != other.getHorizontalAlignment()) {
            return false;
        }
        if (this.getVerticalAlignment() != other.getVerticalAlignment()) {
            return false;
        }
        if (this.getMinimumHeight() != other.getMinimumHeight()) {
            return false;
        }
        if (this.getSide() != other.getSide()) {
            return false;
        }
        Font this$font = this.getFont();
        Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        PdfPCell this$pdfPCell = this.getPdfPCell();
        PdfPCell other$pdfPCell = other.getPdfPCell();
        return !(this$pdfPCell == null ? other$pdfPCell != null : !this$pdfPCell.equals(other$pdfPCell));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CellInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMINIMUM_HEIGHT_DEFAULT();
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + this.getColspan();
        result = result * 59 + this.getHorizontalAlignment();
        result = result * 59 + this.getVerticalAlignment();
        result = result * 59 + this.getMinimumHeight();
        result = result * 59 + this.getSide();
        Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        PdfPCell $pdfPCell = this.getPdfPCell();
        result = result * 59 + ($pdfPCell == null ? 43 : $pdfPCell.hashCode());
        return result;
    }

    public String toString() {
        return "CellInfo(MINIMUM_HEIGHT_DEFAULT=" + this.getMINIMUM_HEIGHT_DEFAULT() + ", prefix=" + this.getPrefix() + ", data=" + this.getData() + ", colspan=" + this.getColspan() + ", horizontalAlignment=" + this.getHorizontalAlignment() + ", verticalAlignment=" + this.getVerticalAlignment() + ", minimumHeight=" + this.getMinimumHeight() + ", side=" + this.getSide() + ", font=" + this.getFont() + ", pdfPCell=" + this.getPdfPCell() + ")";
    }
}

