/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.conversion.domain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.pfscext.service.conversion.bo.GroupMiningSettlementDocPreviewReqBO;
import com.tydic.pfscext.service.conversion.bo.GroupMiningSettlementInfoBO;
import com.tydic.pfscext.service.conversion.bo.GroupMiningSettlementSummaryInfoBO;
import com.tydic.pfscext.service.conversion.bo.base.BaseDataReqBO;
import com.tydic.pfscext.service.conversion.domain.CellInfo;
import com.tydic.pfscext.service.conversion.domain.base.IDataToPdf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="groupMiningToPdf")
public class GroupMiningToPdf
implements IDataToPdf {
    private static final Logger log = LoggerFactory.getLogger(GroupMiningToPdf.class);
    private final int NUM_COLUMNS = 13;
    private final float[] WIDTHS = new float[]{6.29f, 8.71f, 8.43f, 8.71f, 8.86f, 9.0f, 6.29f, 6.29f, 6.29f, 6.29f, 6.29f, 10.57f, 10.57f};
    private BaseFont baseFont;
    private int minHeight = 23;

    public GroupMiningToPdf() {
        try {
            this.baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dataToPdf(BaseDataReqBO dataReqBO, ByteArrayOutputStream outputStream) throws DocumentException {
        GroupMiningSettlementDocPreviewReqBO data = (GroupMiningSettlementDocPreviewReqBO)dataReqBO;
        log.debug("\u751f\u6210\u7fa4\u91c7\u7ed3\u7b97\u5355\u6587\u6863\u7684\u6570\u636e\uff1a", (Object)JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteRootClassName}));
        if (outputStream == null) {
            throw new RuntimeException("\u8f93\u51fa\u6d41\u4e3a\u7a7a");
        }
        Document document = new Document((Rectangle)new RectangleReadOnly(PageSize.A4.getHeight(), PageSize.A4.getWidth()));
        PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        GroupMiningSettlementInfoBO infoBO = data.getGroupMiningSettlementInfoBO();
        List<GroupMiningSettlementSummaryInfoBO> summaryInfoBOS = data.getSummaryInfoBOS();
        Paragraph p = new Paragraph(infoBO.getTitle(), new Font(this.baseFont, 18.0f, 4));
        p.setAlignment(1);
        document.add((Element)p);
        PdfPTable table = new PdfPTable(13);
        table.setSpacingBefore(16.0f);
        table.setWidths(this.WIDTHS);
        Font font = new Font(this.baseFont, 10.0f);
        table.addCell(new CellInfo("\u7ed3\u7b97\u5355\u53f7\uff1a", infoBO.getDocumentno(), 6, 0, 5, 23, 15, font).getCell());
        table.addCell(new CellInfo("\u5355\u636e\u65e5\u671f\uff1a", infoBO.getBilldate(), 5, 0, 5, 23, 15, font).getCell());
        table.addCell(new CellInfo("\u5355\u4f4d\uff1a", infoBO.getUnit(), 2, 0, 5, 23, 15, font).getCell());
        table.addCell(new CellInfo("\u7ed3\u7b97\u5355\u4f4d\uff1a", infoBO.getSettlementsupplier(), 6, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7ed3\u7b97\u671f\u95f4\uff1a", infoBO.getSettlementdate(), 7, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7164\u70ad\u4f9b\u5e94\u5546\uff1a", infoBO.getCoalsupplier(), 13, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7164\u79cd\uff1a", infoBO.getMaterial(), 5, 0, 5, font).getCell());
        table.addCell(new CellInfo("", "\u533a\u57df", 1, 1, 5, font).getCell());
        table.addCell(new CellInfo("", infoBO.getArea(), 1, 1, 5, font).getCell());
        table.addCell(new CellInfo("\u8fd0\u8f93\u65b9\u5f0f\uff1a", infoBO.getTranstype(), 3, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u7ed3\u7b97\u65b9\u5f0f\uff1a", infoBO.getPaytype(), 3, 0, 5, font).getCell());
        if (!CollectionUtils.isEmpty(summaryInfoBOS)) {
            table.addCell(new CellInfo("", "\u8f66\u6570", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u8fc7\u78c5\u51c0\u91cd", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u660e\u6c34\u6263\u6742", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u6c34\u4efd\u6263\u91cd", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u7ed3\u7b97\u6570\u91cf", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u5408\u540c\u5355\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u7070\u5206\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u6325\u53d1\u5206\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u786b\u5206\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "G\u503c\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "Y\u503c\n\u6263\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u7ed3\u7b97\u5355\u4ef7", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", "\u5e94\u7ed3\u91d1\u989d", 1, 1, 5, font).getCell());
            for (GroupMiningSettlementSummaryInfoBO item : summaryInfoBOS) {
                table.addCell(new CellInfo("", item.getCarnum(), 1, 1, 5, font).getCell());
                table.addCell(new CellInfo("", item.getNetweight(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getMingshui(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getShuifenamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getSettlementquantity(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getContractprice(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getAdamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getVdafamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getStdamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getGamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getYamt(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getSettlementprice(), 1, 0, 5, font).getCell());
                table.addCell(new CellInfo("", item.getApplypayamt(), 1, 0, 5, font).getCell());
            }
            if (summaryInfoBOS.size() < 4) {
                for (int i = 0; i < 13 * (4 - summaryInfoBOS.size()); ++i) {
                    table.addCell(new CellInfo("", "    ", 1, 1, 5, font).getCell());
                }
            }
            table.addCell(new CellInfo("", infoBO.getCarnumAll(), 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getNetweightALl(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getMingshuiAll(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getShuifenamtAll(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getSettlementquantity(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("", "    ", 7, 1, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getApplypayamtAll(), 1, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u52a0\u6743\u8865\u507f\uff1a", infoBO.getCompensateweight(), 4, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u91cf\u5316\u8865\u507f\uff1a", infoBO.getCompensatequantif(), 3, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u8ba9\u6b65\u63a5\u6536\u91d1\u989d\uff1a", infoBO.getConcessionamt(), 4, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u8c03\u6574\u91d1\u989d\uff1a", infoBO.getAdjustamt(), 2, 0, 5, font).getCell());
            table.addCell(new CellInfo("", "\u7ed3\u7b97\u91d1\u989d", 1, 1, 5, font).getCell());
            table.addCell(new CellInfo("", infoBO.getSetamt(), 3, 0, 5, font).getCell());
            table.addCell(new CellInfo("\u91d1\u989d\u5927\u5199\uff1a", infoBO.getSetamtcapital(), 9, 0, 5, font).getCell());
        }
        table.addCell(new CellInfo("", "\u5907\u6ce8", 1, 1, 5, font).getCell());
        table.addCell(new CellInfo(" ", infoBO.getRemark(), 12, 0, 5, font).getCell());
        table.addCell(new CellInfo("\u4e1a\u52a1\u5458\uff1a", infoBO.getSalesman(), 3, 0, 5, 23, 15, font).getCell());
        table.addCell(new CellInfo("\u4f9b\u5e94\u90e8\u5185\u52e4\uff1a", infoBO.getStaff(), 2, 0, 5, 23, 15, font).getCell());
        table.addCell(new CellInfo("\u4f9b\u5e94\u90e8\u7ecf\u7406\uff1a", infoBO.getStaffmanager(), 3, 0, 5, 23, 15, font).getCell());
        table.addCell(new CellInfo("\u8d22\u52a1\u5ba1\u6838\uff1a", infoBO.getTreasurer(), 3, 0, 5, 23, 15, font).getCell());
        table.addCell(new CellInfo("\u8d22\u52a1\u7ecf\u7406\uff1a", infoBO.getTreasurermanager(), 2, 0, 5, 23, 15, font).getCell());
        table.setSpacingBefore(16.0f);
        document.add((Element)table);
        document.close();
    }

    public void dataToPdfOld(GroupMiningSettlementDocPreviewReqBO data, OutputStream outputStream) throws DocumentException {
        Document document = new Document((Rectangle)new RectangleReadOnly(PageSize.A4.getHeight(), PageSize.A4.getWidth()));
        PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        Paragraph p = new Paragraph("\u6cb3\u5317\u65ed\u9633\u80fd\u6e90\u6709\u9650\u516c\u53f8\u539f\u6599\u7164\u7ed3\u7b97\u5355", new Font(this.baseFont, 18.0f, 4));
        p.setAlignment(1);
        document.add((Element)p);
        PdfPTable table = new PdfPTable(13);
        table.setSpacingBefore(16.0f);
        table.setWidths(this.WIDTHS);
        Font font = new Font(this.baseFont, 10.0f);
        PdfPCell cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u5355\u53f7\uff1aHBJS21071200059", font));
        cell.setHorizontalAlignment(0);
        cell.disableBorderSide(15);
        cell.setColspan(6);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u65e5\u671f\uff1a2020-06-05", font));
        cell.setHorizontalAlignment(0);
        cell.disableBorderSide(15);
        cell.setColspan(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5355\u4f4d\uff08\u5143\uff09", font));
        cell.setHorizontalAlignment(0);
        cell.setMinimumHeight(23.0f);
        cell.disableBorderSide(15);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u5355\u4f4d\uff1a\u90a2\u53f0\u65ed\u9633\u8d38\u6613\u6709\u9650\u516c\u53f8", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(6);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u671f\u95f4\uff1a2021-6-30\u81f32021-6-30", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(7);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7164\u70ad\u4f9b\u5e94\u5546\uff1a\u5180\u4e2d\u80fd\u6e90\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5cf0\u5cf0\u5206\u516c\u53f8", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(4);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7164\u79cd\uff1a\u7126\u7164", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u77ff\u70b9\uff1a\u9a6c\u9009", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8fd0\u8f93\u65b9\u5f0f\uff1a\u706b\u8fd0", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(3);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u65b9\u5f0f\uff1a\u73b0\u6c47", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5408\u540c\u5355\u53f7\uff1a ", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("HBXYGY202100011", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(11);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8f66\u6570", font));
        cell.setHorizontalAlignment(5);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8fc7\u78c5\u51c0\u91cd", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u660e\u6c34\u6263\u6742", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u6c34\u4efd\u6263\u91cd", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u6570\u91cf", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5408\u540c\u5355\u4ef7", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7070\u5206\n\u6263\u4ef7", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u6325\u53d1\u5206\n\u6263\u4ef7", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(1);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u786b\u5206\n\u6263\u4ef7", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("G\u503c\n\u6263\u4ef7", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("Y\u503c\n\u6263\u4ef7", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u5355\u4ef7", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5e94\u7ed3\u91d1\u989d", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("50", font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("3353.16", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("0.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("210.20", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("3142.96", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("2035.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("7.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("0.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("0.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("0.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("0.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("2028.00", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("6373923.96", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u539f\u53d1\u6570\uff1a3383.0000", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(3);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u539f\u53d1\u6570\uff1a3383.0000", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8fd0\u8d39\uff1a217,338.3000", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5927\u77ff\u91d1\u989d\uff1a6532702.0600", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(4);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8c03\u6574\u91d1\u989d\uff1a170934.57", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u91d1\u989d\uff1a6,762,196.8300", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u91d1\u989d\u5927\u5199 \uff1a\u9646\u4f70\u67d2\u62fe\u9646\u4e07\u8d30\u4edf\u58f9\u4f70\u7396\u62fe\u9646\u5143\u634c\u89d2\u53c1\u5206", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(8);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u4e13\u7ebf\u4f7f\u7528\u8d39\uff1a12,156.4700", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5927\u77ff\u6263\u6b3e\u91d1\u989d\uff1a", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(8);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5907\u6ce8\uff1a", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(1);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(" ", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.setColspan(12);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u4e1a\u52a1\u5458:\u5f20\u4e49\u534e", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.disableBorderSide(15);
        cell.setColspan(3);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u4e1a\u52a1\u5458:\u5f20\u4e49\u534e", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.disableBorderSide(15);
        cell.setColspan(2);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u4f9b\u5e94\u90e8\u7ecf\u7406\uff1a\u5b59\u8d85", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.disableBorderSide(15);
        cell.setColspan(3);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8d22\u52a1\u5ba1\u6838\uff1a", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.disableBorderSide(15);
        cell.setColspan(3);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8d22\u52a1\u7ecf\u7406\uff1a", font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight((float)this.minHeight);
        cell.disableBorderSide(15);
        cell.setColspan(2);
        cell.setVerticalAlignment(1);
        table.addCell(cell);
        table.setSpacingBefore(16.0f);
        document.add((Element)table);
        document.close();
    }

    public void dataToPdf22(GroupMiningSettlementDocPreviewReqBO data, OutputStream outputStream) throws DocumentException {
        if (outputStream == null) {
            throw new RuntimeException("\u8f93\u51fa\u6d41\u4e3a\u7a7a");
        }
        Document document = new Document((Rectangle)new RectangleReadOnly(PageSize.A4.getHeight(), PageSize.A4.getWidth()));
        PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        PdfPTable table = new PdfPTable(13);
        table.setSpacingBefore(16.0f);
        table.setWidths(this.WIDTHS);
    }
}

