/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.conversion.impl;

import com.itextpdf.text.DocumentException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfscext.api.busi.AccessoryTemplateService;
import com.tydic.pfscext.api.busi.bo.AccessoryTemplateReqBO;
import com.tydic.pfscext.api.busi.bo.AccessoryTemplateRspBO;
import com.tydic.pfscext.api.busi.bo.AddAccessoryTemplateReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.conversion.api.DataToPdfService;
import com.tydic.pfscext.service.conversion.bo.BigMineSettlementDocPreviewReqBO;
import com.tydic.pfscext.service.conversion.bo.GroupMiningSettlementDocPreviewReqBO;
import com.tydic.pfscext.service.conversion.bo.base.BaseDataReqBO;
import com.tydic.pfscext.service.conversion.factory.FactoryDataToPdfDomin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="statementDocumentDataToPdfService")
public class StatementDocumentDataToPdfServiceImpl
implements DataToPdfService {
    private static final Logger log = LoggerFactory.getLogger(StatementDocumentDataToPdfServiceImpl.class);
    @Autowired
    private AccessoryTemplateService accessoryTemplateService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private Environment props;
    @Autowired
    private FactoryDataToPdfDomin factoryDataToPdf;
    private static final String REGENERATE_N = "N";

    @Override
    public PfscExtRspBaseBO preview(BaseDataReqBO data) {
        if (!StringUtils.hasText((String)data.getDocumentno())) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        if (REGENERATE_N.equals(data.getRegenerate())) {
            AccessoryTemplateReqBO reqBO = new AccessoryTemplateReqBO();
            reqBO.setAccessoryCode(data.getDocumentno());
            PfscExtRspPageBaseBO rspPageBaseBO = this.accessoryTemplateService.qryAccessoryTemplateList(reqBO);
            if (Objects.nonNull(rspPageBaseBO) && Objects.nonNull(rspPageBaseBO.getRows()) && !CollectionUtils.isEmpty((Collection)rspPageBaseBO.getRows())) {
                pfscExtRspBaseBO.setRespCode("0000");
                pfscExtRspBaseBO.setRespDesc("\u9644\u4ef6\u9884\u89c8\u6210\u529f");
                pfscExtRspBaseBO.setRemark(((AccessoryTemplateRspBO)rspPageBaseBO.getRows().get(0)).getAccessoryUrl());
                return pfscExtRspBaseBO;
            }
        }
        String accessoryUrl = this.doPDFAndUpload(data);
        log.info("\u9644\u4ef6\u5730\u5740\uff1a{}", (Object)accessoryUrl);
        AddAccessoryTemplateReqBO addAccessoryTemplateReqBO = new AddAccessoryTemplateReqBO();
        addAccessoryTemplateReqBO.setAccessoryName("\u7ed3\u7b97\u7fa4\u91c7\u7ed3\u7b97\u5355\u9884\u89c8");
        addAccessoryTemplateReqBO.setAccessoryCode(data.getDocumentno());
        addAccessoryTemplateReqBO.setAccessoryUrl(accessoryUrl);
        addAccessoryTemplateReqBO.setRemark(accessoryUrl);
        this.accessoryTemplateService.addAccessoryTemplate(addAccessoryTemplateReqBO);
        pfscExtRspBaseBO.setRespCode("0000");
        pfscExtRspBaseBO.setRespDesc("\u9644\u4ef6\u9884\u89c8\u6210\u529f");
        pfscExtRspBaseBO.setRemark(accessoryUrl);
        return pfscExtRspBaseBO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doPDFAndUpload(BaseDataReqBO dataReqBO) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.dataToPdf(dataReqBO, outputStream);
            StringJoiner resultUrl = new StringJoiner("");
            StringJoiner fileName = new StringJoiner("");
            fileName.add("fsc-").add(Sequence.getInstance().nextId() + "").add(".pdf");
            String fileByInputStream = this.fileClient.uploadFileByInputStream(this.getPropertyOssUploadFile(), fileName.toString(), (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            resultUrl.add(this.getPropertyOssUrl()).add(fileByInputStream);
            String string = resultUrl.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u9644\u4ef6\u9519\u8bef");
        }
    }

    private void dataToPdf(BaseDataReqBO dataReqBO, ByteArrayOutputStream outputStream) throws DocumentException {
        if (dataReqBO instanceof GroupMiningSettlementDocPreviewReqBO) {
            this.factoryDataToPdf.getStrategy("groupMiningToPdf").dataToPdf(dataReqBO, outputStream);
        } else if (dataReqBO instanceof BigMineSettlementDocPreviewReqBO) {
            this.factoryDataToPdf.getStrategy("bigMineToPdf").dataToPdf(dataReqBO, outputStream);
        }
    }

    private String getPropertyOssUrl() {
        String defaultValue = "https://risun-ds-test.oss-cn-beijing.aliyuncs.com/";
        try {
            return this.props.getProperty("OSS_URL", defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private String getPropertyOssUploadFile() {
        String defaultValue = "pesapp-common";
        try {
            return this.props.getProperty("OSS_UPLOAD_FILE", defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

