/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.api.zm.AddBillApplyInfoByItemsService;
import com.tydic.pfscext.api.zm.bo.AddBillApplyInfoReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleBillInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.SubAcctInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleBillInfoPO;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BillStatus1;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=AddBillApplyInfoByItemsService.class)
public class AddBillApplyInfoByItemsServiceImpl
implements AddBillApplyInfoByItemsService {
    private static final Logger logger = LoggerFactory.getLogger(AddBillApplyInfoByItemsServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleBillInfoMapper saleBillInfoMapper;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;

    public PfscExtRspBaseBO add(AddBillApplyInfoReqBO reqBO) {
        List<SaleOrderInfo> orderList;
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String strPurchaseNo = reqBO.getStrPurchaseNo();
        if (strPurchaseNo == null || "".equals(strPurchaseNo)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u3010strPurchaseNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setPurchaseNo(Long.valueOf(strPurchaseNo));
        String strPurchaseProjectId = reqBO.getStrPurchaseProjectId();
        if (strPurchaseProjectId == null || "".equals(strPurchaseProjectId)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957\u3010strPurchaseProjectId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setPurchaseProjectId(Long.valueOf(strPurchaseProjectId));
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        if (invoiceInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u53d1\u7968\u4fe1\u606f\u3010invoiceInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7684\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfo.getInvoiceType()) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (2 == invoiceInfo.getInvoiceType() && !StringUtils.hasText((String)invoiceInfo.getTaxpayerId())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u90ae\u5bc4\u4fe1\u606f\u3010mailAddrInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u90ae\u5bc4\u4fe1\u606f\u3010mailAddrInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String saleOrderCode = reqBO.getSaleOrderCode();
        ArrayList<String> saleOrderCodeList = new ArrayList<String>();
        ArrayList<Long> inspectionIdList = new ArrayList<Long>();
        if (null != reqBO.getBillNo()) {
            String[] saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setBillNo(reqBO.getBillNo());
            List<SaleOrderInfo> saleBillInfoPO = this.saleOrderInfoMapper.getModelByBillNo((SaleOrderInfo)saleOrderInfo);
            for (SaleOrderInfo saleOrderInfo1 : saleBillInfoPO) {
                inspectionIdList.add(saleOrderInfo1.getInspectionId());
            }
        }
        if (StringUtils.hasText((String)saleOrderCode)) {
            try {
                for (String element : saleOrderCode.split(",")) {
                    saleOrderCodeList.add(element);
                }
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        saleOrderInfoVO.setInspectionIdList(inspectionIdList);
        if ("1".equals(reqBO.getIsOperUnit())) {
            saleOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        saleOrderInfoVO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if (!saleOrderCodeList.isEmpty()) {
            saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
        }
        if ((orderList = this.saleOrderInfoMapper.getListJoin(saleOrderInfoVO)).isEmpty()) {
            throw new PfscExtBusinessException("18001", "\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba2\u5355");
        }
        List<List<SaleOrderInfo>> saleItemInfosList = this.splitByBase(orderList);
        List<String> saleItemInfosList1 = this.splitBySupplierName(orderList);
        String supplierName = "";
        for (int i = 0; i < saleItemInfosList1.size(); ++i) {
            supplierName = i == 0 ? saleItemInfosList1.get(i) : supplierName + "," + saleItemInfosList1.get(i);
        }
        ArrayList<BillApplyInfo> billApplyInfoList = new ArrayList<BillApplyInfo>();
        String applyNo = "";
        for (List<SaleOrderInfo> orderList1 : saleItemInfosList) {
            applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
            SaleOrderInfo get0 = orderList1.get(0);
            BigDecimal amt = BigDecimal.ZERO;
            for (SaleOrderInfo order : orderList1) {
                saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                saleOrderInfoVO.setInspectionId(order.getInspectionId());
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setApplyNo(applyNo);
                saleOrderInfo.setOrderStatus(OrderStatus.APPLIED.getCode());
                this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO, saleOrderInfo);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
                saleItemInfoVO.setInspectionId(order.getInspectionId());
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setApplyNo(applyNo);
                saleItemInfo.setItemStatus(OrderStatus.APPLIED.getCode());
                this.saleItemInfoMapper.updateByCondition(saleItemInfoVO, saleItemInfo);
                amt = amt.add(order.getOrderAmt());
            }
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setInvoiceType(String.valueOf(invoiceInfo.getInvoiceType()));
            billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
            billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
            billApplyInfo.setAddr(invoiceInfo.getAddress());
            billApplyInfo.setPhone(invoiceInfo.getPhone());
            billApplyInfo.setBankName(invoiceInfo.getBank());
            billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
            billApplyInfo.setName(mailAddrInfo.getName());
            billApplyInfo.setProvince(mailAddrInfo.getProvince());
            billApplyInfo.setCity(mailAddrInfo.getCity());
            billApplyInfo.setCounty(mailAddrInfo.getCounty());
            billApplyInfo.setTown("0".equals(mailAddrInfo.getTown()) ? null : mailAddrInfo.getTown());
            billApplyInfo.setProvId(mailAddrInfo.getProvId());
            billApplyInfo.setCityId(mailAddrInfo.getCityId());
            billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo.setTownId(mailAddrInfo.getTownId());
            billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            billApplyInfo.setMobile(mailAddrInfo.getTel());
            billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
            billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
            billApplyInfo.setApplyNo(applyNo);
            billApplyInfo.setApplyDate(new Date());
            billApplyInfo.setAmt(amt);
            billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
            billApplyInfo.setUserId(reqBO.getUserId());
            billApplyInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
            billApplyInfo.setPurchaseNo(get0.getPurchaseNo());
            billApplyInfo.setPurchaseName(get0.getPurchaseName());
            billApplyInfo.setPurchaseProjectId(get0.getPurchaseProjectId());
            billApplyInfo.setOperUnitNo(get0.getOperUnitNo());
            billApplyInfo.setOperUnitName(get0.getOperUnitName());
            if (saleItemInfosList1.size() == 1) {
                billApplyInfo.setSupplierNo(get0.getSupplierNo());
            }
            billApplyInfo.setSupplierName(supplierName);
            billApplyInfoList.add(billApplyInfo);
        }
        this.billApplyInfoMapper.insertByBatch(billApplyInfoList);
        if (null != reqBO.getBillNo()) {
            logger.error("\u7b2c\u4e00\u6b651");
            SaleBillInfoPO saleBillInfoPO = new SaleBillInfoPO();
            saleBillInfoPO.setNotificationNo(applyNo);
            saleBillInfoPO.setBillNo(reqBO.getBillNo());
            this.saleBillInfoMapper.updateByBillNo(saleBillInfoPO);
        }
        for (SaleOrderInfo saleOrderInfo : orderList) {
            SaleBillInfoPO saleBillInfoPO;
            logger.error("BILL_NO" + saleOrderInfo.getBillNo());
            int num = this.saleOrderInfoMapper.getCheck(saleOrderInfo.getBillNo());
            logger.error("NUM" + num);
            if (num == 0) {
                logger.error("111");
                saleBillInfoPO = new SaleBillInfoPO();
                saleBillInfoPO.setBillStatus(BillStatus1.SENDING_BILL.getCode());
                saleBillInfoPO.setBillNo(saleOrderInfo.getBillNo());
                this.saleBillInfoMapper.updateByBillNo(saleBillInfoPO);
                continue;
            }
            logger.error("222");
            saleBillInfoPO = new SaleBillInfoPO();
            saleBillInfoPO.setBillStatus(BillStatus1.SEND_BILL.getCode());
            saleBillInfoPO.setBillNo(saleOrderInfo.getBillNo());
            this.saleBillInfoMapper.updateByBillNo(saleBillInfoPO);
        }
        return new PfscExtRspBaseBO();
    }

    private List<List<SaleOrderInfo>> splitByBase(List<SaleOrderInfo> itemInfoList) {
        LinkedList<List<SaleOrderInfo>> itemsInfoList = new LinkedList<List<SaleOrderInfo>>();
        itemsInfoList.add(itemInfoList);
        return itemsInfoList;
    }

    private List<List<SaleOrderInfo>> splitBySupplierNo(List<SaleOrderInfo> itemInfoList) {
        LinkedList<List<SaleOrderInfo>> itemsInfoList = new LinkedList<List<SaleOrderInfo>>();
        LinkedList<SaleOrderInfo> saleList = null;
        HashMap tmpMap = new HashMap();
        for (SaleOrderInfo saleInfoVO : itemInfoList) {
            if (tmpMap.containsKey(saleInfoVO.getSupplierNo())) {
                ((List)tmpMap.get(saleInfoVO.getSupplierNo())).add(saleInfoVO);
                continue;
            }
            saleList = new LinkedList<SaleOrderInfo>();
            saleList.add(saleInfoVO);
            tmpMap.put(saleInfoVO.getSupplierNo(), saleList);
        }
        for (Map.Entry entry : tmpMap.entrySet()) {
            itemsInfoList.add((List<SaleOrderInfo>)entry.getValue());
        }
        return itemsInfoList;
    }

    private List<String> splitBySupplierName(List<SaleOrderInfo> itemInfoList) {
        LinkedList<String> itemsInfoList = new LinkedList<String>();
        LinkedList<SaleOrderInfo> saleList = null;
        HashMap tmpMap = new HashMap();
        for (SaleOrderInfo saleInfoVO : itemInfoList) {
            if (tmpMap.containsKey(saleInfoVO.getSupplierName())) {
                ((List)tmpMap.get(saleInfoVO.getSupplierName())).add(saleInfoVO);
                continue;
            }
            saleList = new LinkedList<SaleOrderInfo>();
            saleList.add(saleInfoVO);
            tmpMap.put(saleInfoVO.getSupplierName(), saleList);
        }
        for (Map.Entry entry : tmpMap.entrySet()) {
            itemsInfoList.add((String)entry.getKey());
        }
        return itemsInfoList;
    }

    private List<List<SaleOrderInfo>> splitByInvoiceType(List<List<SaleOrderInfo>> itemInfoList) {
        LinkedList<List<SaleOrderInfo>> itemsInfoList = new LinkedList<List<SaleOrderInfo>>();
        for (int index = 0; index < itemInfoList.size(); ++index) {
            List<SaleOrderInfo> itemList = itemInfoList.get(index);
            LinkedList specialList = new LinkedList();
            LinkedList normalList = new LinkedList();
            for (SaleOrderInfo saleOrderInfo : itemList) {
            }
            if (!specialList.isEmpty()) {
                itemsInfoList.add(specialList);
            }
            if (normalList.isEmpty()) continue;
            itemsInfoList.add(normalList);
        }
        return itemsInfoList;
    }

    private String getDay(int month, int day) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal_1 = Calendar.getInstance();
        cal_1.add(2, month);
        cal_1.set(5, day);
        String firstDay = format.format(cal_1.getTime());
        System.out.println("-----------getDay:" + firstDay);
        return firstDay;
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String format2 = format.format(new Date());
        System.out.println("-----1------month:" + format2.substring(4, 6));
        Calendar cal_1 = Calendar.getInstance();
        cal_1.add(2, -12);
        cal_1.set(5, 1);
        String firstDay = format.format(cal_1.getTime());
        System.out.println("-----1------firstDay:" + firstDay);
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 0);
        String lastDay = format.format(cale.getTime());
        System.out.println("-----2------lastDay:" + lastDay);
        Date date = new Date();
        AddBillApplyInfoByItemsServiceImpl a = new AddBillApplyInfoByItemsServiceImpl();
        Date parse = new SimpleDateFormat("yyyy-MM-dd").parse(a.getDay(0, 10));
        boolean before = date.before(parse);
        Date parse2 = new SimpleDateFormat("yyyy-MM-dd").parse(a.getDay(0, 21));
        Date date1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(a.getDay(0, 20) + " 10:59:59");
        boolean after = date1.after(parse2);
        System.out.println("parse:" + parse + " before:" + before + " parse2:" + parse2 + "  date1:" + date1 + " after:" + after);
    }
}

