/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.zm.MarkInvoiceService;
import com.tydic.pfscext.api.zm.bo.MarkInvoiceReqBO;
import com.tydic.pfscext.api.zm.bo.MarkInvoiceRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=MarkInvoiceService.class)
public class MarkInvoiceServiceImpl
implements MarkInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(MarkInvoiceServiceImpl.class);
    private BillApplyInfoMapper billApplyInfoMapper;
    private SaleOrderInfoMapper saleOrderInfoMapper;
    private SaleItemInfoMapper saleItemInfoMapper;

    @Autowired
    public MarkInvoiceServiceImpl(BillApplyInfoMapper billApplyInfoMapper, SaleOrderInfoMapper saleOrderInfoMapper, SaleItemInfoMapper saleItemInfoMapper) {
        this.billApplyInfoMapper = billApplyInfoMapper;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
        this.saleItemInfoMapper = saleItemInfoMapper;
    }

    public MarkInvoiceRspBO markInvoice(MarkInvoiceReqBO markInvoiceReqBO) {
        MarkInvoiceRspBO rspBO = new MarkInvoiceRspBO();
        if (null == markInvoiceReqBO || markInvoiceReqBO.getApplyNo() == null) {
            throw new PfscExtBusinessException("18001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (markInvoiceReqBO.getApplyNo() != null && markInvoiceReqBO.getApplyNo().size() > 0) {
            for (String s : markInvoiceReqBO.getApplyNo()) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(s);
                if (!billApplyInfo.getBillStatus().equals("00")) {
                    throw new PfscExtBusinessException("18003", "\u72b6\u6001\u4e0d\u662f\u5df2\u63d0\u4ea4");
                }
                this.billApplyInfoMapper.updateStatusByApplyNo(s, "03");
                this.saleOrderInfoMapper.updateStatusByApplyNo(s, "02");
                this.saleItemInfoMapper.updateStatusByApplyNo(s, "03");
            }
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        return rspBO;
    }
}

