/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiGetCirculationInfoFromErpService;
import com.tydic.pfscext.external.api.bo.BusiGetCirculationInfoFromErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetCirculationInfoFromErpRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiGetCirculationInfoFromErpServiceImpl
implements BusiGetCirculationInfoFromErpService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetCirculationInfoFromErpServiceImpl.class);
    @Value(value="${BUSI_GET_CIRCULATION_INFO_FROM_ERP_URL:}")
    private String BUSI_GET_CIRCULATION_INFO_FROM_ERP_URL;
    private final String POST_SUCCESS_CODE = "0000";

    @Override
    public BusiGetCirculationInfoFromErpRspBO getCirculationInfoFromErp(BusiGetCirculationInfoFromErpReqBO busiGetCirculationInfoFromErpReqBO) {
        if (busiGetCirculationInfoFromErpReqBO == null) {
            throw new PfscExternalBusinessException("0001", "\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqBOJson = JSON.toJSONString((Object)busiGetCirculationInfoFromErpReqBO);
        log.debug("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u5165\u53c2:{}", (Object)reqBOJson);
        String postToErpRspJson = this.postGetCirculationInfoFromErp(reqBOJson);
        JSONObject jsonObject = JSON.parseObject((String)postToErpRspJson);
        String code = jsonObject.getString("code");
        String msg = jsonObject.getString("msg");
        String data = jsonObject.getString("data");
        if ("0".equals(code)) {
            BusiGetCirculationInfoFromErpRspBO busiGetCirculationInfoFromErpRspBO = new BusiGetCirculationInfoFromErpRspBO();
            busiGetCirculationInfoFromErpRspBO.setCode("0000");
            busiGetCirculationInfoFromErpRspBO.setMsg(msg);
            if (!StringUtils.isEmpty((Object)data)) {
                busiGetCirculationInfoFromErpRspBO.setData(data);
            }
            return busiGetCirculationInfoFromErpRspBO;
        }
        throw new PfscExternalBusinessException("18000", "\u67e5\u8be2erp\u4fe1\u606f\u5931\u8d25\uff0c\u54cd\u5e94msg\uff1a" + msg);
    }

    private String postGetCirculationInfoFromErp(String reqBody) {
        HttpRetBean httpRetBean;
        try {
            log.info("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)reqBody);
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.BUSI_GET_CIRCULATION_INFO_FROM_ERP_URL), HSNHttpHeader.getRequestHeaders("json"), reqBody.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25,e:{}", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25[http_status={},http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.BUSI_GET_CIRCULATION_INFO_FROM_ERP_URL);
            throw new RuntimeException("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25");
        }
        String returnString = httpRetBean.getStr();
        log.info("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u67e5\u8be2erp\u6d41\u8f6c\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return returnString;
    }
}

