/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.external.api.BusiGetInvoiceDataService;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataRspVO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataServiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataServiceRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemListRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiGetInvoiceDataServiceImpl
implements BusiGetInvoiceDataService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetInvoiceDataServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiGetInvoiceDataServiceRspBO getInvoiceData(BusiGetInvoiceDataServiceReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (null == reqBO.getIdMap() || reqBO.getIdMap().isEmpty()) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u53d1\u7968\u552f\u4e00\u6807\u5fd7Id\u548c\u4f9b\u5e94\u5546Id\u6784\u6210\u7684Map\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGetInvoiceDataServiceRspBO rspBO = new BusiGetInvoiceDataServiceRspBO();
        ArrayList<BusiGetInvoiceDataRspVO> list = new ArrayList<BusiGetInvoiceDataRspVO>();
        rspBO.setDataList(list);
        Map<String, String> dataMap = reqBO.getIdMap();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            try {
                HttpRetBean httpRetBean;
                String markId = entry.getKey();
                String suppliedId = entry.getValue();
                Long jdOrgId = null;
                if (null != reqBO.getOrgIdMap() && null != reqBO.getOrgIdMap().get(markId)) {
                    jdOrgId = reqBO.getOrgIdMap().get(markId);
                    log.debug("\u4eac\u4e1ctoken---" + jdOrgId.toString());
                }
                String reqStr = this.initReqStr(markId, jdOrgId);
                log.error("\u83b7\u53d6\u53d1\u7968\u8bf7\u6c42\u5730\u5740=========" + this.prop.getProperty("ESB_INVOICE_QUERY_JD_URL"));
                log.error("\u83b7\u53d6\u53d1\u7968\u8bf7\u6c42\u62a5\u6587\u4e3a=========" + reqStr);
                String hsn = this.prop.getProperty("SUPPLIER_ID_" + suppliedId);
                String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
                log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u83b7\u53d6\u53d1\u7968\u6570\u636e\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u62a5\u6587:" + reqEsbStr + ", URL:" + this.prop.getProperty("ESB_INVOICE_QUERY_JD_URL"));
                try {
                    httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_INVOICE_QUERY_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
                }
                catch (Exception e) {
                    log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a" + markId + "\u4f9b\u5e94\u5546Id\u4e3a\uff1a" + suppliedId, (Throwable)e);
                    throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u5931\u8d25");
                }
                if (httpRetBean.getStatus() != 200) {
                    log.error("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]");
                    throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
                }
                log.info("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    log.info("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                    throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                BusiGetInvoiceDataRspVO rspVO = new BusiGetInvoiceDataRspVO();
                rspVO.setNotificationNo(markId);
                rspVO.setSupplierNo(suppliedId);
                rspVO.setSupplierCode(hsn);
                this.resolveRsp(returnString, rspBO, rspVO);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff1a\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + entry.getKey() + "\uff1b\u9519\u8bef\u4fe1\u606f:", (Throwable)e);
            }
        }
        return rspBO;
    }

    private String initReqStr(String markId, Long jdOrgId) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"markId\":").append("\"" + markId + "\"");
        if (null != jdOrgId) {
            sb.append(",").append("\"orgId\":").append("\"" + jdOrgId + "\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private void resolveRsp(String returnString, BusiGetInvoiceDataServiceRspBO rspBO, BusiGetInvoiceDataRspVO rspVO) {
        JSONObject rspJsonObject;
        String supInfo = rspVO.getSupplierNo() + "(" + rspVO.getSupplierCode() + ")";
        log.debug("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519,sup=" + supInfo + " json:" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        if (null == resultCode) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode,sup=" + supInfo);
            throw new PfscExternalBusinessException("18000", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
        }
        if (resultCode.equals("0004") || resultCode.equals("0005")) {
            JSONArray resultArray = null;
            try {
                resultArray = JSONObject.parseArray((String)rspJsonObject.getString("result"));
            }
            catch (Exception e) {
                log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef,sup=" + supInfo, (Throwable)e);
                throw new PfscExternalBusinessException("18000", "\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
            for (int i = 0; i < resultArray.size(); ++i) {
                JSONObject jsonObject = resultArray.getJSONObject(i);
                String invoiceNo = jsonObject.getString("invoiceNo");
                if (!StringUtils.hasText((String)invoiceNo)) {
                    invoiceNo = jsonObject.getString("invoiceId");
                }
                if (!StringUtils.hasText((String)invoiceNo)) {
                    log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u65e0\u6cd5\u62ff\u5230\u6709\u6548\u7684\u53d1\u7968\u53f7\u7801," + returnString);
                }
                rspVO.setInvoiceNo(invoiceNo);
                rspVO.setInvoiceCode(jsonObject.getString("invoiceCode"));
                rspVO.setInvoiceDate(jsonObject.getDate("invoiceDate"));
                rspVO.setAmt(jsonObject.getBigDecimal("invoiceAmount"));
                rspVO.setNotTaxAmt(jsonObject.getBigDecimal("invoiceNakedAmount"));
                rspVO.setTaxAmt(jsonObject.getBigDecimal("invoiceTaxAmount"));
                rspVO.setName(jsonObject.getString("title"));
                rspVO.setTaxNo(jsonObject.getString("enterpriseTaxpayer"));
                rspVO.setAddress(jsonObject.getString("address"));
                rspVO.setPhone(jsonObject.getString("tel"));
                rspVO.setBankName(jsonObject.getString("bank"));
                rspVO.setBankAcNo(jsonObject.getString("account"));
                rspVO.setInvoiceType(jsonObject.getInteger("invoiceType"));
                rspVO.setResultCode(rspJsonObject.getString("resultCode"));
                rspVO.setResultMsg(rspJsonObject.getString("resultMessage"));
                rspVO.setElectronicInvoiceUrl(rspJsonObject.getString("fileUrl"));
                BusiGetInvoiceDataRspVO rspVO2 = new BusiGetInvoiceDataRspVO();
                BeanUtils.copyProperties((Object)rspVO, (Object)rspVO2);
                rspBO.getDataList().add(rspVO2);
            }
        } else {
            rspVO.setResultCode(rspJsonObject.getString("resultCode"));
            rspVO.setResultMsg(rspJsonObject.getString("resultMessage"));
            rspBO.getDataList().add(rspVO);
        }
    }

    @Override
    public BusiGetInvoiceItemListRspBO getInvoiceItems(BusiGetInvoiceDataServiceReqBO reqBO) {
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"invoiceId\":").append("\"" + reqBO.getIdMap().get("invoiceId") + "\",").append("\"invoiceCode\":").append("\"" + reqBO.getIdMap().get("invoiceCode") + "\"");
        if (null != reqBO.getIdMap().get("orgId")) {
            sb.append(",").append("\"orgId\":").append("\"" + reqBO.getIdMap().get("orgId") + "\"");
        }
        sb.append("}");
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getIdMap().get("supplierId"));
        String reqStr = sb.toString();
        String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
        log.info("\u53d1\u7968\u660e\u7ec6\u8bf7\u6c42\u5730\u5740\uff1a" + this.prop.getProperty("ESB_QUERY_INVOICE_ITEM_URL"));
        log.info("\u53d1\u7968\u660e\u7ec6\u8bf7\u6c42\u62a5\u6587\uff1a" + reqEsbStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QUERY_INVOICE_ITEM_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            throw new PfscExternalBusinessException("18000", "\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u62a5\u9519\uff1a" + e.getMessage());
        }
        log.info("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        if (httpRetBean.getStatus() != 200) {
            log.error("\u72b6\u6001\u5417\u5931\u8d25");
        }
        log.info("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.info("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u8fd4\u56de\u62a5\u6587\u89e3\u6790\u5f02\u5e38:" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        if (!hsn.equals("jd")) {
            return this.resolveRsp(rspJsonObject);
        }
        return this.resolveRspJD(rspJsonObject);
    }

    private BusiGetInvoiceItemListRspBO resolveRsp(JSONObject rspJsonObject) {
        BusiGetInvoiceItemListRspBO rsp = new BusiGetInvoiceItemListRspBO();
        JSONObject jsonObject = rspJsonObject.getJSONObject("result");
        Boolean isSuccess = rspJsonObject.getBoolean("success");
        if (isSuccess.booleanValue()) {
            JSONArray jsonArray = jsonObject.getJSONArray("sku_entity");
            ArrayList<BusiGetInvoiceItemBO> invoiceItemBOS = new ArrayList<BusiGetInvoiceItemBO>();
            if (null != jsonArray) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    BusiGetInvoiceItemBO invoiceItemBO = new BusiGetInvoiceItemBO();
                    Object json = jsonArray.get(i);
                    JSONObject sku = JSONObject.parseObject((String)json.toString());
                    invoiceItemBO.setExtSkuId(sku.getString("skuId"));
                    invoiceItemBO.setOrderCode(sku.getString("eorderId"));
                    invoiceItemBO.setItemName(sku.getString("skuName"));
                    invoiceItemBO.setSpecOrModel(sku.getString("unit"));
                    invoiceItemBO.setItemUnit(sku.getString("settleUnit"));
                    invoiceItemBO.setQuantity(sku.getBigDecimal("num"));
                    invoiceItemBO.setUntaxAmt(sku.getBigDecimal("amountUnTax"));
                    invoiceItemBO.setTaxAmt(sku.getBigDecimal("taxAmount"));
                    invoiceItemBO.setTaxRate(sku.getBigDecimal("tax"));
                    if (sku.getBigDecimal("amount") != null && sku.getBigDecimal("num").compareTo(BigDecimal.ZERO) > 0) {
                        invoiceItemBO.setPriceIntax(sku.getBigDecimal("amount").divide(sku.getBigDecimal("num"), 2, 2));
                    } else {
                        invoiceItemBO.setPriceIntax(new BigDecimal(0));
                    }
                    if (sku.getBigDecimal("amountUnTax") != null && sku.getBigDecimal("num").compareTo(BigDecimal.ZERO) > 0) {
                        invoiceItemBO.setPriceUntax(sku.getBigDecimal("amountUnTax").divide(sku.getBigDecimal("num"), 2, 2));
                    } else {
                        invoiceItemBO.setPriceUntax(new BigDecimal(0));
                    }
                    invoiceItemBO.setAmount(sku.getBigDecimal("amount"));
                    invoiceItemBOS.add(invoiceItemBO);
                }
                log.info("jsonArray:" + jsonArray.toJSONString());
            }
            rsp.setBusiGetInvoiceItemBOs(invoiceItemBOS);
        }
        return rsp;
    }

    private BusiGetInvoiceItemListRspBO resolveRspJD(JSONObject rspJsonObject) {
        BusiGetInvoiceItemListRspBO rsp = new BusiGetInvoiceItemListRspBO();
        JSONObject jsonObject = rspJsonObject.getJSONObject("result");
        Boolean isSuccess = rspJsonObject.getBoolean("success");
        if (isSuccess.booleanValue()) {
            BusiGetInvoiceDataRspVO rspVO = new BusiGetInvoiceDataRspVO();
            rspVO.setInvoiceNo(jsonObject.getString("invoiceId"));
            rspVO.setInvoiceCode(jsonObject.getString("invoiceCode"));
            rspVO.setInvoiceDate(jsonObject.getDate("invoiceDate"));
            rspVO.setAmt(jsonObject.getBigDecimal("invoiceAmount"));
            rspVO.setNotTaxAmt(jsonObject.getBigDecimal("invoiceNakedAmount"));
            rspVO.setTaxAmt(jsonObject.getBigDecimal("invoiceTaxAmount"));
            rspVO.setName(jsonObject.getString("title"));
            rspVO.setTaxNo(jsonObject.getString("taxpayer"));
            rspVO.setAddress(jsonObject.getString("address"));
            rspVO.setPhone(jsonObject.getString("tel"));
            rspVO.setBankName(jsonObject.getString("bank"));
            rspVO.setBankAcNo(jsonObject.getString("account"));
            JSONArray jsonArray = jsonObject.getJSONArray("skuDetails");
            ArrayList<BusiGetInvoiceItemBO> invoiceItemBOS = new ArrayList<BusiGetInvoiceItemBO>();
            if (null != jsonArray) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    BusiGetInvoiceItemBO invoiceItemBO = new BusiGetInvoiceItemBO();
                    Object json = jsonArray.get(i);
                    JSONObject sku = JSONObject.parseObject((String)json.toString());
                    invoiceItemBO.setExtSkuId(sku.getString("skuId"));
                    invoiceItemBO.setOrderCode(sku.getString("jdOrderId"));
                    invoiceItemBO.setItemName(sku.getString("skuName"));
                    invoiceItemBO.setSpecOrModel(sku.getString("specification"));
                    invoiceItemBO.setItemUnit(sku.getString("settleUnit"));
                    invoiceItemBO.setQuantity(sku.getBigDecimal("num"));
                    invoiceItemBO.setUntaxAmt(sku.getBigDecimal("amountUnTax"));
                    invoiceItemBO.setTaxAmt(sku.getBigDecimal("taxAmount"));
                    invoiceItemBO.setTaxRate(sku.getBigDecimal("taxRate"));
                    if (sku.getBigDecimal("amount") != null && sku.getBigDecimal("num").compareTo(BigDecimal.ZERO) > 0) {
                        invoiceItemBO.setPriceIntax(sku.getBigDecimal("amount").divide(sku.getBigDecimal("num"), 2, 2));
                    } else {
                        invoiceItemBO.setPriceIntax(new BigDecimal(0));
                    }
                    if (sku.getBigDecimal("amountUnTax") != null && sku.getBigDecimal("num").compareTo(BigDecimal.ZERO) > 0) {
                        invoiceItemBO.setPriceUntax(sku.getBigDecimal("amountUnTax").divide(sku.getBigDecimal("num"), 2, 2));
                    } else {
                        invoiceItemBO.setPriceUntax(new BigDecimal(0));
                    }
                    invoiceItemBO.setAmount(sku.getBigDecimal("amount"));
                    invoiceItemBOS.add(invoiceItemBO);
                }
                log.info("jsonArray:" + jsonArray.toJSONString());
            }
            rsp.setBusiGetInvoiceItemBOs(invoiceItemBOS);
            rsp.setBusiGetInvoiceDataRspVO(rspVO);
        }
        return rsp;
    }
}

