/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiInvoiceWayDataService;
import com.tydic.pfscext.external.api.bo.BusiInvoiceWayDataReqBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceWayDataRspBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceWayDataVO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiInvoiceWayDataServiceImpl
implements BusiInvoiceWayDataService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceWayDataServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiInvoiceWayDataRspBO getInvoiceWayData(BusiInvoiceWayDataReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getQueryData() == null || reqBO.getQueryData().isEmpty()) {
            throw new PfscExternalBusinessException("0001", "\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiInvoiceWayDataRspBO rspBO = new BusiInvoiceWayDataRspBO();
        ArrayList<BusiInvoiceWayDataVO> dataVOList = new ArrayList<BusiInvoiceWayDataVO>();
        rspBO.setMailStatusList(dataVOList);
        Map<String, String> dataMap = reqBO.getQueryData();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            try {
                HttpRetBean httpRetBean;
                String markId = entry.getKey();
                String suppliedId = entry.getValue();
                String reqStr = this.initReqStr(markId);
                String hsn = this.prop.getProperty("SUPPLIER_ID_" + suppliedId);
                String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
                log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3--->\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u62a5\u6587:" + reqEsbStr);
                log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3--->\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u5730\u5740:" + this.prop.getProperty("ESB_INVOICE_SEND_JD_URL"));
                try {
                    httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_INVOICE_SEND_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
                }
                catch (Exception e) {
                    log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a" + markId + "\u4f9b\u5e94\u5546Id\u4e3a\uff1a" + suppliedId + " err:" + e.getMessage(), (Throwable)e);
                    throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
                }
                if (httpRetBean.getStatus() != 200) {
                    log.error("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]");
                    throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
                }
                log.info("\u8c03\u7528\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    log.info("\u8c03\u7528\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                    throw new RuntimeException("\u8c03\u7528\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                BusiInvoiceWayDataVO dataVO = new BusiInvoiceWayDataVO();
                dataVO.setNotificationNo(markId);
                this.resolveRsp(returnString, rspBO, dataVO);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u8be6\u60c5\u5931\u8d25\u901a\u77e5\u5355:" + entry.getKey() + ";\u4f9b\u5e94\u5546\uff1a" + entry.getValue());
            }
        }
        return rspBO;
    }

    private String initReqStr(String markId) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"markId\":").append("\"" + markId + "\"").append("}");
        return sb.toString();
    }

    private void resolveRsp(String returnString, BusiInvoiceWayDataRspBO rspBO, BusiInvoiceWayDataVO dataVO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519," + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001--\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        if (resultCode.equals("3305")) {
            dataVO.setResultCode(resultCode);
            dataVO.setResultMsg(rspJsonObject.getString("resultMessage"));
            rspBO.getMailStatusList().add(dataVO);
        } else {
            JSONArray resultArray = null;
            try {
                resultArray = JSONObject.parseArray((String)rspJsonObject.getString("result"));
                for (int i = 0; i < resultArray.size(); ++i) {
                    JSONObject jsonObject = resultArray.getJSONObject(i);
                    dataVO.setPostId(jsonObject.getString("postId"));
                    dataVO.setDeliveryId(jsonObject.getString("deliveryId"));
                    dataVO.setPostCompany(jsonObject.getString("postCompany"));
                    dataVO.setPostTime(jsonObject.getString("postTime"));
                    dataVO.setState(jsonObject.getString("state"));
                    dataVO.setResultCode(resultCode);
                    dataVO.setResultMsg(jsonObject.getString("resultMessage"));
                    rspBO.getMailStatusList().add(dataVO);
                }
            }
            catch (Exception e) {
                log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
                throw new PfscExternalBusinessException("18000", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
        }
    }
}

